/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * GAME module
 *
 *    Created on 11 June by JP
 *
 *
 */

#include <allegro.h>
#include <stdio.h>
#include "mapform.h"
#include "game.h"
#include "player.h"
#include "refresh.h"
#include "tileset.h"
#include "main.h"
#include "background.h"
#include "as.h"
#include "Python.h"
#include "timer.h"
#include "animators.h"
#include "config.h"
volatile int speed_counter;
void increment_speed_counter()
{
	speed_counter++;
} END_OF_FUNCTION(increment_speed_counter);
void increment_timer()
{
	timer++;
} END_OF_FUNCTION(increment_timer);


/*
 * Pause the game
 *
 */
void static pause_game(void)
{
	int x, y;

	// TODO: Stop timers
	fade_out(32);
	bmpcpy(screen, scrbuf);
	for (x = 0; x < 640; x += 2) {
		line(scrbuf, x, 0, x, 479, 0);
	}
	for (y = 0; y < 480; y += 2) {
		line(scrbuf, 0, y, 639, y, 0);
	}
	textout_centre(scrbuf, font, " -= Game Paused =- ", 320, 240, 15);
	bltscr(scrbuf);
	fade_in(pal, 32);
	clear_keybuf();
	PyRun_SimpleString(scfg_get("call_game_pause"));

	while (!keypressed())
		speed_counter = 0;
	clear_keybuf();
	fade_out(32);
	dirtify_blocks();
	refresh_screen();
	fade_in(pal, 32);

	// TODO: Start timers
	speed_counter = 0;
}


/*
 * COMMAND RUNNER
 *
 * 	Runs simple Python string from cmd array.
 */
void run_cmd(int number, int x, int y)
{
	sprintf(txtbuf, map_parm.cmd[x][y], number, x, y);
	PyRun_SimpleString(txtbuf);
}

/*
 * MAP PARSER
 * 
 *   Studies map data, and sets up neccesary variables
 *
 */
void static parse_map()
{
	int block;
	int x, y;
	int number = 1;
	fprintf(stderr, "Parsing map...\n");
	for (x = 0; x < 10; x++) {
		for (y = 0; y < 2; y++) {
			teleporter[x][y][0] = -1;
			teleporter[x][y][1] = -1;
		}
	}
	game_parm.num_items = 0;
	for (x = 0; x < 20; x++) {
		for (y = 0; y < 15; y++) {
			block = (int) map_parm.block[x][y];
			if (block == 1) {	// Player 1 start
				if (cfg_get("game_num_players") > 0)
					init_player(S2M(x), S2M(y), 0);
			} else if (block == 2) {	// Player 2 start
				if (cfg_get("game_num_players") > 1)
					init_player(S2M(x), S2M(y), 1);
			} else if (block > 100 && block < 200) {	// Enemy start
				if (number < MAX_PLAYERS) {
					number++;
					init_creature(block, x, y, number);
				}
			} else if (block > 39 && block < 50) {	// Teleporter
				fprintf(stderr, "Teleporter %i found...",
					block - 40);
				if (teleporter[block - 40][0][0] == -1) {
					fprintf(stderr,
						"Setting up pod 1\n");
					teleporter[block - 40][0][0] = x;
					teleporter[block - 40][0][1] = y;
				} else {
					fprintf(stderr,
						"Setting up pod 2\n");
					teleporter[block - 40][1][0] = x;
					teleporter[block - 40][1][1] = y;
				}
			} else if (block >= 10 && block <= 19)
				game_parm.num_items++;
		}
	}
}


/*
 * Game main function
 *
 * returns:
 *   
 *   0 - User exit
 *   1 - Player die
 *   2 - Mission complete
 */
int game_main(void)
{
	int inkey;
	BITMAP *bmp;
	int x, y, number, ret = 0, exit_cntr = -1;
	unsigned char block;
	if (cur_depth != 8)
		set_video(8);

#	define EXIT_DELAY 300 // Time to delay before exiting
	LOCK_VARIABLE(speed_counter);
	LOCK_VARIABLE(timer);
	LOCK_FUNCTION(increment_speed_counter);
	LOCK_FUNCTION(increment_timer);
	bgbuf = create_bitmap(640, 480);
	draw_background(bgbuf, 640, 480, map_parm.bg, map_parm.numbg);
	
	for(x = 0; x < 20; x++)
		for(y = 0; y < 15; y++){
			load_tile(tilebuf, bg_data[x][y]);
			masked_blit(tilebuf, bgbuf, 0, 0, S2M(x), S2M(y), 32, 32);
		}
	
	speed_counter = 0;
	if (cfg_get("timer_reset_on_game_start"))
		timer_reset();
	for (x = 0; x < MAX_PLAYERS; x++) {
		player[x].active = FALSE;
	}

	// !DEBUG
	temp_mparm = map_parm;
	parse_map();
	for (x = 0; x < 10; x++)
		animator[x].clock = 0;
	dirtify_blocks();
	fade_out(63);
	refresh_screen();
	fade_in(pal, 32);
	install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
	install_int_ex(increment_timer, BPS_TO_TIMER(100));

	// Main game loop
	while (!key[KEY_ESC]) {

      /*-- K E Y B O A R D  H A N D L E R ---------------------*/
		while (keypressed()) {
			inkey = readkey();
			if(ISKEY(KEY_F12)) {
				get_palette(pal);
				bmp =
				    create_sub_bitmap(screen, 0, 0,
						      SCREEN_W, SCREEN_H);
				for (x = 0;
				     sprintf(txtbuf, "scrdump%03i.pcx", x)
				     && exists(txtbuf); x++);
				save_bitmap(txtbuf, bmp, pal);
				destroy_bitmap(bmp);
			}
			if(ISKEY(KEY_P)) {
				pause_game();
			}
		}

      /*-- K E Y B O A R D  H A N D L E R ---------------------*/

		// GAME LOGIC
		while (speed_counter > 0) {

			// Go through all player objs.
			for (number = 0; number < MAX_PLAYERS; number++) {
				if (plobj.active && in_sector(number)) {
					block =
					    map_parm.
					    block[M2S((int) plobj.x)][M2S
								      ((int) plobj.y)];

					/* TELEPORTERS */
					if (block > 39 && block < 50) {

						// Player stepped into teleporter
						if (M2S((int) plobj.x)
						    ==
						    teleporter[block -
							       40][0]
						    [0]
						    && M2S((int)
							   plobj.y) ==
						    teleporter[block -
							       40][0]
						    [1]) {
							if (teleporter
							    [block -
							     40][1][0] ==
							    -1) {
								reperr
								    ("Broken teleporter");
								goto fin;
							} else {
								dirty_block
								    [M2S
								     ((int)
								      plobj.
								      x)]
								    [M2S
								     ((int)
								      plobj.
								      y)] =
								    TRUE;
								plobj.x =
								    teleporter
								    [block
								     -
								     40][1]
								    [0] <<
								    5;
								plobj.y =
								    teleporter
								    [block
								     -
								     40][1]
								    [1] <<
								    5;
						}} else
						    if (M2S
							((int) plobj.x) ==
							teleporter[block -
								   40][1]
							[0]
							&& M2S((int) plobj.
							       y) ==
							teleporter[block -
								   40][1]
							[1]) {
							if (teleporter
							    [block -
							     40][0][0] ==
							    -1) {
								reperr
								    ("Broken teleporter");
								goto fin;
							} else {
								dirty_block
								    [M2S
								     ((int)
								      plobj.
								      x)]
								    [M2S
								     ((int)
								      plobj.
								      y)] =
								    TRUE;
								plobj.x =
								    teleporter
								    [block
								     -
								     40][0]
								    [0] <<
								    5;
								plobj.y =
								    teleporter
								    [block
								     -
								     40][0]
								    [1] <<
								    5;
						}}
					} else if (block >= 253) {
						if (!
						    (block == 253
						     && number <
						     2) && !(block == 254
							     && number >
							     1))
							run_cmd(number,
								M2S((int)
								    plobj.
								    x),
								M2S((int)
								    plobj.
								    y));
					}
					if (number < 2 && block >= 10 && block <= 19) {	// A pickable object
						sound_play(cfg_get
							   ("sample_pick_item"));
						plobj.score +=
						    (block - 10) * 10 + 10;
						map_parm.
						    block[M2S
							  ((int) plobj.
							   x)][M2S((int)
								   plobj.
								   y)] = 0;
						map_parm.
						    tile[M2S
							 ((int) plobj.
							  x)][M2S((int)
								  plobj.
								  y)] =
						    255;
						game_parm.num_items--;
					}
					if (pl1.active && number == 0) {	// These are player 1 keys if anyone is interested
						if (key[KEY_RIGHT])
							pl1.direction = 0;
						if (key[KEY_DOWN])
							pl1.direction = 1;
						if (key[KEY_LEFT])
							pl1.direction = 2;
						if (key[KEY_UP])
							pl1.direction = 3;
					} else if (pl2.active && number == 1) {	// And these are player 2 keys
						if (key[KEY_D])
							pl2.direction = 0;
						if (key[KEY_S])
							pl2.direction = 1;
						if (key[KEY_A])
							pl2.direction = 2;
						if (key[KEY_W])
							pl2.direction = 3;
					} else {
						move_creature(number);
					}
				}
				move_player(number);
			}
			speed_counter--;
		}

		// Check if we should end the game.
		// --
		// Both players died
		if (!pl1.active && !pl2.active && exit_cntr < 0) {
			ret = 1;
			exit_cntr = EXIT_DELAY;
		}
		// Mission complete
		// TODO: Some sort of handling for other types
		//       of missions, not only collect all things
		if (game_parm.num_items == 0 && exit_cntr < 0) {
			ret = 2;
			exit_cntr = timer + EXIT_DELAY;
		}
		if (exit_cntr <= timer && exit_cntr != -1)
			goto fin;
		
		if (fading_pal)
			fade_back();
		update_timers();
		refresh_screen();
		while (speed_counter < 0);
	}
      fin:fade_out(1);
	destroy_bitmap(bgbuf);
	clear_bitmap(screen);
	set_palette(pal);
	map_parm = temp_mparm;
	for (number = 0; number < MAX_PLAYERS; number++) {
		clear_player(number);
	}
	remove_int(increment_speed_counter);
	remove_int(increment_timer);
	while (key[KEY_ESC]);
	clear_keybuf();
	return ret;
}
