/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * GAME CONFIGURATION
 *
 * 	Created by JP on 26th February 2003
 *
 */

int cfg_get(char *key);
/* This function gets value out of game configuration array in the memory.
 * 
 * Returns integer found under the key or 0 when the key is not found. Note that
 * zero will be returned also if the value exists but is set to zero so I don't
 * recommend you to rely on this. (If key is not found in array the message
 * about this is printed to stderr).
 *
 * Read more about configuration arrays in corresponding chapter.
 */

int cfg_set(char *key, int val);
/* This function sets some value represented by key to value indicated by val.
 * Note that this system supports only integer config variables. For strings
 * see scfg_* functions.
 *
 * Funcion returns zero if the key is not found (and message about it is printed
 * to stderr) and non-zero otherwise.
 *
 * Read more about configuration arrays in corresponding chapter.
 */

void cfg_ls(void);
/* List contents of configuration array. Not very useful thing to use in
 * programs, but meant for missionpack writers or game players to get
 * information about current configuration directives, as this manual doesn't
 * talk about them all.
 *
 * The list is printed to stdout.
 *
 * Read more about configuration arrays in corresponding chapter.
 */

char *scfg_get(char *key);
/* Gets entry from scfg array, what is the same as cfg array but entries here
 * are strings rather than integers.
 * 
 * Returns string containing the value or empty string if no entry by that key
 * was found and prints error message to stderr. Also returns empty string if
 * entry is found, but the value is empty string. Quite logical, isn't it. ;)
 *
 * Read more about configuration arrays in corresponding chapter.
 */

int scfg_set(char *key, char *val);
/* This function sets some value represented by key to value indicated by val
 * in scfg array. In another words the same thing as cfg array but for strings.
 * Note that maximum size for the value is 32 characters. If you try to pass
 * more than the scfg string is left unaltered and error message is printed to
 * stderr.
 *
 * Funcion returns zero if the key is not found or val is larger than 32 bytes
 * (and message about it is printed to stderr) and non-zero otherwise.
 *
 * Read more about configuration arrays in corresponding chapter.
 */

void scfg_ls(void);
/* List contents of scfg array. Not very useful thing to use in programs, but meant
 * for missionpack writers or game players to get information about current
 * configuration directives, as this manual doesn't talk about them all.
 *
 * The list is printed to stdout.
 * 
 * Read more about configuration arrays in corresponding chapter.
 */
