/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * BACKGROUND specific stuff
 *
 *   Created on Tue Nov 19 19:50:01 2002 by JP
 *
 */

#include <stdlib.h>
#include <allegro.h>
#include "mapform.h"
#include "background.h"

void draw_background(BITMAP *bmp, int width, int height,
		     unsigned char colors[5], int numcolors)
{

	int x, y;

	if (numcolors == 0)
		return;

	for (x = 0; x < width; x++) {
		for (y = 0; y < height; y++) {

			putpixel(bmp, x, y,
				 colors[(int) random() % numcolors]);

		}
	}
}


void static update_preview(unsigned char colors[5], int num)
{

	BITMAP *temp;
	int n;

	temp = create_bitmap(32, 32);

	clear_bitmap(temp);

	if (num > 0)
		draw_background(temp, 32, 32, colors, num);

	blit(temp, screen, 0, 0, 43, 75, 32, 32);

	destroy_bitmap(temp);

	for (n = 0; n < 5; n++) {

		if (n < num) {
			rect(screen, 12 + n * 4, 75, 15 + n * 4, 80, 7);
			rectfill(screen, 13 + n * 4, 76, 14 + n * 4, 79,
				 colors[n]);
		} else
			rectfill(screen, 12 + n * 4, 75, 15 + n * 4, 80,
				 8);



	}

}

/*
 *  Background editor
 *
 */
void edit_background()
{

	int n, x, y, aborted = FALSE;
	unsigned char bgcolors[5];

	// Huh, First let's draw the background box

	rectfill(screen, 10, 10, 74, 107, 0);
	rect(screen, 9, 9, 75, 108, 7);

	// Now we need colors

	for (n = 0; n < 256; n++) {

		y = (n / 16) * 4 + 10;
		x = (n % 16) * 4 + 10;

		rectfill(screen, x, y, x + 4, y + 4, n);
	}

	// Let's draw one line to separate color selector
	// From other things...
	line(screen, 10, 74, 74, 74, 7);
	//And other to separate sample display...
	line(screen, 42, 74, 42, 107, 7);

	for (x = 0; x < 5; x++) {
		bgcolors[x] = map_parm.bg[x];
	}
	n = map_parm.numbg;

	if (n > 5)
		n = 0;

	update_preview(bgcolors, n);

	while (!aborted) {

		if (mouse_b & 1 || mouse_b & 2) {
			if (mouse_b & 1) {

				if (n < 5) {
					scare_mouse();
					bgcolors[n] =
					    getpixel(screen, mouse_x,
						     mouse_y);
					unscare_mouse();
					n++;
				}
			} else if (mouse_b & 2) {

				if (n > 0) {
					n--;
				}
			}
			while (mouse_b & 1 || mouse_b & 2);
			scare_mouse();
			update_preview(bgcolors, n);
			unscare_mouse();
		}

		if (key[KEY_ENTER]) {

			for (x = 0; x < 5; x++) {
				map_parm.bg[x] = bgcolors[x];
			}

			map_parm.numbg = n;

			aborted = TRUE;

		}
		if (key[KEY_ESC]) {

			aborted = TRUE;

		}

	}

	while (key[KEY_ESC] || key[KEY_ENTER]);
	clear_keybuf();
}
