/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 * ARTIFICIAL STUPIDITY
 *
 *   Created on Wed Nov 20 13:49:11 2002 by JP
 *
 */

#include <allegro.h>
#include <stdlib.h>
#include <stdio.h>
#include "player.h"
#include "tileset.h"
#include "mapform.h"
#include "main.h"

void init_creature(int block, int x, int y, int number)
{

	plobj.x = S2M(x);
	plobj.y = S2M(y);
	plobj.oldx = S2M(x);
	plobj.oldy = S2M(y);

	block -= 100;

	plobj.active = TRUE;

	plobj.type = (block - (block % 10)) / 10;

	if (plobj.type < 6)
		plobj.speed = 1;
	else {

		plobj.type -= 6;
		plobj.speed = 2;

	}

	if (plobj.type == 5)
		plobj.direction = 3;


	for (x = 0; x < 3; x++) {
		plobj.tile[x] = create_bitmap(32, 32);
		load_tile(plobj.tile[x], 6 + x + (block % 10) * 3);
	}

}



void move_creature(int number)
{

	int pln;
	int x, y, nch = 0, ch[4];

#define regdir(dir) ch[nch] = dir; nch++

	if (number < 2)
		return;		// Hey! It's not my work to move players

	if (plobj.type == 0) {	// Random wonderers just wonder around
		if (in_sector(number)) {
			x = M2S((int) plobj.x);
			y = M2S((int) plobj.y);

			// Look around for a way to move
			if (map_data[limx(x + 1)][limy(y)] != 20) {
				regdir(0);
			}
			if (map_data[limx(x)][limy(y + 1)] != 20) {
				regdir(1);
			}
			if (map_data[limx(x - 1)][limy(y)] != 20) {
				regdir(2);
			}
			if (map_data[limx(x)][limy(y - 1)] != 20) {
				regdir(3);
			}
			// And if in the mood of turning pick the direction
			if (nch > 0
			    && (!(random() % 10) || !can_move(number)))
				plobj.direction = ch[random() % nch];
		}
	}

	if (!can_move(number)) {	// Commanded wonderers care only about walls

		if (plobj.type == 1) {
			if (plobj.direction == 0)
				plobj.direction = 3;
			else
				plobj.direction--;
		} else if (plobj.type == 2) {
			if (plobj.direction == 3)
				plobj.direction = 0;
			else
				plobj.direction++;
		}
		if (plobj.type == 4) {	// Guards (left - right)
			if (plobj.direction == 2)
				plobj.direction = 0;
			else
				plobj.direction = 2;
		}
		if (plobj.type == 5) {	// Guards (up - down)
			if (plobj.direction == 3)
				plobj.direction = 1;
			else
				plobj.direction = 3;
		}
	}

	if (plobj.type == 3) {	// Manic chasers

		if (pl1.active && pl2.active) {
			if ((int)
			    ((abs((int) (plobj.x - pl1.x)) +
			      abs((int) (plobj.y - pl1.y)))) <
			    (int) (abs((int) (plobj.x - pl2.x)) +
				   abs((int) (plobj.y - pl2.y))))
				pln = 0;
			else
				pln = 1;
		} else if (pl1.active && !pl2.active)
			pln = 0;
		else if (!pl1.active && pl2.active)
			pln = 1;
		else {
			plobj.type = 0;	// If no players available then just wonder around
		}
		if (random() % 2 - 1) {

			if (player[pln].x > plobj.x)
				plobj.direction = 0;
			else if (player[pln].x < plobj.x)
				plobj.direction = 2;

		} else {

			if (player[pln].y > plobj.y)
				plobj.direction = 1;
			else if (player[pln].y < plobj.y)
				plobj.direction = 3;
		}
	}
}
