/*
 *  Packdude game engine
 *  Copyright (C) 2003  Jaan Pullerits
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------
 *  ANIMATORS
 *
 *     Created on Fri Nov 22 21:29:46 2002 by JP
 *
 */

#include <allegro.h>
#include <stdio.h>
#include "tileset.h"
#include "animators.h"
#include "main.h"

#define ANIMFORM_VERSION 1

/*******************************************************************************

   clear_animator(ANIMATOR anim); Clears animator

*******************************************************************************/

void clear_animator(ANIMATOR anim)
{
	anim.mode = 0;
	anim.speed = 0;
	anim.frames = 0;
}


/*******************************************************************************

   clear_animators(); Clears all animators

*******************************************************************************/

void clear_animators()
{
	int x;
	for (x = 0; x < 10; x++) {
		clear_animator(animator[x]);
	}
	for (x = 0; x < 256; x++) {
		animator_lut[x] = -1;
	}
}

/*******************************************************************************

   redraw_animator_selector(); Redraws the animator selector

*******************************************************************************/
void static redraw_animator_selector()
{

	rect(screen, 44, 54, 69, 63, 7);

	textprintf(screen, font, 45, 55, 5, "%03i", current_animator);

}

/*******************************************************************************

   redraw_speed_selector(); Redraws the speed selector

*******************************************************************************/
void static redraw_speed_selector()
{

	rect(screen, 44, 36, 69, 45, 7);

	textprintf(screen, font, 45, 37, 5, "%03i", (int) animobj.speed);

}

/*******************************************************************************

   redraw_mode_selector(); Redraws the animation mode selector

*******************************************************************************/
void static redraw_mode_selector()
{

	rect(screen, 44, 9, 117, 27, 7);

	if (animobj.mode == 0) {
		textprintf(screen, font, 45, 10, 15, "FORWARD  ");
		textprintf(screen, font, 45, 18, 8, "PING-PONG");
	} else {

		textprintf(screen, font, 45, 10, 8, "FORWARD  ");
		textprintf(screen, font, 45, 18, 15, "PING-PONG");
	}

}



/*******************************************************************************

   redraw_listbox(); Redraws the listbox

*******************************************************************************/
void static redraw_listbox()
{

	int n;

	rect(screen, 9, 9, 35, 90, 7);

	for (n = 0; n < 10; n++) {

		if (n < animobj.frames)
			textprintf(screen, font, 10, 10 + n * 8, 15,
				   "%03i", (int) animobj.tile[n]);
		else
			textprintf(screen, font, 10, 10 + n * 8, 15,
				   "   ");

	}
}


/*******************************************************************************

   redraw_screen(); Redraws the screen by calling other functions 

*******************************************************************************/
void static redraw_screen()
{

	scare_mouse();
	clear_bitmap(screen);
	redraw_speed_selector();
	redraw_mode_selector();
	redraw_listbox();
	redraw_animator_selector();
	unscare_mouse();


}

/*MAIN**************************************************************************

   edit_animation(); Animation editor

*******************************************************************************/

void edit_animation()
{

	signed char aborted = FALSE;
	int inkey;
	BITMAP *image;

	image = create_bitmap(32, 32);	// These functions actually don't use it, but
	// Tile selector needs some bitmat as argument

	current_animator = 0;
	
redraw_screen();

	while (!aborted) {

		// KBHANDLER
		if (keypressed()) {

			inkey = readkey();

			if (ISKEY(KEY_SPACE)) {
				if (animobj.frames < 10) {
					if (select_tile(image)) {

						if (animator_lut
						    [current_tile] == -1) {
							animator_lut
							    [current_tile]
							    =
							    current_animator;
							animobj.frames++;
							animobj.
							    tile[animobj.
								 frames -
								 1] =
							    current_tile;
						}

					}
				}

				redraw_screen();
			} else if (ISKEY(KEY_ESC)) {

				aborted = TRUE;

			} else if (ISKEY(KEY_BACKSPACE)) {

				if (animobj.frames > 0) {

					animator_lut[(int) animobj.
						     tile[(int) animobj.
							  frames - 1]] =
					    -1;
					animobj.frames--;

				}

				redraw_listbox();

			} else if (ISKEY(KEY_P)) {

				if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
					if (animobj.speed > 0) {

						animobj.speed--;

					}

				} else {

					if (animobj.speed < 255) {

						animobj.speed++;

					}
				}

				redraw_speed_selector();
			} else if (ISKEY(KEY_M)) {

				if (animobj.mode == 0)
					animobj.mode = 1;
				else
					animobj.mode = 0;


				redraw_mode_selector();

			} else if (ISKEY(KEY_A)) {

				if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) {
					if (current_animator > 0) {

						current_animator--;

					}

				} else {

					if (current_animator < 9) {

						current_animator++;

					}
				}
				redraw_screen();
			} else if (ISKEY(KEY_S)) {
				if (file_select_ex
				    ("Save animator", animator_path, "ANM",
				     1024, 0, 0)) {
					report_map_err(save_animators
						       (animator_path));
				}
			} else if (ISKEY(KEY_L)) {
				if (file_select_ex
				    ("Load animator", animator_path, "ANM",
				     1024, 0, 0)) {
					report_map_err(load_animators
						       (animator_path));
					redraw_screen();
				}
			}
		}
	}
	destroy_bitmap(image);
}

/*******************************************************************************

   save_animators(); Animation format save

*******************************************************************************/
save_animators(char *filename)
{

	FILE *fp;
	int x, y;
	char version = ANIMFORM_VERSION;

	if ((fp = fopen(filename, "wb"))) {
		fputs("PDANM", fp);	// Header
		fputc(version, fp);	// Version

		for (x = 0; x < 10; x++) {
			for (y = 0; y < 10; y++) {
				fputc(animator[x].tile[y], fp);
			}
			fputc(animator[x].mode, fp);
			fputc(animator[x].speed, fp);
			fputc(animator[x].frames, fp);
		}
		fclose(fp);

	} else
		return 3;

	return 0;
}

/*******************************************************************************
   
  load_animators(); Animation format load

*******************************************************************************/
load_animators(char *filename)
{

	FILE *fp;
	int x, y, tile;
	int version;

	if ((fp = fopen(filename, "rb"))) {

		fgets(txtbuf, 6, fp);

		if (strcmp(txtbuf, "PDANM"))
			return 1;	// Not valid animator file

		version = (char) fgetc(fp);	// Version;

		if (1 > version > 1)
			return 2;	// Unknown version (right now only version 1 is supported)

		for (x = 0; x < 10; x++) {
			for (y = 0; y < 10; y++) {
				animator[x].tile[y] = tile = fgetc(fp);
				animator_lut[tile] = x;
			}
			animator[x].mode = fgetc(fp);
			animator[x].speed = fgetc(fp);
			animator[x].frames = fgetc(fp);

		}

		fclose(fp);

		strncpy(animator_path, filename, 1024);

	} else
		return 3;
	return 0;
}
