//last edit 3/21/97 :328
#include "pacgame.h"

Button *btn_start_game;
Button *btn_custom_game;
Button *btn_prev_menu;
Button *btn_high_scores;
Button *btn_credits;
Button *btn_options;

void Options(void)
{
 	PlaySong();
 	fade_out(10);
 	char *dif_levels[] = {"Easy", "Normal", "Hard"};
  	Button btn_exit_options = Button("E x i t", 215, 400, 425, 430, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
	if (sound_on) strcpy(text, "Sound On");
   else strcpy(text, "Sound Off");
   Button btn_sound_on = Button(text, 80, 100, 290, 130, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
	if (music_on) strcpy(text, "Music On");
   else strcpy(text, "Music Off");
   Button btn_music_on = Button(text, 350, 100, 560, 130,157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   Button btn_sound_rt = Button(NULL, 80, 200, 110, 230, 157, 142, (BITMAP*)graphics[BTN_LT].dat);
   Button btn_sound_lt = Button(NULL, 260, 200, 290, 230, 157, 142,(BITMAP*)graphics[BTN_RT].dat);
   Button btn_music_rt = Button(NULL, 350, 200, 380, 230, 157, 142, (BITMAP*)graphics[BTN_LT].dat);
   Button btn_music_lt = Button(NULL, 530, 200, 560, 230, 157, 142,(BITMAP*)graphics[BTN_RT].dat);
   Button btn_dif_rt = Button(NULL, 215, 300, 245, 330, 157, 142, (BITMAP*)graphics[BTN_LT].dat);
   Button btn_dif_lt = Button(NULL, 395, 300, 425, 330, 157, 142, (BITMAP*)graphics[BTN_RT].dat);

   sprintf(text, "%d", sound_volume);
   Button btn_sound_volume = Button(text, 111, 200, 259, 230, 157,142, (BITMAP*)graphics[BTN_EDIT].dat);
   sprintf(text, "%d", music_volume);
   Button btn_music_volume = Button(text, 381, 200, 529, 230, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);

   Button btn_dif_level = Button(dif_levels[dif_level], 246, 300, 394, 330, 157,142, (BITMAP*)graphics[BTN_EDIT].dat);


 	show_mouse(NULL);
   clear(screen);
   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN2].dat, 0, 0);
   rectfill(screen, 0, 0, SCREEN_W, SCREEN_H, 1);
   solid_mode();
   text_mode(-1);
	rect(screen, 0, 0, SCREEN_W-1, SCREEN_H-1, 142);
   textout_centre(screen, (FONT*)graphics[GAME_FONT].dat, "O P T I O N S", SCREEN_W/2, 20, 15);
   textout_centre(screen, (FONT*)graphics[GAME_FONT].dat, "Sound Volume", 195, 160, 15);
   textout_centre(screen, (FONT*)graphics[GAME_FONT].dat, "Music Volume", 455, 160, 15);
   textout_centre(screen, (FONT*)graphics[GAME_FONT].dat, "Difficulty level", SCREEN_W/2, 260, 15);
   show_mouse(screen);
   btn_exit_options.DrawButton();
   btn_sound_on.DrawButton();
   btn_music_on.DrawButton();
   btn_sound_rt.DrawButton();
   btn_sound_lt.DrawButton();
   btn_music_rt.DrawButton();
   btn_music_lt.DrawButton();
   btn_dif_rt.DrawButton();
   btn_dif_lt.DrawButton();
   btn_music_volume.DrawButton();
   btn_sound_volume.DrawButton();
   btn_dif_level.DrawButton();
   show_mouse(NULL);
   fade_in((RGB*)graphics[EDIT_PALLETE].dat, 5);
   show_mouse(screen);
   while (1==1) {
     	if (btn_exit_options.Clicked()) break;
      else if (btn_sound_on.Clicked()){
        	if (sound_on) {
           	sound_on = FALSE;
            btn_sound_on.ChangeName("Sound Off");
            btn_sound_on.DrawButton();
         }
      	else {
           	sound_on = TRUE;
            btn_sound_on.ChangeName("Sound On");
            btn_sound_on.DrawButton();
         }
      }
      else if (btn_music_on.Clicked()) {
        	if (music_on) {
           	music_on = FALSE;
            stop_midi();
            btn_music_on.ChangeName("Music Off");
            btn_music_on.DrawButton();
         }
      	else {
           	music_on = TRUE;
            PlaySong();
            btn_music_on.ChangeName("Music On");
            btn_music_on.DrawButton();
         }
      }
      else if (btn_sound_lt.Clicked()) {
        	if (sound_volume < 250) {
           	sound_volume+=10;
            sprintf(text, "%d", sound_volume);
            btn_sound_volume.ChangeName(text);
            btn_sound_volume.DrawButton();
         	set_volume(sound_volume, music_volume);
         }
      }
      else if (btn_sound_rt.Clicked()) {
        	if (sound_volume > 0) {
           	sound_volume-=10;
            sprintf(text, "%d", sound_volume);
            btn_sound_volume.ChangeName(text);
            btn_sound_volume.DrawButton();
         	set_volume(sound_volume, music_volume);
         }
      }
      else if (btn_music_lt.Clicked()) {
        	if (music_volume < 250) {
           	music_volume+=10;
            sprintf(text, "%d", music_volume);
            btn_music_volume.ChangeName(text);
            btn_music_volume.DrawButton();
          	set_volume(sound_volume, music_volume);
         }
      }
      else if (btn_music_rt.Clicked()) {
        	if (music_volume > 0) {
           	music_volume -= 10;
            sprintf(text, "%d", music_volume);
            btn_music_volume.ChangeName(text);
            btn_music_volume.DrawButton();
	      	set_volume(sound_volume, music_volume);
         }
      }
      else if (btn_dif_lt.Clicked()) {
        	if (dif_level < 2) {
            dif_level++;
            btn_dif_level.ChangeName(dif_levels[dif_level]);
            btn_dif_level.DrawButton();
         }
      }
      else if (btn_dif_rt.Clicked()) {
        	if (dif_level > 0) {
            dif_level--;
            btn_dif_level.ChangeName(dif_levels[dif_level]);
            btn_dif_level.DrawButton();
         }
      }
	}
	fade_out(10);
   stop_midi();
}

void ViewCredits(void)
{
 	#define MAX_LINES 16
 	char *credits[] = {"Programming: Andrew Deren",
   						 "Graphics: Rafal Wiszowaty",
                      "Andrew Deren",
                      "Level Design: Rafal Wiszowaty",
                      "Andrew Deren",
                      "Mateusz Zagata",
                      "Music: Mateusz Zagata",
                      "Sounds: Unknown",
                      " ",
                      "Special Thanks to: ",
                      "DJ Delorie",
                      "Shawn Hargreaves",
                      "Robert Hohne",
                      "Dexter Greene",
                      "Chris Deren",
                      "Don Yanek"};

   int position = SCREEN_H;
	PlaySong();
   show_mouse(NULL);
  	fade_out(255);
 	blit((BITMAP*)graphics[TITLE].dat, screen, 0, 0, 0, 0, 640, 480);
  	fade_in((RGB*)graphics[TITLE_PALLETE].dat, 5);
   text_mode(-1);
   clear_keybuf();
   while (1==1) {
      	blit((BITMAP*)graphics[TITLE].dat, screen_bitmap, 0, 0, 0, 0, 640, 480);
         for (int i=0; i<MAX_LINES; i++)
            textout_centre(screen_bitmap, (FONT*)graphics[NORMAL_FONT].dat, credits[i], SCREEN_W/2,position+i*20,255);
         vsync(); vsync();
			blit(screen_bitmap, screen, 0, 0, 0, 0, 640,480);
         position -= 1;
         if(position+MAX_LINES*20 < 0) position = SCREEN_H;
         if (keypressed()) break;
    }
   stop_midi();
   fade_out(2);
   clear(screen);
}




void DrawHighScores()
{
 	show_mouse(NULL);
   clear(screen);
   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN2].dat, 0, 0);
   rectfill(screen, 0, 0, SCREEN_W, SCREEN_H, 1);
   solid_mode();
   text_mode(-1);
	rect(screen, 0, 0, SCREEN_W-1, SCREEN_H-1, 142);

//   draw_sprite(screen, (BITMAP*)graphics[SCORE_BOX].dat, 245, 100);
   textout_centre(screen, (FONT*)graphics[GAME_FONT].dat, "H I G H   S C O R E S",
                  SCREEN_W/2, 20, 15);
   textout(screen, (FONT*)graphics[NORMAL_FONT].dat, "Name", 150, 60, 15);
   textout(screen, (FONT*)graphics[NORMAL_FONT].dat, "Score", 380, 60, 15);
   textout(screen, (FONT*)graphics[NORMAL_FONT].dat, "Level", 450, 60, 15);
	for (int i=0; i<MAX_HIGHSCORES; i++) {
      sprintf(text, "%2d     %s", i+1, HighScores[i].name);
      textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, 55, 80+i*20, 15);
      sprintf(text, "%06d", HighScores[i].score);
      textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, 380, 80+i*20, 15);
      sprintf(text, "%02d", HighScores[i].level);
      textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, 460, 80+i*20, 15);
   }
	show_mouse(screen);
}

void ViewHighScores(void)
{
 	PlaySong();
 	Button btn_high_scores = Button("E x i t", 100, 420, 300, 450, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
	Button btn_reset = Button("R e s e t", 340, 420, 540, 450, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   DrawHighScores();
   btn_high_scores.DrawButton();
   btn_reset.DrawButton();
   while (1==1) {
     	if (btn_high_scores.Clicked()) break;
      else if (btn_reset.Clicked()) {
        	for (int i= 0; i<MAX_HIGHSCORES; i++) {
            HighScores[i].score = 0;
            HighScores[i].level = 1;
            strcpy(HighScores[i].name, "Pac-Killer");
         }
         DrawHighScores();
         btn_high_scores.DrawButton();
         btn_reset.DrawButton();
      }
   	else if (key[KEY_ESC]) break;
   }
	stop_midi();
}

void DrawStartGameMenu(void)
{
   show_mouse(NULL);
   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN2].dat, 0, 0);
   rectfill(screen, 0, 0, SCREEN_W, SCREEN_H, 1);
   solid_mode();
   text_mode(-1);
	rect(screen, 0, 0, SCREEN_W-1, SCREEN_H-1, 142);
   textout(screen, font, "Pac-Horror v1.0 -- Ader Software 1997", 5, 468, 15);
   draw_sprite(screen, (BITMAP*)graphics[PAC_HORROR].dat, 135, 25);
   show_mouse(screen);

  	btn_start_game->DrawButton();
   btn_custom_game->DrawButton();
   btn_prev_menu->DrawButton();
   btn_high_scores->DrawButton();
   btn_credits->DrawButton();
   btn_options->DrawButton();
}


void StartGameMenu(void)
{
 	btn_start_game = new Button("Start Game", 200, 140, 440, 170, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_custom_game = new Button("Custom Game", 200, 180, 440, 210, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_options = new Button("Options", 200, 220, 440, 250, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_high_scores = new Button("View High Scores", 200, 260, 440, 290, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_credits = new Button("Credits", 200, 300, 440, 330, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_prev_menu = new Button("Previous Menu", 200, 340, 440, 370, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);

   show_mouse(NULL);
	fade_out(10);
	DrawStartGameMenu();
   show_mouse(NULL);
   fade_in((RGB*)graphics[EDIT_PALLETE].dat, 3);
	show_mouse(screen);

//   set_pallete((RGB*)graphics[EDIT_PALLETE].dat);
	PlaySong();
   while (1==1) {
     	if (btn_start_game->Clicked()) {
         stop_midi();
        	strcpy(text, "Map: 0");
         PlayGame();
         DrawStartGameMenu();
         PlaySong();
      }
      else if (btn_custom_game->Clicked()) {
         stop_midi();
         PlayCustomGame();
         DrawStartGameMenu();
         PlaySong();
      }
   	else if (btn_prev_menu->Clicked()) break;
      else if (btn_high_scores->Clicked()) {
         stop_midi();
        	ViewHighScores();
         DrawStartGameMenu();
         PlaySong();
      }
      else if (btn_credits->Clicked()) {
         stop_midi();
        	ViewCredits();
         DrawStartGameMenu();
         set_pallete((RGB*)graphics[EDIT_PALLETE].dat);
         PlaySong();
      }
      else if (btn_options->Clicked()) {
         stop_midi();
        	Options();
         DrawStartGameMenu();
         set_pallete((RGB*)graphics[EDIT_PALLETE].dat);
         PlaySong();
      }
      if (key[KEY_ESC]) break;
   }
	stop_midi();
	delete btn_start_game;
   delete btn_custom_game;
   delete btn_prev_menu;
   delete btn_high_scores;
   delete btn_credits;
   delete btn_options;
}
