//last edit 3/21/96 :102
#ifndef _pacgame_h
#define _pacgame_h

#include <stdio.h>
#include <allegro.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

// all of those includes are created by grabber
#define NUM_SETS 8	// number of sets of graphics
#include "set0.h"
#include "set1.h"
#include "set2.h"
#include "set3.h"
#include "set4.h"
#include "set5.h"
#include "set6.h"
#include "set7.h"
#include "pac.h"
#include "pac2.h"
#include "maps.h"
#include "sounds.h"

#define MAX_HIGHSCORES 15	// maximum number of highscores
#define MAX_SONGS 8			// number of midis
#define MAX_MAPS 26			// number of maps

typedef unsigned char BYTE;
typedef short int INTEGER;

extern DATAFILE *set_graphics[NUM_SETS]; 	//set0..NUM_SETS

extern BITMAP *screen_bitmap;			//640x480 bitmap
extern BITMAP *map_bitmap;


extern DATAFILE *graphics;
extern DATAFILE *sprites;
extern DATAFILE *mapData;
extern DATAFILE *sounds;

struct map_struct {
	INTEGER eater_x, eater_y;
	INTEGER pac_x, pac_y;
	INTEGER num_eaters, num_balls;
	INTEGER values[22][22];
	INTEGER scores[8];
};

class Button {
private:
	int x1, x2, y1, y2;
	int frame1, frame2;
	BITMAP *bitmap;
	char name[25];
	int pressed;
public:
	Button(char *, int xa, int ya, int xb, int yb, int f1, int f2, BITMAP*);
	void DrawButton(void);
	int Clicked(void);
	void ChangeName(char*);
};

void Error(char *string);
int mouseinbox(int x1, int y1, int x2, int y2);
int FileExist(char *filename);
void DrawFrame(int x1, int y1, int x2, int y2, int col1, int col2);
void main_edit(void);
void Dtextout_centre(BITMAP *s, FONT *f, char *str, int x1, int y1, int col1, int col2);
void Dtextout(BITMAP* s, FONT* f, char *str, int x1, int y1, int col1, int col2);
void PlayGame(void);
void PlayMap(struct map_struct *map);
void StartGameMenu(void);
void InitGameGraphics(void);
void ViewHighScores(void);
void PlayCustomGame(void);
int Random(int);
void PlaySong(void);

extern map_struct map;
extern char text[256];

extern int lives;
extern int score;

struct HighScoresStruct {
	int score;
	int level;
	char name[14];
};

extern struct HighScoresStruct HighScores[MAX_HIGHSCORES];
extern int current_map_played;

extern int sound_on;
extern int music_on;
extern int sound_volume;
extern int music_volume;
extern int dif_level;
#endif
