//last edit: 3/20/97 :575
#include "pacgame.h"

DATAFILE *edit_graphics;
Button *btn_new;
Button *btn_opn;
Button *btn_sav;
Button *btn_ext;
Button *btn_arup;
Button *btn_ardn;
Button *btn_grid;
Button *btn_pretty;
Button *btn_pref;
Button *btn_replace;

map_struct map;
char text[256];

int button = 0;
int current_set = 0;
int current_left = 1;
int current_right = 1;
int *tt;
int prettyOn = TRUE;
int gridOn = TRUE;
int replace_array[] = {1, 101, 201, 301, 401, 501, 601, 701, 702, 703, 704, 713};

char current_map_name[20] = {"untitled.map"};

void DrawMap(void);
void Pretty(void);

void DrawGrid(void)
{
	for (int i=1; i<23; i++) {
		vline(map_bitmap, i*20, 0, 22*20, 13);
		hline(map_bitmap, 0, 20*i, 22*20, 13);
	}
}

void DrawMapName(void)
{
 	show_mouse(NULL);
   blit((BITMAP*)graphics[BTN_EDIT].dat, screen, 0, 0, 445, 440, 190, 15);
   rect(screen, 445, 440, 635, 455, 142);
   text_mode(-1);
   textout(screen, font, current_map_name, 450, 444, 15);
   show_mouse(screen);
}

void NewGame(void)
{
 	for (int i=0; i<22; i++) {
      for (int j=0; j<22; j++) {
         map.values[i][j] = 713;
       }
   }
	for (int i=0; i<4; i++) map.scores[i] = 20;
   for (int i=4; i<8; i++) map.scores[i] = 200;
	map.num_eaters = 3;
   strcpy(current_map_name, "Untitled.map");
   DrawMapName();
   show_mouse(NULL);
	DrawMap();
   show_mouse(screen);
}

void DrawSelected(void)
{
		blit((BITMAP*)set_graphics[current_left/100][current_left%100].dat,
           screen, 0, 0, 395, 455, 20, 20);
      blit((BITMAP*)set_graphics[current_right/100][current_right%100].dat,
           screen, 0, 0, 418, 455, 20, 20);
      textout(screen, font, "L:", 397, 445, 15);
      textout(screen, font, "R:", 420, 445, 15);
      rect(screen, 394, 454, 416, 476, 13);
      rect(screen, 417, 454, 439, 476, 15);
}

void SetLocs(void)
{
   map.num_balls = 0;
   for (int i=0; i<22; i++) {
      for (int j=0; j<22; j++) {
         if (map.values[i][j]/100==7 && map.values[i][j]%100<5) map.num_balls++;
         else if (map.values[i][j] == 715) {
            map.eater_x = i; map.eater_y = j;
         }
      	else if (map.values[i][j] == 716) {
           	map.pac_x = i; map.pac_y = j;
         }
      }
   }
}

void SaveMap(void)
{
 	int temp = 1;
 	FILE *file;
   SetLocs();
   show_mouse(NULL);
   blit(screen, screen_bitmap, 0, 0, 0, 0, 640, 480);
   show_mouse(screen);
//   text[0] = '\0';
	strcpy(text, current_map_name);
  	if (file_select("Save Map", text, "map") != 0) {
     	if (FileExist(text)) 	temp = (alert("File already exists.", "Overwrite", NULL, "OK", "Cancel", KEY_ENTER, KEY_ESC) == 1);
		if (temp == 1) {
		   file = fopen(text, "wb");
   	   if (!file)	alert("Error saving file.", NULL, NULL, "OK", NULL, KEY_ENTER, 0);
	   	else {
			   fwrite(&map, sizeof(struct map_struct), 1, file);
      	   fclose(file);
            strcpy(current_map_name, get_filename(text));
	      }
      }
   }
   show_mouse(NULL);
	blit(screen_bitmap, screen, 0, 0, 0, 0, 640, 480);
   show_mouse(screen);
	DrawMapName();
}

void OpenMap(void)
{
 	FILE *file;
   show_mouse(NULL);
   blit(screen, screen_bitmap, 0, 0, 0, 0, 640, 480);
   show_mouse(screen);
   text[0] = '\0';
   if (file_select("Open Map", text, "map") != 0) {
     	file = fopen(text, "rb");
      if (!file)
        	alert("Error opening file.", NULL, NULL, "OK", NULL, KEY_ENTER, 0);
      else {
        	fread(&map, sizeof(struct map_struct), 1, file);
         fclose(file);
         strcpy(current_map_name, get_filename(text));
      }
   }
	show_mouse(NULL);
	blit(screen_bitmap, screen, 0, 0, 0, 0, 640, 480);
   DrawMap();
   show_mouse(screen);
	DrawMapName();
}

void DrawSet(void)
{
 	show_mouse(NULL);
   sprintf(text, "%d", current_set);
	text_mode(0);
   textout(screen, font, text, 2, 445, 15);
   int col;
 	for (int i=1; i<17; i++) {
      col = 0;
		if (current_left / 100 == current_set && current_left%100 == i) col = 13;
      else if (current_right / 100 == current_set && current_right%100 == i) col = 15;
		rect(screen, i*22-1, 454, i*22+20, 475, col);
		sprintf(text, "%2d", i);
      textout(screen, font, text, i*22+3, 445, 15);
		blit((BITMAP*)set_graphics[current_set][i].dat, screen, 0, 0, i*22, 455, 20, 20);
   }
	DrawSelected();
	show_mouse(screen);
}


void edit_init(void)
{
   show_mouse(NULL);
   clear(screen);
   gui_fg_color = 8;
   gui_bg_color = 47;
   fade_in((RGB*)graphics[EDIT_PALLETE].dat, 10);

   btn_new = new Button("N E W", 480, 10, 600, 35, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_sav = new Button("S A V E", 480, 40, 600, 65, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_opn = new Button("O P E N", 480, 70, 600, 95, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_ext = new Button("E X I T", 480, 100, 600, 125, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
	btn_grid = new Button("Grid On", 480, 150, 600, 175, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_pretty = new Button("Pretty On", 480, 180, 600, 205, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_pref = new Button("Preferences", 480, 220, 600, 245, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   btn_replace = new Button("Replace", 480, 255, 600, 280, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);

   btn_arup = new Button(NULL, 1, 455, 20, 465, 157, 142, (BITMAP*)graphics[BTN_UP].dat);
	btn_ardn = new Button(NULL, 1, 466, 20, 476, 157, 142, (BITMAP*)graphics[BTN_DN].dat);

   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN].dat, 0, 0);
   rectfill(screen, 442, 0, 640, 480, 2);
   solid_mode();

   vline(screen, 441, 0, 480, 142);
   hline(screen, 0, 441, 441, 142);
   vline(screen, 0, 442, 480, 142);
   hline(screen, 0, 479, 640, 142);
   hline(screen, 442, 0, 640, 142);
   vline(screen, 639, 0, 480, 142);
   vline(screen, 442, 0, 480, 157);
   text_mode(-1);
	textout(screen, font, "Pac-Edit v1.12", 444, 460, 15);
   textout(screen, font, "Andrew Deren 1997", 444, 470, 15);
   NewGame();

   show_mouse(screen);

	btn_new->DrawButton();
   btn_sav->DrawButton();
   btn_opn->DrawButton();
   btn_ext->DrawButton();
   btn_arup->DrawButton();
   btn_ardn->DrawButton();
   btn_pretty->DrawButton();
   btn_grid->DrawButton();
   btn_pref->DrawButton();
   btn_replace->DrawButton();
   DrawSet();
}

void DrawMap(void)
{
	clear(map_bitmap);
   if (prettyOn) Pretty();
 	for (int i=0; i<22; i++) {
      for (int j=0; j<22; j++) {
        	blit((BITMAP*)set_graphics[map.values[i][j]/100][map.values[i][j]%100].dat, map_bitmap,
                0, 0, i*20, j*20, 20, 20);
      }
   }
	if (gridOn) DrawGrid();
   vline(map_bitmap, 0, 0, 441, 142);
   hline(map_bitmap, 0, 0, 441, 142);

	blit(map_bitmap, screen, 0, 0, 0, 0, 441, 441);
}

int SetNext(int cur1, int cur2)
{
 	if (map.values[cur1][cur2] / 100 > 6) return 0;
	int dirs[5];

	if (cur2 == 0) dirs[1] = 0;
   else {
     	if (map.values[cur1][cur2-1] / 100 < 7) dirs[1] = map.values[cur1][cur2-1];
      else dirs[1] = 0;
   }
	if (cur2 == 21) dirs[3] = 0;
   else {
     	if (map.values[cur1][cur2+1] / 100 < 7) dirs[3] = map.values[cur1][cur2+1];
      else dirs[3] = 0;
   }
	if (cur1  == 0) dirs[4] = 0;
   else {
     	if (map.values[cur1-1][cur2] / 100 < 7) dirs[4] = map.values[cur1-1][cur2];
      else dirs[4] = 0;
   }
	if (cur1  == 21) dirs[2] = 0;
   else {
	   if (map.values[cur1+1][cur2] / 100 < 7) dirs[2] = map.values[cur1+1][cur2];
      else dirs[2] = 0;
   }

	if ((dirs[1] > 0) && (dirs[2] > 0) && (dirs[3] > 0) && (dirs[4] > 0))
		return 16;
	else if ((dirs[1] > 0) && (dirs[2] > 0) && (dirs[3] > 0))
		return 7;
	else if ((dirs[1] > 0) && (dirs[2] > 0) && (dirs[4] > 0))
		return 9;
	else if ((dirs[1] > 0) && (dirs[3] > 0) && (dirs[4] > 0))
		return 8;
	else if ((dirs[2] > 0) && (dirs[3] > 0) && (dirs[4] > 0))
		return 10;
	else if ((dirs[2] > 0) && (dirs[3] > 0))
		return 3;
	else if ((dirs[1] > 0) && (dirs[2] > 0))
		return 4;
	else if ((dirs[1] > 0) && (dirs[4] > 0))
		return 5;
	else if ((dirs[4] > 0) && (dirs[3] > 0))
		return 6;
	else if ((dirs[1] > 0) && (dirs[3] > 0))
		return 1;
	else if ((dirs[2] > 0) && (dirs[4] > 0)) 
		return 2;
	else if (dirs[3] > 0)
		return 11;
	else if (dirs[1] > 0)
		return 12;
	else if (dirs[2] > 0)
		return 13;
	else if (dirs[4] > 0)
		return 14;
	else return 15;
}
		
void Pretty()
{
	int ret;
	for (int i=0; i<22;i++) {
      for (int j=0; j<22; j++) {
			ret = SetNext(i, j);
			if (ret != 0) map.values[i][j] = (int)(map.values[i][j] / 100)*100 + ret;
		}
   }
}

void DrawScoreValues(void)
{
 	show_mouse(NULL);
   text_mode(-1);
   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN].dat, 0, 0);
	for (int i=0; i<8; i++) {
      if (map.scores[i] < 0) {
         if (i<4) map.scores[i] = 200;
         else map.scores[i] = 2000;
      }
   	if (i<4 && map.scores[i] > 200) map.scores[i] = 0;
     	else if  (i >= 4 && map.scores[i] > 2000) map.scores[i] = 0;
      sprintf(text, "%4d", map.scores[i]);
		rectfill(screen, 322, 105+i*30, 365, 115+i*30, 15);
      textout(screen, font, text, 325, 106+i*30, 15);
   }
	if (map.num_eaters < 1) map.num_eaters = 20;
   else if (map.num_eaters > 20) map.num_eaters = 1;
	sprintf(text, "%4d", map.num_eaters);
	rectfill(screen, 322, 105+8*30, 365, 115+8*30, 15);
	textout(screen, font, text, 325, 8*30+106, 15);
   solid_mode();
   show_mouse(screen);
}

void Preferences(void)
{
	Button *buttons[18];
   Button *exit_btn;
   Button *def_btn;
   SetLocs();
   for (int i=0; i<9; i++) {
	   buttons[i] = new Button(NULL, 300, 100+i*30, 320, 110+i*30, 157, 142, (BITMAP*)graphics[BTN_UP].dat);
		buttons[i+9] = new Button(NULL, 300, 111+i*30, 320, 121+i*30, 157, 142, (BITMAP*)graphics[BTN_DN].dat);
	}
	exit_btn = new Button("EXIT", 220, 100, 290, 125, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   def_btn = new Button("Default", 220, 140, 290, 165, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
	show_mouse(NULL);

	blit(screen, screen_bitmap, 0, 0, 0, 0, 640, 480);

   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN].dat, 0, 0);
   rectfill(screen, 200, 80, 450, 420, 10);
   solid_mode();
   DrawFrame(200, 80, 450, 420, 142, 157);
	sprintf(text, "Number of balls: %d", map.num_balls);
   textout(screen, font, text, 220, 375, 15);
   sprintf(text, "Eater loc: %d  %d",map.eater_x, map.eater_y);
   textout(screen, font, text, 220, 390, 15);
   sprintf(text, "Pac loc: %d  %d", map.pac_x, map.pac_y);
   textout(screen, font, text, 220, 405, 15);

	for (int i=0; i<9; i++) {
    	buttons[i]->DrawButton();
      buttons[i+9]->DrawButton();
   }
	for (int i=0; i<8; i++)
      draw_sprite(screen, (BITMAP*)set_graphics[7][i+1].dat, 370, 101+i*30);
   draw_sprite(screen, (BITMAP*)set_graphics[7][15].dat, 370, 101+8*30);
	exit_btn->DrawButton();
   def_btn->DrawButton();
   show_mouse(screen);
	DrawScoreValues();
	while (1==1) {
		if (exit_btn->Clicked()) break;
      if (def_btn->Clicked()) {
        	for (int i=0; i<4; i++) map.scores[i] = 20;
         for (int i=4; i<8; i++) map.scores[i] = 200;
         map.num_eaters = 3;
         DrawScoreValues();
      }
      else if (buttons[8]->Clicked()) {
        	map.num_eaters++;
         DrawScoreValues();
      }
		else if (buttons[17]->Clicked()) {
        	map.num_eaters--;
         DrawScoreValues();
      }
      for (int i=0; i<8; i++) {
         if (buttons[i]->Clicked()) {
           	if (i<4) map.scores[i] += 5;
           	else map.scores[i] += 10;
            DrawScoreValues();
         }
         else if (buttons[i+9]->Clicked()) {
           	if (i<4) map.scores[i] -= 5;
           	else map.scores[i] -= 10;
            DrawScoreValues();
         }
      }
   }
	for (int i=0; i<18; i++) delete buttons[i];
   delete exit_btn;
   delete def_btn;
	show_mouse(NULL);
	blit(screen_bitmap, screen, 0, 0, 0, 0, 640, 480);
   show_mouse(screen);
}

void DrawReplaceSet(int old_set, int new_set)
{
 	show_mouse(NULL);
   old_set = replace_array[old_set];
   new_set = replace_array[new_set];
  	blit((BITMAP*)set_graphics[old_set/100][old_set%100].dat, screen, 0, 0, 380, 210, 20, 20);
	blit((BITMAP*)set_graphics[new_set/100][new_set%100].dat, screen, 0, 0, 380, 240, 20, 20);
	show_mouse(screen);
}

void Replace(void)
{
 	Button *buttons[6];
   int old_set = 11;
   int new_set = 7;
   buttons[0] = new Button("OK", 230, 210, 330, 235, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   buttons[1] = new Button("Cancel", 230, 240, 330, 265, 157, 142, (BITMAP*)graphics[BTN_EDIT].dat);
   buttons[2] = new Button(NULL, 350, 210, 370, 220, 157, 142, (BITMAP*)graphics[BTN_UP].dat);
   buttons[3] = new Button(NULL, 350, 221, 370, 231, 157, 142, (BITMAP*)graphics[BTN_DN].dat);
   buttons[4] = new Button(NULL, 350, 240, 370, 250, 157, 142, (BITMAP*)graphics[BTN_UP].dat);
   buttons[5] = new Button(NULL, 350, 251, 370, 261, 157, 142, (BITMAP*)graphics[BTN_DN].dat);

   show_mouse(NULL);
   blit(screen, screen_bitmap, 0, 0, 0, 0, 640, 480);
	drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN].dat, 0, 0);
   rectfill(screen, 200, 180, 460, 300, 1);
   solid_mode();
   DrawFrame(200, 180, 460, 300, 142, 157);
   DrawFrame(378, 238, 402, 262, 157, 142);
	DrawFrame(378, 208, 402, 232, 157, 142);
   Dtextout_centre(screen, (FONT*)graphics[GAME_FONT].dat, "Replace", 330, 185, 142, 157);
   textout(screen, font, "Old", 410, 221, 15);
   textout(screen, font, "New", 410, 251, 15);
	show_mouse(screen);
   DrawReplaceSet(old_set, new_set);
   for (int i=0; i<6; i++) buttons[i]->DrawButton();
   while (1==1) {
     	if (buttons[0]->Clicked()) {
        	for (int i=0; i<22; i++) {
            for (int j=0; j<22; j++) {
					if (map.values[i][j]/100 == replace_array[old_set]/100 && map.values[i][j]/100 < 7)
                  map.values[i][j] = replace_array[old_set];
					if (map.values[i][j] == replace_array[old_set])
                  map.values[i][j] = replace_array[new_set];
            }
         }
        	break;
      }
   	else if (buttons[1]->Clicked()) break;
      else if (buttons[2]->Clicked()) {
        	old_set++;
         if (old_set > 11) old_set = 0;
         DrawReplaceSet(old_set, new_set);
      }
   	else if (buttons[3]->Clicked()) {
        	old_set--;
         if (old_set < 0) old_set = 11;
         DrawReplaceSet(old_set, new_set);
      }
   	else if (buttons[4]->Clicked()) {
        	new_set++;
         if (new_set > 11) new_set = 0;
         DrawReplaceSet(old_set, new_set);
      }
   	else if (buttons[5]->Clicked()) {
        	new_set--;
         if (new_set < 0) new_set = 11;
         DrawReplaceSet(old_set, new_set);
      }
   }
	for (int i=0; i<6; i++) delete buttons[i];
	show_mouse(NULL);
	blit(screen_bitmap, screen, 0, 0, 0, 0, 640, 480);
   DrawMap();
   show_mouse(screen);
}

void main_edit(void)
{
 	int t;
 	edit_init();
   while (1==1) {
     	if (key[KEY_F10]){
      	while (key[KEY_F10]) {}
        	BITMAP* bmp;
         PALLETE pal;
         bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
         get_pallete(pal);
         save_pcx("pacedit.pcx", bmp, pal);
         destroy_bitmap(bmp);
      }

    	if (btn_new->Clicked()) NewGame();
      else if (btn_sav->Clicked()) SaveMap();
      else if (btn_opn->Clicked()) OpenMap();
      else if (btn_ext->Clicked()) break;
      else if (btn_grid->Clicked()) {
        	if (gridOn) {gridOn = FALSE; btn_grid->ChangeName("Grid off");}
         else {gridOn = TRUE; btn_grid->ChangeName("Grid On");}
         btn_grid->DrawButton();
         show_mouse(NULL);
         DrawMap();
         show_mouse(screen);
      }
   	else if (btn_pretty->Clicked()) {
        	if (prettyOn) {prettyOn = FALSE; btn_pretty->ChangeName("Pretty off");}
         else {prettyOn = TRUE; btn_pretty->ChangeName("Pretty On");}
         btn_pretty->DrawButton();
      }
      else if (btn_arup->Clicked()) {
        	current_set++;
         if (current_set == NUM_SETS) current_set = 0;
         DrawSet();
      }
   	else if (btn_ardn->Clicked()) {
        	current_set--;
         if (current_set == -1) current_set = NUM_SETS-1;
         DrawSet();
      }
   	else if (btn_pref->Clicked()) Preferences();
      else if (btn_replace->Clicked()) Replace();
   	if (mouseinbox(21, 454, 372, 475)) {
         if ((mouse_b & 1) || (mouse_b & 2)){
   	      if (mouse_b & 1) tt = &current_left;
	         else if (mouse_b & 2) tt = &current_right;
           	set_mouse_range(22, 454, 371, 475);
            t = *tt;
	         while ((mouse_b & 1)||(mouse_b&2)) {
              	*tt = (mouse_x / 22)+current_set*100;
					if (*tt != t) {
                  show_mouse(NULL);
                 	t = *tt;
						DrawSet();
                  show_mouse(screen);
               }	//end if
				}	//end while
         	set_mouse_range(0, 0, 640, 480);
         }	//end mouse_b
      }	//end mouseinbox
   	else if (mouseinbox(0, 0, 440, 440)) {
			int old_x = mouse_x / 20+1;
         int old_y = mouse_y / 20+1;
         if ((mouse_b & 1) || (mouse_b & 2)){
           	set_mouse_range(0, 0, 439, 439);
            if (mouse_b & 2) tt = &current_right;
            else tt = &current_left;
				do {
					if ((mouse_x / 20 != old_x) || (mouse_y / 20 != old_y)) {
                 	show_mouse(NULL);
                  if (key[KEY_LSHIFT] || key[KEY_RSHIFT]) map.values[mouse_x/20][mouse_y/20] = 713;
						else map.values[mouse_x/20][mouse_y/20] = *tt;
                  DrawMap();
                  old_x = mouse_x / 20;
                  old_y = mouse_y / 20;
                  rect(screen, old_x*20, old_y*20, old_x*20+20, old_y*20+20, 15);
                  show_mouse(screen);
					} // end if
            } while ((mouse_b & 1)||(mouse_b & 2));
         	set_mouse_range(0, 0, 640, 480);
            show_mouse(NULL);
            DrawMap();
            show_mouse(screen);
         }	// end if mouse_b & 1
      }	//end else if
	} //end while infinite loop
   delete btn_new;
   delete btn_sav;
   delete btn_opn;
   delete btn_ext;
   delete btn_arup;
   delete btn_ardn;
   delete btn_grid;
   delete btn_pretty;
   delete btn_pref;
   delete btn_replace;
   fade_out(25);
   show_mouse(NULL);
   clear(screen);
}

