//last edit: 3/21/97 :167
#include "pacgame.h"

DATAFILE *set_graphics[8];
DATAFILE *graphics;
DATAFILE *sprites;
DATAFILE *mapData;
DATAFILE *sounds;

BITMAP *screen_bitmap;
BITMAP *map_bitmap;

Button *btn_new_game;
Button *btn_map_edit;
Button *btn_exit;

int sound_on = TRUE;
int music_on = TRUE;
int sound_volume = 200;
int music_volume = 200;
int dif_level = 1;

void Error(char *string)
{
	allegro_exit();
	printf("Error: %s\n", string);
	exit(1);
}

int FileExist(char *filename)
{
	return file_exists(filename, FA_RDONLY | FA_ARCH, NULL);
}

void DrawTitle(void)
{
	show_mouse(NULL);
	fade_out(255);
	blit((BITMAP*)graphics[TITLE].dat, screen, 0, 0, 0, 0, 640, 480);
	btn_new_game->DrawButton();
	btn_map_edit->DrawButton();
	btn_exit->DrawButton();
	show_mouse(NULL);
	fade_in((RGB*)graphics[TITLE_PALLETE].dat, 5);
	show_mouse(screen);
}

void PlaySong(void)
{
	if (music_on)
		play_midi((MIDI*)sounds[SONG1+Random(MAX_SONGS)].dat, TRUE);
}

int main(int argc, char** argv)
{
	FILE *file;
	printf("Initializing...\n");
	srand((int)time(NULL));
	allegro_init();
	install_mouse();
	install_timer();
	install_keyboard();
	initialise_joystick();

	printf("Installing sound...\n");
	if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL) != 0) {
		printf("No sound and music drivers found\n");
		sound_on = FALSE;
		music_on = FALSE;
	}
	else {
		printf("Sound driver %s %s\n", digi_driver->name, digi_driver->desc);
		printf("Music driver %s %s\n", midi_driver->name, midi_driver->desc);
		set_volume(sound_volume, music_volume);
	}

	if (!FileExist("pac.hsc")) {
		for (int i=0; i<MAX_HIGHSCORES; i++) {
			HighScores[i].score = 0;
			HighScores[i].level = 1;
			strcpy(HighScores[i].name, "Pac-Killer");
		}
	}
	else {
		file = fopen("pac.hsc", "rb");
		if (!file) Error("Error reading file: pac.hsc\nDelete it and try running again.\n");
		fread(&HighScores, sizeof(struct HighScoresStruct), MAX_HIGHSCORES, file);
		fclose(file);
	}
	if (!FileExist("pac.dat")) Error("Cannot find file pac.dat");
	if (!FileExist("pac2.dat")) Error("Cannot find file pac2.dat");
	if (!FileExist("maps.dat")) Error("Cannot find file maps.dat");
	if (!FileExist("set0.dat")) Error("Cannot find file set0.dat");
	if (!FileExist("set1.dat")) Error("Cannot find file set1.dat");
	if (!FileExist("set2.dat")) Error("Cannot find file set2.dat");
	if (!FileExist("set3.dat")) Error("Cannot find file set3.dat");
	if (!FileExist("set4.dat")) Error("Cannot find file set4.dat");
	if (!FileExist("set5.dat")) Error("Cannot find file set5.dat");
	if (!FileExist("set6.dat")) Error("Cannot find file set6.dat");
	if (!FileExist("set7.dat")) Error("Cannot find file set7.dat");
	if (!FileExist("sounds.dat")) Error("Cannot find file sounds.dat");
	printf("Loading set graphics ...\n");
	set_graphics[0] = load_datafile("set0.dat");
	set_graphics[1] = load_datafile("set1.dat");
	set_graphics[2] = load_datafile("set2.dat");
	set_graphics[3] = load_datafile("set3.dat");
	set_graphics[4] = load_datafile("set4.dat");
	set_graphics[5] = load_datafile("set5.dat");
	set_graphics[6] = load_datafile("set6.dat");
	set_graphics[7] = load_datafile("set7.dat");
	sprites = load_datafile("pac2.dat");
	mapData = load_datafile("maps.dat");
	printf("Loading title graphics ... \n");
	graphics = load_datafile("pac.dat");
	printf("Loading sounds ...\n");
	sounds = load_datafile("sounds.dat");
	btn_new_game = new Button("GAME", 10, 230, 150, 255, 48, 110, (BITMAP*)graphics[BTN_TITLE].dat);
	btn_map_edit = new Button("MAP EDITOR", 10, 260, 150, 285, 48, 110, (BITMAP*)graphics[BTN_TITLE].dat);
	btn_exit = new Button("EXIT", 10, 290, 150, 315, 48, 110, (BITMAP*)graphics[BTN_TITLE].dat);

	set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0);	//set graphics mode to 640x480x256

	map_bitmap = create_bitmap(441,441);
	screen_bitmap = create_bitmap(640, 480);
	PlaySong();
	DrawTitle();
	do {
		if (key[KEY_F10]) {
			RGB title_pal[256];
			get_palette(title_pal);
			//create temp bitmap
			BITMAP *tbmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
			//save the picture with game pallete
			save_pcx("editor.pcx", tbmp, title_pal);
			destroy_bitmap(tbmp);     //destroy bitmap
		}
		if (btn_new_game->Clicked()) {
			stop_midi();
			StartGameMenu();
			DrawTitle();
			PlaySong();
		}
		else if (btn_map_edit->Clicked()) {
			stop_midi();
			main_edit();
			DrawTitle();
			PlaySong();
		}
		else if (btn_exit->Clicked()) break;
		else if (key[KEY_ESC]) break;
	} while (1==1);
	stop_midi();
	fade_out(2);
	file = fopen("pac.hsc", "wb");
	if (file) {
		fwrite(&HighScores, sizeof(struct HighScoresStruct), MAX_HIGHSCORES, file);
		fclose(file);
	}
	allegro_exit();
	printf("                             Ader Software 2001                        \n");
	printf("                         P A C - H O R R O R   v1.02                   \n");
	printf("              http://www.adersoftware.com                              \n");
	printf(" --------------------------------------------------------------------- \n");
	printf("                               Programming  by                         \n");
	printf("                      Andrew Deren  aderen@eecs.uic.edu                \n");
	printf("                                Graphics by                            \n");
	printf("                             Rafal Wiszowaty                           \n");
	printf(" --------------------------------------------------------------------- \n");
	printf("                            Special Thanks To:                         \n");
	printf("                      DJ Delorie - for making DJGPP                    \n");
	printf("           Shawn Hargreaves - for making allegro game library          \n");
	printf("      Dexter Greene (dyg@hickory.net) - for changing some things       \n");
	printf("              and all the other people who contributed to              \n");
	printf("                 DJGPP development tools and utilities.                \n");
	printf(" --------------------------------------------------------------------- \n");
	printf("                       (C) Ader Software 1997");
	printf("\n\n\n");

	return 0;
}
END_OF_MAIN();