//last edit 3/21/97 :648
#include "pacgame.h"

#define SCORE_X 500
#define SCORE_Y 210

struct player_struct {	//player structure
	int x_loc, y_loc;		//used by pac
	int x_dir, y_dir;		//and eaters
	int state;
	int frame;
};

struct map_struct *gmap;

struct player_struct eaters[20];
struct player_struct pac;

int mapV[22][22];
int mapBlood[22][22];

volatile int pac_timer = 0;
volatile int eater_timer = 0;
volatile int eater_dead_timer= 0;
volatile int ball_timer=0;
volatile int frame_rate_timer = 0;

int pac_speed, eater_speed;
int state_timer = 0;
int eater_move_counter = 0;
int pac_move_counter = 0;
int pac_move_direction=0; /* 0-none, 1-up, 2-down, 3-left, 4-right */

int current_map_played;
int score;
int num_balls;
int lives;
int end_game;
int eaters_eaten;
int max_eaters_state;
int num_eaters;
int extra_life;


struct HighScoresStruct HighScores[MAX_HIGHSCORES];

int Random(int x) {return rand() % x;}

void MoveEater(int which);
void ChangeEaterDir(int which);
int EaterGoUp(int which);
int EaterGoLeft(int which);
int EaterGoDown(int which);
int EaterGoRight(int which);
void MoveLeft(void);
void MoveRight(void);
void MoveDown(void);
void MoveUp(void);
void Blood(void);
void GetHighScore(void);
void GotHighScore(void);

void increment_timer()
{
	pac_timer++;
	eater_timer++;
	eater_dead_timer++;
	ball_timer++;
	frame_rate_timer++;
}
END_OF_FUNCTION(increment_timer);

void PlaySound(int which)
{
	play_sample((SAMPLE*)sounds[which].dat, sound_volume, 125, 1000, FALSE);
}

void InitGameGraphics(void)
{
	clear(screen);
	//   drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN].dat, 0, 0);
	//	rectfill(screen, 465, 20, 630, 460, 1);
	//   solid_mode();
	draw_sprite(screen, (BITMAP*)graphics[SCORE_BOX].dat, 465, 160);
	draw_sprite(screen, (BITMAP*)graphics[GAME_TITLE].dat, 465, 10);
	//   rect(screen, 465, 20, 630, 460, 142);
}

void DrawGameMap(void)
{
	int i, j;
	clear(map_bitmap);
	for (i=0; i<22; i++) {
		for (j=0; j<22; j++) {
			if (gmap->values[i][j] < 700)
				draw_sprite(map_bitmap, (BITMAP*)set_graphics[gmap->values[i][j]/100][gmap->values[i][j]%100].dat, i*20, j*20);
			if (mapV[i][j] > 0 && mapV[i][j] < 9)
				draw_sprite(map_bitmap, (BITMAP*)set_graphics[7][mapV[i][j]].dat, i*20, j*20);

			if (mapBlood[i][j] == 2)	//put blood
				draw_sprite(map_bitmap, (BITMAP*)sprites[BLOOD_RIGHT].dat, i*20, j*20);
			else if (mapBlood[i][j] == 4)	//put blood
				draw_sprite(map_bitmap, (BITMAP*)sprites[BLOOD_DOWN].dat, i*20,j*20);
			else if (mapBlood[i][j] == 8)	// put blood
				draw_sprite(map_bitmap, (BITMAP*)sprites[BLOOD_LEFT].dat, i*20, j*20);
			else if (mapBlood[i][j] == 16)	// put blood
				draw_sprite(map_bitmap, (BITMAP*)sprites[BLOOD_UP].dat, i*20, j*20);

		}
	}
	for (i=0; i<num_eaters; i++)
		draw_sprite(map_bitmap, (BITMAP*)sprites[eaters[i].frame].dat, eaters[i].x_loc,
		eaters[i].y_loc);
	draw_sprite(map_bitmap, (BITMAP*)sprites[pac.frame].dat, pac.x_loc, pac.y_loc);
	blit(map_bitmap, screen, 0, 0, 20, 20, 440, 440);
	sprintf(text, "Score: %06d", score);
	text_mode(159);
	textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, SCORE_X, SCORE_Y, 32);
}

void StartLevel(void)
{
	for (int i=0; i<num_eaters; i++) {
		eaters[i].x_loc = gmap->eater_x*20;
		eaters[i].y_loc = gmap->eater_y*20;
		eaters[i].x_dir = 5;
		eaters[i].y_dir = 0;
		eaters[i].frame = EATER01;
		eaters[i].state = 0;
	}
	pac.x_loc = gmap->pac_x*20;
	pac.y_loc = gmap->pac_y*20;
	pac.frame = PAC1A;
	text_mode(159);
	sprintf(text, "Lives: %6d", lives);
	textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, SCORE_X, SCORE_Y + 40, 15);
	sprintf(text, "Level: %6d", current_map_played+1);
	textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, SCORE_X, SCORE_Y + 75, 15);
	textout(screen, (FONT*)graphics[NORMAL_FONT].dat, "High Score:", SCORE_X, SCORE_Y + 100, 15);
	textout(screen, (FONT*)graphics[NORMAL_FONT].dat, HighScores[0].name, SCORE_X, SCORE_Y+120, 15);
	sprintf(text, "%06d", HighScores[0].score);
	textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, SCORE_X, SCORE_Y + 140, 15);
	PlaySong();
}

void PlayCustomGame(void)
{
	FILE *file;
	text[0] = '\0';
	gui_fg_color = 15;
	gui_bg_color = 1;
	if (file_select("Select Custom Map", text, "map") != 0) {
		file = fopen(text, "rb");
		if (!file)
			alert("Error opening file.", NULL, NULL, "OK", NULL, KEY_ENTER, 0);
		else {
			fread(&map, sizeof(struct map_struct), 1, file);
			fclose(file);
			show_mouse(NULL);
			fade_out(3);
			clear(screen);
			clear_keybuf();
			InitGameGraphics();
			fade_in((RGB*)graphics[EDIT_PALLETE].dat, 200);
			score = 0;
			if (dif_level == 0) {
				lives = 5;
				max_eaters_state = 150;
				pac_speed = 7;
				eater_speed = 14;
			}
			else if (dif_level == 1) {
				lives = 4;
				max_eaters_state = 100;
				pac_speed = eater_speed = 10;
			}
			else if (dif_level == 2) {
				lives = 3;
				max_eaters_state = 50;
				pac_speed = 12;
				eater_speed = 7;
			}
			extra_life = 0;
			current_map_played = 0;
			PlayMap(&map);
			GotHighScore();
			show_mouse(screen);
		}
	}
}


void PlayMap(struct map_struct *map)
{
	int i, j;
	gmap = map;
	pac_timer = eater_timer = ball_timer = eater_dead_timer = 0;
	LOCK_VARIABLE(pac_timer);
	LOCK_VARIABLE(eater_timer);
	LOCK_VARIABLE(ball_timer);
	LOCK_VARIABLE(eater_dead_timer);
	LOCK_FUNCTION(increment_timer);
	install_int(increment_timer, 5);
	eater_move_counter = 0;
	num_balls = gmap->num_balls;
	end_game = FALSE;
	eaters_eaten = 0;
	num_eaters = map->num_eaters+dif_level;
	if (num_eaters > 20) num_eaters = 20;
	StartLevel();
	for (i=0; i<22; i++) {
		for (j=0; j<22; j++) {
			if (map->values[i][j] < 700) mapV[i][j] = 0;
			else if (map->values[i][j] < 709) mapV[i][j] = map->values[i][j]-700;
			else mapV[i][j] = -1;
			mapBlood[i][j] = 0;
		}
	}
	if (current_map_played >= MAX_MAPS) end_game = TRUE;
	while (end_game != TRUE) {	//start game loop
		if (key[KEY_ESC]) {
			while (key[KEY_ESC]){}
			text_mode(-1);
			textout(screen, (FONT*)graphics[NORMAL_FONT].dat,
				"Are you sure you want to quit? (y/n)", 100, 200, 15);
			clear_keybuf();
			int ch = readkey();
			if (ch >> 8 == KEY_Y) {
				end_game = TRUE;
				break;
			}
		} //if ESC pressed exit game

		// save screen to file if f10 pressed
		else if (key[KEY_F10]){
			while (key[KEY_F10]) {}
			BITMAP* bmp;
			PALLETE pal;
			bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);
			get_pallete(pal);
			save_pcx("pacgame.pcx", bmp, pal);
			destroy_bitmap(bmp);
		}
		poll_joystick();
		if (pac_timer > pac_speed) {
			if(!pac_move_direction) {
				if (key[KEY_UP] | joy_up) MoveUp();
				if (key[KEY_DOWN] | joy_down) MoveDown();
				if (key[KEY_LEFT] | joy_left) MoveLeft();	// ... left
				if (key[KEY_RIGHT] | joy_right) MoveRight();	// ... right
			}
			else{
				if(pac_move_direction==1) MoveUp();
				if(pac_move_direction==2) MoveDown();
				if(pac_move_direction==3) MoveLeft();
				if(pac_move_direction==4) MoveRight();
			}
			pac_timer = 0;
		}
		/*
		if (key[KEY_A]) if (pac_speed > 0) pac_speed--;	// decrease speed
		if (key[KEY_Z]) if (pac_speed < 15) pac_speed++;	// increase speed
		if (key[KEY_S]) if (eater_speed > 0) eater_speed--;
		if (key[KEY_X]) if (eater_speed < 15) eater_speed++;
		if (key[KEY_TAB]) if (num_balls > 10) num_balls -= 10;
		*/
		if (eater_timer > eater_speed) {
			for (i=0; i<num_eaters; i++) MoveEater(i);	//move all eaters
			eater_move_counter++;
			eater_timer = 0;
		

			if (state_timer != 0) {		//if state_timer activated
				state_timer++;				//increment it
				if (state_timer > max_eaters_state) {	//if state time is 100 make all eaters normal
					for (i=0; i<num_eaters; i++) eaters[i].state = 0;
					state_timer = 0;			//deactivate state_timer
					eaters_eaten = 0;
				}
			}
		}

		DrawGameMap();	//draw the map
		//check for collision
		for (i=0; i<num_eaters; i++) {
			if ((pac.x_loc >= eaters[i].x_loc && pac.x_loc < eaters[i].x_loc + 20) ||
				(pac.x_loc + 20 > eaters[i].x_loc && pac.x_loc + 20 < eaters[i].x_loc + 20)) {
					if ((pac.y_loc >= eaters[i].y_loc && pac.y_loc < eaters[i].y_loc + 20) ||
						(pac.y_loc + 20 > eaters[i].y_loc && pac.y_loc + 20 < eaters[i].y_loc + 20)) {
							if (eaters[i].state == 2) {	// if eater state is 2 pac eats eater
								if (sound_on) PlaySound(EATEATER);
								eaters[i].x_loc = gmap->eater_x*20;
								eaters[i].y_loc = gmap->eater_y*20;
								eaters[i].state = 0;
								eaters_eaten++;
								score += 200 * eaters_eaten + 200 * dif_level;
								Blood();
							} //end if eaters[i].state 2
							else { //pac die
								Blood();
								if (lives > 1) {
									if (sound_on) PlaySound(PACDIE);
									lives--;
									text_mode(-1);
									textout(screen, (FONT*)graphics[GAME_FONT].dat, "You Died!!!", 200, 240, 15);
									textout(screen, (FONT*)graphics[NORMAL_FONT].dat, "Press space", 200, 265, 15);
									while (!key[KEY_SPACE]);
									StartLevel();
								}
								else {
									end_game = TRUE;
									if (sound_on) PlaySound(GAMEOVER_SOUND);
								} //end else
							} //end else pac die
						} // end y_loc checking
				} //end x_loc checking
		} //end for loop

		if (num_balls == 0) {
			if (sound_on) PlaySound(ENDLEVEL);
			break;
		}
		if (end_game == TRUE) break;
		if (score - extra_life > 20000+15000*dif_level) {
			if (sound_on) PlaySound(EXTRA_LIFE);
			extra_life = score;
			lives++;
			text_mode(159);
			sprintf(text, "Lives: %6d", lives);
			textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, SCORE_X, SCORE_Y + 40, 15);
		}
	};	//infinite loop
	remove_int(increment_timer);
	stop_midi();
	if (end_game == TRUE) {
		draw_sprite(screen, (BITMAP*)graphics[GAME_OVER].dat, 150, 160);
		while (!key[KEY_SPACE]);
	} //end if end_game
}

void GotHighScore(void)
{
	if (score > HighScores[MAX_HIGHSCORES-1].score) {
		if (sound_on) PlaySound(HIGH_SCORE);
		int i;
		for (i=MAX_HIGHSCORES-1; i>=0; i--) {
			if (score > HighScores[i].score) {
				if (i>0) {
					HighScores[i].score = HighScores[i-1].score;
					HighScores[i].level = HighScores[i-1].level;
					strcpy(HighScores[i].name, HighScores[i-1].name);
				} // end if i>0
			} //end if score > hiscore
			else break;
		} // end for
		HighScores[i+1].score = score;
		HighScores[i+1].level = current_map_played+1;
		GetHighScore();
		strcpy(HighScores[i+1].name, text);
		ViewHighScores();
	} //end if score > HighSCore
}

void PlayGame(void)
{
	current_map_played = 0;
	if (dif_level == 0) {
		lives = 5;
		max_eaters_state = 300;
		pac_speed = 7;
		eater_speed = 14;
	}
	else if (dif_level == 1) {
		lives = 4;
		max_eaters_state = 200;
		pac_speed = eater_speed = 10;
	}
	else if (dif_level == 2) {
		lives = 3;
		max_eaters_state = 100;
		pac_speed = 12;
		eater_speed = 7;
	}
	else Error("Internal error: wrong number of lives.\n");
	extra_life = 0;
	show_mouse(NULL);
	fade_out(10);
	clear_keybuf();
	InitGameGraphics();
	fade_in((RGB*)graphics[EDIT_PALLETE].dat, 200);
	score = 0;
	do {
		PlayMap((struct map_struct*)mapData[current_map_played].dat);
		current_map_played++;
		if (current_map_played >= MAX_MAPS) {
			end_game = TRUE;
		}
	} while (end_game != TRUE);
	GotHighScore();
	/*   while (1==1) {
	if (key[KEY_UP]) {
	current_map_played++;
	if (current_map_played > 26) current_map_played = 0;
	sprintf(text, "Map: %3d", current_map_played);
	PlayMap((struct map_struct*)mapData[current_map_played].dat);
	while (key[KEY_UP]) {}
	}
	else if (key[KEY_DOWN]) {
	current_map_played--;
	if (current_map_played < 0) current_map_played = 26;
	sprintf(text, "Map: %3d", current_map_played);
	PlayMap((struct map_struct*)mapData[current_map_played].dat);
	while (key[KEY_DOWN]){}
	}
	else if (key[KEY_ESC]){
	while (key[KEY_ESC]);
	break;
	}
	}*/
	show_mouse(screen);
	stop_midi();
}

// moves which eater
void MoveEater(int which)
{
	if (eater_move_counter % 8 >= 0 || eater_move_counter % 8 <= 4)
		eaters[which].frame = EATER01;
	else eaters[which].frame = EATER02;
	// if state is 2 frame is RED
	if (eaters[which].state == 2) eaters[which].frame = EATER03;

	// if eater is in perfect square can change direction
	if ((eaters[which].x_loc % 20 == 0) && (eaters[which].y_loc % 20 == 0))
		ChangeEaterDir(which);

	// increment eater location
	eaters[which].x_loc += eaters[which].x_dir;
	eaters[which].y_loc += eaters[which].y_dir;

	//check if eater had eaten pac
}//end function

// change eater direction if possible
void ChangeEaterDir(int which)
{
	int dir = Random(4-dif_level); // 0: continue direction

	if (dir == 1 && eaters[which].state != 2) {
		if (eaters[which].x_dir == 5) {
			if (eaters[which].x_loc < pac.x_loc && EaterGoRight(which))	return;
			else if (eaters[which].y_loc < pac.y_loc && EaterGoDown(which)) return;
			else if (eaters[which].y_loc > pac.y_loc && EaterGoUp(which)) return;
		}
		else if (eaters[which].x_dir == -5) {
			if (eaters[which].x_loc > pac.x_loc && EaterGoLeft(which)) return;
			else if (eaters[which].y_loc < pac.y_loc && EaterGoDown(which)) return;
			else if (eaters[which].y_loc > pac.y_loc && EaterGoUp(which)) return;
		}
		else if (eaters[which].y_dir == 5) {
			if (eaters[which].y_loc < pac.y_loc && EaterGoDown(which)) return;
			else if (eaters[which].x_loc < pac.x_loc && EaterGoRight(which)) return;
			else if (eaters[which].x_loc > pac.x_loc && EaterGoLeft(which)) return;
		}
		else if (eaters[which].y_dir == -5) {
			if (eaters[which].y_loc > pac.y_loc && EaterGoUp(which)) return;
			else if (eaters[which].x_loc < pac.x_loc && EaterGoRight(which)) return;
			else if (eaters[which].x_loc > pac.x_loc && EaterGoLeft(which)) return;
		}
	}
	dir = Random(3);
	if (eaters[which].x_dir == 5 || eaters[which].x_dir == -5) {  //go right or left
		if (dir == 2) { //go down
			if (EaterGoDown(which)) return;
			else dir = Random(2);
		}
		if (dir == 1){
			if (EaterGoUp(which)) return;
		}
		if (eaters[which].x_dir == 5) {
			if (EaterGoRight(which)) return;
			else EaterGoLeft(which);
			return;
		}
		else {
			if (EaterGoLeft(which)) return;
			else EaterGoRight(which);
			return;
		}
	}
	if (eaters[which].y_dir == 5 || eaters[which].y_dir == -5) { //going down or up
		if (dir == 2) {
			if (EaterGoLeft(which)) return;
			else dir = Random(2);
		}
		if (dir == 1) {
			if (EaterGoRight(which)) return;
		}
		if (eaters[which].y_dir == 5)	{
			if (EaterGoDown(which)) return;
			else EaterGoUp(which);
			return;
		}
		else {
			if (EaterGoUp(which)) return;
			else EaterGoDown(which);
			return;
		}
	}
}

// checks if eater can go up and changes direction if can
int EaterGoUp(int which)
{
	if (mapV[eaters[which].x_loc / 20][eaters[which].y_loc / 20 -1] == 0) return FALSE;
	eaters[which].x_dir = 0;
	eaters[which].y_dir = -5;
	if (eaters[which].y_loc == 5) eaters[which].y_dir = 5; //cannot go thru walkways
	return TRUE;
}

int EaterGoDown(int which)
{
	if (mapV[eaters[which].x_loc / 20][eaters[which].y_loc / 20 +1] == 0) return FALSE;
	eaters[which].x_dir = 0;
	eaters[which].y_dir = 5;
	if (eaters[which].y_loc == 415) eaters[which].y_dir = -5;
	return TRUE;
}

int EaterGoRight(int which)
{
	if (mapV[eaters[which].x_loc / 20+1][eaters[which].y_loc / 20] == 0) return FALSE;
	eaters[which].x_dir = 5;
	eaters[which].y_dir = 0;
	if (eaters[which].x_loc >= 415) eaters[which].x_dir = -5;
	return TRUE;
}

int EaterGoLeft(int which)
{
	if (mapV[eaters[which].x_loc / 20-1][eaters[which].y_loc / 20] == 0) return FALSE;
	eaters[which].x_dir = -5;
	eaters[which].y_dir = 0;
	if (eaters[which].x_loc == 5) eaters[which].x_dir = 5;
	return TRUE;
}

//checks if pac has eaten the ball
void EatBall(void)
{
	int temp = mapV[pac.x_loc / 20][pac.y_loc / 20];
	if (temp > 0 && temp < 5) {	//small ball?
		mapV[pac.x_loc / 20][pac.y_loc / 20] = -1;	//set map_balls at pac loc to 0
		num_balls--;	//dectrement num of balls
		if (sound_on) PlaySound(EATSBALL);
		score += gmap->scores[temp-1]+10*dif_level;
	}
	else if (temp > 4 && temp < 9) { //big ball?
		mapV[pac.x_loc / 20][pac.y_loc / 20] = -1;
		state_timer = 1;	//activate state_timer
		score += gmap->scores[temp-1] + 100*dif_level;
		if (sound_on) PlaySound(EATBBALL);
		for (int i=0; i<num_eaters;i++) eaters[i].state = 2;	//set all eaters state to 2
	}
}

//move pac up
void MoveUp(void)
{
	if (pac.x_loc % 20 != 0) return; //if not at x_perfect square cannot move up
	pac_move_direction=1;
	if (pac.y_loc % 20 == 0) {
		if (mapV[pac.x_loc / 20][pac.y_loc / 20 -1] == 0){
			pac_move_direction=0;
			return;
		}
	} // if wall above pac cannot move
	if (pac.y_loc % 10 == 0) pac.frame = PAC3A; //change frame
	else pac.frame = PAC3B;
	EatBall();
	pac.y_loc -= 5;	//change position
	if (pac.y_loc % 20 == 0) pac_move_direction=0;
	if (pac.y_loc < 5) pac.y_loc = 415;
}

void MoveDown(void)
{
	if (pac.x_loc % 20 != 0) return;
	pac_move_direction=2;
	if (pac.y_loc % 20 == 0){
		if (mapV[pac.x_loc / 20][pac.y_loc / 20 + 1] == 0){
			pac_move_direction=0;
			return;
		}
	}
	if (pac.y_loc % 10 == 0) pac.frame = PAC4A;
	else pac.frame = PAC4B;
	EatBall();
	pac.y_loc += 5;
	if (pac.y_loc % 20 == 0) pac_move_direction=0;
	if (pac.y_loc > 415) pac.y_loc = 5;
}

void MoveRight(void)
{
	if (pac.y_loc % 20 != 0) return;
	pac_move_direction=4;
	if (pac.x_loc % 20 == 0) {
		if (mapV[pac.x_loc / 20 +1][pac.y_loc / 20] == 0){
			pac_move_direction=0;
			return;
		}
	}
	if (pac.x_loc % 10 == 0) pac.frame = PAC1A;
	else pac.frame = PAC1B;
	EatBall();
	pac.x_loc += 5;
	if (pac.x_loc % 20 == 0) pac_move_direction=0;
	if (pac.x_loc > 415) pac.x_loc = 5;
}

void MoveLeft(void)
{
	if (pac.y_loc % 20 != 0) return;
	pac_move_direction=3;
	if (pac.x_loc % 20 == 0) {
		if (mapV[pac.x_loc / 20 -1][pac.y_loc / 20] == 0){
			pac_move_direction=0;
			return;
		}
	}
	if (pac.x_loc % 10 == 0) pac.frame = PAC2A;
	else pac.frame = PAC2B;
	EatBall();
	pac.x_loc -= 5;
	if (pac.x_loc % 20 == 0) pac_move_direction=0;
	if (pac.x_loc < 5) pac.x_loc = 415;
}

void Blood(void)
{
	if (mapV[pac.x_loc / 20+1][pac.y_loc / 20] == 0)
		mapBlood[pac.x_loc / 20+1][pac.y_loc / 20] = 8;
	if (mapV[pac.x_loc / 20-1][pac.y_loc / 20] == 0)
		mapBlood[pac.x_loc / 20-1][pac.y_loc / 20] = 2;
	if (mapV[pac.x_loc / 20][pac.y_loc / 20-1] == 0)
		mapBlood[pac.x_loc / 20][pac.y_loc / 20-1] = 4;
	if (mapV[pac.x_loc / 20][pac.y_loc / 20+1] == 0)
		mapBlood[pac.x_loc / 20][pac.y_loc / 20+1] = 16;
}

void GetHighScore(void)
{
	drawing_mode(DRAW_MODE_COPY_PATTERN, (BITMAP*)graphics[PATTERN2].dat, 0, 0);
	rectfill(screen, 100, 150, 340, 280, 1);
	solid_mode();
	text_mode(-1);
	rect(screen, 100,150, 340, 280, 142);
	textout_centre(screen, (FONT*)graphics[GAME_FONT].dat, "You got high score", 210, 160, 15);
	rectfill(screen, 150, 200, 290, 240, 0);
	rect(screen, 150, 200, 290, 240, 142);
	int l = 0;
	int ch;
	text[l] = '\0';
	clear_keybuf();
	text_mode(0);
	textout(screen, (FONT*)graphics[NORMAL_FONT].dat, "_", 155, 212, 15);
	do {
		if (keypressed()) {
			ch = readkey() & 0x00ff;
			if ((ch > 31) && (ch < 127) && (l<14)) {
				text[l+1] = '\0';
				text[l] = ch;
				l++;
				PlaySound(TYPE_LETTER);
			} //end if
			else if ((key[KEY_BACKSPACE]) && (l>0)) {
				PlaySound(TYPE_LETTER);
				l--;
				text[l] = '\0';
				rectfill(screen, 151, 201, 289, 239, 0);
			} //end else if
			else if (key[KEY_ENTER]) break;
			textout(screen, (FONT*)graphics[NORMAL_FONT].dat, text, 155, 212, 15);
			textout(screen, (FONT*)graphics[NORMAL_FONT].dat, "_", text_length((FONT*)graphics[NORMAL_FONT].dat, text)+155, 212, 15);
		} //end if
	}while(1==1);
	text_mode(-1);
}

