//last edit: 3/21/97 :99
#include "pacgame.h"

void DrawFrame(int x1, int y1, int x2, int y2, int col1, int col2)
{
	hline(screen, x1, y1, x2, col1);  hline(screen, x1, y2, x2, col2);
	vline(screen, x1, y1, y2, col1);  vline(screen, x2, y1, y2, col2);

	hline(screen, x1+1, y1+1, x2-1, col1); hline(screen, x1+1, y2-1, x2-1, col2);
	vline(screen, x1+1, y1+1, y2-1, col1); vline(screen, x2-1, y1+1, y2-1, col2);
}

void Dtextout(BITMAP* s, FONT* f, char *str, int x1, int y1, int col1, int col2)
{
	text_mode(-1);
	textout(s, f, str, x1+1, y1+1, col2);
	textout(s, f, str, x1, y1, col1);
}

void Dtextout_centre(BITMAP *s, FONT *f, char *str, int x1, int y1, int col1, int col2)
{
	text_mode(-1);
	textout_centre(s, f, str, x1+1, y1+1, col2);
	textout_centre(s, f, str, x1, y1, col1);
}

int mouseinbox(int x1, int y1, int x2, int y2)
{
	if ((mouse_x > x1) && (mouse_x < x2)) {
		if ((mouse_y > y1) && (mouse_y < y2)) return TRUE;
	}
	return FALSE;
}

Button::Button(char *n, int xa, int ya, int xb, int yb, int f1, int f2, BITMAP *btn)
{
	x1 = xa; 		x2 = xb;
	y1 = ya;			y2 = yb;
	frame1 = f1;	frame2 = f2;
	bitmap = btn;
	pressed = FALSE;
	if (n)  strcpy(name, n);
	else name[0] = NULL;
}

void Button::ChangeName(char *n)
{
	strcpy(name,n);
}

void Button::DrawButton(void)
{
	show_mouse(NULL);
	if (name[0] == NULL) blit(bitmap, screen, 0, 0, x1, y1, x2-x1, y2-y1);
	else {
		drawing_mode(DRAW_MODE_COPY_PATTERN, bitmap, 0, 0);
		rectfill(screen, x1, y1, x2, y2, 1);
	}
	solid_mode();
	int temp = y1+((y2-y1)-text_height((FONT*)graphics[GAME_FONT].dat))/2;
	if (pressed) {
		DrawFrame(x1, y1, x2, y2, frame1, frame2);
		if (name)
			Dtextout_centre(screen, (FONT*)graphics[GAME_FONT].dat, name, x1+(x2-x1)/2,
			temp, frame1, frame2);
	}
	else {
		DrawFrame(x1, y1, x2, y2, frame2, frame1);
		if (name)
			Dtextout_centre(screen, (FONT*)graphics[GAME_FONT].dat,
			name, x1+(x2-x1)/2, temp, frame2, frame1);
	}
	show_mouse(screen);
}

int Button::Clicked(void)
{
	if ((mouseinbox(x1, y1, x2, y2)) && (mouse_b & 1)) {
		pressed = TRUE;
		DrawButton();
		if (sound_on) play_sample((SAMPLE*)sounds[BUTTON_CLICK].dat, sound_volume, 125, 1000, FALSE);
		do {
			if ((mouseinbox(x1, y1, x2, y2)) && (pressed == FALSE)) {
				if (sound_on) play_sample((SAMPLE*)sounds[BUTTON_CLICK].dat, sound_volume, 125, 1000, FALSE);
				pressed = TRUE;
				DrawButton();
			}
			else if (!(mouseinbox(x1, y1, x2, y2)) && (pressed == TRUE)) {
				pressed = FALSE;
				DrawButton();
			}
		} while (mouse_b & 1);
		int temp = pressed;
		pressed = FALSE;
		DrawButton();
		return temp;
	}
	return FALSE;
}

