/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include "map.h"
#include "unit.h"
#include "upkeep.h"

/************************************/
/* Unit list resource management    */
/************************************/
/* Get upkeep; ie, only count units that have an amount >0 */
int get_unitlist_upkeep(UNIT *ulst, int resource)
{
   UNIT *u;
   int res = 0;

   for (u = ulst; u; u = u->next) {
      if (u->data->resource_cost[resource] > 0)
         res += u->data->resource_cost[resource];
      if (u->data->loaded_units)
         res += get_unitlist_upkeep(u->data->loaded_units, resource);
   }
   return res;
}

/* Get provison; ie, only count units that have an amount <0 */
int get_unitlist_provision(UNIT *ulst, int resource)
{
   UNIT *u;
   int res = 0;

   for (u = ulst; u; u = u->next) {
      if (u->data->resource_cost[resource] < 0)
         res -= u->data->resource_cost[resource];
      if (u->data->loaded_units)
         res += get_unitlist_provision(u->data->loaded_units, resource);
   }
   return res;
}
