/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include "global.h"
#include "map.h"
#include "maptile.h"
#include "unit.h"
#include "unitmap.h"

/************************************/
/* Unit <--> map interaction        */
/************************************/

/* Returns TRUE if the tile is blocked in the specified layer, either by */
/*  the terrain or by a unit that is not on the ignore list */
int tile_blocked(const int tx, const int ty, const int layer, const UNIT *ignore)
{
   UNIT *chr;

   if (!in_rect(tx, ty, 0, 0, get_map_width() - 2, get_map_height() - 2))
      return TRUE;

   if (tile_flags(tx, ty, layer) & TILE_BARRIER) {
      return TRUE;
   } else {
      for (chr = get_block_char(tx, ty); chr; chr = chr->next)
         if (!in_list(ignore, chr->data))
            if (!(chr->data->flags & CF_NOBLOCK) && (chr->data->layer == layer)) {
               return TRUE;
               break;
            }
   }
   return FALSE;
}

/* make unit block current tile(s) */
void set_unit_block(UNITDATA *u)
{
   int tx = u->x / TILE_WIDTH;
   int ty = u->y / TILE_HEIGHT;
   int cx, cy;

   for (cx = 0; cx < u->gfx_x_size; cx++)
      for (cy = 0; cy < u->gfx_y_size; cy++)
         set_block_char(tx + cx, ty + cy,
                        add_to_list(u, get_block_char(tx, ty)));
}

/* make unit unblock current tile(s) */
void clear_unit_block(UNITDATA *u)
{
   int tx = u->x / TILE_WIDTH;
   int ty = u->y / TILE_HEIGHT;
   int cx, cy;

   for (cx = 0; cx < u->gfx_x_size; cx++)
      for (cy = 0; cy < u->gfx_y_size; cy++)
         set_block_char(tx + cx, ty + cy,
                        remove_from_list(u, get_block_char(tx, ty)));
}

/* make unit block destinationtile(s) */
void set_unit_dest_block(UNITDATA *u)
{
   int dx = dir_to_dx(u->draw_dir);
   int dy = dir_to_dy(u->draw_dir);
   int tx;
   int ty;
   int cx, cy;

   tx = u->x / TILE_WIDTH + dx;
   ty = u->y / TILE_HEIGHT - dy;

   for (cx = 0; cx < u->gfx_x_size; cx++)
      for (cy = 0; cy < u->gfx_y_size; cy++)
         set_block_char(tx + cx, ty + cy,
                        add_to_list(u, get_block_char(tx, ty)));
}

/* make unit unblock destination tile(s) */
void clear_unit_dest_block(UNITDATA *u)
{
   int dx = dir_to_dx(u->draw_dir);
   int dy = dir_to_dy(u->draw_dir);
   int tx;
   int ty;
   int cx, cy;

   tx = u->x / TILE_WIDTH + dx;
   ty = u->y / TILE_HEIGHT - dy;

   for (cx = 0; cx < u->gfx_x_size; cx++)
      for (cy = 0; cy < u->gfx_y_size; cy++)
         set_block_char(tx + cx, ty + cy,
                        remove_from_list(u, get_block_char(tx, ty)));
}

/* Centre the map on a specified unit group */
void centre_map_on_group(UNIT *ulst)
{
   UNIT *u;
   int x = 0;
   int y = 0;
   int n = 0;
   
   if (ulst) {
      for (u=ulst; u; u=u->next) {
         x += u->data->x;
         y += u->data->y;
         n++;
      }
      x /= (n*TILE_WIDTH);
      y /= (n*TILE_HEIGHT);      
      centre_map (x, y);
   }
}

/* Returns TRUE if a structure of dimension tw x th can be placed at (tx, ty) */
/* This takes into account the one-tile distance between structures */
int can_place_structure(int tx, int ty, int tw, int th, UNIT *ignore)
{
   int x, y;

   for (x = tx; x<tx+tw; x++) {   
      for (y = ty; y<ty+th; y++) {
         if (in_rect(x, y, 0, 0, get_map_width() - 1, get_map_height() - 1)) {
            if (tile_blocked(x, y, 0, ignore)) {
               return PLACE_OCC;
            }
            if (tile_hidden(x, y)) {
               return PLACE_EXPL;
            }
            /*
            if (count_structures(get_block_char(x, y)))
               return FALSE;
            */
         } else {
            return PLACE_NOMAP;
         }
      }
   }
   
   for (x = tx-1; x<tx+tw+1; x++) {   
      for (y = ty-1; y<ty+th+1; y++) {
         if (in_rect(x, y, 0, 0, get_map_width() - 2, get_map_height() - 2)) {
            if (tile_hidden(x, y)) {
               return PLACE_EXPL;
            }
            if (count_structures(get_block_char(x, y)))
               return PLACE_STRUC;
         } else {
            return PLACE_NOMAP;
         }
      }
   }
   
   return PLACE_OK;
}
