/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include "icpanel.h"
#include "unit.h"
#include "gfx.h"
#include "gamegfx.h"
#include "global.h"

/* Interface Command Panel button handling */


typedef struct ICBUTTON {
   //BITMAP *cmd_bitmap;
   UCMDS *cmd;
   char *description;
   int flags;
} ICBUTTON;

static ICBUTTON button[12] = {
   {NULL, NULL, 0}, {NULL, NULL, 0}, {NULL, NULL, 0}, {NULL, NULL, 0},
   {NULL, NULL, 0}, {NULL, NULL, 0}, {NULL, NULL, 0}, {NULL, NULL, 0},
   {NULL, NULL, 0}, {NULL, NULL, 0}, {NULL, NULL, 0}, {NULL, NULL, 0}
};
static int buttons_active = 0;

void clear_command_panel_buttons(void)
{
   int c;

   for (c = 0; c < 12; c++) {
      button[c].cmd = NULL;
      button[c].description = NULL;
      button[c].flags = 0;
   }
   buttons_active = 0;
}

void add_command_panel_button(int id, UCMDS *cmd, char *descr, int flags)
{
   /* Passing a NULL bitmap disables this button */
   if (!cmd) {
      if (buttons_active)
         buttons_active--;
   } else if (!button[id].cmd) {
      buttons_active++;
   }

   button[id].cmd = cmd;
   button[id].description = descr;
   button[id].flags = flags;
}

void disable_command_panel_button(int id)
{
   add_command_panel_button(id, NULL, NULL, 0);
}

/* Draw the command panel buttons. (x, y) is the location of the first one; */
/*  panel is drawn in a 4x3 layout */
void draw_command_panel(BITMAP *bmp, int x, int y)
{
   int c;

   if (buttons_active) {
      for (c = 0; c < 12; c++) {
         rectfill(bmp, x + (c % 4) * 32, y + (c / 4) * 32,
                  x + (c % 4) * 32 + 31, y + (c / 4) * 32 + 31, black);
         if (button[c].cmd)
            draw_sprite(bmp, get_cmd_panel_bitmap(c), x + (c % 4) * 32,
                        y + (c / 4) * 32);
         draw_sprite(bmp, get_cmdpanel_button_bitmap(), x + (c % 4) * 32,
                     y + (c / 4) * 32);
      }
   }
}

/* Returns the button number that falls under (mx, my) or -1 if no */
/*  valid button falls within that range */
int get_button_id(const int mx, const int my, const int panel_x,
                  const int panel_y)
{
   int c;

   if (buttons_active) {
      for (c = 0; c < 12; c++) {
         if (in_rect
             (mx, my, panel_x + (c % 4) * 32, panel_y + (c / 4) * 32, 32,
              32)) {
            if (button[c].cmd) {
               return c;
            } else {
               return -1;
            }
         }
      }
   }
   return -1;
}

/* Get descriptive string for command button */
char *get_cmd_panel_string(const int button_id)
{
   return button[button_id].description;
}

/* Get flags for command button */
int get_cmd_panel_flags(const int button_id)
{
   if (button_id >= 0)
      return button[button_id].flags;
   else
      return 0;
}

/* Get bitmap for command button */
BITMAP *get_cmd_panel_bitmap(const int button_id)
{
   if (button_id >= 0) {
      return button[button_id].cmd->icon;
   } else {
      return NULL;
   }
}

/* Get command panel argument list item */
int get_cmd_panel_argv(const int button_id, const int n)
{
   ASSERT(button_id >= 0);
   ASSERT(button_id < 12);
   ASSERT(n<3);
   return button[button_id].cmd->argv[n];
}
