/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include "sound.h"
#include "gmemusic.h"

static int *music_playlist = NULL;
static int last_tune = 0;
static long pause_pos = 0;

void set_music_playlist(int *playlist)
{
   music_playlist = playlist;
}

void cycle_game_music(void)
{
   int n;
   
   ASSERT (music_playlist);

   if (!music_playing()) {
      if (music_playlist[0]>1) {
         do {
            n = 1 + rand() % music_playlist[0];
         } while (n == last_tune);
         last_tune = n;
         pause_pos = 0;
         start_music(music_playlist[n], FALSE);
      } else {
         start_music(music_playlist[1], FALSE);
      }
   }
}

void pause_music(void)
{
   pause_pos = midi_pos;
   stop_music();
}

void resume_music(void)
{
   if (music_playlist[0]>1) {
      start_music(music_playlist[last_tune], FALSE);   
   } else {
      start_music(music_playlist[1], FALSE);   
   }
   midi_seek(pause_pos);
}
