/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include "global.h"
#include "cheats.h"
#include "opcodes.h"
#include "map.h"

int cheat_flags = 0;

/* Check if a string is a valid cheat code and perform the action if needed */
/* Returns 0 if no cheat code was entered */
/*         1 if a cheat was activated     */
/*        -1 if it was disabled */
int do_cheat_codes(const char *msg)
{
   char *s;
   int res;

   s = str_to_lower(msg);

   res = 0;

   if (!strcmp(s, "clear vision")) {
      /* Disable fog-of-war */
      cheat_flags ^= CHEAT_FOG;
      if (cheat_flags & CHEAT_FOG) {
         unshroud_map();
         res = 1;
      } else {
         res = -1;
      }
   } else if (!strcmp(s, "infravision")) {
      /* Remove black shroud */
      reveal_map();
      res = 1;
   } else if (!strcmp(s, "timewarp")) {
      /* Disable all wait cycles */
      disable_waittimes();
      res = 1;
   } else if (!strcmp(s, "one ring to rule them all")) {
      /* Instant victory */
      cheat_flags |= CHEAT_WIN;
      res = 1;
   } else if (!strcmp(s, "infinite space")) {
      /* Infinite supply */
      cheat_flags ^= CHEAT_CONTROL;
      if (cheat_flags & CHEAT_CONTROL)
         res = 1;
      else
         res = -1;
   }

   if (res)
      cheat_flags |= CHEAT_USED;

   free(s);
   return res;
}

