#ifndef UNITPROG_H
#define UNITPROG_H

#include "unit.h"
typedef int (*CPOPCODE)(UNITDATA *unit, int *loop);

extern SCRIPT_STACK *duplicate_commands(SCRIPT_STACK *p);
extern SCRIPT_STACK *match_prog_flags(SCRIPT_STACK *p, int flags);

extern void push_command (UNITDATA *c, char *minip, int flag);
extern void pass_script_argument(UNITDATA *c, int arg);
extern void insert_command (UNITDATA *s, char *minip, int flag, int del);
extern void release_prog_head (UNITDATA *c);
extern void rmv_command_tail (UNITDATA *c);
extern void remove_commands (UNITDATA *c);
extern void loop_command (UNITDATA *c);
extern void stop_all_scripts (void);

extern int get_queuecount(UNITDATA *c);
extern int push_queue(UNITDATA *c, TARGET target, int command_id);
extern void pop_queue(UNITDATA *c);
extern int clear_queue_head(UNITDATA *c);

extern void script_cp_init(void);
extern void register_opcode (const int opcode, CPOPCODE func);
extern int script_exec(UNITDATA *c);

#endif