#ifndef SCRIPT_H
#define SCRIPT_H

/* control program opcodes */
#define CMD_NOP      0xFF
#define CMD_RETURN   0xFE
#define CMD_ALERT    0xFD
#define CMD_CLRMSG   0xFC
#define CMD_SHOWMSG  0xFB
#define CMD_TRNSPRT  0xFA
#define CMD_ATOMIC   0xF9
#define CMD_CHKSW    0xF0
#define CMD_SETSW    0xEF
#define CMD_CLRSW    0xEE
#define CMD_CASTSPL  0xED
#define CMD_CREATE   0xEC
#define CMD_SPAWN    0xEC
#define CMD_UNLOAD   0xEB
#define CMD_JCF      0xE7
#define CMD_JBE      0xE6
#define CMD_JAE      0xE5
#define CMD_JB       0xE4
#define CMD_JA       0xE3
#define CMD_JNE      0xE2
#define CMD_JE       0xE1
#define CMD_TLPRTL   0xE0
#define CMD_TLPRTF   0xDF
#define CMD_TOUCH    0xDE
#define CMD_UNTOUCH  0xDD
#define CMD_POP      0xDB
#define CMD_STORE    0xDB
#define CMD_PUSH     0xDA
#define CMD_LOAD     0xDA
#define CMD_HPADD    0xB6
#define CMD_MPADD    0xB5
#define CMD_HPBOUND  0xB4
#define CMD_MPBOUND  0xB3
#define CMD_CMPHP    0xB2
#define CMD_CMPMP    0xB1
#define CMD_DAMAGE0  0xA0
#define CMD_DAMAGE1  0xA1
#define CMD_DAMAGE2  0xA2
#define CMD_DAMAGE3  0xA3
#define CMD_DAMAGE4  0xA4
#define CMD_LRAD     0xA5
#define CMD_LINT     0xA6
#define CMD_CMDOFF   0xA7
#define CMD_CMDON    0xA8
#define CMD_ADVCOUNTER 0xA9
#define CMD_CHKCOUNTER 0xAA
#define CMD_SHOWCNTER  0xAB
#define CMD_HIDECNTER  0xAC
#define CMD_CHKRES   0x40
#define CMD_RESET    0x00
#define CMD_WAIT1    0x01
#define CMD_JMP      0x03
#define CMD_SHOWF    0x04
#define CMD_MOVE     0x05
#define CMD_WAIT2    0x07
#define CMD_WAIT3    0x09
#define CMD_SOUND    0x0A
#define CMD_FIRE     0x0B
#define CMD_WAIT4    0x0C
#define CMD_CLRZF    0x0D
#define CMD_REMOVE   0x10
#define CMD_CHANGE   0x11
#define CMD_NEWDIR   0x12
#define CMD_CHDIR    0x13
#define CMD_INVSBL   0x14
#define CMD_VSBL     0x15
#define CMD_CHKD     0x17
#define CMD_CLRC     0x18
#define CMD_SETC     0x19
#define CMD_SETD     0x1A
#define CMD_CLRD     0x1B
#define CMD_CHKC     0x1C
#define CMD_TARGET   0x1D
#define CMD_PUSHN    0x1E
#define CMD_POPN     0x1F
#define CMD_FACETO   0x20

#ifndef NORTH
#define NORTH           0
#define NORTH_EAST      1
#define EAST            2
#define SOUTH_EAST      3
#define SOUTH           4
#define SOUTH_WEST      5
#define WEST            6
#define NORTH_WEST      7
#endif

/* additional definitions for directions */
#define LEFT         16
#define RIGHT        17
#define BACKWARD     18
#define RANDOM       19

#define SCRIPT_SAVE     1  /* Do not remove from stack when completed */
#define SCRIPT_ZF       2  /* Zero flag */
#define SCRIPT_SF       4  /* Sign flag */
#define SCRIPT_LOOP     8  /* Loop flag */
#define SCRIPT_CANCEL  16  /* Script cancel flag */
#define SCRIPT_SIGNAL  32  /* Script signal flag */

extern void load_unit_control (char *filename);
extern unsigned char *get_prog_ptr (char *name);
extern void clear_parser_stack(void);
extern void pass_one(void);
extern void pass_two(void);
#endif