#ifndef MAP_H
#define MAP_H
/* Tile flags */
#define TILE_UNDER      1
#define TILE_OVER       2
#define TILE_BARRIER    4
#define TILE_BASE       8
#define TILE_MMCHANGED  512
#define TILE_CHANGED    1024
#define TILE_MASK       2048
/* Hidden/fog-of-war state, for each tile corner */
#define HIDDEN_UL       65536*1
#define HIDDEN_UR       65536*2
#define HIDDEN_LL       65536*4
#define HIDDEN_LR       65536*8
#define FOG_UL          65536*16
#define FOG_UR          65536*32
#define FOG_LL          65536*64
#define FOG_LR          65536*128

#define ALL_FOG         (FOG_UL|FOG_UR|FOG_LL|FOG_LR)
#define ALL_HIDDEN      (HIDDEN_UL|HIDDEN_UR|HIDDEN_LL|HIDDEN_LR)

/* Symbolic constants indexing the mouse arrows, scroll directions, unit facing etc */
#define NORTH        0
#define NORTH_EAST   1
#define EAST         2
#define SOUTH_EAST   3
#define SOUTH        4
#define SOUTH_WEST   5
#define WEST         6
#define NORTH_WEST   7

typedef struct MAP_TILE_LIST {
   struct MAP_TILE_LIST *next;
   int tx, ty;
} MAP_TILE_LIST;

extern inline int dir_to_dx(const int dir);
extern inline int dir_to_dy(const int dir);
extern inline void dir_to_dx_dy(const int dir, int *dx, int *dy);
extern inline int dx_dy_to_dir(const int dx, const int dy);

extern MAP_TILE_LIST *alloc_maptile(void);
extern void free_maptile(MAP_TILE_LIST *c);
extern void map_init(void);
extern inline int map_loaded(void);

extern void shroud_map(void);
extern void unshroud_map(void);
extern void reveal_map(void);
extern void lift_fog(const int tx, const int ty, const int r);
extern void mark_fog_tiles(void);

extern void load_map(const char *filename);
extern inline int get_map_width(void);
extern inline int get_map_height(void);
extern inline int get_viewport_x(void);
extern inline int get_viewport_y(void);
extern inline int get_map_layers(void);

extern inline int scrx_to_tilex(const int scrx);
extern inline int scry_to_tiley(const int scry);

extern int scroll_map(const int dx, const int dy);
extern int centre_map(const int cx, const int cy);

extern void get_viewport_tiles (int *start_tx, int *start_ty, int *tw, int *th, int *dx, int *dy);
extern void mark_viewport(void);
extern void unmark_viewport(void);

extern void mark_tile(const int x, const int y);
extern void mark_mmtile(const int x, const int y);
extern void unmark_tile(const int x, const int y);
extern void unmark_mmtile(const int x, const int y);
extern void *get_ovr_char(const int x, const int y);
extern void set_ovr_char(const int x, const int y, void *ovru);
extern void *get_block_char(const int x, const int y);
extern void set_block_char(const int x, const int y, void *blocku);
extern int tile_flags(const int tx, const int ty, const int layer);
extern int tile_marked(const int tx, const int ty);
extern int tile_fog(const int tx, const int ty);
extern int tile_hidden(const int tx, const int ty);
extern int tile_type(const int tx, const int ty, const int layer);
//extern int tile_blocked(const int tx, const int ty, const int layer);

extern int tile_in_list (const MAP_TILE_LIST *tlst, const int tx, const int ty);
#endif