/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <unistd.h>
#include "playgame.h"
#include "gamegfx.h"
#include "dialog.h"
#include "global.h"
#include "gfx.h"
#include "ugfx.h"
#include "game.h"
#include "map.h"
#include "unit.h"
#include "sound.h"
#include "unitprog.h"

/* Setup data */
#define SETUP_EMBEDDED
#define SETUP_TITLE "Rise of the Tribes SETUP"
#ifdef ALLEGRO_WINDOWS
   #define SETUP_CFG_FILE "rise.ini"
#else
   #ifdef ALLEGRO_DOS
      #define SETUP_CFG_FILE "rise.cfg"
   #else
      #ifdef ALLEGRO_UNIX
         static char *configfile_and_path;

         #define SETUP_CFG_FILE configfile_and_path
      #else
         #define SETUP_CFG_FILE "allegro.cfg"
      #endif
   #endif
#endif
#include "setup.c"

/* Decrease to make the game run faster. This is the number of ms between cycles. */
/* Default: 25, a la WarCraft II */
#define GAMESPEED 25

#ifdef ALLEGRO_WINDOWS
   #define TABS "\t\t"
   #define STAB "\t"
#else
   #define TABS "\t"
   #define STAB "\t"
#endif

int main(int argc, char *argv[])
{
   int show_opening = TRUE;
   char *cdir;

   set_uformat(U_ASCII);
   allegro_init();

#ifdef ALLEGRO_UNIX   
   /* give up privileges */
   setuid(getuid());
#endif

#ifdef ALLEGRO_UNIX
   configfile_and_path = malloc(256);
   if (getenv("HOME")) {
      sprintf(configfile_and_path, "%s/%s", getenv("HOME"), ".riserc");
      if (!file_exists(configfile_and_path, FA_HIDDEN, NULL)) {
         sprintf(configfile_and_path, "/etc/riserc");
      }
   } else if (exists("/etc/riserc") && !exists(".riserc")) {
      sprintf(configfile_and_path, "/etc/riserc");
   } else {
      sprintf(configfile_and_path, ".riserc");
   }
#endif

   /* The game directory defaults to the current directory */
   cdir = malloc(1024);
   get_current_dir(cdir, 1024);
   set_game_directory(cdir);
   
   set_config_file(SETUP_CFG_FILE);
   settings.width = get_config_int("video", "width", settings.width);
   settings.height = get_config_int("video", "height", settings.height);
   settings.colour_depth =
      get_config_int("video", "depth", settings.colour_depth);

   set_digi_volume(get_config_int("sound", "digi_volume", get_digi_volume()));
   set_midi_volume(get_config_int("sound", "midi_volume", get_midi_volume()));


   if (get_config_int("video", "gouraud_shading", 0)) {
      settings.flags &= ~(LIT_PLAIN + LIT_GOURAUD);
      settings.flags |= LIT_GOURAUD;
   } else {
      settings.flags &= ~(LIT_PLAIN + LIT_GOURAUD);
      settings.flags |= LIT_PLAIN;
   }
   if (get_config_int("game", "fog_of_war", 1)) {
      settings.flags |= FOG_OF_WAR_ON;
   } else {
      settings.flags &= ~FOG_OF_WAR_ON;
   }
   if (get_config_int("game", "fog_of_war_bitmap", 1)) {
      settings.flags |= FOG_OF_WAR_BITMAP;
   } else {
      settings.flags &= ~FOG_OF_WAR_BITMAP;
   }
   if (get_config_int("video", "windowed", 0))
      settings.flags |= WINDOWED_MODE;
   
   set_game_directory(get_config_string("game", "game_dir", get_game_path("")));
   
   /* Now change to the game directory */
   chdir(get_game_path(""));
      
#ifdef ALLEGRO_UNIX
   /* If the config file was read from /etc, save new settings in the user's */
   /*  home dir */
   if (exists("/etc/riserc")) {
      if (getenv("HOME")) {
         sprintf(configfile_and_path, "%s/%s", getenv("HOME"), ".riserc");
      } else {
         sprintf(configfile_and_path, ".riserc");
      }
   }
#endif

   install_timer();
   install_keyboard();

   if (install_mouse() < 0) {
      allegro_message("This game requires a mouse, but I couldn't find one.\n"
                      "Perhaps you should query your cat?\n");
      return 0;
/*
   } else if (install_mouse()==0) {
      allegro_message ("Hmm... your mouse doesn't seem to have any buttons... how odd!\n"
                       "Did you disable it in the setup menu? If so, please reenable it, yes? Please?\n");
*/
   }

   set_window_title("Rise of the Tribes");
   set_window_close_button(FALSE);

   if (argc > 1) {
      int c;

      for (c = 1; c < argc; c++)
         if (!strcmp(argv[c], "-8bpp")) {
            settings.colour_depth = 8;
         } else if (!strcmp(argv[c], "-15bpp")) {
            settings.colour_depth = 15;
         } else if (!strcmp(argv[c], "-16bpp")) {
            settings.colour_depth = 16;
         } else if (!strcmp(argv[c], "-24bpp")) {
            settings.colour_depth = 24;
         } else if (!strcmp(argv[c], "-32bpp")) {
            settings.colour_depth = 32;
         } else if (!strcmp(argv[c], "-gouraud")) {
            settings.flags &= ~(LIT_PLAIN + LIT_GOURAUD);
            settings.flags |= LIT_GOURAUD;
         } else if (!strcmp(argv[c], "-plain")) {
            settings.flags &= ~(LIT_PLAIN + LIT_GOURAUD);
            settings.flags |= LIT_PLAIN;
         } else if (!strcmp(argv[c], "-fowbmp")) {
            settings.flags |= FOG_OF_WAR_BITMAP;
         } else if (!strcmp(argv[c], "-fowshade")) {
            settings.flags &= ~FOG_OF_WAR_BITMAP;
         } else if (!strcmp(argv[c], "-dblbuffer")) {
            settings.flags &=
               ~(DOUBLE_BUFFER + PAGE_FLIP + IMMEDIATE + TRIPLE_BUFFER +
                 DIRTY_RECTANGLE);
            settings.flags |= DOUBLE_BUFFER;
         } else if (!strcmp(argv[c], "-tribuffer")) {
            settings.flags &=
               ~(DOUBLE_BUFFER + PAGE_FLIP + IMMEDIATE + TRIPLE_BUFFER +
                 DIRTY_RECTANGLE);
            settings.flags |= TRIPLE_BUFFER;
         } else if (!strcmp(argv[c], "-pageflip")) {
            settings.flags &=
               ~(DOUBLE_BUFFER + PAGE_FLIP + IMMEDIATE + TRIPLE_BUFFER +
                 DIRTY_RECTANGLE);
            settings.flags |= PAGE_FLIP;
         } else if (!strcmp(argv[c], "-immediate")) {
            settings.flags &=
               ~(DOUBLE_BUFFER + PAGE_FLIP + IMMEDIATE + TRIPLE_BUFFER +
                 DIRTY_RECTANGLE);
            settings.flags |= IMMEDIATE;
         } else if (!strcmp(argv[c], "-drect")) {
            settings.flags &=
               ~(DOUBLE_BUFFER + PAGE_FLIP + IMMEDIATE + TRIPLE_BUFFER +
                 DIRTY_RECTANGLE);
            settings.flags |= DIRTY_RECTANGLE;
         } else if (!strcmp(argv[c], "-lowres")) {
            settings.width = 320;
            settings.height = 240;
         } else if (!strcmp(argv[c], "-midres")) {
            settings.width = 640;
            settings.height = 480;
         } else if (!strcmp(argv[c], "-hires")) {
            settings.width = 800;
            settings.height = 600;
         } else if (!strcmp(argv[c], "-ultrares")) {
            settings.width = 1024;
            settings.height = 768;
         } else if (!strcmp(argv[c], "-sone")) {
            settings.flags &= ~LIT_INLINE;
         } else if (!strcmp(argv[c], "-stwo")) {
            settings.flags &= ~LIT_INLINE;
            settings.flags |= LIT_INLINE;
         } else if (!strcmp(argv[c], "-midi")) {
            settings.flags &= ~(MUSIC_MIDI + MUSIC_CD);
            settings.flags |= MUSIC_MIDI;
         } else if (!strcmp(argv[c], "-cd")) {
            settings.flags &= ~(MUSIC_MIDI + MUSIC_CD);
            settings.flags |= MUSIC_CD;
         } else if (!strcmp(argv[c], "-nomusic")) {
            settings.flags &= ~(MUSIC_MIDI + MUSIC_CD);
         } else if (!strcmp(argv[c], "-nosound")) {
            settings.flags &= ~(MUSIC_MIDI + MUSIC_CD + SFX_DIGI);
#ifndef ALLEGRO_DOS
         } else if (!strcmp(argv[c], "-window")) {
            settings.flags |= WINDOWED_MODE;
         } else if (!strcmp(argv[c], "-fullscrn")) {
            settings.flags &= ~WINDOWED_MODE;
         } else if (!strcmp(argv[c], "-w")) {
            c++;
            sscanf(argv[c], "%d", &(settings.width));
            /* make sensible window dimensions */
            if (settings.width < 320)
               settings.width = 320;
         } else if (!strcmp(argv[c], "-h")) {
            c++;
            sscanf(argv[c], "%d", &(settings.height));
            /* make sensible window dimensions */
            if (settings.height < 200)
               settings.height = 200;
#endif
         } else if (!strcmp(argv[c], "-noopening")) {
            show_opening = FALSE;
         } else if (!strcmp(argv[c], "-nofog")) {
            settings.flags &= ~FOG_OF_WAR_ON;
         } else if (!strcmp(argv[c], "-fog")) {
            settings.flags |= FOG_OF_WAR_ON;
         } else if (!strcmp(argv[c], "-setup")) {
            set_gfx_mode(GFX_SAFE, 640, 480, 0, 0);
            return setup_main();
         } else {
/* *INDENT-OFF* */
            allegro_message("Valid command-line options are:\n"
                            " -xbpp     " TABS " where x=8,15,16,24 or 32. selects the desired colourdepth.\n"
                            " -gouraud"   TABS " Selects gouraud shading (default)\n"
                            " -plain    " TABS " Selects plain light source shading\n"
                            " -sone     " TABS " Shades everything in one pass (default)\n"
                            " -stwo     " TABS " Shade everything in two passes\n" 
                            " -dblbuffer" TABS " Selects doublebuffering for screen updates\n"
                            " -tribuffer" TABS " Selects triple buffering for screen updates\n"
                            " -pageflip " TABS " Selects pageflipping for screen updates\n"
                            " -immediate" STAB " Select immediate screen updates\n" 
                            " -drect    " TABS " Select dirty-rectangle screen updates (default)\n"
                            " -lowres   " TABS " Select low resolution (320x240)\n"
                            " -midres   " TABS " Select medium resolution (640x480, default)\n"
                            " -hires    " TABS " Select high resolution (800x600)\n"
                            " -ultrares " TABS " Select very high resolution (1024x768)\n"
#ifndef ALLEGRO_DOS
                            " -window "   TABS " Run in windowed mode\n"
                            " -fullscrn " TABS " Run in full-screen mode\n"
                            " -w width "  TABS " Set width of window\n"
                            " -h height " TABS " Set height of window\n"
#endif
                            " -nofog    " TABS " Disable fog-of-war\n"
                            " -fog      " TABS " Enable fog-of-war (default)\n" 
                            " -fowbmp   " STAB " Use bitmaps for the fog-of-war\n"
                            " -fowshade " STAB " Use shading for the fog-of-war\n" 
                            " -midi     " TABS " Select MIDI music\n" 
                            " -cd       " TABS " Select CD music\n" 
                            " -nomusic"   TABS " Disables music\n" 
                            " -nosound"   TABS " Disables all sound effects and music\n"
                            " -setup    " TABS " Change default settings\n");
/* *INDENT-ON* */
            exit(0);
         }
   }

   set_sound();
   set_graphics();
   //load_midi_patches();   
   /* Initizlize music lookup tables */
   read_music_aliases(get_game_path("rise.gme"));
   read_sample_aliases(get_game_path("rise.gme"));
   /* Load and initialize graphics */
   load_global_gfx();
   cgfx_init();
   cgfx_load();
   /* Initialize command scripts */
   script_cp_init();
   /* Initialize dialog boxes */
   dialog_init();

   /* Set the game viewport */
   //set_commandmap (0,0, SCREEN_W, SCREEN_H-120); /* Command map viewport */
   set_commandmap(8, 18, SCREEN_W - 16, SCREEN_H - 120 - 18);  /* Command map viewport */
   set_interface(0, SCREEN_H - 144, SCREEN_W, SCREEN_H); /* Interface */
   /* Prepare the screen, set up page flipping, double buffering etc. */
   prepare_screen();
   playgame_init(GAMESPEED);
   install_fps_counter();

   start_game();

   stop_sound();
   remove_sound();
   set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
   allegro_exit();

   /* Now return to the original directory */
   chdir(cdir);

   return 0;
}
END_OF_MAIN()
