/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include "maptile.h"
#include "global.h"

typedef struct TILE {
   int gfx_index;
   int mm_col;
   int mm_fog_col;
} TILE;

static DATAFILE *tiles_dat = NULL;
static TILE tiledata[1] = { {0, 0, 0} };

void load_tileset(char *filename)
{
   if (tiles_dat) {
      unload_datafile(tiles_dat);
      tiles_dat = NULL;
   }
   
      
   tiles_dat = load_datafile(get_game_path("tiles.dat"));
   if (!tiles_dat) {
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
      allegro_message("Unable to load the map tileset!\n"
                      "Make sure that the datafile is in the current directory\n");
      exit(EXIT_FAILURE);
   }

   /* Load tile graphics */
   tiledata[0].gfx_index = 0;
   tiledata[0].mm_col = makecol(16, 97, 4);
   tiledata[0].mm_fog_col = makecol(8, 47, 2);
}


/* Access routine to map tiles. Implemented in this way to hide from other */
/*  parts of the program ('data-hiding') */
BITMAP *get_tile_bitmap(int index)
{
   return tiles_dat[tiledata[index].gfx_index].dat;
}

/* Return the colour a tile should have on the mini-map */
int get_tile_colour(int index)
{
   return tiledata[index].mm_col;
}

/* Return the colour a tile should have on the mini-map if under the fog-of-war */
int get_tile_fog_colour(int index)
{
   return tiledata[index].mm_fog_col;
}
