/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <stdlib.h>
#include <string.h>
#include "rise.h"
#include "playgame.h"
#include "dialog.h"
#include "global.h"
#include "sound.h"
#include "gfx.h"
#include "map.h"
#include "maptile.h"
#include "game.h"
#include "unit.h"
#include "ugrp.h"
#include "udraw.h"
#include "gamegfx.h"
#include "gamedraw.h"
#include "mapdraw.h"
#include "unitprog.h"
#include "path.h"
#include "icpanel.h"
#include "alintro.h"
#include "gmeparse.h"
#include "gmemusic.h"
#include "unitmap.h"
#include "gamemsg.h"
#include "opcodes.h"
#include "cheats.h"

#define MOUSE_FREE                  1
#define MOUSE_ACQUIRE_TARGET        2
#define MOUSE_ACQUIRE_BUILDINGSITE  4
#define MOUSE_BUTTON1_DOWN          8
#define MOUSE_BUTTON2_DOWN          16

/* Mouse screen area's */
#define MA_NONE          0
#define MA_MENU_BUTTON   1
#define MA_MINIMAP       2
#define MA_COMMAND_PANEL 3
#define MA_COMMAND_MAP   4

/* Scrolling speed */
#define M_SCROLL 16
#define K_SCROLL 8

/* User messages */
#define MSG_LENGTH 128

/* Preprocessor macro that handles the ctrl+#, # unit group selection/deselection */
/* This requires the same code ten times, with just one small difference */

#define PPD_CTRL_NUM(n) case KEY_## n: \
                           if (key_shifts&KB_CTRL_FLAG) { \
                              store_unit_groupnr (get_local_player(), n);\
                           } else {\
                              if (group_is_active_group(get_local_player(), n) && key_relax) {\
                                 centre_map_on_group(get_selected_units(get_local_player()));\
                                 set_screen_changed();\
                              } else {\
                                 retrieve_unit_groupnr (get_local_player(), n); \
                                 set_command_panel();\
                                 mark_interface_area(INT_CAPTAIN|INT_QUEUE|INT_GROUP|INT_INFO|INT_COMMANDS);\
                                 set_screen_changed();\
                              }\
                           }\
                           break

/* Specify how many ticks elapse before we reshroud the Fog-of-War */
#define FOG_UPDATE_INTERVAL 60

/* Relaxation time between keypresses */
#define KEY_RELAX_TIME  10


static int fog_count = FOG_UPDATE_INTERVAL;
static int mouse_mode = MOUSE_FREE;

static unsigned int game_cycle_count;  /* Used for future multiplayer synchronization */
static int command_pending;
static int show_tip = TRUE;
static UNIT *map_indicator;
static int key_relax = 0;
static int enter_msg;
static char user_msg[MSG_LENGTH];

/* Game music playlist */
static int game_playlist[] = { 4,  /* Number of items in the play-list */
   1, 2, 3, 4
};

/* Titlescreen playlist */
static int title_playlist[] = { 1,  /* Number of items in the play-list */
   0
};



/* Update floating windows */
static void update_floatwin(void)
{
   FLOATWIN_LIST *flwl = flwin;

   while (flwl) {
      /* If the map building grid is dirty, the state of some tiles under it */
      /*  has changed - recalculate it just to be sure it's still accurate */
      /* We should only have to redo the graphic for it, so that not all */
      /*  tiles are redrawn */
      if ((flwl->win->flags & FWIN_PLACESTRUCTURE) &&
          (flwl->win->flags & FWIN_DIRTY)) {
         int tx = scrx_to_tilex(flwl->win->x);
         int ty = scry_to_tiley(flwl->win->y);
         UNIT *ovru = alloc_unit();

         /* Make sure the unit that is supposed to build the structure */
         /*  doesn't show up as red square (ie, put it on the ignore list)! */
         ovru->next = ovru->prev = NULL;
         ovru->data = get_captain(get_local_player());

         draw_structure_mask(flwl->win->content, tx, ty, flwl->win->w/TILE_WIDTH, flwl->win->w/TILE_HEIGHT, ovru);

         free_unit (ovru);
         flwl->win->timeleft = 1;
      }

      /* Floating windows with 0 timeleft at start live forever */
      if (flwl->win->timeleft) {
         flwl->win->timeleft--;
         /* Kill him if he's lived too long */
         if (!flwl->win->timeleft) {
            set_screen_changed();
            if (flwl->next) {
               flwl = flwl->next;
               kill_floatwin(flwl->prev->win);
            } else {
               kill_floatwin(flwl->win);
               flwl = NULL;
            }
         } else {
            flwl = flwl->next;
         }
      } else {
         flwl = flwl->next;
      }
   }
}

static int exit_game(void)
{
   if (popup_game_quit_dialog()) {
      return TRUE;
   }
   synchronize();
   return FALSE;
}

/* returns 0 when `exit' is chosen, or non-zero if gameplay can begin */
static int game_menu(void)
{
   BITMAP *bmp;
   PALETTE pal;
   FONT *f;
   int res;
   int mv;
   int v;
   UNIT *u;

   /* Load title background */
   bmp = get_title_screen(pal);
   set_palette(*get_game_palette());
   select_palette(*get_game_palette());

   /* Select menu font */
   f = font;
   font = (FONT *)get_menu_font();

   /* Show the background */
   prepare_screen_update();
   stretch_blit(bmp, get_screen_bmp(), 0, 0, bmp->w, bmp->h, 0, 0, SCREEN_W,
                SCREEN_H);
   font = (FONT *)get_small_font();
   textprintf(get_screen_bmp(), font, 2, SCREEN_H - text_height(font), white,
              GAME_VERSTR);
   mark_rect(0, 0, SCREEN_W, SCREEN_H);
   screen_update_done();

   font = (FONT *)get_menu_font();

   /* Start title music */
   stop_music();
   mv = get_music_volume();
   //start_music(0, TRUE);
   set_music_playlist(title_playlist);

   //set_music_volume (32);

   select_mouse_cursor(-1);
   show_mouse(get_monitor_bmp());
   do {
      res = popup_dialog(main_menu_dialog, find_dialog_focus(main_menu_dialog));
      switch (res) {
         case 1:               /* campaign */
            res = popup_dialog(camp_menu_dialog, -1);
            if (res == 1) {
               stop_music();

               /* Reset the player status and unit allocation, ie, free all units */
               initialize_gme_parser();
               register_parser_function(load_unit_data, UNITS);
               register_parser_function(load_cmdb_data, COMMANDS);
               ini_chars();
               game_draw_initialize();
               reset_players();

               /* Load the specific campaign */
               load_map("");
               u = create_unit(name_to_id("Caveman"));
               set_unit_coors(u->data, 12 * 32, 15 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               set_unit_block(u->data);
               give_to_player(1, u);

               /*
               u = create_unit(name_to_id("Medicine Man"));
               set_unit_coors(u->data, 13 * 32, 16 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(1, u);

               u = create_unit(name_to_id("Painter"));
               set_unit_coors(u->data, 15 * 32, 14 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(1, u);

               u = create_unit(name_to_id("Hunter"));
               set_unit_coors(u->data, 18 * 32, 17 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(1, u);

               u = create_unit(name_to_id("Cave"));
               set_unit_coors(u->data, 15 * 32, 15 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               set_unit_block(u->data);
               give_to_player(1, u);

               u = create_unit(name_to_id("Medicine Hut"));
               set_unit_coors(u->data, 13 * 32, 15 * 32);
               u->data->draw_dir = u->data->direction = 0;
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(1, u);

               u = create_unit(name_to_id("Medicine Hut"));
               set_unit_coors(u->data, 19 * 32, 15 * 32);
               u->data->draw_dir = u->data->direction = 0;
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(1, u);

               u = create_unit(name_to_id("Basic Hut"));
               set_unit_coors(u->data, 15 * 32, 18 * 32);
               u->data->draw_dir = u->data->direction = 0;
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(1, u);

               u = create_unit(name_to_id("Woodcraft Hut"));
               set_unit_coors(u->data, 17 * 32, 18 * 32);
               u->data->draw_dir = u->data->direction = 0;
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(1, u);
               */

               /* add an opponent */
               u = create_unit(name_to_id("Caveman"));
               set_unit_coors(u->data, 50 * 32, 50 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(2, u);

               u = create_unit(name_to_id("Basic Hut"));
               set_unit_coors(u->data, 50 * 32, 49 * 32);
               u->data->draw_dir = u->data->direction = 0;
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(2, u);

               u = create_unit(name_to_id("Cave"));
               set_unit_coors(u->data, 48 * 32, 46 * 32);
               u->data->draw_dir = u->data->direction = 0;
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(2, u);

               /* And another one */
               u = create_unit(name_to_id("Caveman"));
               set_unit_coors(u->data, 44 * 32, 5 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(6, u);

               u = create_unit(name_to_id("Caveman"));
               set_unit_coors(u->data, 42 * 32, 6 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(6, u);

               u = create_unit(name_to_id("Caveman"));
               set_unit_coors(u->data, 43 * 32, 5 * 32);
               register_unit(u->data);
               mark_unit(u->data);
               give_to_player(6, u);

               add_resource(get_local_player(), 3, 50);
               add_resource(get_local_player(), 4, 75);

               return -1;
            } else if (res > 1) {
               game_message("Sorry, only the Stone Age\n"
                            "campaign has been created\n" "at this point.");
               res = 0;
            } else {
               res = 0;
            }
            break;
         case 2:               /* custom game */
            game_message("Sorry, support for custom games\n"
                         "has not been added yet.\n");
            break;
         case 3:               /* load game */
            break;
         case 4:               /* options */
            popup_options();
            break;
         default:
            if (!exit_game())
               res = 0;
            break;
      }                         /* end of switch */
   } while (res != 5 && res != -1);
   show_mouse(NULL);

   /* Fade out title music and stop */
   while ((v = get_music_volume())) {
      set_music_volume(--v);
   }
   stop_music();
   /* Restore original settings */
   set_music_volume(mv);
   font = f;
   return 0;
}

/* Run unit mini-programs */
static void update_units(void)
{
   UNIT *ulst;
   UNIT *c;
   UNIT *bc;
   UNITDATA *udta;
   int i;
   int newdir;
   int targetx;
   int targety;
   int dx;
   int dy;

   /* Lift fog of war for current player */
   c = get_player_units(get_local_player());
   while (c) {
      lift_fog(c->data->x / TILE_WIDTH, c->data->y / TILE_HEIGHT,
               c->data->radius);
      c = c->next;
   }

   if (fog_count)
      fog_count--;

   /* At this point, we should consider if the unit control programs are */
   /*  executed on this machine or some other machine (ie, across a network) */
   for (i = 0; i < 9; i++) {
      c = ulst = duplicate_list(get_player_units(i));

      while (c) {
         if (c->data->ai_target.unit) {
            targetx = c->data->ai_target.unit->x / TILE_WIDTH;
            targety = c->data->ai_target.unit->y / TILE_HEIGHT;
         } else {
            targetx = c->data->ai_target.x;
            targety = c->data->ai_target.y;
         }
         /* Structures don't move */
         if (!c->data->cprog && !is_structure(c->data)) {
            /* If we're not where we want to be, make a path to get there */
            if ((c->data->x * TILE_WIDTH != targetx) ||
                (c->data->y * TILE_WIDTH != targety)) {
               if (!c->data->path && (c->data->path_tries < 3)) {
                  c->data->path_tries++;

                  if (path_exists(c->data->x / TILE_WIDTH,
                                  c->data->y / TILE_HEIGHT,
                                  targetx, targety, c->data->layer))
                     set_path(c->data, create_path(c->data->x / TILE_WIDTH,
                                                   c->data->y / TILE_HEIGHT,
                                                   targetx, targety,
                                                   c->data->layer));
               }
            }

            /* If we have a path to follow, follow it! */
            if (c->data->path) {
               /* We should be at the location specified in the first node */
               /*  of the path, if not, the path was blocked and should be cleared */
               dx = c->data->path->tx - c->data->x / TILE_WIDTH;
               dy = c->data->path->ty - c->data->y / TILE_HEIGHT;
               if ((dx || dy)) {
                  clear_path(c->data);
                  break;
               } else {
                  /* Proceed to next step */
                  clear_first_step(c->data);
               }

               if (c->data->path) {
                  dx = c->data->path->tx - c->data->x / TILE_WIDTH;
                  dy = c->data->path->ty - c->data->y / TILE_HEIGHT;

                  newdir = dx_dy_to_dir(dx, dy);

                  /* Change direction */
                  if (c->data->direction != newdir) {
                     insert_command(c->data,
                                    c->data->prog[PROG_TURN_NORTH + newdir],
                                    0, FALSE);
                  }
                  /* Insert move command */
                  insert_command(c->data, c->data->prog[PROG_MOVE], 0, FALSE);

               } else {
                  /* Now, either we're where we want to be, or our path is blocked */
                  c->data->ai_target.x = c->data->x / TILE_WIDTH;
                  c->data->ai_target.y = c->data->y / TILE_HEIGHT;
                  c->data->ai_target.unit = NULL;
                  c->data->path_tries = 0;
               }
            } else {
               push_command(c->data, c->data->prog[PROG_IDLE], 0);
            }
         }

         /* Pop command off the queue, if any are waiting */
         /* Cancel the command if it cannot be performed at the requested */
         /*  location */
         /* First move to the target location */
         if (!c->data->cprog && c->data->queuecount) {
            //c->data->queuestart%c->data->queuesize
            if (!targets_are_equal(c->data->ai_target, c->data->cqueue[c->data->queuestart%c->data->queuesize].target)) {
               set_unit_target(c->data, c->data->cqueue[c->data->queuestart%c->data->queuesize].target);
            } else {
               TARGET t;
               t.unit = c->data;
               if (targets_are_equal(t, c->data->cqueue[c->data->queuestart%c->data->queuesize].target)) {
                  pop_queue(c->data);
               } else {
                  clear_queue_head(c->data);
               }
            }
         }

         if (!c->data->cprog && c->data->prog[PROG_IDLE]) {
            push_command(c->data, c->data->prog[PROG_IDLE], 0);
         }

         if (c->data->cprog) {
            switch (script_exec(c->data)) {
               case 0:
                  c = c->next;
                  break;
               case 1:         // kill unit, ie, remove from all lists
                  udta = c->data;
                  if (map_indicator && c->data == map_indicator->data) {
                     map_indicator = NULL;
                  }
                  c = c->next;
                  if (udta->flags&CF_SELECTED) {
                     mark_interface_area(INT_INFO|INT_CAPTAIN|INT_QUEUE);
                  }
                  remove_from_all_selections(udta);
                  mark_unit(udta);
                  unregister_unit(udta);
                  remove_commands(udta);
                  set_command_panel();
                  release_unit(take_from_player(i, udta));
                  break;
               default:
                  c = c->next;
            }
         } else {
            if (c->data->current_frame) {
               unregister_unit(c->data);
               c->data->current_frame = 0;
               register_unit(c->data);
               mark_unit(c->data);
               set_screen_changed();
            }
            c = c->next;
         }
      }
      destroy_list(ulst);
   }

   /* mini programs not associated with a specific effect; eg non-visible
      spell effects */
   c = active;
   while (c) {
      if (c->data->cprog) {
         switch (script_exec(c->data)) {
            case 0:
               c = c->next;
               break;
            case 1:            // kill character
               if (c == active) {
                  active = active->next;
               }
               bc = c;
               c = c->next;
               if (bc->prev)
                  bc->prev->next = bc->next;
               if (bc->next)
                  bc->next->prev = bc->prev;
               release_unit(bc);
               break;
            case 4:            // prog is NULL
               /* this is bad... there shouldn't be inactive characters in this list */
               push_msg("ERROR: Inactive effect (internal error)");
               //mark_interface();
               set_screen_changed();
               c = c->next;
               break;
            default:
               c = c->next;
         }
      } else {
         c = c->next;
      }
   }

   /* Active tiles */
   c = mapobj;
   while (c) {
      if (!c->data->cprog)
         push_command(c->data, c->data->prog[PROG_IDLE], 0);
      if (c->data->cprog) {
         switch (script_exec(c->data)) {
            case 0:
               c = c->next;
               break;
            case 1:            // kill character
               popup_message("Erasing active tiles is not possible yet.");
               c = c->next;
               break;
            case 4:            // prog is NULL
               c = c->next;
               break;
            default:
               c = c->next;
         }
      } else {
         c = c->next;
      }
   }
   return;
}


void inline playgame_preamble(void)
{
   int c;
   UNIT *u = get_player_units(get_local_player());
   UNITDATA *udta;

   /* Initialize scripting virtual machine */
   register_opcodes();

   /* Set the playlist for game music */
   set_music_playlist(game_playlist);

   /* Find the player's command centre if it exists */
   udta = find_char_flags(u, CC_COMMANDPOST);
   if (udta) {
      centre_map(udta->x / TILE_WIDTH, udta->y / TILE_HEIGHT);
   } else {
      centre_map(u->data->x / TILE_WIDTH, u->data->y / TILE_HEIGHT);
   }

   mark_viewport();

   /* Clear pathfinder data */
   reset_pathfinder();

   /* Lift fog of war for current player */
   while (u) {
      lift_fog(u->data->x / TILE_WIDTH, u->data->y / TILE_HEIGHT,
               u->data->radius);
      u = u->next;
   }

   for (c = 0; c < 9; c++) {
      set_last_clicked_unit(c, NULL);
   }

   game_butt->flags &= ~(D_GOTFOCUS | D_SELECTED);

   enter_msg = FALSE;
   user_msg[0] = '\0';

   cheat_flags = 0;

   clear_command_panel_buttons();
   mouse_mode = MOUSE_FREE;
   command_pending = -1;
   map_indicator = NULL;
   game_cycle_count = 0;

   set_palette(*get_game_palette());
   select_palette(*get_game_palette());

   game_gfx_update();

   show_tip = TRUE;

   /* Show tips */
   if (show_tip) {
      popup_tip_dialog();
      show_tip = FALSE;
   }

}

void inline playgame_closing(void)
{
   destroy_all_floatwins();
   prepare_screen_update();
   clear_bitmap(get_screen_bmp());
   mark_rect(0, 0, SCREEN_W, SCREEN_H);
   screen_update_done();
   while (keypressed())
      readkey();
}

void inline game_gfx_update_preamble(void)
{
   /* Mark tiles where the Fog-of-War state has changed */
   mark_fog_tiles();
}

void inline game_gfx_update(void)
{
   UNIT *c;

   prepare_screen_update();
   do_screen_update();
   screen_update_done();

   /* Shroud the map again in the Fog of War, then lift the fog from those */
   /*  area's that should be clean */
   if (!fog_count && settings.flags & FOG_OF_WAR_ON && !(cheat_flags & CHEAT_FOG)) {
      shroud_map();
      set_screen_changed();
      fog_count = FOG_UPDATE_INTERVAL;
      c = get_player_units(get_local_player());
      while (c) {
         lift_fog(c->data->x / TILE_WIDTH, c->data->y / TILE_HEIGHT,
                  c->data->radius);
         c = c->next;
      }
   }

   /* Show UNIT and UDTA counts */
   /*
      text_mode (0);
      textprintf (get_monitor_bmp(), get_normal_font(), 0,16,white,"#CHAR:     %d   ", get_unit_count());
      textprintf (get_monitor_bmp(), get_normal_font(), 0,32,white,"#CHARDATA: %d   ", get_udta_count());
      //   */
}

void inline game_state_update(void)
{
   cycle_game_music();

   update_floatwin();
   update_units();
   
   if (key_relax)
      key_relax--;

   game_cycle_count++;
}

void ingame_menu(void)
{
   int res;

   do {
      res = popup_ingame_menu();

      switch (res) {
         case -1:
            res = 4;
            break;
         case 1:
            /* Don't allow toggleing the fog-of-war during play */
            disable_fog_of_war_toggle();
            popup_options();
            enable_fog_of_war_toggle();
            break;
         case 5:
            if (popup_game_quit_dialog())
               set_game_done();
            break;
         default:
      }
   } while (res != 4 && res != 5);
   synchronize();
}

/* Return the screen area the mouse is in */
static int get_screen_mouse_area(int x, int y)
{
   if (in_rect(x, y, game_butt->x, game_butt->y, game_butt->w, game_butt->h)) {
      return MA_MENU_BUTTON;
   } else if (in_rect(x, y, SCREEN_W - 132, SCREEN_H - 132, 128, 128)) {
      return MA_MINIMAP;
   } else if (in_rect(x, y, get_commandmap_x(), get_commandmap_y(),get_commandmap_width(),get_commandmap_height())) {
      return MA_COMMAND_MAP;
   }

   return MA_NONE;
}

static void inline game_mouse_interface_button(const int x, const int y,
                                               const int b)
{
   FONT *f = (FONT *)get_normal_font();


   /* Check if the mouse overlaps with the `Menu' button */
   if (in_rect(x, y, game_butt->x, game_butt->y, game_butt->w, game_butt->h)) {
      if (!(game_butt->flags & D_GOTFOCUS)) {
         game_butt->flags |= D_GOTFOCUS;
         mark_interface_area(INT_BUTTON);
         set_screen_changed();
      }
      if (b & 1) {
         if (!(game_butt->flags & D_SELECTED)) {
            game_butt->flags |= D_SELECTED;
            mark_interface_area(INT_BUTTON);
            set_screen_changed();
         }
      } else if (game_butt->flags & D_SELECTED) {
         game_butt[0].proc(MSG_CLICK, &(game_butt[0]), 0);
         game_butt->flags &= ~(D_SELECTED);
         mark_interface_area(INT_BUTTON);
         ingame_menu();
      }
      return;
      /* No; make sure the button display matches this */
   } else {
      if (game_butt->flags & (D_GOTFOCUS)) {
         game_butt->flags &= ~(D_GOTFOCUS);
         mark_interface_area(INT_BUTTON);
         set_screen_changed();
      }
      if (game_butt->flags & (D_SELECTED)) {
         game_butt->flags &= ~(D_SELECTED);
         mark_interface_area(INT_BUTTON);
         set_screen_changed();
      }
   }

   /* Check if the mouse overlaps with the `Cancel' button */
   if (!(cancel_butt->flags & D_HIDDEN) &&
       in_rect(x, y, cancel_butt->x, cancel_butt->y,
               cancel_butt->w, cancel_butt->h)) {

      if (!(cancel_butt->flags & D_GOTFOCUS)) {
         cancel_butt->flags |= D_GOTFOCUS;

         make_floattext(4, SCREEN_H - text_height(f) - 1, black, white,
                        FWIN_CANCELTEXT, 0, f, "Cancel");

         set_screen_changed();
      }

      if (b & 1) {
         if (!(cancel_butt->flags & D_SELECTED)) {
            cancel_butt->flags |= D_SELECTED;
            mark_interface_area(INT_QUEUE);
            set_screen_changed();
         }
      } else if (cancel_butt->flags & D_SELECTED) {
         give_group_targeted_command(get_local_player(), 12,
                                     get_player_target(get_local_player()),
                                     0);
         set_command_panel();
         mark_interface_area(INT_QUEUE|INT_COMMANDS);
         set_screen_changed();
         cancel_butt->flags |= D_HIDDEN;
         cancel_butt->flags &= ~D_SELECTED;
      }

      return;
      /* No; make sure the button display matches this */
   } else {
      FLOATWIN *flw = find_floatwin(FWIN_CANCELTEXT);
      if (flw)
         set_lifetime(flw, 1);

      if (cancel_butt->flags & (D_GOTFOCUS)) {
         cancel_butt->flags &= ~(D_GOTFOCUS);
         mark_interface_area(INT_QUEUE);
         set_screen_changed();
      }
      if (cancel_butt->flags & (D_SELECTED)) {
         cancel_butt->flags &= ~(D_SELECTED);
         mark_interface_area(INT_QUEUE);
         set_screen_changed();
      }
   }
}

static void inline game_mouse_unit_buttons(const int x, const int y,
                                           const int b)
{
   int n = get_button_id(x, y, 0, SCREEN_H - 96 - 16);
   UNIT *u;

   /* Only highlight new options if the mouse is free */
   if (n != get_last_touched_button(get_local_player()) && n >= 0 &&
       mouse_mode & MOUSE_FREE) {
      FONT *f = (FONT *)get_normal_font();

      /* Actually, we should check if such a floatwin already exists and if it */
      /*  does destroy it, or alter it's contents */
      set_lifetime(find_floatwin(FWIN_CMDNAME), 1);
      make_floattext(4, SCREEN_H - text_height(f) - 1, black, white,
                     FWIN_CMDNAME, 0, f, get_cmd_panel_string(n));
      mark_interface_area(INT_DESCR);
      set_screen_changed();
      set_last_touched_button(get_local_player(), n);
   } else if (n == get_last_touched_button(get_local_player()) && n >= 0 &&
              b & 1 && get_last_clicked_button(get_local_player()) < 0) {
      /* The button was actually clicked... */
      set_last_clicked_button(get_local_player(), n);
   } else if (n == get_last_clicked_button(get_local_player()) && n >= 0 &&
              !(b & 1)) {
      /* ... and now the mouse was released there as well */

      /* Clear target and queue if requested */
      if (get_cmd_panel_flags(command_pending) & UCMD_CLR_TARGET) {
         u = get_selected_units(get_local_player());
         u = NULL;
         while (u) {
            if (u->data->path) {
               /* Set target to the first node in the path */
               u->data->ai_target.unit = NULL;
               u->data->ai_target.x = u->data->path->tx;
               u->data->ai_target.y = u->data->path->ty;
               clear_path(u->data);
            }

            /* Clear command queue */
            while (clear_queue_head(u->data));
            u = u->next;
            if (get_cmd_panel_flags(command_pending) & UCMD_EXCLUSIVE)
               break;
         }
      }

      /* Check if the command requires a target */
      if (get_cmd_panel_flags(n) & UCMD_TARGET) {
         mouse_mode |= MOUSE_ACQUIRE_TARGET;
         if (get_cmd_panel_flags(n) & UCMD_PLACE) {
            mouse_mode |= MOUSE_ACQUIRE_BUILDINGSITE;
         }
         mouse_mode &= ~MOUSE_FREE;
      }
      command_pending = n;

      /* Clear button status so we can handle new events */
      set_last_touched_button(get_local_player(), -1);
      set_last_clicked_button(get_local_player(), -1);
   } else if (n < 0) {
      if (!find_floatwin(FWIN_CANCELTEXT))
         set_lifetime(find_floatwin(FWIN_CMDNAME), 1);

      mark_interface_area(INT_DESCR);
      set_last_touched_button(get_local_player(), n);
      set_last_clicked_button(get_local_player(), n);
   }
}

/* Mouse click on unit icons (in multiple selections) */
void inline game_mouse_unit_icons(int mx, int my, int b)
{
   UNIT *udrw = get_selected_units(get_local_player());
   int num_sel_units = get_num_selected_units(get_local_player());
   int x, y;
   int c;
   int flags;

   if (num_sel_units) {
      /* Center on group leader if his portrait is clicked */
      if (in_rect(mx, my, game_butt[0].x + 8, SCREEN_H - 128 + 44, 34, 34) &&
          b & 1) {
         if (centre_map
             (udrw->data->x / TILE_WIDTH, udrw->data->y / TILE_HEIGHT)) {
            set_screen_changed();
         }
      }

      if (num_sel_units > 0) {

         //x = 136 + (c / 2) * 36;
         //y = SCREEN_H - 128 + 28 + 42 * (c % 2);
         x = game_butt[0].x + 8;
         y = SCREEN_H - 128 + 44;
         for (c = 0; udrw && c <= 12; c++) {

            if (in_rect(mx, my, x, y, 34, 34)) {

               if (b & 1 && mouse_mode & MOUSE_FREE) {
                  set_last_clicked_unit(get_local_player(), udrw->data);
               } else if (!(b & 1) &&
                          get_last_clicked_unit(get_local_player()) ==
                          udrw->data) {

                  /* Unit was definately clicked */
                  if (key_shifts & KB_SHIFT_FLAG) {
                     flags = CLICK_TOGGLE_SELECTION;
                  } else if (key_shifts & KB_CTRL_FLAG) {
                     flags = CLICK_RMV_SELECTION;
                  } else {
                     flags = CLICK_MAKE_SELECTION;
                  }
                  register_click(get_local_player(), flags);
                  set_last_clicked_unit(get_local_player(), NULL);
                  mark_interface_area(INT_GROUP|INT_CAPTAIN|INT_INFO);

                  /* Now set the command-buttons appropriately */
                  if (udrw->data->player == get_local_player()) {
                     set_command_panel();
                     mark_interface_area(INT_COMMANDS);
                     set_screen_changed();
                  }
               }

               return;
            }
            x = 136 + (c / 2) * 36;
            y = SCREEN_H - 128 + 28 + 42 * (c % 2);
            
            if (c) udrw = udrw->next;
         }
      }
   }
}

void inline game_keyboard_input(void)
{
   int c;
   int msg_changed = FALSE;

   if (keypressed()) {
      c = readkey();
      switch (c >> 8) {
         case KEY_F1:
            select_mouse_cursor(-1);
            popup_tip_dialog();
            synchronize();
            break;
//         case KEY_F2: /* For debugging purposes */
//            push_group_script (get_local_player(), get_prog_ptr("char_dies"), 0, 0);
//            break;
//         case KEY_F3: /* For debugging purposes */
//            push_group_script (get_local_player(), get_prog_ptr("struc_dies"), 0, 0);
//            break;
//         case KEY_F5: /* For debugging purposes */
//            dump_player_units(get_local_player());
//            break;

            /* Check for ctrl+# or # unit commands */
            PPD_CTRL_NUM(1);
            PPD_CTRL_NUM(2);
            PPD_CTRL_NUM(3);
            PPD_CTRL_NUM(4);
            PPD_CTRL_NUM(5);
            PPD_CTRL_NUM(6);
            PPD_CTRL_NUM(7);
            PPD_CTRL_NUM(8);
            PPD_CTRL_NUM(9);
            PPD_CTRL_NUM(0);

         case KEY_TAB:  /* Change leader if not busy executing a command */
            shift_selection(get_local_player());
            set_command_panel();
            mouse_mode |= MOUSE_FREE;
            mouse_mode &= ~(MOUSE_ACQUIRE_TARGET+MOUSE_ACQUIRE_BUILDINGSITE);
            command_pending = -1;
            mark_interface_area(INT_COMMANDS|INT_GROUP|INT_CAPTAIN);
            set_screen_changed();
            break;

#ifdef ALLEGRO_LINUX
         case KEY_F12:
#endif
         case KEY_PRTSCR:
            screenshot();
            break;
         case KEY_ESC:
            if (mouse_mode & MOUSE_FREE) {
               select_mouse_cursor(-1);
               if (popup_game_quit_dialog())
                  set_game_done();
               synchronize();
            } else {
               mouse_mode |= MOUSE_FREE;
               mouse_mode &= ~(MOUSE_ACQUIRE_TARGET+MOUSE_ACQUIRE_BUILDINGSITE);
               command_pending = -1;
            }
            break;
         case KEY_F10:
            select_mouse_cursor(-1);
            ingame_menu();
            break;
         case KEY_LEFT:
            if (scroll_map(-K_SCROLL, 0)) {
               set_screen_changed();
            }
            break;
         case KEY_RIGHT:
            if (scroll_map(K_SCROLL, 0)) {
               set_screen_changed();
            }
            break;
         case KEY_UP:
            if (scroll_map(0, -K_SCROLL)) {
               set_screen_changed();
            }
            break;
         case KEY_DOWN:
            if (scroll_map(0, K_SCROLL)) {
               set_screen_changed();
            }
            break;
         case KEY_ENTER:
            if (!enter_msg) {
               //uszprintf (user_msg, MSG_LENGTH, " ");
               user_msg[0] = '\0';
            } else {
               broadcast_text(user_msg, get_local_player(), COMPUTER_RECIPIENT);
            }
            enter_msg = !enter_msg;
            msg_changed = TRUE;
            break;
         case KEY_A...KEY_Z:
         case KEY_SPACE:
            if (enter_msg) {    /* Append to string */
               if (key[KEY_LSHIFT]||key[KEY_RSHIFT]) {
                  uszprintf(user_msg, MSG_LENGTH, "%s%c", user_msg, utoupper(c&0xFF));
               } else {
                  uszprintf(user_msg, MSG_LENGTH, "%s%c", user_msg, c&0xFF);
               }
               msg_changed = TRUE;
            } else {            /* Hotkey */
            }
            break;
         case KEY_BACKSPACE:
            if (enter_msg) {
               user_msg[uoffset(user_msg, -1)] = '\0';
               msg_changed = TRUE;
            }
         default:
            break;
      }                         /* end of switch */

      if (msg_changed) {
         set_lifetime(find_floatwin(FWIN_USERMSG), 1);
         if (enter_msg) {
            FONT *f = (FONT *)get_normal_font();

            make_floattext(128, SCREEN_H - 124 - text_height(f), black, white,
                           FWIN_USERMSG, 0, f, "Message: %s_", user_msg);
         }
         set_screen_changed();
      }
      clear_keybuf();
      key_relax = KEY_RELAX_TIME;
   }
}

void inline game_input(void)
{
   int x, y;
   int b;
   int tx=0;
   int ty=0;
   int mouse_arrow = -1;
   int x_extr = 0;
   int y_extr = 0;
   int flags;
   int mouse_area = MA_NONE;
   int target_x = -1, target_y = -1;
   int res;
   UNIT *ovru;
   UNIT *u;

   /* Process keyboard input */
   game_keyboard_input();

   /* Track the mouse cursor */
   x = mouse_x;
   y = mouse_y;
   b = mouse_b;

   if (b & 1)
      mouse_mode |= MOUSE_BUTTON1_DOWN;

   /* Check interface command buttons */
   game_mouse_interface_button(x, y, b);

   /* Check unit command buttons */
   game_mouse_unit_buttons(x, y, b);

   /* Check unit portraits */
   game_mouse_unit_icons(x, y, b);

   /* Mouse scrolling */
   if (x == 0)
      if (scroll_map(-M_SCROLL, 0))  {
         set_screen_changed();
         x_extr = -1;
      }

   if (x == SCREEN_W - 1)
      if (scroll_map(M_SCROLL, 0)) {
         set_screen_changed();
         x_extr = 1;
      }

   if (y == 0)
      if (scroll_map(0, -M_SCROLL)) {
         set_screen_changed();
         y_extr = -1;
      }

   if (y == SCREEN_H - 1)
      if (scroll_map(0, M_SCROLL)) {
         set_screen_changed();
         y_extr = 1;
      }
   if (!x_extr && y_extr) {
      if (y_extr > 0)
         mouse_arrow = SOUTH;
      else
         mouse_arrow = NORTH;
   } else if (!y_extr && x_extr) {
      if (x_extr > 0)
         mouse_arrow = EAST;
      else
         mouse_arrow = WEST;
   } else if (y_extr && x_extr) {
      if (x_extr > 0) {
         if (y_extr > 0)
            mouse_arrow = SOUTH_EAST;
         else
            mouse_arrow = NORTH_EAST;
      } else {
         if (y_extr > 0)
            mouse_arrow = SOUTH_WEST;
         else
            mouse_arrow = NORTH_WEST;
      }

   }

   mouse_area = get_screen_mouse_area(x, y);

   /* Check if the mouse is over the mini-map; centre map if mm clicked */
   if (mouse_area == MA_MINIMAP) {
      tx = (x - SCREEN_W + 132) * get_map_width() / 128;
      ty = (y - SCREEN_H + 132) * get_map_height() / 128;
      target_x = tx * TILE_WIDTH + 16;
      target_y = ty * TILE_HEIGHT + 16;

      if (mouse_mode & MOUSE_BUTTON1_DOWN && !(b & 1)) {
         if ((mouse_mode & MOUSE_ACQUIRE_TARGET) &&
             (!(mouse_mode & MOUSE_ACQUIRE_BUILDINGSITE))) {
            /* Now pass the command given from the command button! */
            set_player_target(get_local_player(), tx, ty, NULL);
            mouse_mode |= MOUSE_FREE;
            mouse_mode &= ~MOUSE_ACQUIRE_TARGET;
         }
      } else if (b&1) {
         if (centre_map(tx, ty)) {
            set_screen_changed();
         }
      }
   }

   /* Check if the mouse is over the command map */
   if (mouse_area == MA_COMMAND_MAP) {
      tx = scrx_to_tilex(x);
      ty = scry_to_tiley(y);
   }

   if (mouse_area == MA_COMMAND_MAP) {
      if (tile_hidden(tx, ty) || tile_fog(tx, ty))
         ovru = NULL;
      else
         ovru = duplicate_list(get_ovr_char(tx, ty));
      if (ovru) {
         /* Check if the mouse was clicked and if so, maybe select a unit */
         u = ovru;
         /* Check if this is the unit we want to click */
         while (u) {
            if (in_rect
                (get_viewport_x() - get_commandmap_x() + x,
                 get_viewport_y() - get_commandmap_y() + y,
                 u->data->x - u->data->gfx_dx, u->data->y - u->data->gfx_dy,
                 u->data->gfx_w, u->data->gfx_h) &&
                can_be_selected(u->data)) {
	       /* TO DO: */
               /* Make a distinction between `friendly' and `hostile' units */
               mouse_arrow = 8;
               if (b & 1 && mouse_mode & MOUSE_FREE)
                  set_last_clicked_unit(get_local_player(), u->data);

               break;
            }
            u = u->next;
         }
         if (!(b & 1) && get_last_clicked_unit(get_local_player())) {
            /* Make sure the mouse cursor is still over the last clicked unit */
            while (u) {
               if (u->data == get_last_clicked_unit(get_local_player())) {
                  break;
               }
               u = u->next;
            }
            if (u) {
               /* Unit was definately clicked */
               if (key_shifts & KB_SHIFT_FLAG) {
                  flags = CLICK_TOGGLE_SELECTION;
               } else if (key_shifts & KB_CTRL_FLAG) {
                  flags = CLICK_RMV_SELECTION;
               } else {
                  flags = CLICK_MAKE_SELECTION;
               }
               register_click(get_local_player(), flags);
               mark_interface_area(INT_GROUP|INT_CAPTAIN|INT_INFO|INT_COMMANDS|INT_QUEUE);

               /* Now set the command-buttons appropriately */
               if (u->data->player == get_local_player()) {
                  set_command_panel();
                  set_screen_changed();
               }
            }
         }
      }
      destroy_list(ovru);

      /* If the mouse was not free, then check for map clicks */
      if (mouse_mode & MOUSE_ACQUIRE_TARGET && mouse_mode & MOUSE_BUTTON1_DOWN && !(b & 1)) {
         /* If we're asked to place a structure, then make sure that it is */
         /*  ok to do so at this location! */

         /* We pass the unit that is to construct the building in the ignore list */
         ovru = alloc_unit();
         ovru->next = ovru->prev = NULL;
         ovru->data = get_captain(get_local_player());

         res = can_place_structure(tx, ty, 1, 1, ovru);

         if ((mouse_mode & MOUSE_ACQUIRE_BUILDINGSITE) && (res != PLACE_OK)){
            switch(res) {
               case PLACE_EXPL:
                  //push_gamemsg(yellow, "You must explore there first");
                  broadcast_message(GAMEMSG_NOEX, get_local_player(), get_local_player());
                  break;
               case PLACE_STRUC:
                  //push_gamemsg(yellow, "You must keep space between buildings");
                  broadcast_message(GAMEMSG_NOSP, get_local_player(), get_local_player());
                  break;
               default:
                  //push_gamemsg(yellow, "You cannot build there");
                  broadcast_message(GAMEMSG_NONO, get_local_player(), get_local_player());
            }
            set_screen_changed();
         } else {
            /* Now pass the command given from the command button! */
            set_player_target(get_local_player(), tx, ty, NULL);
            mouse_mode |= MOUSE_FREE;
            mouse_mode &= ~(MOUSE_ACQUIRE_TARGET+MOUSE_ACQUIRE_BUILDINGSITE);
         }

         free_unit(ovru);
      }

      target_x = x - 16 + get_viewport_x() - get_commandmap_x();
      target_y = y - 16 + get_viewport_y() - get_commandmap_y();
   }

   /* Auto commands; actually should be activated at button release */
   if ((mouse_area == MA_COMMAND_MAP || mouse_area == MA_MINIMAP)) {
      if (b & 2)
         mouse_mode |= MOUSE_BUTTON2_DOWN;

      if (!(b & 2) && (mouse_mode & MOUSE_BUTTON2_DOWN)) {
         mouse_mode &= ~MOUSE_BUTTON2_DOWN;
         if (get_selected_units(get_local_player())) {
            if (mouse_mode & MOUSE_FREE && (!count_structures(get_selected_units(get_local_player())))) {
               set_player_target(get_local_player(), tx, ty, NULL);

               /* What command do we want to give? */
               /* Right now, this causes structures to build units when the */
               /* right mouse button is clicked on the map. Not wanted! */
               command_pending = 0;

               /* Display `clicked here' animation */
               if (!map_indicator) {
                  map_indicator = create_unit(name_to_id("_clicked_action"));
                  set_unit_coors(map_indicator->data, target_x, target_y);
                  map_indicator->data->draw_dir =
                     map_indicator->data->direction = 0;
                  register_unit(map_indicator->data);
                  mark_unit(map_indicator->data);
                  give_to_player(0, map_indicator);
               }
            } else if (mouse_mode & MOUSE_ACQUIRE_TARGET) {
               mouse_mode |= MOUSE_FREE;
               mouse_mode &= ~(MOUSE_ACQUIRE_TARGET+MOUSE_ACQUIRE_BUILDINGSITE);
               command_pending = -1;
            }
         }
      }
   } else {
      mouse_mode &= ~MOUSE_BUTTON2_DOWN;
   }

   /* Remove the mouse tracker for clicked units - if a unit were clicked, */
   /*  we'd have taken care of it above */
   if (!(b & 1) && get_last_clicked_unit(get_local_player())) {
      set_last_clicked_unit(get_local_player(), NULL);
   }

   if (!(b & 1))
      mouse_mode &= ~MOUSE_BUTTON1_DOWN;

   if (command_pending >= 0 && (mouse_mode & MOUSE_FREE)) {
      give_group_targeted_command(get_local_player(), command_pending,
                                  get_player_target(get_local_player()), 0);
      set_command_panel();
      command_pending = -1;
      mark_interface_area(INT_COMMANDS|INT_GROUP|INT_CAPTAIN|INT_QUEUE);
      set_screen_changed();
   }

   if (mouse_mode & MOUSE_ACQUIRE_TARGET) {
      if (!(mouse_mode & MOUSE_ACQUIRE_BUILDINGSITE)) {
         if (mouse_arrow == 8)
            mouse_arrow = 10;
         else
            mouse_arrow = 9;
      } else {
         if (mouse_arrow == 8)
            mouse_arrow = -1;
      }
   } else {
   }

   select_mouse_cursor(mouse_arrow);

   /* Build target area indicator */
   if (mouse_mode & MOUSE_ACQUIRE_BUILDINGSITE && mouse_area == MA_COMMAND_MAP) {
      FLOATWIN *flw = find_floatwin(FWIN_PLACESTRUCTURE);
      int fx = tx*TILE_WIDTH - get_viewport_x() + get_commandmap_x() - TILE_WIDTH;
      int fy = ty*TILE_HEIGHT - get_viewport_y() + get_commandmap_y() - TILE_HEIGHT;

      if (!flw) {
         BITMAP *bmp;
         int n;

         /* Make sure the unit that is supposed to build the structure */
         /*  doesn't show up as red square (ie, put it on the ignore list)! */
         ovru = alloc_unit();
         ovru->next = ovru->prev = NULL;
         ovru->data = get_captain(get_local_player());

         /* The target structure is in the 3rd argument (counting from 0) */
         n = get_cmd_panel_argv(command_pending, 2);
         bmp = draw_structure_mask(NULL, tx, ty, get_char_xsize(n), get_char_ysize(n), ovru);

         free_unit (ovru);

         make_floatwin(fx, fy, bmp->w, bmp->h, FWIN_PLACESTRUCTURE+FWIN_TRANS+FWIN_HIDDEN, 0, NULL, bmp);
      } else {
         if ((flw->x != fx) || (flw->y != fy)) {
            set_lifetime(find_floatwin(FWIN_PLACESTRUCTURE), 1);
         }
      }
   } else if (find_floatwin(FWIN_PLACESTRUCTURE)) {
      set_lifetime(find_floatwin(FWIN_PLACESTRUCTURE), 1);
   }

   /* Check for `cheat' wins */
   if (cheat_flags & CHEAT_WIN) {
      popup_game_victory_dialog();
      set_game_done();
   }
}

void start_game(void)
{
   srand(time(NULL));

   show_opening_animation();

   while (game_menu()) {
      playgame();
   }
}
