/**********************************************/
/* Rise of the Tribes                         */
/* C version, Take 2                          */
/* Evert Glebbeek 1998, 2002                  */
/* eglebbk@phys.uva.nl                        */
/**********************************************/
#include <allegro.h>
#include <string.h>
#include <stdio.h>
#include "playgame.h"
#include "global.h"
#include "dialog.h"
#include "gamegfx.h"
#include "mapdraw.h"
#include "gfx.h"
#include "sound.h"
#include "gmemusic.h"

#define D_PASSIVE (D_USER << 1)

#ifdef ALLEGRO_LINUX
#undef KEY_PRTSCR
#define KEY_PRTSCR KEY_F12
#endif

/* *INDENT-OFF* */
typedef int (*BUTTCALLBACK)(int msg, DIALOG *d, int c);

int num_tips = 0;
int tip_nr = 0;
char *tip_text[] = {
   "Use the left mouse button to select a unit. "
   "Hold down the SHIFT key to add a unit to the current selection, "
   "or to remove it from the selection.",

   "Keep an eye on the morale counter. If morale drops too low, "
   "units will suffer penalties in battle.",

   "You can use the right mouse button to give auto commands. "
   "Simply right click on the command map or mini map to make units move "
   "to the target location to perform routine tasks "
   "such as attacking enemy units or harvesting resources.",

   "You can press F1 during gameplay to pause the game and get more tips.",

   "Remember that this is an ALPHA version, and a lot of things are "
   "not working properly yet!",

   "You can set up a unit group by pressing CTRL+#. Stored groups can "
   "be quickly re-selected by pressing the number key (#) where they were "
   "stored. Press ## to centre the map on the group.",

   "Always keep a couple of basic workers (Cavemen) handy - without them, "
   "you can't build new houses or tech support if you need it.",

   "Check the Allegro site regularly for library updates! Always use the "
   "latest library version available for your platform.",

   "Remember that structures cannot be placed directly next to each other: "
   "you must always leave some space between them.",

   "You can get better music playback by switching on Digital Midi in "
   "the options menu.",

   "You can centre the command map on the leader of the selected group by "
   "clicking on his portrait below the menu button.",

   "You can disable the fog-of-war in the Options menu, but not while "
   "you're playing!",

   "You can change the leader of a selected group by pressing the TAB key. "
   "In this way, you can give special commands without deselecting the rest "
   "of the group.",

   "Check out www.allegro.cc for other nice games made with Allegro.",

   "To change the audio setup, start the game with the `-setup' commandline "
   "flag. You can also change the volume settings here.",

   NULL
};

static DIALOG game_quit_dialog[] = {
   /* (dialog proc) (x)     (y)  (w)      (h)   (fg) (bg) (key) (flags) (d1)  (d2)  (dp) */
   { d_mbitmap_proc,    -96,-48,   192,   136,  0,     0,   0,    0,      0,   0,    NULL },
   { d_text_proc,       -64,-36,   128,   16,   0,     7,   0,    0,      0,   0,    "Are you sure?",NULL },
   { d_butgfx_agui_proc,-63, 36,   126,   18,   0,     7,   'y',  D_EXIT, 0,   0,    "&Yes",NULL },
   { d_butgfx_agui_proc,-63, 60,   126,   18,   0,     7,   'n',  D_EXIT, 0,   0,    "&No",NULL },
   { d_keyboard_proc,     0,  0,     0,    0,   0,     0,   0,    0,      0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

DIALOG main_menu_dialog[] = {
   /* (dialog proc) (x)      (y)  (w)   (h)   (fg) (bg) (key) (flags) (d1)  (d2)  (dp) */
   { d_mbitmap_proc,    -96,-48, 192,   136,   0,    0,   0,    0,      0,   0,    NULL },
   { d_butgfx_agui_proc,-63,-36, 126,    18,   0,    7,  'n',   D_EXIT, 0,   0,    "&New Campaign", NULL },
   { d_butgfx_agui_proc,-63,-12, 126,    18,   0,    7,  'c',   D_EXIT, 0,   0,    "&Custom game", NULL },
   { d_butgfx_agui_proc,-63, 12, 126,    18,   0,    7,  'l',   D_EXIT, 0,   0,    "&Load game", NULL },
   { d_butgfx_agui_proc,-63, 36, 126,    18,   0,    7,  'o',   D_EXIT, 0,   0,    "&Options", NULL },
   { d_butgfx_agui_proc,-63, 60, 126,    18,   0,    7,  'x',   D_EXIT, 0,   0,    "E&xit program", NULL },
   { d_keyboard_proc,     0,  0,   0,     0,   0,    0,   0,    0,      0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

DIALOG camp_menu_dialog[] = {
   /* (dialog proc)     (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1)  (d2)  (dp) */
   { d_mbitmap_proc,    -96,-48,  192, 136,  0,   0,    0,    0,      0,    0,   NULL },
   { d_butgfx_agui_proc,-63,-36,  126,  18,  0,   7,   's',  D_EXIT,  0,    0,   "&Stone Age Campaign", NULL },
   { d_butgfx_agui_proc,-63,-12,  126,  18,  0,   7,   'i',  D_EXIT,  0,    0,   "&Iron Age Campaign", NULL },
   { d_butgfx_agui_proc,-63, 12,  126,  18,  0,   7,   'm',  D_EXIT,  0,    0,   "&Medieval Campaign", NULL },
   { d_butgfx_agui_proc,-63,-12,  126,  18,  0,   7,   'i',  D_HIDDEN,0,    0,   "M&odern Campaign", NULL },   
   { d_butgfx_agui_proc,-63, 60,  126,  18,  0,   7,   'f',  D_HIDDEN,0,    0,   "&Future Campaign", NULL },
   { d_keyboard_proc,     0,  0,    0,   0,  0,   0,    0,    0,      0,KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

static DIALOG game_msg_dialog[] = {
   /* (dialog proc)    (x)    (y)   (w)   (h)  (fg) (bg) (key) (flags)  (d1)  (d2)  (dp) */
   { d_mbitmap_proc,   -96,   -48,  192, 136,   0,   0,   0,      0,      0,   0,      NULL },
   { d_text_proc,      -88,   -36,  128,  16,   0,   7,   0,      0,      0,   0,      NULL,NULL },
   { d_text_proc,      -88,   -20,  128,  16,   0,   7,   0,      0,      0,   0,      NULL,NULL },
   { d_text_proc,      -88,    -4,  128,  16,   0,   7,   0,      0,      0,   0,      NULL,NULL },
   { d_butgfx_agui_proc,-63,   60,  126,  18,   0,   7,   'o',    D_EXIT, 0,   0,      "&Ok",NULL },
   { d_keyboard_proc,    0,     0,    0,   0,   0,   0,    0,     0,      0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

static DIALOG game_victory_dialog[] = {
   /* (dialog proc)    (x)    (y)   (w)   (h)  (fg) (bg) (key) (flags)  (d1)  (d2)  (dp) */
   { d_mbitmap_proc,   -96,   -48,  192, 136,   0,   0,   0,      0,      0,   0,      NULL },
   { d_ctext_proc,       0,   -36,  128,  16,   0,   7,   0,      0,      0,   0,      "You are victorious!",NULL },
   { d_ctext_proc,       0,   -16,  128,  16,   0,   7,   0,      0,      0,   0,      "All your enemies have",NULL },
   { d_ctext_proc,       0,     0,  128,  16,   0,   7,   0,      0,      0,   0,      "been defeated!",NULL },
   { d_butgfx_agui_proc,-63,   60,  126,  18,   0,   7,  'v',     D_EXIT, 0,   0,      "&Victory",NULL },
   { d_keyboard_proc,    0,     0,    0,   0,   0,   0,   0,      0,      0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

/* Game menu dialog box */
static DIALOG game_menu_dialog[] = {
   /* (dialog proc)    (x)    (y)   (w)   (h)  (fg) (bg) (key) (flags) (d1)  (d2)  (dp) */
   { d_mbitmap_proc,    -96, -48,   192,   136, 0,   0,    0,   0,      0,   0,      NULL },
   { d_butgfx_agui_proc,-63, -37,   126,    18, 0,   7,    'o', D_EXIT, 0,   0,      "&Options",NULL },
   { d_butgfx_agui_proc,-63, -11,   126,    18, 0,   7,    'n', D_EXIT, 0,   0,      "&New Game",NULL },
   { d_butgfx_agui_proc,-63,  13,   126,    18, 0,   7,    'l', D_EXIT, 0,   0,      "&Load Game",NULL },
   { d_butgfx_agui_proc,-63,  37,   126,    18, 0,   7,    'r', D_EXIT, 0,   0,      "&Resume",NULL },
   { d_butgfx_agui_proc,-63,  61,   126,    18, 0,   7,    'q', D_EXIT, 0,   0,      "&Quit",NULL },
   { d_keyboard_proc,0,    0,     0,    0,   0,    0,    0,    0,     0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

/* Game options dialog box */
static DIALOG game_options_menu_dialog[] = {
   /* (dialog proc)    (x)    (y)   (w)   (h)  (fg) (bg) (key) (flags)  (d1)  (d2)  (dp) */
   { d_mbitmap_proc,    -96, -48,   192,  136,  0,   0,   0,      0,      0,      0,      NULL },
   { d_butgfx_agui_proc,-63, -37,   126,   18,  0,   7,   'd',    D_EXIT,0,   0,      "&Display options",NULL },
   { d_butgfx_agui_proc,-63, -11,   126,   18,  0,   7,   's',    D_EXIT,0,   0,      "&Sound options",NULL },
   { d_butgfx_agui_proc,-63,  13,   126,   18,  0,   7,   0,      D_DISABLED,0,0,     "",NULL },
   { d_butgfx_agui_proc,-63,  37,   126,   18,  0,   7,   0,      D_DISABLED,0,0,     "",NULL },
   { d_butgfx_agui_proc,-63,  61,   126,   18,  0,   7,   'r',    D_EXIT,0,   0,      "&Return",NULL },
   { d_keyboard_proc,0,    0,     0,    0,   0,    0,    0,    0,     0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

/* Video options dialog */
static DIALOG game_video_options_dialog[] = {
   /* (dialog proc) (x)   (y)  (w)     (h)   (fg) (bg) (key) (flags)  (d1)  (d2)  (dp) */
   { d_mbitmap_proc,  0,   0,    320,   240,   0,   0,   0,      0,     0,   0,      NULL },
   { d_butgfx_agui_proc, 19,210, 126,    18,   0,   7,   'o',    D_EXIT,0,   0,      "&Ok",NULL },
   { d_butgfx_agui_proc, 175,210,126,    18,   0,   7,   'c',    D_EXIT,0,   0,      "&Cancel",NULL },
   /* Text captions */
   { d_ctext_proc,  160,   16,  128,     32,   0,  -1,   0,      0,     0,   0,      "Display Options",NULL },
   { d_text_proc,    56,   36,  128,     32,   0,  -1,   0,      0,     0,   0,      "Enable gouraud shading",NULL },
   { d_text_proc,    56,   99,  128,     32,   0,  -1,   0,      0,     0,   0,      "Run in windowed mode",NULL },
   { d_ctext_proc,  160,  116,  128,     32,   0,  -1,   0,      0,     0,   0,      "Resolution and colour depth",NULL },
   { d_ctext_proc,   64,  160,  64,      16,   0,  -1,   0,      0,     0,   0,      "640x480",NULL },
   { d_ctext_proc,  134,  160,  64,      16,   0,  -1,   0,      0,     0,   0,      "800x600",NULL },
   { d_ctext_proc,  204,  160,  64,      16,   0,  -1,   0,      0,     0,   0,      "1024x768",NULL },
   { d_ctext_proc,   64,  192,  64,      16,   0,  -1,   0,      0,     0,   0,      "8bpp",NULL },
   { d_ctext_proc,  134,  192,  64,      16,   0,  -1,   0,      0,     0,   0,      "15/16bpp",NULL },
   { d_ctext_proc,  204,  192,  64,      16,   0,  -1,   0,      0,     0,   0,      "24bpp",NULL },
   { d_ctext_proc,  274,  192,  64,      16,   0,  -1,   0,      0,     0,   0,      "32bpp",NULL },
   /* Checkbox: gouraud shading (14) */
   { d_gfxcheck_proc,30,   34,  15,    15,   0,    0,    0,    0,     0,   0,    NULL  },
   /* Checkbox: windowed mode shading (15) */
   { d_gfxcheck_proc,30,   97,  15,    15,   0,    0,    0,    0,     0,   0,    NULL  },
   /* Option buttons: Resolution (16-18) */
   { d_gfxradio_proc,58,  142,  15,    15,   0,    0,    0,    0,     0,   0,    NULL  },
   { d_gfxradio_proc,128, 142,  15,    15,   0,    0,    0,    0,     0,   0,    NULL  },
   { d_gfxradio_proc,198, 142,  15,    15,   0,    0,    0,    0,     0,   0,    NULL  },
   /* Option buttons: colour depth (19-22) */
   { d_gfxradio_proc,58,  174,  15,    15,   0,    0,    0,    0,     1,   0,    NULL  },
   { d_gfxradio_proc,128, 174,  15,    15,   0,    0,    0,    0,     1,   0,    NULL  },
   { d_gfxradio_proc,198, 174,  15,    15,   0,    0,    0,    0,     1,   0,    NULL  },
   { d_gfxradio_proc,268, 174,  15,    15,   0,    0,    0,    0,     1,   0,    NULL  },
   /* Fog-of-war toggle switches (23, 24) */
   { d_gfxcheck_proc,30,   55,  15,    15,   0,    0,    0,    0,     0,   0,    NULL  },
   { d_gfxcheck_proc,30,   76,  15,    15,   0,    0,    0,    0,     0,   0,    NULL  },
   /* Fog-of-war toggle switches description (25, 26) */
   { d_text_proc,    56,   57,  128,   32,   0,     -1,      0,      0,     0,   0,      "Enable fog-of-war",NULL },
   { d_text_proc,    56,   78,  128,   32,   0,     -1,      0,      0,     0,   0,      "Use bitmaps for fog-of-war",NULL },

   { d_keyboard_proc,0,    0,     0,    0,   0,    0,    0,    0,     0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

/* Sound options dialog */
static DIALOG game_sound_options_dialog[] = {
   /* (dialog proc) (x)   (y)    (w)    (h)   (fg) (bg) (key)  (flags) (d1) (d2)  (dp) */
   { d_mbitmap_proc,  0,   0,    320,   240,   0,    0,   0,    0,     0,   0,   NULL },
   { d_butgfx_agui_proc, 19,210, 126,    18,   0,    7,   'o',  D_EXIT,0,   0,   "&Ok",NULL },
   { d_butgfx_agui_proc, 175,210,126,    18,   0,    7,   'c',  D_EXIT,0,   0,   "&Cancel",NULL },
   /* Text captions */
   { d_ctext_proc,  160,   16,   128,    32,   0,   -1,   0,    0,     0,   0,   "Sound Options",NULL },
   { d_text_proc,    32,   50,   128,    32,   0,   -1,   0,    0,     0,   0,   "Digital volume",NULL },
   { d_text_proc,    32,   82,   128,    32,   0,   -1,   0,    0,     0,   0,   "Music volume",NULL },
   { d_text_proc,    56,  130,   128,    32,   0,   -1,   0,    0,     0,   0,   "Use Digital MIDI",NULL },

   /* Slider bars (7, 8) */
   { d_slider_proc,  32,  64,    256,    16,   0,    0,   0,    0,     31,  0,   ""},
   { d_slider_proc,  32,  96,    256,    16,   0,    0,   0,    0,     31,  0,   ""},

   /* Checkbox (9) */
   { d_gfxcheck_proc,36, 128,    256,    16,   0,    0,   0,    0,     31,  0,   NULL},
   { d_keyboard_proc, 0,   0,      0,     0,   0,    0,   0,    0,     0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

/* Game tips */
static DIALOG game_tips_dialog[] = {
   /* (dialog proc) (x)   (y)  (w)  (h)   (fg) (bg) (key) (flags) (d1)  (d2)  (dp) */
   { d_mbitmap_proc,-96,  -48, 192, 136,   0,   0,    0,     0,      0,   0,   NULL },
   { d_ctext_proc,    0,  -40, 128,  32,   0,  -1,    0,     0,      0,   0,   "Rise of the Tribes tips", NULL },
   { d_textbox_proc,-86,  -24, 172,  80,   0,   7,    0,     0,      0,   0,   NULL },
   { d_butgfx_agui_proc,-63,60,126,  18,   0,   7,    'o',   D_EXIT, 0,   0,   "&Ok",NULL },
   { d_keyboard_proc, 0,    0,   0,   0,   0,   0,    0,     0,      0,   KEY_PRTSCR, d_scrnshot_proc},
   { d_gamemusic_proc },
   { d_yield_proc },
   { NULL }
};

/* Partial dialog objects */
DIALOG game_butt[] = {
   /* (dialog proc) (x)  (y)  (w)  (h) (fg) (bg) (key) (flags) (d1)  (d2)  (dp) */
   {d_butgfx_proc, -280, -108, 126, 18, 0, 7, 0, 0, 0, 0, "Menu", NULL},
   {NULL}
};

DIALOG cancel_butt[] = {
   /* (dialog proc) (x)  (y)  (w)  (h) (fg) (bg) (key) (flags) (d1)  (d2)  (dp) */
   {d_butgfx_proc, 0,0, 32, 32, 0, 7, 0, 0, 0, 0, "", NULL},
   {NULL}
};
/* *INDENT-ON* */

/* Play button clicked sound */
static int play_button_sound(int msg, DIALOG *d, int c)
{
   if (msg==MSG_CLICK || msg==MSG_KEY) {
      play_sample (get_button_sample(), get_sfx_volume(), 127, 1000, FALSE);
   }

   return D_O_K;
}

/* Set the digital volume */
static int set_digivol_callback(void *dp3, int d2)
{
   set_sfx_volume((d2 > 31) ? 255 : (d2 * 8));
   play_button_sound(MSG_CLICK, NULL, 0);
   return D_O_K;
}

/* Set the music volume */
static int set_musicvol_callback(void *dp3, int d2)
{
   set_music_volume((d2 > 31) ? 255 : (d2 * 8));
   play_button_sound(MSG_CLICK, NULL, 0);
   return D_O_K;
}

/* Initializes all dialog objects and prepares them for use in the current */
/*  screen mode */
void dialog_init(void)
{
   int c;

   for (c = 0; game_quit_dialog[c].proc; c++) {
      game_quit_dialog[c].x += SCREEN_W / 2;
      game_quit_dialog[c].y += SCREEN_H / 2;
      if (game_quit_dialog[c].proc == d_butgfx_agui_proc) {
         game_quit_dialog[c].dp2 = get_button_bitmap(2);
         game_quit_dialog[c].dp3 = play_button_sound;
         game_quit_dialog[c].fg = white;
         game_quit_dialog[c].bg = yellow;
      }
   }
   game_quit_dialog[1].dp2 = (FONT *)get_royal_font();
   game_quit_dialog[1].fg = black;
   game_quit_dialog[1].bg = -1;
   game_quit_dialog[0].dp = get_dframe_bitmap();
   game_quit_dialog[0].fg = black;
   game_quit_dialog[0].bg = -1;

   for (c = 0; main_menu_dialog[c].proc; c++) {
      main_menu_dialog[c].x += SCREEN_W / 2;
      main_menu_dialog[c].y += SCREEN_H / 2;
      if (main_menu_dialog[c].proc == d_butgfx_agui_proc) {
         main_menu_dialog[c].dp2 = get_button_bitmap(1);
         main_menu_dialog[c].dp3 = play_button_sound;
         main_menu_dialog[c].fg = white;
         main_menu_dialog[c].bg = yellow;
      }
   }

   for (c = 0; camp_menu_dialog[c].proc; c++) {
      camp_menu_dialog[c].x += SCREEN_W / 2;
      camp_menu_dialog[c].y += SCREEN_H / 2;
      if (camp_menu_dialog[c].proc == d_butgfx_agui_proc) {
         camp_menu_dialog[c].dp2 = get_button_bitmap(1);
         camp_menu_dialog[c].dp3 = play_button_sound;
         camp_menu_dialog[c].fg = white;
         camp_menu_dialog[c].bg = yellow;
      }
   }

   for (c = 0; game_msg_dialog[c].proc; c++) {
      game_msg_dialog[c].x += SCREEN_W / 2;
      game_msg_dialog[c].y += SCREEN_H / 2;
      if (game_msg_dialog[c].proc == d_butgfx_agui_proc) {
         game_msg_dialog[c].dp2 = get_button_bitmap(0);
         game_msg_dialog[c].dp3 = play_button_sound;
         game_msg_dialog[c].fg = white;
         game_msg_dialog[c].bg = yellow;
      }
   }
   game_msg_dialog[0].dp = get_dframe_bitmap();
   game_msg_dialog[0].fg = black;
   game_msg_dialog[0].bg = grey;
   game_msg_dialog[1].fg = game_msg_dialog[2].fg = game_msg_dialog[3].fg =
      black;
   game_msg_dialog[1].bg = game_msg_dialog[2].bg = game_msg_dialog[3].bg = -1;

   for (c = 0; game_victory_dialog[c].proc; c++) {
      game_victory_dialog[c].x += SCREEN_W / 2;
      game_victory_dialog[c].y += SCREEN_H / 2;
      if (game_victory_dialog[c].proc == d_butgfx_agui_proc) {
         game_victory_dialog[c].dp2 = get_button_bitmap(1);
         game_victory_dialog[c].dp3 = play_button_sound;
         game_victory_dialog[c].fg = white;
         game_victory_dialog[c].bg = yellow;
      }
   }
   game_victory_dialog[1].dp2 = (FONT *)get_menu_bold_font();
   game_victory_dialog[2].dp2 = (FONT *)get_menu_font();
   game_victory_dialog[3].dp2 = (FONT *)get_menu_font();
   
   game_victory_dialog[0].dp = get_dframe_bitmap();
   game_victory_dialog[0].fg = black;
   game_victory_dialog[0].bg = grey;
   game_victory_dialog[1].fg = game_victory_dialog[2].fg = 
      game_victory_dialog[3].fg = black;
   game_victory_dialog[1].bg = game_victory_dialog[2].bg = 
      game_victory_dialog[3].bg = -1;

   /* game-menu dialog box */
   for (c = 0; game_menu_dialog[c].proc; c++) {
      game_menu_dialog[c].x += SCREEN_W / 2;
      game_menu_dialog[c].y += SCREEN_H / 2;
      if (game_menu_dialog[c].proc == d_butgfx_agui_proc) {
         game_menu_dialog[c].dp2 = get_button_bitmap(1);
         game_menu_dialog[c].dp3 = play_button_sound;
         game_menu_dialog[c].fg = white;
         game_menu_dialog[c].bg = yellow;
      }
   }
   game_menu_dialog[0].dp = get_alt_dframe_bitmap();
   game_menu_dialog[0].fg = black;
   game_menu_dialog[0].bg = grey;

   /* game option-menu dialog box */
   for (c = 0; game_options_menu_dialog[c].proc; c++) {
      game_options_menu_dialog[c].x += SCREEN_W / 2;
      game_options_menu_dialog[c].y += SCREEN_H / 2;
      if (game_options_menu_dialog[c].proc == d_butgfx_agui_proc) {
         game_options_menu_dialog[c].dp2 = get_button_bitmap(1);
         //game_options_menu_dialog[c].dp3 = get_button_bitmap(0);
         game_options_menu_dialog[c].dp3 = play_button_sound;
         game_options_menu_dialog[c].fg = white;
         game_options_menu_dialog[c].bg = yellow;
      }
   }
   game_options_menu_dialog[0].dp = get_alt_dframe_bitmap();
   game_options_menu_dialog[0].fg = black;
   game_options_menu_dialog[0].bg = grey;

   /* Prepare game video-options dialog box */
   for (c = 0; game_video_options_dialog[c].proc; c++) {
      game_video_options_dialog[c].x += (SCREEN_W - 320) / 2;
      game_video_options_dialog[c].y += (SCREEN_H - 240) / 2;
      game_video_options_dialog[c].fg = white;
      game_video_options_dialog[c].bg = -1;
      if ((game_video_options_dialog[c].proc == d_ctext_proc) ||
          (game_video_options_dialog[c].proc == d_text_proc)) {
         game_video_options_dialog[c].dp2 = (FONT *)get_menu_font();
      } else if (game_video_options_dialog[c].proc == d_gfxcheck_proc) {
         game_video_options_dialog[c].dp2 = get_cboxnch_bitmap();
         game_video_options_dialog[c].dp3 = get_cboxch_bitmap();
      } else if (game_video_options_dialog[c].proc == d_gfxradio_proc) {
         game_video_options_dialog[c].dp2 = get_obutnch_bitmap();
         game_video_options_dialog[c].dp3 = get_obutch_bitmap();
      }
   }
   game_video_options_dialog[0].dp = get_opt_frame_bitmap();
   game_video_options_dialog[1].dp2 = get_button_bitmap(2);
   game_video_options_dialog[2].dp2 = get_button_bitmap(2);
   game_video_options_dialog[1].dp3 = play_button_sound;
   game_video_options_dialog[2].dp3 = play_button_sound;
   game_video_options_dialog[1].fg = game_video_options_dialog[2].fg = white;
   game_video_options_dialog[1].bg = game_video_options_dialog[2].bg = yellow;
   game_video_options_dialog[3].dp2 =
      game_video_options_dialog[6].dp2 = (FONT *)get_normal_font();

   /* Prepare game sound-options dialog box */
   for (c = 0; game_sound_options_dialog[c].proc; c++) {
      game_sound_options_dialog[c].x += (SCREEN_W - 320) / 2;
      game_sound_options_dialog[c].y += (SCREEN_H - 240) / 2;
      game_sound_options_dialog[c].fg = white;
      game_sound_options_dialog[c].bg = -1;
      if ((game_sound_options_dialog[c].proc == d_ctext_proc) ||
          (game_sound_options_dialog[c].proc == d_text_proc)) {
         game_sound_options_dialog[c].dp2 = (FONT *)get_menu_font();
      } else if (game_sound_options_dialog[c].proc == d_gfxcheck_proc) {
         game_sound_options_dialog[c].dp2 = get_cboxnch_bitmap();
         game_sound_options_dialog[c].dp3 = get_cboxch_bitmap();
      } else if (game_sound_options_dialog[c].proc == d_gfxradio_proc) {
         game_sound_options_dialog[c].dp2 = get_obutnch_bitmap();
         game_sound_options_dialog[c].dp3 = get_obutch_bitmap();
      } else if (game_sound_options_dialog[c].proc == d_slider_proc) {
         game_sound_options_dialog[c].dp = get_obutch_bitmap();
         game_sound_options_dialog[c].bg = blue;
      }
   }
   game_sound_options_dialog[0].dp = get_opt_frame_bitmap();
   game_sound_options_dialog[1].dp2 = get_button_bitmap(2);
   game_sound_options_dialog[2].dp2 = get_button_bitmap(2);
   game_sound_options_dialog[1].dp3 = play_button_sound;
   game_sound_options_dialog[2].dp3 = play_button_sound;
   game_sound_options_dialog[1].fg = game_sound_options_dialog[2].fg = white;
   game_sound_options_dialog[1].bg = game_sound_options_dialog[2].bg = yellow;
   game_sound_options_dialog[4].dp2 =
      game_sound_options_dialog[5].dp2 = (FONT *)get_normal_font();
   game_sound_options_dialog[7].dp2 = set_digivol_callback;
   game_sound_options_dialog[8].dp2 = set_musicvol_callback;

   /* Tips dialog */
   for (c = 0; game_tips_dialog[c].proc; c++) {
      game_tips_dialog[c].x += SCREEN_W / 2;
      game_tips_dialog[c].y += SCREEN_H / 2;
      if (game_tips_dialog[c].proc == d_ctext_proc)
         game_tips_dialog[c].dp2 = (FONT *)get_menu_bold_font();
   }
   game_tips_dialog[0].dp = get_dframe_bitmap();
   game_tips_dialog[3].dp2 = get_button_bitmap(1);
   game_tips_dialog[3].dp3 = play_button_sound;
   game_tips_dialog[1].fg = black;
   game_tips_dialog[1].bg = -1;
   game_tips_dialog[2].fg = black;
   game_tips_dialog[2].bg = makecol(208, 204, 180);
   game_tips_dialog[3].fg = white;
   game_tips_dialog[3].bg = yellow;
   for (c = 0; tip_text[c]; c++);
   num_tips = c;


   /* Game menu button */
   game_butt->fg = white;
   game_butt->bg = yellow;
   game_butt->dp2 = get_button_bitmap(2);
   game_butt->dp3 = play_button_sound;
   game_butt->x += SCREEN_W;
   game_butt->y += SCREEN_H;

   cancel_butt->fg = white;
   cancel_butt->bg = yellow;
   cancel_butt->dp2 = get_button_bitmap(2);
   cancel_butt->dp3 = play_button_sound;
   cancel_butt->x += SCREEN_W;
   cancel_butt->y += SCREEN_H;
}

/* Custom dialog routines */

/* Similar to d_text_proc, but draws the image in dp3 first */
int d_gfxtext_proc(int msg, DIALOG *d, int k)
{
   if ((msg == MSG_DRAW) && (d->dp3)) {
      BITMAP *bmp = d->dp3;

      blit(bmp, get_monitor_bmp(), 0, 0, d->x, d->y, bmp->w, bmp->h);
      //rect (get_monitor_bmp(), d->x, d->y, d->x+bmp->w, d->y+bmp->h,makecol(255,255,255));
   }
   if (d->dp)
      return d_text_proc(msg, d, k);
   else
      return D_O_K;
}

/* d_mbitmap_proc: wrapper for the allegro d_bitmap_proc function; fixes
   some compatibility issues. */
int d_mbitmap_proc(int msg, DIALOG *d, int c)
{
   BITMAP *b = (BITMAP *)d->dp;

   switch (msg) {
      case MSG_DRAW:
         if (b)
            blit(b, get_monitor_bmp(), 0, 0, d->x, d->y, d->w, d->h);
         return D_O_K;
      case MSG_WANTFOCUS:
         return D_O_K;
      default:
         return D_O_K;
   }
}

/* d_tbitmap_proc: transparent bitmap. */
int d_tbitmap_proc(int msg, DIALOG *d, int c)
{
   BITMAP *b = (BITMAP *)d->dp;

   switch (msg) {
      case MSG_DRAW:
         if (b)
            masked_blit(b, get_monitor_bmp(), 0, 0, d->x, d->y, d->w, d->h);
         return D_O_K;
      case MSG_WANTFOCUS:
         return D_O_K;
      default:
         return D_O_K;
   }

}

/* Checkbox; conterary to the standard Allegro checkboxes, this doesn't */
/*  display any text string; the dp2&dp3 fields hold the graphics for the */
/*  chheckbox in checked and unchecked state respectively. */
int d_gfxcheck_proc(int msg, DIALOG *d, int c)
{
   BITMAP *bmp;

   if (msg == MSG_DRAW) {
      if (d->flags & D_SELECTED) {
         bmp = d->dp3;
      } else {
         bmp = d->dp2;
      }

      if (bmp) {
         if (d->flags & D_DISABLED)
            draw_lit_sprite(get_monitor_bmp(), bmp, d->x, d->y, 128);
         else
            draw_sprite(get_monitor_bmp(), bmp, d->x, d->y);
      }
      return D_O_K;
   }
   return d_check_proc(msg, d, c);
}

/* Radiobutton; conterary to the standard Allegro radiobuttons, this doesn't */
/*  display any text string; the dp2&dp3 fields hold the graphics for the */
/*  chheckbox in checked and unchecked state respectively. */
int d_gfxradio_proc(int msg, DIALOG *d, int c)
{
   BITMAP *bmp;

   if (msg == MSG_DRAW) {
      if (d->flags & D_SELECTED) {
         bmp = d->dp3;
      } else {
         bmp = d->dp2;
      }
      if (bmp) {
         if (d->flags & D_DISABLED)
            draw_lit_sprite(get_monitor_bmp(), bmp, d->x, d->y, 128);
         else
            draw_sprite(get_monitor_bmp(), bmp, d->x, d->y);
      }
      return D_O_K;
   }
   return d_radio_proc(msg, d, c);
}

/* Graphical button */
/* The bitmap should be passed in the dp2 field. If it is NULL, a normal
    button will be drawn instead. */
/* An optional callback function can be placed in the dp3 field that will be
    called when the button is clicked */
/* Draws a solid border in b->bg if the button is selected */
/* The graphic is stretched to the proper dimensions */
int d_butgfx_agui_proc(int msg, DIALOG *d, int c)
{
   int fg;
   int state1, state2;
   int g;
   BITMAP *bmp = d->dp2;
   BUTTCALLBACK callback = d->dp3;

   if (d->flags & D_DISABLED)
      return D_O_K;

   /* Draw normal button if no image preented */
   if (bmp == NULL)
      return d_button_proc(msg, d, 0);

   //d->w=bmp->w;
   //d->h=bmp->h;

   if (msg == MSG_DRAW) {
      if (d->flags & D_SELECTED) {
         g = 1;
         state1 = d->bg;
         state2 = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;
      } else {
         g = 0;
         state1 = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;
         state2 = d->bg;
      }

      /* Display graphic */
      //blit (bmp, get_monitor_bmp(), 0,0,d->x,d->y, bmp->w, bmp->h);
      stretch_blit(bmp, get_monitor_bmp(), 0, 0, bmp->w, bmp->h, d->x, d->y,
                   d->w, d->h);
      fg = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;

      text_mode(-1);
      gui_textout(get_monitor_bmp(), d->dp, d->x + d->w / 2 + g,
                  d->y + d->h / 2 - (text_height(font) + 1) / 2 + g, state1,
                  TRUE);

      if ((d->flags & D_GOTFOCUS) &&
          (!(d->flags & D_SELECTED) || !(d->flags & D_EXIT)))
         rect(get_monitor_bmp(), d->x + 1 + g, d->y + 1 + g,
              d->x + d->w - 2 + g, d->y + d->h - 2 + g, state2);
      return D_O_K;
   } else {
   }

   if (callback) {
      callback(msg, d, c);
   }

   return d_button_proc(msg, d, 0);
}

/* Graphical button, incompatible with Allegro's GUI */
/* The bitmap should be passed in the dp2 field. If it is NULL, a normal
   button will be drawn instead. */
/* Draws a solid border in b->bg if the button is selected */
/* The graphic is stretched to the proper dimensions */
int d_butgfx_proc(int msg, DIALOG *d, int c)
{
   int fg;
   int state1, state2;
   int g;
   BITMAP *bmp = d->dp2;
   BUTTCALLBACK callback = d->dp3;

   if (d->flags & D_DISABLED)
      return D_O_K;

   /* Draw normal button if no image preented */
   if (bmp == NULL)
      return d_button_proc(msg, d, 0);

   //d->w=bmp->w;
   //d->h=bmp->h;

   if (msg == MSG_DRAW) {
      if (d->flags & D_SELECTED) {
         g = 1;
         state1 = d->bg;
         state2 = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;
      } else {
         g = 0;
         state1 = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;
         state2 = d->bg;
      }

      /* Display graphic */
      //blit (bmp, get_monitor_bmp(), 0,0,d->x,d->y, bmp->w, bmp->h);
      stretch_blit(bmp, get_screen_bmp(), 0, 0, bmp->w, bmp->h, d->x, d->y,
                   d->w, d->h);
      fg = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;

      text_mode(-1);
      gui_textout(get_screen_bmp(), d->dp, d->x + d->w / 2 + g,
                  d->y + d->h / 2 - (text_height(font) + 1) / 2 + g, state1,
                  TRUE);

      if ((d->flags & D_GOTFOCUS) && !(d->flags & D_SELECTED))
         rect(get_screen_bmp(), d->x + 1 + g, d->y + 1 + g,
              d->x + d->w - 2 + g, d->y + d->h - 2 + g, state2);
      return D_O_K;
   } else {
   }

   if (callback) {
      callback(msg, d, c);
   }

   return d_button_proc(msg, d, 0);
}


/* Transparent button compatible with the Allegro GUI */
/*  *dp3 should be the background of the previous blit or NULL  */
/*  If it is the previous background, it will be blit at the MSG_DRAW, */
/*   and destroyed; oherwise it will be ignored */
/* This will outline the bitmap when the box is selected (normal routine */
/*  simply draws a box; this is more tricky) */
int d_tbutgfx_agui_proc(int msg, DIALOG *d, int c)
{
   int fg;
   int state1, state2;
   int g;
   BITMAP *bmp = d->dp2;
   BITMAP *bgbmp = d->dp3;

   if (d->flags & D_DISABLED)
      return D_O_K;

   /* Draw normal button if no image preented */
   if (bmp == NULL)
      return d_button_proc(msg, d, 0);

   d->w = bmp->w;
   d->h = bmp->h;

   if (msg == MSG_DRAW) {
      /* Restore background */
      if (bgbmp) {
         blit(bgbmp, get_monitor_bmp(), 0, 0, d->x, d->y, bgbmp->w, bgbmp->h);
         destroy_bitmap(bgbmp);
         bgbmp = d->dp3 = NULL;
      }
      fg = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;
      if ((d->flags & D_GOTFOCUS) &&
          (!(d->flags & D_SELECTED) || !(d->flags & D_EXIT))) {
         /* Outline the bitmap */
         bmp = outline_bitmap(bmp, d->bg);
         /* Store background */
         d->dp3 = bgbmp =
            create_bitmap_ex(bitmap_color_depth(get_monitor_bmp()), bmp->w,
                             bmp->h);
         blit(get_monitor_bmp(), bgbmp, d->x, d->y, 0, 0, bgbmp->w, bgbmp->h);
      }
      if (d->flags & D_SELECTED) {
         g = 1;
         state1 = d->bg;
         state2 = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;
      } else {
         g = 0;
         state1 = (d->flags & D_DISABLED) ? gui_mg_color : d->fg;
         state2 = d->bg;
      }

      /* Display graphic */
      masked_blit(bmp, get_monitor_bmp(), 0, 0, d->x, d->y, bmp->w, bmp->h);

      text_mode(-1);
      gui_textout(get_monitor_bmp(), d->dp, d->x + d->w / 2 + g,
                  d->y + d->h / 2 - text_height(font) / 2 + g, state1, TRUE);

      /* Destroy bitmap if needed */
      if (bmp != d->dp2)
         destroy_bitmap(bmp);
      return D_O_K;
   } else if (msg == MSG_END) {
      /* Free background memory if needed */
      if (bgbmp) {
         destroy_bitmap(bgbmp);
         bgbmp = d->dp3 = NULL;
      }
   }

   return d_button_proc(msg, d, 0);
}

int d_gamemusic_proc(int msg, DIALOG *d, int c)
{
   if (msg == MSG_IDLE || msg == MSG_START) {
      cycle_game_music();
   }
   return D_O_K;
}

/* Screenshot capture rourine */
int d_scrnshot_proc(void)
{
   screenshot();
   return D_O_K;
}

/* Small popup dialog box with a one-line message; layout appropriate for */
/*  the game */
void game_message(char *msg, ...)
{
   FONT *f = font;
   char *s = malloc(4096);
   char *l1 = NULL;
   char *l2 = NULL;
   char *l3 = NULL;
   int c;

   va_list ap;

   va_start(ap, msg);
   uvsprintf(s, msg, ap);
   va_end(ap);

   l1 = s;
   l2 = strstr(l1, "\n");
   if (l2) {
      l2[0] = '\0';
      l2++;

      l3 = strstr(l2, "\n");
      if (l3) {
         l3[0] = '\0';
         l3++;
      }
   }
   if (l1)
      game_msg_dialog[1].dp = l1;
   else
      game_msg_dialog[1].dp = "";
   if (l2)
      game_msg_dialog[2].dp = l2;
   else
      game_msg_dialog[2].dp = "";
   if (l3)
      game_msg_dialog[3].dp = l3;
   else
      game_msg_dialog[3].dp = "";

   for (c = 1; c < 4; c++) {
      game_msg_dialog[c].dp2 = (FONT *)get_menu_bold_font();
   }

   font = (FONT *)get_menu_font();
   popup_dialog(game_msg_dialog, -1);
   font = f;

   free(s);
   synchronize();
}

/* Basically, this is a wrapper for the Allegro Alert() dialog box */
void popup_message(char *msg, ...)
{
   char *s = malloc(4096);
   char *l1 = NULL;
   char *l2 = NULL;
   char *l3 = NULL;
   int old_fg;
   int old_bg;
   PALETTE p;

   va_list ap;

   va_start(ap, msg);
   uvsprintf(s, msg, ap);
   va_end(ap);

   l1 = s;
   l2 = strstr(l1, "\n");
   if (l2) {
      l2[0] = '\0';
      l2++;

      l3 = strstr(l2, "\n");
      if (l3) {
         l3[0] = '\0';
         l3++;
      }
   }
   old_fg = gui_fg_color;
   old_bg = gui_bg_color;
   if (bitmap_color_depth(screen) == 8) {
      get_palette(p);
      if ((p[gui_fg_color].r == p[gui_bg_color].r)
          && (p[gui_fg_color].g == p[gui_bg_color].g)
          && (p[gui_fg_color].b == p[gui_bg_color].b))
         set_palette(default_palette);
   } else {
      gui_fg_color = makecol_depth(bitmap_color_depth(screen), 0, 0, 0);
      gui_bg_color = makecol_depth(bitmap_color_depth(screen), 192, 192, 192);
   }
   alert(l1, l2, l3, "Ok", NULL, 0, 0);
   if (bitmap_color_depth(screen) == 8)
      set_palette(p);
   gui_fg_color = old_fg;
   gui_bg_color = old_bg;
   free(s);
}

/* Disable the ability to toggle the fog-of-war on and off */
void disable_fog_of_war_toggle(void)
{
   game_video_options_dialog[23].flags |= D_DISABLED;
}

/* Enable the ability to toggle the fog-of-war on and off */
void enable_fog_of_war_toggle(void)
{
   game_video_options_dialog[23].flags &= ~D_DISABLED;
}

/* Handle the game-options */
static void popup_video_options(void)
{
   int need_restart = FALSE;
   int need_repaint = FALSE;
   int w = get_config_int("video", "width", SCREEN_W);
   int h = get_config_int("video", "height", SCREEN_H);
   int cd = get_config_int("video", "depth", bitmap_color_depth(screen));
   int shade = (settings.flags & (LIT_PLAIN + LIT_GOURAUD)) == LIT_GOURAUD;
   int win = settings.flags & WINDOWED_MODE;
   int fog = settings.flags & (FOG_OF_WAR_ON + FOG_OF_WAR_BITMAP);
   int c;

   shade = get_config_int("video", "gouraud_shading", shade);
   win = get_config_int("video", "windowed", win);

   /* Disable all checkboxes and radio buttons */
   for (c = 0; game_video_options_dialog[c].proc; c++) {
      if ((game_video_options_dialog[c].proc == d_gfxradio_proc) ||
          (game_video_options_dialog[c].proc == d_gfxcheck_proc))
         game_video_options_dialog[c].flags &= ~D_SELECTED;
   }

   /* Set checkboxes as needed */
   if (shade)
      game_video_options_dialog[14].flags |= D_SELECTED;

#ifdef ALLEGRO_DOS
   /* Under DOS, the `run in windowed-mode' should NEVER be enabled: the */
   /*  game will be unable to load because it can't find a windowed driver */
   game_video_options_dialog[15].flags |= D_DISABLED;
#else
   if (win)
      game_video_options_dialog[15].flags |= D_SELECTED;
#endif

   if (fog & FOG_OF_WAR_ON)
      game_video_options_dialog[23].flags |= D_SELECTED;

   if (fog & FOG_OF_WAR_BITMAP)
      game_video_options_dialog[24].flags |= D_SELECTED;

   switch (w) {
      case 800:
         if (h == 600) {
            game_video_options_dialog[17].flags |= D_SELECTED;
            break;
         }
      case 1024:
         if (h == 768) {
            game_video_options_dialog[18].flags |= D_SELECTED;
            break;
         }
      default:
         game_video_options_dialog[16].flags |= D_SELECTED;
   }

   switch (cd) {
      case 8:
         game_video_options_dialog[19].flags |= D_SELECTED;
         break;
      case 15:
      case 16:
         game_video_options_dialog[20].flags |= D_SELECTED;
         break;
      case 24:
         game_video_options_dialog[21].flags |= D_SELECTED;
         break;
      default:
         game_video_options_dialog[22].flags |= D_SELECTED;
         break;
   }

   /* Get the new results if dialog is ok'ed */
   if (popup_dialog(game_video_options_dialog, -1) == 1) {
      c = (game_video_options_dialog[15].flags & D_SELECTED) != 0;
      if (win != c) {
         win = c;
         need_restart = TRUE;
      }

      c = (game_video_options_dialog[14].flags & D_SELECTED) != 0;
      if (shade != c) {
         shade = c;
         need_repaint = TRUE;
      }

      c = ((game_video_options_dialog[23].flags & D_SELECTED) !=
           0) * FOG_OF_WAR_ON +
         ((game_video_options_dialog[24].flags & D_SELECTED) !=
          0) * FOG_OF_WAR_BITMAP;
      
      if (fog != c) {
         fog = c;
         need_repaint = TRUE;
      }

      if (game_video_options_dialog[16].flags & D_SELECTED) {
         if (w != 640)
            need_restart = TRUE;
         w = 640;
         h = 480;
      } else if (game_video_options_dialog[17].flags & D_SELECTED) {
         if (w != 800)
            need_restart = TRUE;
         w = 800;
         h = 600;
      } else if (game_video_options_dialog[18].flags & D_SELECTED) {
         if (w != 1024)
            need_restart = TRUE;
         w = 1024;
         h = 768;
      }
      if (game_video_options_dialog[19].flags & D_SELECTED) {
         if (cd != 8)
            need_restart = TRUE;
         cd = 8;
      } else if (game_video_options_dialog[20].flags & D_SELECTED) {
         if (cd != 16)
            need_restart = TRUE;
         cd = 16;
      } else if (game_video_options_dialog[21].flags & D_SELECTED) {
         if (cd != 24)
            need_restart = TRUE;
         cd = 24;
      } else if (game_video_options_dialog[22].flags & D_SELECTED) {
         if (cd != 32)
            need_restart = TRUE;
         cd = 32;
      }

      set_config_int("video", "width", w);
      set_config_int("video", "height", h);
      set_config_int("video", "depth", cd);
      set_config_int("video", "gouraud_shading", shade);
      set_config_int("video", "windowed", win);
      set_config_int("game", "fog_of_war", (fog & FOG_OF_WAR_ON) != 0);
      set_config_int("game", "fog_of_war_bitmap",
                     (fog & FOG_OF_WAR_BITMAP) != 0);

      settings.flags &= ~(FOG_OF_WAR_ON + FOG_OF_WAR_BITMAP);
      settings.flags |= fog;

      if (shade) {
         settings.flags &= ~(LIT_PLAIN + LIT_GOURAUD);
         settings.flags |= LIT_GOURAUD;
      } else {
         settings.flags &= ~(LIT_PLAIN + LIT_GOURAUD);
         settings.flags |= LIT_PLAIN;
      }

      if (need_restart) {
         game_message("Screen options will not take\n"
                      "effect until the next time\n" "you start the game.");
         /*
         settings.width = get_config_int("video", "width", settings.width);
         settings.height = get_config_int("video", "height", settings.height);
         settings.colour_depth = get_config_int("video", "depth", settings.colour_depth);
         if (get_config_int("video", "windowed", win)) {
            settings.flags |= WINDOWED_MODE;
         } else {
            settings.flags &= ~WINDOWED_MODE;
         }
         
         set_graphics();
         prepare_screen();
         mark_viewport();
         */
      }

      if (need_repaint) {
         map_draw_initialize();
         mark_viewport();
      }
   }
}

static void popup_sound_options(void)
{
   int digivol = get_sfx_volume();
   int musicvol = get_music_volume();
   char *digmidfile = malloc(1024);
   char *gamedir = malloc(1024);

   get_current_dir(gamedir, 1024);
   fix_filename_case(gamedir);
   fix_filename_slashes(gamedir);
   put_backslash(gamedir);

   uszprintf (digmidfile, 1024, "%s%s", gamedir, "digmid.dat");

   //file_select_ex("Specify patch set", digmidfile, "dat", 1024, 0, 0);

   game_sound_options_dialog[7].d2 =
      digivol * game_sound_options_dialog[7].d1 / 255;
   game_sound_options_dialog[8].d2 =
      musicvol * game_sound_options_dialog[8].d1 / 255;

   if (get_config_id("sound", "midi_card", -1) == MIDI_DIGMID) {
      game_sound_options_dialog[9].flags |= D_SELECTED;
   } else {
      game_sound_options_dialog[9].flags &= ~D_SELECTED;
   }

   if (!exists(digmidfile)) {
      game_sound_options_dialog[9].flags |= D_DISABLED;
   } else {
      game_sound_options_dialog[9].flags &= ~D_DISABLED;
   }

   /* Disable for now - need to think about storing the path to the patches */
   //game_sound_options_dialog[9].flags |= D_DISABLED;

   if (popup_dialog(game_sound_options_dialog, -1) == 1) {
      digivol = get_digi_volume();
//         game_sound_options_dialog[7].d2 * 255 /
//         game_sound_options_dialog[7].d1;
      musicvol = get_music_volume();
//         game_sound_options_dialog[8].d2 * 255 /
//         game_sound_options_dialog[8].d1;

      set_config_int("sound", "digi_volume", digivol);
      set_config_int("sound", "midi_volume", musicvol);

      if (!(game_sound_options_dialog[9].flags & D_DISABLED)) {
         if (game_sound_options_dialog[9].flags & D_SELECTED) {
            if (get_config_id("sound", "midi_card", -1) != MIDI_DIGMID) {
               set_config_id("sound", "midi_card", MIDI_DIGMID);
               set_config_string("sound", "patches", digmidfile);
               pause_music();
               remove_sound();
               install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
               resume_music();
            }
         } else {
            if (get_config_id("sound", "midi_card", -1) == MIDI_DIGMID) {
               set_config_id("sound", "midi_card", MIDI_AUTODETECT);
               pause_music();
               remove_sound();
               install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, NULL);
               resume_music();
            }
         }
      }
   }

   set_sfx_volume(digivol);
   set_music_volume(musicvol);

   free (gamedir);
   free (digmidfile);
}

void popup_options(void)
{
   int (res);

   do {
      res = popup_dialog(game_options_menu_dialog, -1);
      switch (res) {
         case -1:
         case 5:
            return;
         case 1:
            popup_video_options();
            break;
         case 2:
            popup_sound_options();
            break;
         default:
            break;
      }
   } while (res != 5);
}

void popup_tip_dialog(void)
{

   tip_nr = get_config_int("game", "nexttip", 0);

   game_tips_dialog[2].dp = tip_text[tip_nr];
   popup_dialog(game_tips_dialog, 3);

   tip_nr++;
   tip_nr %= num_tips;

   set_config_int("game", "nexttip", tip_nr);
}

/* Popup the game quit dialog, and returns TRUE if the dialog is ok'ed */
int popup_game_quit_dialog(void)
{
   return popup_dialog(game_quit_dialog, 3) == 2;
}

/* Popup the game victory dialog */
void popup_game_victory_dialog(void)
{
   popup_dialog(game_victory_dialog, -1);
}

/* Popup the in-game menu and return the requested action */
int popup_ingame_menu(void)
{
   return popup_dialog(game_menu_dialog, -1);
}
