#ifndef UGFX_H
#define UGFX_H

typedef struct {
   int numgfx;		/* Number of graphics available for this unit */
   PALETTE *pal;  /* Palette for this sprite */
   BITMAP **gfx;	/* list of bitmaps defining the current unit */
   int *x_adjust;	/* x/y adjustments */
   int *y_adjust;
} UNIT_GFX;

extern void cgfx_init(void);
extern void cgfx_load(void);
extern BITMAP *get_char_gfx(int char_id, int frame);
extern BITMAP *get_icon_gfx(int icon_id);
extern PALETTE *get_char_palette(const int char_id, const int colour_sceme);
extern PALETTE *get_icon_palette(const int cs);
extern int get_gfx_dx(int char_id, int frame);
extern int get_gfx_dy(int char_id, int frame);
extern int find_cgfx_name(const char *s);
extern int find_icon_name(const char *s);
extern int get_num_gfx (const int utype);

extern int get_player_colour(const int player_id, const int intensity);

#endif