#ifndef PLAYGAME_H
#define PLAYGAME_H

extern void playgame_init(const int gamespeed);
extern void playgame(void);

/* Interface routines for notifying the game loop that the state has changed */
void inline set_game_done(void);
void inline set_screen_changed(void);
void inline synchronize(void);

/* These routines should be provided by the user */
extern void inline playgame_preamble(void);        // Called at start of playgame()
extern void inline playgame_closing(void);         // Called at end of playgame()
extern void inline game_gfx_update_preamble(void); // Called before gfx update
extern void inline game_gfx_update(void);          // Called to do gfx update
extern void inline game_state_update(void);        // Called to update game state
extern void inline game_input(void);               // Process user input

#endif