#ifndef GFX_H
#define GFX_H
/* Floating window flags */
#define FWIN_STICKMAP  1     /* When set, the (x,y) are taken to be map coordinates */
#define FWIN_FADETPDN  2     /* Fade from top to bottom (gouraud) */
#define FWIN_TRANS     4     /* Transparent floatwin */
#define FWIN_HIDDEN    8     /* Hidden floatwin, not drawn */
#define FWIN_DIRTY    16     /* Floatwin must be redrawn */
#define FWIN_CUSTOM0  32     /* Flag fields that are undefined and free to use */


/* (Dirty) rectangle data structure */
typedef struct DRECT {
	int x, y, w, h;
} DRECT;

/* Floating windows */
typedef struct FLOATWIN {
   int x, y;
   int w, h;
   int flags;
   int timeleft;
   BITMAP *bg;
   BITMAP *content;
} FLOATWIN;

/* Floating windows draw list */
typedef struct FLOATWIN_LIST {
   FLOATWIN *win;
   struct FLOATWIN_LIST *next;
   struct FLOATWIN_LIST *prev;
} FLOATWIN_LIST;

/* gfx global variables */
extern FLOATWIN_LIST *flwin;
extern int black;
extern int grey;
extern int white;
extern int red;
extern int yellow;
extern int blue;
extern int green;
extern int bright_red;
extern int bright_blue;
extern int darkgreen;

/* Function templates */
extern int (*makecolour)(int r, int g, int b);

/* Graphics functions */
extern BITMAP *get_commandmap_bmp(void);
extern BITMAP *get_interface_bmp(void);
extern void set_commandmap (const int x, const int y, const int w, const int h);
extern void set_interface (const int x, const int y, const int w, const int h);

extern void set_graphics(void);
extern BITMAP *create_optimized_mask_bitmap(const int w, const int h);
extern BITMAP *create_optimized_bitmap(const int w, const int h);
extern BITMAP *get_screen_bmp(void);
extern BITMAP *get_monitor_bmp(void);
extern BITMAP *outline_bitmap (BITMAP *bmp, const int colour);
inline extern int get_mcptr_hotx(void);
inline extern int get_mcptr_hoty(void);
inline extern int get_mcptr_w(void);
inline extern int get_mcptr_h(void);
inline extern int get_commandmap_width(void);
inline extern int get_commandmap_height(void);
inline extern int get_commandmap_x(void);
inline extern int get_commandmap_y(void);

extern void screenshot(void);

extern int get_fps(void);
extern void inc_frame_counter(void);
extern void install_fps_counter(void);
extern void uninstall_fps_counter(void);

extern void set_flwin_border (BITMAP **blst);
extern BITMAP *text_boxed (int maxw, int bgcolor, int textcolor, const FONT *textfont, int center, char *msg, ...);

extern void push_render_job (BITMAP *bmp, int x, int y, int w, int h, int c1,int c2,int c3,int c4);
extern void do_render_job (void);

extern void push_floatwin (FLOATWIN *flw);
extern void kill_floatwin(FLOATWIN *flw);
extern void destroy_floatwin (FLOATWIN *flw);
extern void destroy_all_floatwins (void);
extern FLOATWIN *make_floatwin (int x, int y, int w, int h, int flags, int lifetime, BITMAP *bg, BITMAP *content);
extern FLOATWIN *make_floatmsg (int bgcolor, int textcolor, const FONT *textfont, int center, int lifetime, char *msg,...);
extern FLOATWIN *make_floatmsg_fit (int bgcolor, int textcolor, const FONT *textfont, int center, int lifetime, char *msg,...);
extern FLOATWIN *make_floattext (int x, int y, int bgcolor, int fgcolor, int flags, int lifetime, const FONT *textfont, char *msg,...);
extern FLOATWIN *find_floatwin(int flag);
extern void set_lifetime(FLOATWIN *flw, int lifetime);

/* These functions must be provided by an external file */
extern void undraw_floatwin(FLOATWIN *flw);
extern void draw_floatwin(FLOATWIN *flw);
extern void draw_floatwins(void);

extern void prepare_screen(void);
extern void prepare_screen_update(void);
extern void screen_update_done(void);

extern void mark_rect(int x, int y, int w, int h);
extern void store_rect(int x, int y, int w, int h);
extern void mark_commandmap(void);
extern void mark_interface(void);

#endif