/*         ______   ___    ___ 
 *        /\  _  \ /\_ \  /\_ \ 
 *        \ \ \L\ \\//\ \ \//\ \      __     __   _ __   ___ 
 *         \ \  __ \ \ \ \  \ \ \   /'__`\ /'_ `\/\`'__\/ __`\
 *          \ \ \/\ \ \_\ \_ \_\ \_/\  __//\ \L\ \ \ \//\ \L\ \
 *           \ \_\ \_\/\____\/\____\ \____\ \____ \ \_\\ \____/
 *            \/_/\/_/\/____/\/____/\/____/\/___L\ \/_/ \/___/
 *                                           /\____/
 *                                           \_/__/
 *      By Shawn Hargreaves,
 *      1 Salisbury Road,
 *      Market Drayton,
 *      Shropshire,
 *      England, TF9 1AJ.
 *
 *      Main header file for the Allegro library.
 *      This should be included by everyone and everything.
 *
 *      See readme.txt for copyright information.
 */
//           ********            ********************
//          *************        *********************
//          ***************     ********************
//          ****************    *******************
//          *****************   *****************
//         *****************       ***********
//         *****************  ****  ********
//         ***************** ******  ****
//         ****************  ******  **
//         ****************  ******
//         ****************  *****
//         ***************     **  ***
//         **************         ******
//         *************          *******
//         ************        ************
//         **********         *************
//           ******           ***************
//                            ***************
//                            *****************
//                            ******************
//                            *****************
//                            *****************
//                            ****************
//                            ****************
//         **  * ** * **** **   *** **** ****
//         **  * ** * **** **   **  ** * ** *
//         *** * ** * **   **   *** ** * ** *
//         *** * ** * **   **   **  **** ****
//         ** ** **** **** **** *** ** * **  *
//         ** ** **** **** **** *** ** * **  *
//
//nuclear war version graphique souris ... 640*480 en 256 couleurs
//
   #define S "<br>"
   #define ECRANX     640
   #define ECRANY     480
   #define SMS        300       //la longueur des textos ...
   #define SMS_X      120        //les coords de la boite a textos
   #define SMS_Y      30
   #define SMS_DX     ECRANX-120
   #define SMS_DY     100
   #define N1 80 // rez du mode text (lignes)
   #define N2 80 // (colonnes)
   #define P2 6 // hauteur de la grille de caractres
   #define P1 8 // largeur
   #define APPARRITION 75 //pourcentage de chance q 1 carac n'apparaisse pas
   #define CHANCE      75 //pourcentage de chance des bruits electroniques
   //les valeurs pour l'affichage du globe
   // 
   #define  RAYON      320               // le rayon du cercle
   #define  CENTREX    ECRANX/2               // le centroid
   #define  CENTREY    ECRANY
   //la definition (pixels par cases) = rayon*2/cases
   //et doit etre entiere
   #define  CASES      80               // la definition du globe
   #define  MAILLES    (CASES+1)

   int coords[MAILLES][MAILLES][2];  // la trame du globe
   int map[CASES*2][CASES*2];        // la carte du globe
   
   #define NOMBRE 17  //nb de phrases dans le gnrique
   #define PROX 2    // distance min entre 2 villes
   #include <stdio.h>
   #include <allegro.h>
   #include <math.h>    // pour les calculs de du globe
   
   //le tableau des couleurs des joueurs
   int couleurs[8]={60,75,45,37,75,41,23,57};
   //le clignotement des couleurs
   int flashi = 0 ;
   
   char message[SMS];// des messages pour les joueurs
   
   struct CONFIG
      {
      int modjeu;       // 0 -> chacun pour soi  1 -> humains contre machines
      int popuville;
      int modauto;      // si 0 mode manuel il faut appuyer pour passer les ecrans
      int demo;         // 0-> les ecrans attendent >0 attends qq secondes et passe  la suite
      int son;          // 0->muet 1->du son
      }
      config;
   
   
   struct SOURIS
      {
      int lig;
      int col;
      int gauche;
      int droite;
      }
      souris ;

   PALLETE palette;
   BITMAP *console;   // l'affichage des sms
   BITMAP *buffer;    // memoire tampon pour le double buffer
   BITMAP *bombes[4];
   FILE *FP;          // debugage general : info sur les actions et les joueurs

   SAMPLE * debut;
   SAMPLE * clic;
   SAMPLE * construit;
   SAMPLE * m_sound[10];
   
   int encore_des_humains=1,encore_des_machines=1;  // tests pour la victoire par equipes
   int mondiale;
   int manche=1;
   int temps;
   
struct ACTIONS
   {
   const char *nom;//le nom de l'action
   int  (*choix)(int j);//le remplissage du tableau action pour joueur[j]
   int  (*test)(int j);//si l'actin est possible pour le joueur j
   void (*ecran)(int j);//l'affichage de l'action
   }
   actions[5];


   struct JOUEUR
      {
      int numero;             //identifiant code joueur
      BITMAP *bitmap;         //image du joueur
      char nom[20];           //le nom du joueur
      int  action[3];         //la prochaine action du joueur
      int  popu;              //la population totale
      int  ville[5];          //la population dans les villes
      int cville[5][2];       //la position des villes du pays sur le globe
      char nville[5][20];     //les noms des villes du joueur
      char nombmp[20];        //l adresse de l'image du joueur
      int  pasdetir;          //la bombe en cours de lancement
      int  humain;            //1 joueur humain 0 machine  
      int  stock[4];          //les differentes armes en stock
      int bombes;             //nombre de bombes lances
      int victimes;
      int morts;
      int immigrants;
      int emmigrants;
      }
      joueur[8];
      
   int nb_joueurs=8;
   int mega [4]={10,25,50,100}; // les formats des bombes

   //les positions des pays , coins hauts gauches
   int positions[8][2]={{1,1} ,{10,2} ,{20,3} ,{30,4} ,{1,10} ,{10,11} ,{20,12} ,{30,13}};

   char * noms_humains[8]={"Oussama","Karl","Georges","Jacques","Vladimir","Mao","Saddam","Gerhard"};
   char * noms_ordi [8]={"SKYNET","Big blue","HAL","ED-209","Cerveau central","THE MATRIX","Windows","Cpc 464"};
   char * noms [8]={"Oussama","Karl","Georges","Jacques","Vladimir","Mao","Saddam","Gerhard"};
   char * noms_bmp [8]={"images/oussama.bmp","images/karl.bmp","images/Georges.bmp","images/Jacques.bmp","images/Vladimir.bmp","images/Mao.bmp","images/Saddam.bmp","images/Gerhard.bmp"};
   char * noms_ordi_bmp [8]={"images/SKYNET.bmp","images/Big_blue.bmp","images/HAL.bmp","images/ED209.bmp","images/Cerveau.bmp","images/MATRIX.bmp","images/Windows.bmp","images/Cpc464.bmp"};
   char * noms_villes [8][5]={
    "Kabhul","Isalamabad","Kandavid","Kandara","Zagrehb",
    "Rome","Venise","Naples","Milan","Genes",
    "Whashington","New York","Detroit","Los Angeles","San Francisco",
    "Paris","Marseille","Bordeaux","Charleville","Lyon",
    "Moscou","Vladivostok","Volgograd","Leningrad","Stalingrad",
    "Pekin","Canton","Beyhjing","Hong-Kong","Shangai",
    "Bagdad","Mossouf","Kirkuk","Karbala","Bassora",
    "Berlin","Bohn","Munich","Sarrebruk","Wiesbaden"
    };
   char * noms_villes_ordi [8][5]={
    "Kabhul","Isalamabad","Kandavid","Kandara","Zagrehb",
    "Rome","Venise","Naples","Milan","Genes",
    "Whashington","New York","Detroit","Los Angeles","San Francisco",
    "Paris","Marseille","Bordeaux","Charleville","Lyon",
    "Moscou","Vladivostok","Volgograd","Leningrad","Stalingrad",
    "Pekin","Canton","Beyhjing","Hong-Kong","Shangai",
    "Bagdad","Mossouf","Kirkuk","Karbala","Bassora",
    "Berlin","Bohn","Munich","Sarrebruk","Wiesbaden"
    };
   
   
   char evenement[1024];


   //gestion du temps
   int compte=0;
   //attends qqtemps et passe les ecrans
int attends()
   {
   if(!config.demo)
      return 1 ;
   compte ++;
   if (compte>50)
      {
      compte=0;
      return 0;
      }
   return (1);
   }


void vide_evenement()
   {
   int i;
   for(i=0;i<1024;i++) evenement[i]=0;
   }


   //propagande
void quittent(int combien,char *qui,char *pourqui)
   {
   vide_evenement();
   switch(D(2))
      {
      case 1 : sprintf(evenement,"%d millions quittent %s pour %s",combien,qui,pourqui);break;
      case 2 : sprintf(evenement,"%d millions abandonnent lachement %s pour %s",combien,qui,pourqui);break;
      }
   }



   // fait quoi ?
int degats;
const char * faitquoi (char *qui)
   {
   vide_evenement();
   switch(D(4))
      {
      case 1 :
         degats=(D(10))-20;
         sprintf(evenement," %s organise un concert ",qui);
         break;
      case 2 :
         degats=(D(20))-10;
         sprintf(evenement," %s monte un festival ",qui);
         break;
      case 3 :
         degats=1;
         sprintf(evenement," %s prpare une teuf techno",qui);
         break;
      case 4 :
         degats=0-10-D(10);
         sprintf(evenement,"%s invite Celine Dion",qui);
         break;
         }
      }



   //et la ville est dtruite
const char *destruction()
   {
   switch(D(3))
      {
      case 1 :return(" et la ville est dtruite");break;
      case 2 :return(" , il ne reste que des cendres de cette ville");break;
      case 3 :return(" ,une ville raye de la carte ...");break;
      }
   }



   //prepare arme
void preparation(char *qui,int combien)
   {
   vide_evenement();
   sprintf(evenement,"%s prepare %d megatonnes",qui,combien);
   }



   //un joueur qui est mort
const char *souvenir()
   {
   switch(D(3))
      {
      case 1 :return("%s n'est qu'un mauvais souvenir");break;
      case 2 :return("%s est mort et personne ne le regrette ...");break;
      case 3 :return("%s est trop vieux ...");break;
      }
   }



   //la machine joue
   //const char *ordinateur={"%s est une machine"};
   //construstion


   //augmentation
const char *augmente()
   {
   switch (D(3))
      {
      case 1 :return("%s augmente son arsenal ...");break;
      case 2 :return("De petits jouets nuclaires pour %s ...");break;
      case 3 :return("%s se prpare  la guerre ...");break;
      }
   }



   //rien
const char *stagne()
   {
   switch (D(2))
      {
      case 1 :return("%s ne construit rien ...");break;
      case 2 :return("Nib , peau de balle , pas d'armes pour %s ...");break;}
      }


   //en cas de victoire par quipe
const char *victoire_equipe()
   {
   switch (D(2))
      {
      case 1 :return(S"La guerre est finie en %d jours , c'est les %s qui gagnent ...");break;
      case 2 :return(S"Aprs %d jours de batailles acharnes , les %s finissent par l'emporter ...");break;
      }
   }



   //en cas de victoire d'un joueur
const char *victoire_joueur()
   {
   switch (D(2))
      {
      case 1 :return(S"La guerre est finie en %d jours ,c'est %s le plus beau ,  le moins mort ...");break;
      case 2 :return(S"Au bout de %d jours de combats , %s terrassa ses adversaires qui taient trop vieux ...");break;
      }
   }



   //quitter
char *quitter()
   {
   switch (D(7))
      {
      case 1 :return("La tu quitte le jeu et c est dommage ...");break;
      case 2 :return("Tu as vraiment autre chose de si important  faire ?");break;
      case 3 :return("Retour  Windows ?");break;
      case 4 :return("Tu ne veux plus jouer au jeu qui peut changer ta vie ?");break;
      case 5 :return("Les jeux vidos ne sont qu'une perte de temps ...");break;
      case 6 :return("N'oublies pas que tu va mourrir ...");break;
      case 7 :return("Petit joueur ...");break;
      }
   }



   //pas quitter
char *pas_quitter()
   {
   switch (D(3))
      {
      case 1 :return("C'est une erreur , et il ne peut en rester qu un...");break;
      case 2 :return("Je ne suis pas trop vieux et je suis prt  me battre ...");break;
      case 3 :return("WOWWW !! Ce jeu est trop COOOOOL !!!");break;
      }
   }



   //Declaration de guerre
const char *declaration()
   {
   switch (D(3))
      {
      case 1 :return("Declaration de guerre");break;
      case 2 :return("Les voila les joyeux combattants :");break;
      case 3 :return("Et ils partirent  la guerre ...");break;
      }
   }



   //sur le pas de tir 
//const
char *sur_le_pas_de_tir()
   {
   switch (D(2))
      {
      case 1 :return("%d megatonnes sur le feu");break;
      case 2 :return("peut utiliser %d mgatonnes ...");break;
      }
   }



   //Que va faire %s ?
const char *que_faire()
   {
   switch (D(2))
      {
      case 1 :return("Que va faire %s ...");break;
      case 2 :return("%s se tate ...");break;
      }
   }



void charge_sons ()
   {
   debut=load_sample("sons/debut.wav");
   clic =load_sample("sons/clic.wav");
   construit =load_sample("sons/construit.wav");

   m_sound[0]=load_sample("sons/m0.wav");
   m_sound[1]=load_sample("sons/m1.wav");
   m_sound[2]=load_sample("sons/m2.wav");
   m_sound[3]=load_sample("sons/m3.wav");
   m_sound[4]=load_sample("sons/m4.wav");
   m_sound[5]=load_sample("sons/m5.wav");
   m_sound[6]=load_sample("sons/m6.wav");
   m_sound[7]=load_sample("sons/m7.wav");
   m_sound[8]=load_sample("sons/m8.wav");
   m_sound[9]=load_sample("sons/m9.wav");
   }



void joue_son(SAMPLE * son)
   {
   if(config.son)play_sample(son, 255, 128, 1000, 0);
   }


   // donne la position de la souris au programme
   // la premire fois que le boutton est cliqu on a 1
   // si le boutton est maintenu on a -1 
   // si le boutton est relach on a 0
void ou_est_la_souris ()
   {
   if (mouse_b & 1)
      if (souris.gauche==0)
         souris.gauche=1;
      else
         souris.gauche=-1;
   else
      souris.gauche=0;
   //souris.droite  = mouse_b & 2;
   souris.col     = mouse_pos>>16;
   souris.lig     = (mouse_pos<<16)>>16;
   }




   //un curseur souris qui vise ...
void affiche_souris(int x,int y,int dx,int dy)
   {
   vline(buffer,souris.col,0,y,50);
   vline(buffer,souris.col,dy,ECRANY,50);
   hline(buffer,0,souris.lig,x,50);
   hline(buffer,dx,souris.lig,ECRANX,50);
   rect(buffer,x,y,dx,dy,50);
   }



   // vrai si la souris clique dans le rectangle
   //et affiche le pointeur qui vise
   // si on passe sur une zone selectionnable
int teste_souris (int x,int y,int dx,int dy)
   {
   if (souris.col>=x&&souris.col<=dx&&souris.lig>=y&&souris.lig<=dy)
      {
      affiche_souris(x,y,dx,dy);
      if(souris.gauche==1)
         {
         joue_son(clic);
         return (1);
         }
      }
   return(0);
   }



   //les p'tites icones flashies en 64*64
   //les couleurs flashent si flashie=1

   //vahala prochaine page ...
void fleche_droite (int x,int y,int flashie)
   {
   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;
   rectfill(buffer,x+22,y+22,x+44,y+44,flashie);
   triangle(buffer,x+44,y+12,x+44,y+52,x+54,y+34,flashie);
   }



   //vahala  page d avant...
void fleche_gauche (int x,int y,int flashie)
   {
   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;

   rectfill(buffer,x+42,y+22,x+20,y+44,flashie);
   triangle(buffer,x+20,y+12,x+20,y+52,x+10,y+34,flashie);
   }



   //construire
void usine (int x,int y,int flashie)
   {
   int j;
   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;

   for(j=0;j<6;j++)
   triangle(buffer,8+j*8+x,32+y,16+j*8+x,32+y,16+j*8+x,24+y,flashie);
   rectfill(buffer,8+x,32+y,56+x,50+y,flashie);
   }



   //cibler
void cible (int x,int y,int flashie)
   {
   int j;
   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;

   circle(buffer,32+x,32+y,26,flashie);
   line(buffer,2 +x,32+y,10+x,32+y,flashie);
   line(buffer,54+x,32+y,62+x,32+y,flashie);
   line(buffer,32+x,2 +y,32+x,10+y,flashie);
   line(buffer,32+x,54+y,32+x,62+y,flashie);
   }



   //attaquer
void attaquage (int x,int y,int flashie)
   {
   int j;
   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;

   circlefill(buffer,32+x,32+y,12,flashie);
   circle    (buffer,32+x,32+y,15,flashie);
   }



   //propagande
void propaganda (int x,int y,int flashie)
   {
   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;
   textprintf(buffer,font,10+x,14+y,flashie,"Propa");
   textprintf(buffer,font,10+x,32+y,flashie,"ganda");
   }



   //prepare une arme
void preparme (int x,int y,int flashie)
   {
   int j;
   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;

   for(j=0;j<5;j++)
      {
      line(buffer,20+x,20+y+j*7,27+x,27+y+j*7,flashie);
      line(buffer,27+x,20+y+j*7,20+x,27+y+j*7,flashie);
      rect(buffer,20+x,20+y+j*7,27+x,27+y+j*7,flashie);
      }
   ellipsefill(buffer,37+x,35+y,8,16,flashie);
   }



   //pour se dfendre
void parabole (int x,int y,int flashie)
   {
   int j;

   if(flashie)
      flashie=50-flashi%10000;
   else
      flashie=50;
   
   circlefill(buffer,36+x,28+y,10,flashie);
   triangle  (buffer,x,y,64+x,44+y,64+x,0+y,0);//un masque...
   triangle(buffer,10+x,54+y,20+x,54+y,20+x,44+y,flashie);
   triangle(buffer,54+x,54+y,44+x,54+y,44+x,44+y,flashie);
   rectfill (buffer,20+x,53+y,44+x,44+y,flashie);
   }



   //affiche les bitmaps aux coins hauts de l ecran
void versus (BITMAP * a ,BITMAP * b)
   {
   if(a!=NULL)
      blit(a, buffer, 0, 0, 0, 0, a->w,a->w);
   if(b!=NULL)
      blit(b, buffer, 0, 0, ECRANX-50-(b->w)/2, 0, b->w,b->h);
   }



void voir_stock(int bomb[4])
   {
   int i,k,l=0; 
   for (i=0;i<4;i++) 
      for (k=0;k<bomb[i]>0;k++)
         masked_blit(bombes[i], buffer, 0,0, l+=5+bombes[i]->w ,100,bombes[i]->w,bombes[i]->h );
   }



void neige (int x,int y,int dx,int dy,int i)
   {
   while (i>0)
      {
      putpixel ( buffer, x +rand () % ( dx-x ) , y + rand () % ( dy-y ) , rand ( ) % 8 ) ;
      i--;
      }
   }



   // declenche l affichage du buffer BITMAP
   //et affiche le fps : nombre d images secondes ...
void affiche ()
   {
   static int frames=0,fps;
   frames++;
   flashi++;
   if(flashi>40000)
      flashi=0;

   if(time(0)>temps)
      {
      fps=frames;
      frames=0;
      temps++;
      }
   show_mouse(buffer);
   textprintf(buffer,font,ECRANX/2,0,50,"%d",fps);
   vsync();
   blit(buffer, screen, 0, 0, 0, 0,ECRANX, ECRANY);
   clear (buffer);
   show_mouse(NULL);
   }



void nuke (int j)
   {
   int centrex = ECRANX/2;
   int centrey = ECRANY/2;
   int grand = ECRANX/2;
   int petit = ECRANX/4;
   int rotation;
   double angle=0;
   double debut ;
   double xcos;
   double xsin;

   for (rotation=0;rotation<91;rotation+=5)
      {
      //conversion de rotation de degres en radians
      debut =((rotation%120)*PI)/180; 
      clear(buffer);
      for (angle=debut;angle<debut + PI/3;angle+=.01)
         {
         textprintf(buffer,font,ECRANX/2-50,ECRANY/2+60,50,"%s",joueur[j].nom);
         xcos=cos ( angle ) ;xsin =sin(angle);
         line (buffer , centrex + xcos  * grand , centrey + xsin * grand , centrex + xcos  * petit , centrey + xsin * petit ,50);

         xcos=cos ( angle +PI*2/3) ;xsin =sin(angle +PI*2/3);
         line (buffer , centrex + xcos  * grand , centrey + xsin * grand , centrex + xcos  * petit , centrey + xsin * petit ,50);

         xcos=cos ( angle -PI*2/3) ;xsin =sin(angle-PI*2/3);
         line (buffer , centrex + xcos  * grand , centrey + xsin * grand , centrex + xcos  * petit , centrey + xsin * petit ,50);
         }
      blit(joueur[j].bitmap,buffer,0,0,(ECRANX/2)-50,(ECRANY/2)-50,100,100);
      affiche();
      }
   }




   // envoie des info dans le fichier debug et efface le message
   // si on donne un Njoueur valide , il affiche sa photo et ses stats
void debug(int j)
   {
   int i=0;

   fprintf(FP,"<p><img src='%s' width='30' height='30'>%d - ",joueur[j].nombmp,j);


   for (i=0;i<4;i++)
      {
      if(joueur[j].stock[i]<0)
         fprintf(FP,"(<hr><font color=green>%d</font><h1>BUG</h1>)",joueur[j].stock[i]);
      if(joueur[j].stock[i]==0)
         fprintf(FP,"(<font color=blue>%d</font>)",joueur[j].stock[i]);
      if(joueur[j].stock[i]>0)
         fprintf(FP,"(%d)",joueur[j].stock[i]);
      }

   fprintf(FP,"%s",message);

   fprintf (FP,"<table border=1>");
   fprintf(FP,"<td><font color=red> Total : %d </font></td>",joueur[j].popu);
   for (i=0;i<5;i++)
      {
      if(joueur[j].ville[i]>0&&joueur[j].ville[i]<=1000)
         fprintf(FP,"<td> %s : %d </td>",joueur[j].nville[i],joueur[j].ville[i]);
      else
         {
         if(joueur[j].ville[i]>1000)
            fprintf(FP,"<td><hr><font color=green> %s : %d </font><h1>BUG</h1></td>",joueur[j].nville[i],joueur[j].ville[i]);
         else
            fprintf(FP,"<td><font color=blue> %s : %d </font></td>",joueur[j].nville[i],joueur[j].ville[i]);
         }
      }
   fprintf (FP,"</table><br>\n");

   // efface le message
   message[0]=0;
   //ecrit le tampon dans le fichier
   fflush(FP);
   }




   //ecrit l'entete des fichiers de debugage
void en_tete_fichier ()
   {
   fprintf(FP ,"<center><p><img src='images/nuclear.bmp'></p></center>\n");
   }



   //ecrit le jour et la population
void report_fichier ()
   {
   int j;
   fprintf(FP ,"<h3>Jour : %d</h3><h3>Population  : %d</h3>\n",manche,mondiale);
   fprintf(FP ,"<table border=1>");
   fprintf(FP ,"<tr><td>noms</td><td>Population</td><td>Bombes</td><td>Morts</td><td>Victimes</td><td>Emmigrants</td><td>Immigrants</td><td>Actions</td></tr>");
   for(j=0;j<nb_joueurs;j++)
      fprintf(FP ,"<tr><td>%d - %s</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td>%d</td><td> %d - %d - %d </td></tr>",j,joueur[j].nom,joueur[j].popu,joueur[j].bombes,joueur[j].morts,joueur[j].victimes,joueur[j].emmigrants,joueur[j].immigrants,joueur[j].action[0],joueur[j].action[1],joueur[j].action[2]);
   fprintf(FP ,"</table>");
   }



void circzoomfontcenter (BITMAP * cible,char c[],int x,int y,float zoom,int couleur)
   {
   BITMAP * temp , * tempb;
   int h,i,j,r=zoom/2;
   x=x-zoom*4-zoom*8*(strlen(c)-1)/2;
   y=y-zoom*4;
   temp=   create_bitmap(8,8);
   tempb=   create_bitmap(8*zoom,8*zoom);
   for (h=strlen(c)-1;h>=0;h--)
      {
      clear(temp);clear(tempb);
      textprintf(temp,font,0,0,couleur,"%c",c[h]);

      for (i=0;i<8;i++)
         for (j=0;j<8;j++)
            if (temp->line[j][i]==couleur)
               circlefill (tempb,i*zoom+r,j*zoom+r,r,temp->line[j][i]);

      blit (tempb,cible,0,0,(h*8*zoom)+x,y,tempb->w,tempb->h);
      }
   destroy_bitmap(temp);
   destroy_bitmap(tempb);
   }




   //un effet de matrix cod par goldeneye
void matrix()
   {
   static int ecran [N1][N2];// la matrice de l'cran en mode texte
   int i,j,k,n,rnd;
   int N=3000; // indicateur de la charge de l'cran (voir algorithme)
   clear_keybuf() ; // un premier passage  vide

   for(i=N1-1;i>0;i--)
      {
      for(j=0;j<N2;j++)
         { // l a devient rigolo: programm  la GoldenEye
         while(((rnd=48+rand()%74)<65&&rnd>57)||(rnd>90&&rnd<97)); //tant que c'est pas un chiffre ou une lettre
         ecran[i][j]=(ecran[i-1][j]!=32&&rand()%100>APPARRITION?rnd:ecran[i][j]); // 32=code ASCII de l'espace
         if(ecran[i][j]!=32&&i==N1-1) //si la colonne est pleine
            {
            for ( k = 0 ; k < N1 ; k ++ ) //efface la colonne
               ecran[k][j]=32;
            if(D(100)>CHANCE)joue_son(m_sound[D(10)-1]);//joue un bruit electronique au hasard
            }
         }
      } // 32=code de [SPC] pour les neuneus
      for(n=0;n<N2;n++)
         {// premire ligne tout en haut
         rnd = rand ( ) % N ;
         if(!((rnd<48)||(rnd>57&&rnd<65)||(rnd>122)))
            ecran[0][n]=rnd;
         else
            ecran[0][n]=32;
         } // si c pas une lettre ou un chiffre,on met un espace
      for (i=1;i<N1;i++)
         {
         for (j=1;j<N2;j++ )
            if(ecran[i][j]!=32)
               textprintf(buffer, font, (j-1)*P1,(i-1)*P2, 140+rand()%10 , "%c",ecran[i][j]);
      }
   }




   //lance un D a d faces
int D (int d)
   {
   return (1+(rand()%d));
   }




   //affichage de texte vertical en partant de x,y
void ecrit_vertical(int x,int y,char *texte)
   {
   int i,l=strlen(texte);

   for (i=0;i<=l;i++)
      textprintf (buffer, font, x ,y-i*8, 50,"%c",texte[l-i]);
   }



   //dessinne un immeuble de hauteur h en x,y
   //de couleurs c1 -> murs et c2 -> vitres
void dessinne_ville (int x,int y,int h,int c1,int c2)
   {
   int i;

   if(h==0)
      return;

   for (i=0;i<=h/10;i++)
      {
      rectfill (buffer,x-6,y,x+6,y-6,c1);
      rectfill (buffer,x-5,y-1,x-1,y-5,c2);
      rectfill (buffer,x+5,y-1,x+1,y-5,c2);
      y-=6;
      }
   }




   // le map est un carre : comment le remplir ?
   //  +--+--+
   //  | 1  2|
   // -+--+--+-axe
   //  | 3  4|
   //  +--+--+
   //
   // pour le remplir on doit appliquer la regle suivante :
   // 1 represente l hemisphere EST
   // 1 represente l hemisphere OUEST
   // 3 est le symetrique par rapport a l axe de 2
   // 4 est le symetrique par rapport a l axe de 1
   //
   //de cette facon quand on fait le tour que l on sort
   //en bas de 2 on arrive sur la copie inverse de 1
   //qui est represente a l envers
void charge_map(BITMAP *mapbitmap)
   {
   int i,j;
   //BITMAP *mapbitmap;
   //mapbitmap=load_bitmap("images/map.bmp",palette);
   //teste si le map rentre dans le tableau
   if (mapbitmap->w!=CASES*2&&mapbitmap->h!=CASES*2)
      {
      printf("Le map (%d-%d) n'est pas de la bonne taille : (%d-%d)\n",mapbitmap->w,mapbitmap->h,CASES*2,CASES*2);
      exit (2);
      }

   for (i=0;i<mapbitmap->w;i++)
      for (j=0;j<mapbitmap->h;j++)
         map [i][j] = mapbitmap->line[j][i];

//   destroy_bitmap(mapbitmap);

   }



   //comme son nom l indique ...
   //permet aussi de rcuprer les coords des villes dans int[10] pour la souris
   //et d'afficher les noms et population
void affiche_globe (int pos[2])
   {
   int i,j,k,l,encore=1;
   int t[8],x,y;      // le tableau des coordonnees d une maille
   //int jv,v;// quelle ville (v) de quel joueur (jv) est sur la case
   int noms[8][5][2];//les coordonnes des villes...
   //le but du jeu est que l'affichage soit centr
   //les paramtres donneront la position haut gauche (phg)
   //je peut la dcaler pour placer le pp au centre de l'ecran
   //il suffit d'ajouter CASES/4 a phgx
   // et CASES/8 a phgy

   x=pos[0]-CASES/2;
   y=pos[1]-CASES/6;

   //init des pos de villes
   for ( k=0 ; k < nb_joueurs ; k++ )
      for ( l=0 ; l < 5 ; l++ )
         {
         noms[k][l][0]=-1;noms[k][l][1]=-1;
         }

    // comme l'affichage est identique a CASES pres on en rajoutte ...
   while (x<=0)
      x+=CASES*10;
   while (y<=0)
      y+=CASES*10;

   //atmosphere ...
   for(i=0;i<4;i++)
      circle ( buffer ,CENTREX ,CENTREY ,RAYON+i , 52-i ) ;

   //le calcul des points
   for ( i=0 ; i < (CASES/2) ; i++ )
      for ( j=0 ; j < (CASES) ; j++ )
         {

         t [ 0 ] =coords[ j ][ i ][0];
         t [ 1 ] =coords[ j ][ i ][1];
         t [ 2 ] =coords[j+1][ i ][0];//x haut gauche
         t [ 3 ] =coords[j+1][ i ][1];//y haut gauche
         t [ 4 ] =coords[j+1][i+1][0];
         t [ 5 ] =coords[j+1][i+1][1];
         t [ 6 ] =coords[ j ][i+1][0];//x bas droite
         t [ 7 ] =coords[ j ][i+1][1];//y bas droite
         polygon(buffer,4,t,map[( x+j)%(CASES*2)][( y+i)%(CASES*2)]);

         //la case est elle une ville ?
         if(map[( x+j)%(CASES*2)][( y+i)%(CASES*2)]==0)
            for ( k=0 ; k < nb_joueurs ; k++ )
               for ( l=0 ; l < 5 ; l++ )
                  if((x+j)%(CASES*2)==joueur[k].cville[l][0]&&(y+i)%(CASES*2)==joueur[k].cville[l][1])
                     {
                     noms[k][l][0]=t[6];
                     noms[k][l][1]=t[7];
                     }
      }
   //restitution du nom des villes...
   for ( k=0 ; k < nb_joueurs ; k++ )
      for ( l=0 ; l < 5 ; l++ )
         if(noms[k][l][0]>-1)
            {
            textprintf(buffer,font,noms[k][l][0],noms[k][l][1],50,"%s",joueur[k].nville[l]);
            }
   //dessinne les villes...
   for ( k=0 ; k < nb_joueurs ; k++ )
      for ( l=0 ; l < 5 ; l++ )
         if(noms[k][l][0]>-1)
            {
            if(pos[0]==joueur[k].cville[l][0]&&pos[1]==joueur[k].cville[l][1])
               dessinne_ville(noms[k][l][0],noms[k][l][1],joueur[k].ville[l],4,8);
            else
               dessinne_ville(noms[k][l][0],noms[k][l][1],joueur[k].ville[l],50,56);
            }
   }




   // cette fonction recupere les coords des points des elipses   
   // de centrex et centrey , de rayon horizontaux variant de DEF en DEF
   // si les coords de ces points sont :
   //         a gauche du centre
   //         et egaux a centrey +- def
   // on les stockent dans la case de coords :
   //         (CASES /2) -d        (si d=0 on est au centre)
   //          (y-centrey+rayon)/def
void filtre(BITMAP* bitmap,int x,int y ,int d )
   {
   if(x<=CENTREX&&(y%((2*RAYON)/CASES))==CENTREY%((2*RAYON)/CASES))
      {
      coords[(CASES/2)-d][(y-CENTREY+RAYON)/((2*RAYON)/CASES)][0]=x;
      coords[(CASES/2)-d][(y-CENTREY+RAYON)/((2*RAYON)/CASES)][1]=y;
      }
   }


//place les coords du globe dans un tableau
void init_coords()
   {
   int i,j;
   for (i=0;i<=CASES/2;i++)
      {
      do_ellipse(buffer, CENTREX, CENTREY, 2*i*(RAYON/CASES), RAYON, i,filtre);
      }

   // symetrisation du tableau
   // le tableau n est rempli qu a moitie donc il faut recopier la moitie
   // de gauche sur la moitie de droite :
   //           y gauche =y droite
   //           x gauche = CENTREX -xdroite +CENTREX
   //    ou xgauche = 2* CENTREX - xdroite
   for (i=MAILLES/2;i<MAILLES;i++)
      for (j=0;j<MAILLES;j++)
         {
         coords[i][j][0]=2*CENTREX - coords[MAILLES-i-1][j][0];  // les x
         coords[i][j][1]=  coords[MAILLES-i-1][j][1];            // les y
         }
   }
   //fin du globe




   //recalcule les populations et renvoit la population mondiale
int populations ()
   {
   int i,j;

   fprintf(FP,"p");

   for (i=0;i<nb_joueurs;i++)
      {
      joueur[i].popu=0;
      for (j=0;j<5;j++)
         {
         if (joueur[i].ville[j]<0)joueur[i].ville[j]=0;
         joueur[i].popu +=joueur[i].ville[j];
         }
      }
   mondiale=0;

   for (i=0;i<nb_joueurs;i++)
      mondiale+=joueur[i].popu;

   return mondiale;
   }




   //renvoie 1 si le joueur j est mort ( plus de population )
int est_mort (int j)
   {
   int i;

   fprintf(FP,"e");

   i=populations();
   if (joueur[j].popu==0)
      {
      joueur[j].action[0]=0;
      joueur[j].action[1]=0;
      joueur[j].action[2]=0;
      return 1;
      }
   return 0;
   }



   //teste a chaque tour si personne n a gagn
int personne_ne_gagne ()
   {
   int i,c=0;    // recalcule la populations des pays , si = 0 le joueur est mort

   fprintf(FP,"g");

   if (config.modjeu==0)  // mode chacun pour soi
      {
      i = populations();
      for (i=0;i<nb_joueurs;i++)
         if (joueur[i].popu>0)
            c++;

      if (c>1) return 1;      //si personne ne gagne
      else return 0;         //s il n y a plus qu'un joueur ou plus du tout
      }

   if (config.modjeu==1)  // mode humains VS machines
      {
      encore_des_humains=0;
      encore_des_machines=0;

      for (i=0;i<nb_joueurs;i++)
         if (joueur[i].popu>0&&joueur[i].humain==1)
            encore_des_humains=1;

      for (i=0;i<nb_joueurs;i++)
         if (joueur[i].popu>0&&joueur[i].humain==0)
            encore_des_machines=1;

      if ( encore_des_humains&&encore_des_machines)
         return 1; // les 2 camps sont presents
      else
         return 0;
      }
   }



   //renvoie le megatonnage en stock
int megatonnage (int j)
   {
   int i,m=0;

   fprintf(FP,"m");

   for (i=0;i<4;i++)
      m+=joueur[j].stock[i]*mega[i];

   return m;
   }



   //intro au debut du jeu...
void intro()
   {
   fprintf(FP,"Introduction");
   clear(screen);
   circzoomfontcenter ( screen , "Nuclear",ECRANX/2,ECRANY/4,5,1);
   circzoomfontcenter ( screen , "Wars",ECRANX/2,3*ECRANY/4,5,1);
   while(!keypressed()&&!(mouse_b & 1));
   }


   //fonction generique :
   //le texte contenu dans tab va defiler facon generique de film
   //les phrases sont centres sur le milieu de l'cran
void generique ()
   {
   int i,fin=0,scroll,pos;
   int tableau[NOMBRE]={2,6.5,2,2,2,8,1,1,1,1,1,1,1,1,1,1,1};
   char tab[NOMBRE][50]=
      {
      "Vous venez de jouer ",
      "Nuclear-Wars",
      "Un jeu gratuit",
      "Cod en C",
      "Avec la librairie allegro",
      " ",
      " ",
      "Vous pouvez maintenant teindre votre ordinateur",
      "et reprendre une activit normale...",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " ",
      " "
      };

   //calcul de la fin :
   for (i=0;i<NOMBRE;i++)
      fin-=tableau[i]*10;

   clear(buffer);

   for (scroll=ECRANY;scroll>=fin;scroll-=2)
      {
      pos=scroll;
      for (i=0;i<NOMBRE;i++)
         {
         pos+=tableau[i]*5;
         circzoomfontcenter (buffer,tab[i],ECRANX/2,pos,tableau[i],55);
         pos+=tableau[i]*5;
         }
      affiche();
      }
   }



   // affichage des infos a chaque debut de tour
void affiche_info()
   {
   float i;
   char temp[30];

   fprintf(FP,"---------nouveau tour----------");

   temp[0]=0;
   sprintf(temp,"Jour %d",manche);
   for (i=0;i<=25;i+=.5)
      {
      circzoomfontcenter (buffer,temp,ECRANX/2,ECRANY/2,i,1);
      affiche();
      }
   }



   //ecran pour quitter
void quitte()
   {
   char m1[128],m2[128];

   fprintf(FP,"Quitter ?");

   m1[0]=0;
   m2[0]=0;

   strcat(m1,quitter());
   strcat(m2,pas_quitter());

   affiche();
   delay(500);
   while(1)
      {
      ou_est_la_souris();
      textprintf (buffer,font,100,ECRANY/2,50,"%s",m1);
      textprintf (buffer,font,100,ECRANY/2+100,50,"%s",m2);
      fleche_droite(0,ECRANY/2,1);
      fleche_gauche(0,ECRANY/2+100,1);
      if(teste_souris(0,ECRANY/2,64,ECRANY/2+64))
         {
         fprintf(FP,"<hr><p>END OF GAME</p>");
         fclose(FP);
         exit (0);
         }

      if(teste_souris(0,ECRANY/2+100,64,ECRANY/2+164))break;
      affiche();
      }
   }



   // affiche le texte entre les coordonnes donnes ...
void affiche_message ()
   {
   int px=0,py=0,i=0,j,mot_suivant;

int cool=D(256);

   text_mode(160);//couleur de fond de la console

   //affiche la console
   masked_blit(console,buffer,0,0,110,5,console->w,console->h);

   // affiche le jour et la population
   textprintf (buffer,font,180,10,cool,"Jour  : %4d   Population  :  %5d",manche,mondiale);

   // si la fin de ligne sort de l ecran : + de 400/8 =50 carac
   //  on va a la ligne d'apres
   for (i=0;i<strlen(message);i++)
      {
      j=i;
      mot_suivant=0;
      while (message[j]!=32&&message[j]!=0)
         {
         mot_suivant++;
         j++;
         }
   //dans le cas ou le mot suivant depasse on remet px a 0
   //et on saute une ligne
      if (mot_suivant+px>(SMS_DX-SMS_X)/8)
         {
   //  sinon on va a la fin
         px=0;
         py++;
   // si py depasse le nb de ligne autorisee on arrete
         if ((SMS_DY-SMS_Y)/8<py)
            i=strlen(message);
         }
      textprintf(buffer ,font, SMS_X+px*8,SMS_Y+py*8,cool,"%c",message[i]);
      px++;
   // si deux espaces on passe une ligne
      if (message[i]==32&&message[i-1]==32)
         {
         px=0;
         py++;
         }
      }
   text_mode(0);
   }



   //gere les ecrans de prop et d attaque
void affiche_propagande_attaque(int ja,int jb)
   {
   while(1)
      {
      ou_est_la_souris();
      affiche_message ();
      versus(joueur[ja].bitmap,joueur[jb].bitmap);
      affiche_globe(joueur[ja].cville[0]);
      fleche_droite(ECRANX-64,ECRANY-64,1);
      if(key[KEY_ESC])
         quitte();
      if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      affiche();
      if(!joueur[ja].humain)
         matrix();
      if(!attends())
         break;
      }
   }



void affiche_mort(int ja)
   {
   int i;
   while (1)
      {
      ou_est_la_souris();
      for (i=0;i<4000;i++)
        putpixel (screen ,rand()%100 ,rand()%100 ,16+rand()%8);
      affiche_message ();
      affiche();
      if(!joueur[ja].humain)
         matrix();
      fleche_droite(ECRANX-64,ECRANY-64,1);
      if(key[KEY_ESC])
         quitte();
      if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      if(!attends())
         break;
      }
   }



   //action de preparer une arme
void affiche_arme (int j,int bomb)
   {
   while(1)
      {
      ou_est_la_souris();
      versus(joueur[j].bitmap,bombes[bomb]);
      affiche_message ();
      affiche();
      if(!joueur[j].humain)
         matrix();
      fleche_droite(ECRANX-64,ECRANY-64,1);
      if(key[KEY_ESC])
         quitte();
      if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      if(!attends())
         break;
      }
   }




void affiche_construction (int j,int bomb[4])
   {
   int i=0;
   while(1)
      {
      ou_est_la_souris();
      if(i<bomb[1]+bomb[2]+bomb[3]+bomb[0])
         {
         i++;
         joue_son(construit);
         }

      if(!joueur[j].humain)
         matrix();
      voir_stock(bomb);//afiche le stock en contruction ...
      versus(joueur[j].bitmap,NULL);
      affiche_message ();
      affiche_globe(joueur[j].cville[0]);
      fleche_droite(ECRANX-64,ECRANY-64,1);
      if(key[KEY_ESC])
         quitte();
      if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      affiche();
      if(!attends())
         break;
      }
   }




struct ACTIONS cree_action (const char *nom,int  (*choix)(int j),int  (*test)(int j),void (*ecran)(int j))
   {
   struct ACTIONS action;
   action.nom=nom;
   action.choix=choix;
   action.test =test;
   action.ecran=ecran;
   return action;
   }



int toujours_possible(int j)
   {
   return (1);
   }



int pas_de_choix(int j)
   {
   return (0);
   }



int teste_arme(int j)
   {
   if(megatonnage(j)==0)
      return (0);
   else
      return (1);
   }




int teste_attaque(int j)
   {
   if(joueur[j].pasdetir > -1 )
      return 1;
   else
      return 0;
   }




   //action de propagande ( a revoir)...
void propagande (int ja)
   {
   // si la propagande attire plus de personne que la ville n'en contient
   // l excedent est la marge
   int va,vb=joueur[ja].action[2]; //la ville du joueur a est aleatoire
   int i,jb=joueur[ja].action[1],villea,villeb,detruite=0;
   char truc[50];

   fprintf(FP,S"propagande :");

   //recherche de va :
   va=D(5)-1;
   while (joueur[ja].ville[va]<=0)
      {
      va++;
      if(va>4)
         va=0;
      }

   fprintf(FP," va[%d] = %d ",va,joueur[ja].ville [ va ]);

   truc[0]=0;
   // on stocke les populations pour les calculs
   villea=joueur[ja].ville [ va ];
   villeb=joueur[jb].ville [ vb ];

   fprintf(FP," vb[%d] = %d ",vb,joueur[jb].ville [ vb ]);

   // qui ?
   faitquoi(joueur[ja].nom);
   sprintf (message,"%s",evenement);

   // si degats est =0 , RAS
   // pas de deplacement
   if (degats==0)
      strcat(message,"et personne n y va ...");
   // sinon 2 cas
   else
      {
   // si degats est >0 , la propagande est reussie
   // deplacement de vb vers va
      if (degats>0)
         {
         if(degats>=villeb)
            {
            detruite=1;
            degats=villeb;
            villeb=0;
            villea=villea+degats;
            }
         else
            {
            villeb=villeb-degats;
            villea=villea+degats;
            }
         quittent(degats,joueur[ja].nville[va],joueur[jb].nville[vb]);
         sprintf(truc,"%s",evenement);
         joueur[ja].emmigrants+=degats;
         joueur[jb].immigrants+=degats;

         strcat(message,truc);
         }
      // si degats est <0 , la propagande est ratee
      // deplacement de va vers vb
      if (degats<0)
         {
         degats=0-degats;
         if(degats>=villea)
            {
            detruite=1;
            degats=villea;
            villea=0;
            villeb=villeb+degats;
            }
         else
            {
            villea=villea-degats;
            villeb=villeb+degats;
            }
         quittent(degats,joueur[ja].nville[va],joueur[jb].nville[vb]);
         sprintf(truc,"%s",evenement);
         joueur[ja].immigrants+=degats;
         joueur[jb].emmigrants+=degats;
         strcat(message,truc);
         }
      }
   fprintf(FP," deg = %d ",degats);

   //test de destruction
   if(detruite)
      {
      truc[0]=0;
      sprintf(truc,destruction());
      strcat(message,truc);
      }
   // on fait les comptes
   joueur[ja].ville [ va ]=villea;
   joueur[jb].ville [ vb ]=villeb;
   fprintf(FP," va[%d] = %d ",va,joueur[ja].ville [ va ]);
   fprintf(FP," vb[%d] = %d ",vb,joueur[jb].ville [ vb ]);

   if (!config.modauto)affiche_propagande_attaque(ja,jb);
   debug(ja);
   }




   //action d attaquer
void attaque (int ja)
   {
   char temp[30];
   int a;
   int jb=joueur[ja].action[1];
   int vb=joueur[ja].action[2];

   fprintf(FP,S"attaque :");

   temp[0]=0;
   // le calcul des degats d une attaque
   a=mega[joueur[ja].pasdetir];
   degats = ((rand () % a/2)+a)*(((rand()%12)+10)/10);

   fprintf(FP," deg= %d ",degats);

   if (joueur[jb].ville[vb] <= degats)
      degats=joueur[jb].ville[vb];

   fprintf(FP,"vb[%d] = %d",vb,joueur[jb].ville[vb]);

   joueur[jb].ville[vb]-=degats;

   fprintf(FP," -> %d",joueur[jb].ville[vb]);

   sprintf ( message ,"%s attaque %s a %s , %d millions de victimes ",joueur[ja].nom,joueur[jb].nom,joueur[jb].nville[vb],degats);

   joueur[ja].victimes+=degats;
   joueur[jb].morts   +=degats;
   joueur[ja].bombes++;

   if(joueur[jb].ville[vb]==0)
      sprintf ( temp ,"et la ville est detruite");
   else
      sprintf ( temp,", %d millions survivent ...",joueur[jb].ville[vb]);

   strcat (message,temp);
   joueur[ja].pasdetir=-1;
   if (!config.modauto)
      affiche_propagande_attaque(ja,jb);
   debug(ja);
   }



   //action de construction
void construction (int j)
   {
   int nombre,i,k,n,oui=0,bomb[4]={0,0,0,0};
   //on construit 1Dx bombes par pays ,
   //ou x est le nombre d'habitants / 50

   fprintf(FP,S"construction :");

   nombre=1+rand()%joueur[j].popu/25;
   if(nombre>500/25)
      nombre=500/25;

   for (i=0;i<4;i++)
      {
      n= rand() % nombre;
      nombre -= n;
      if (n>0)
         {
         fprintf(FP," (%d)",mega[i]);
         oui=1;
         bomb[i]=n;
         joueur[j].stock[i]+=n;
         }
      }

   if (oui==1)
      sprintf(message,augmente(),joueur[j].nom);
   if (oui==0)
      sprintf(message,stagne(),joueur[j].nom); 

   if (!config.modauto)
      affiche_construction(j,bomb);
   debug (j);
   }



   //action de preparer une arme
void arme (int j)
   {
   int b=joueur[j].action[1];

   fprintf(FP,S"arme :");

   if (joueur[j].pasdetir>-1&&joueur[j].stock[b]>0)
      {
      joueur[j].stock[joueur[j].pasdetir]++;
      fprintf(FP," %d mgt ->",mega[joueur[j].pasdetir]);
      }
   if(b<4&&b>=0)
      preparation(joueur[j].nom,mega[joueur[j].pasdetir]);
   else
      preparation(joueur[j].nom,0);

   sprintf (message ,"%s",evenement);

   if(joueur[j].stock[b]>0)
      {
      joueur[j].pasdetir=b;
      fprintf(FP," stock -> %dmgt",mega[b]);
      joueur[j].stock[b]--;
      }

   if (!config.modauto)
      affiche_arme(j,b);
   debug(j);
   }




   //action de ne rien faire pour les joueurs morts
void mort(int j)
   {

   fprintf(FP,S"mort de %s",joueur[j].nom);

   sprintf (message ,souvenir(), joueur[j].nom);
   if (!config.modauto)
      affiche_mort(j);
   debug (j);
   }



   //cre une forme alatoire dans le bitmap qui servira de carte du pays du joueur
void carte(BITMAP * pays,int c,int positions[2])
   {
   int l=(CASES/8*3);//largeur hauteur du pays
   int x,y,r,k;

   fprintf(FP,"- pays -");

   clear(pays);
   circlefill(pays,l/2,l/2,5,couleurs[c]);

   while(1)
      {
      x=D(l);
      y=D(l);
      r=D(2)+D(2);
      if(getpixel(pays,x,y)==couleurs[c])
         {
         circlefill(pays,x,y,r,couleurs[c]);
         if(x>pays->w-5||x<5||y>pays->h-5||y<5)
            break;
         }
      }
   }



   //teste les distances entres les k-1 premieres villes du joueur j
   //et la ville k  si elle est trop proche ,  retourne 0
   //et la ville n'est pas ajoutte ...
int distance_villes(int j,int k)
   {
   int i=0,dx,dy;
   for (i=0;i<k;i++)
      {
      dx=joueur[j].cville[i][0]-joueur[j].cville[k][0];
      dy=joueur[j].cville[i][1]-joueur[j].cville[k][1];
      if(dx<PROX&&dx>-PROX)
         {
         fprintf(FP,"x:%d",dx);
         fflush(FP);
         return (0);
         }
      if(dy<PROX&&dy>-PROX)
         {
         fprintf(FP,"y:%d",dy);
         fflush(FP);
         return (0);
         }
      }
   return (1);
   }


                                                      
   // comme son nom l'indique
void place_villes(BITMAP * mapbitmap)
   {
   int j,k,x,y;
   int l=(CASES/8*3);//largeur hauteur du pays

   fprintf(FP,"- placement des villes ,espacement = %d -",PROX);

   //placement des villes
   for (j=0;j<nb_joueurs;j++)
      for (k=0;k<5;k++)
         {
         fprintf(FP,"-",k);
         fflush(FP);
         joueur[j].cville[k][0]=j*20+D(l);
         joueur[j].cville[k][1]=D(l);

      //teste si deux villes ne sont pas trop proches

         if(getpixel(mapbitmap,joueur[j].cville[k][0],joueur[j].cville[k][1])==couleurs[j]&&distance_villes(j,k))
            {
            fprintf(FP,S"place la ville : %d -",k);
            fflush(FP);
            putpixel(mapbitmap,joueur[j].cville[k][0],joueur[j].cville[k][1],0);
            }
         else k--;
         }
      }


   //remplit la case c du tableau des joueurs avec les informations i
   //dessinne les pays dans le map
   //si h=1 le joueur est humain sinon c'est une machine
void remplit_joueur(int c,int i,int h,BITMAP *mapbitmap)
   {
   BITMAP * pays;//l'image pour les cartes temporaires ...
   int j;

   fprintf(FP,"- remplissage du joueur %d %s -",c,joueur[c].nom);

   //initalise le bitmap carte du pays du joueur
   pays=create_bitmap(CASES/4*3,CASES/4*3);
   //la partie commune

   joueur[c].bombes=0;
   joueur[c].victimes=0;
   joueur[c].immigrants=0;
   joueur[c].emmigrants=0;
   joueur[c].morts=0;
   joueur[c].numero=c;
   joueur[c].pasdetir=-1;
   joueur[c].popu=5*config.popuville;

   //cree le pays dans le map
   carte(pays,c,positions[c]);

   //place le pays sur la carte
   masked_blit(pays,mapbitmap,0,0,c*20,0,pays->w,pays->h);

   //place les villes sur la carte
   for (j=0;j<5;j++)
      putpixel(mapbitmap,joueur[c].cville[j][0],joueur[c].cville[j][1],0);//en noir

   //la partie ordi
   if(h==0)
      {
      for (j=0;j<5;j++)
         {
         joueur[c].nville[j][0]=0;
         strcat(joueur[c].nville[j],noms_villes_ordi[i][j]);
         joueur[c].ville[j]=config.popuville;
         }
      joueur[c].nom[0]=0;
      strcat(joueur[c].nom,noms_ordi[i]);
      joueur[c].nombmp[0]=0;
      strcat(joueur[c].nombmp,noms_ordi_bmp[i]);
      joueur[c].humain=0;
      }

   //la partie humain
   if(h==1)
      {
      for (j=0;j<5;j++)
         {
         joueur[c].nville[j][0]=0;
         strcat(joueur[c].nville[j],noms_villes[i][j]);
         joueur[c].ville[j]=config.popuville;
         }
      joueur[c].nom[0]=0;
      strcat(joueur[c].nom,noms_humains[i]);
      joueur[c].nombmp[0]=0;
      strcat(joueur[c].nombmp,noms_bmp[i]);
      joueur[c].humain=1;
      }
   joueur[c].bitmap = load_bitmap(joueur[c].nombmp, palette);
   destroy_bitmap(pays);
   }


   //menu de saisie des joueurs
void menu ()
   {
   char m1[255];
   int i,j,en_cours=0,c,jt[8]; // les joueurs temporaires pour le menu
   BITMAP *mapbitmap;  //la texture applique sur le globe
   BITMAP *temp[16];

   fprintf(FP,S"Menu de configuration");

   config.popuville=50;
   config.modjeu=0;
   config.modauto=0;
   config.son=1;
   config.demo=0;

   mapbitmap = create_bitmap(CASES*2,CASES*2);
   clear_to_color(mapbitmap,2);//colore en bleu

   for(i=0;i<16;i++)
      temp[i]=load_bitmap(noms_bmp[i],palette);
   //init du tableau des joueurs temporaires
   for (i=0;i<8;i++)
      jt[i]=0;

   delay(1000);
   while (1)
      {
      affiche();
      ou_est_la_souris();
 
      fleche_droite(ECRANX-64,ECRANY-64,1); 
      fleche_gauche(0,ECRANY-64,1); 

      // configuration
      textprintf(buffer, font,100, 20, 50,"Configuration");
      if (config.modjeu==0)textprintf(buffer, font,10, 40, 56,"Chacun pour soi           ");
      if (config.modjeu==1)textprintf(buffer, font,10, 40, 56,"Humains Vs Machines");

      if (config.popuville>100)config.popuville=10;
      textprintf(buffer, font,10, 60, 56,"Viles : %d   ",config.popuville);

      if (config.modauto==0)textprintf(buffer, font,10, 80, 56,"Mode manuel     ");
      if (config.modauto==1)textprintf(buffer, font,10, 80, 56,"Mode automatique");

      if (config.son==0)textprintf(buffer, font,10, 100, 56,"Pas de bruits");
      if (config.son==1)textprintf(buffer, font,10, 100, 56,"Bruitages actifs");

      if (config.demo==0)textprintf(buffer, font,10, 120, 56,"Normal");
      if (config.demo==1)textprintf(buffer, font,10, 120, 56,"Demo");

      textprintf(buffer, font,ECRANX/3*2+50, 40, 56,"Mode Test");
      textprintf(buffer, font,ECRANX/3*2+50, 60, 56,"Annule tout");
      textprintf(buffer, font,ECRANX/3*2+50, 80, 56,"Demonstration");

      //choix des joueurs
      textprintf(buffer, font, 100, ECRANY/2-30, 50,"Choix des joueurs : %1d joueurs en cours",nb_joueurs);
 
      for (i=0;i<8;i++)
         {
         if(jt[i]==0)neige(i*80,ECRANY/2,80+i*80,80+ECRANY/2,400);
         if(jt[i]==1)blit(temp[i]  ,buffer,10,10,i*80,ECRANY/2,80,80);
         if(jt[i]==2)blit(temp[i+8],buffer,10,10,i*80,ECRANY/2,80,80);
         if(jt[i]>2)jt[i]=0;
         }
 
      for (i=0;i<8;i++)
         {
         if(teste_souris(i*80,ECRANY/2, 79+i*80,ECRANY/2+80)){jt[i]++;}
         }

      if (teste_souris(0,35,ECRANX/3,50))
         config.modjeu=1-config.modjeu;
      if (teste_souris(0,55,ECRANX/3,70))
         config.popuville+=10;
      if (teste_souris(0,75,ECRANX/3,90))
         config.modauto=1-config.modauto;
      if (teste_souris(0,95,ECRANX/3,110))
         config.son=1-config.son;
      if (teste_souris(0,115,ECRANX/3,130))
         config.demo=1-config.demo;
      if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      if (teste_souris(ECRANX/3*2,75,ECRANX,90))
         {
         for(i=0;i<8;i++)
            jt[i]=2;

         config.son=1;
         config.modauto=0;
         config.popuville=50;
         config.modjeu=0;
         config.demo=1;
         }
      if (teste_souris(ECRANX/3*2,55,ECRANX,70))
         {
         for(i=0;i<8;i++)
            jt[i]=0;

         config.son=1;
         config.modauto=0;
         config.popuville=50;
         config.modjeu=0;
         config.demo=0;
         }
      if (teste_souris(ECRANX/3*2,35,ECRANX,50))
         {
         for(i=0;i<8;i++)
            jt[i]=2;
  
         config.modauto=1;
         config.popuville=50;
         config.modjeu=0;
         config.demo=0;
         }
      nb_joueurs=0;
      for (i=0;i<8;i++)if (jt[i]>0)
         nb_joueurs++;
      if (teste_souris(0,ECRANY-64,64,ECRANY))
         quitte();
      }
   affiche();
   delay(1000);
   //repartition des noms des joueurs et des images ordis
   //si jt=1 le joueur est humain
   //      2               une machine
   c=0;
   for (i=0;i<8;i++)
      {
      if (jt[i]==1)
         {
         remplit_joueur(c,i,1,mapbitmap);
         c++;
         }
      if (jt[i]==2)
         {
         remplit_joueur(c,i,0,mapbitmap);
         c++;
         }
      }
   place_villes(mapbitmap);

   for(i=0;i<255;i++)
      m1[i]=0;

   sprintf(m1,declaration());

   while(1)
      {
      ou_est_la_souris();
      textprintf(buffer, font, 100, 20, 50,m1);

      for (i=0;i<nb_joueurs;i++)
         textprintf(buffer, font, 50, 40+i*15, 50,"Joueur %d-%s",i, joueur[i].nom);

      textprintf(buffer, font, 100, ECRANY/2, 50,"La carte :");

      stretch_blit(mapbitmap,buffer,0,0,mapbitmap->w,mapbitmap->h,100,ECRANY/2+40,mapbitmap->w,mapbitmap->h);

      fleche_droite(ECRANX-64,ECRANY-64,1); 

      if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      affiche();
      }
   charge_map(mapbitmap);

   for(i=0;i<16;i++)
      destroy_bitmap(temp[i]);

   destroy_bitmap(mapbitmap);
   }


   //ecran de choix d'une ville pour le joueur j1 chez j2
int choix_ville (int j1)
   {

   int i,le_joueur=0,la_ville=0,d,v;

   while (1)
      {
      //trouve un joueur choisissable
      while(joueur[le_joueur].numero==j1||est_mort(le_joueur)||le_joueur>=nb_joueurs)
         {
         le_joueur++;
         if(le_joueur>=nb_joueurs)le_joueur=0;
         }

      ou_est_la_souris();
      versus(joueur[j1].bitmap,joueur[le_joueur].bitmap);
      message[0]=0;
      sprintf(message,"%s %s %s a %s",joueur[j1].nom,(joueur[j1].action[0]==1)?"sourit a":"attaque",joueur[le_joueur].nom,joueur[le_joueur].nville[la_ville]);
      affiche_message();

      versus(joueur[j1].bitmap,joueur[le_joueur].bitmap);
 
      for(v=0;v<5;v++)
         {
         textprintf(buffer,font,ECRANX/5*v,120,50,"%s:%d",joueur[le_joueur].nville[v],joueur[le_joueur].ville[v]);

         if(teste_souris(ECRANX/5*v,120,ECRANX/5*(v+1),130))
            la_ville=v;
         }

      affiche_globe(joueur[le_joueur].cville [la_ville]);

      fleche_droite(ECRANX-64,ECRANY-64,1);
      fleche_gauche(0        ,ECRANY-64,1);

      if(teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      if(teste_souris(0        ,ECRANY-64,    64,ECRANY))
         return(1);
      if(teste_souris(ECRANX-100,    0,ECRANX,100))
         le_joueur++;
      if (key[KEY_ESC])
         quitte();
      affiche();
      }

   joueur[j1].action[1]=le_joueur;
   joueur[j1].action[2]=la_ville;
   //si c est bon on retourne 0
   return (0);
   }



   //ecran de choix d'un joueur sauf j
int choix_joueur (int j)
   {
   int c=0,i,encore=1;

   while (encore)
      {
      //trouve un joueur choisissable
      while(joueur[c].numero==j||est_mort(c)||c>=nb_joueurs)
         {
         c++;
         if(c>=nb_joueurs)c=0;
         }

      ou_est_la_souris();
      message[0]=0;
      sprintf(message,"%s choisit %s",joueur[j].nom,joueur[c].nom);
      affiche_message ();
      versus(joueur[j].bitmap,joueur[c].bitmap);
 
      affiche_globe(joueur[c].cville [0]);

      fleche_droite(ECRANX-64,ECRANY-64,1);
      fleche_gauche(0        ,ECRANY-64,1);

      if(teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      if(teste_souris(0        ,ECRANY-64,    64,ECRANY))
         return(1);
      if(teste_souris(ECRANX-100,    0,ECRANX,100))
         c++;
      if(key[KEY_ESC])
         quitte();

      affiche();
      }
   joueur[j].action[1] = c;
   //si c est bon on retourne 0
   return (0);
   }



   //ecran de choix d'une bombe pour le joueur j
int choix_arme (int j)
   {
   int c=0,i,k,l=0;
   while (1)
      {
      affiche();
      ou_est_la_souris();
      //trouve une arme en stock
      while(joueur[j].stock[c]==0)
         {
         c++;
         if(c==4)c=0;
         }
 
      versus(joueur[j].bitmap,bombes[c]);
      message[0]=0;
      sprintf(message,"%s choisit %d megatonnes",joueur[j].nom,mega[c]);
      affiche_message();
 
      voir_stock(joueur[j].stock);

      fleche_droite(ECRANX-64,ECRANY-64,1);
      fleche_gauche(0        ,ECRANY-64,1);

      if(teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      if(teste_souris(0        ,ECRANY-64,    64,ECRANY))
         return(1);
      if(teste_souris(ECRANX-100,    0,ECRANX,100))
         c++;
      if (key[KEY_ESC])
         quitte();
      }
   joueur[j].action[1] = c;
   //si c est bon on retourne 0
   return (0);
   }




int choix_action (int j)
   {
   char m1[255],m2[255];
   int c=0,i;
   int actes[5]={0,0,0,0,0};

   for (i=0;i<4;i++)
      actes[i]=actions[i].test(j);  // si le pas de tir est pret on peut attaquer

   actes[4]=1  ;          //        la defense est pour l instant en construction...
   clear_keybuf();
   for (i=0;i<255;i++)
      {
      m1[i]=0;
      m2[i]=0;
      }

   sprintf(m1,sur_le_pas_de_tir(),mega[joueur[j].pasdetir]);
   sprintf(m2,que_faire(),joueur[j].nom);

   while (1)
      {
      affiche();
      ou_est_la_souris();
      versus(joueur[j].bitmap,NULL);
      textprintf(buffer, font, 110, 20, 50,"%s",m2);
      if(actes[0])
         {
         propaganda(110,40,(c==0)?1:0);
         if(teste_souris(110,40,174,104))
            c=0;
         }
      if(actes[1])
         {
         usine     (174,40,(c==1)?1:0);
         if(teste_souris(174,40,238,104))
            c=1;
         }
      if(actes[2])
         {
         preparme  (238,40,(c==2)?1:0);
         if(teste_souris(238,40,302,104))
            c=2;
         }
      if(actes[3])
         {
         cible     (302,40,(c==3)?1:0);
         if(teste_souris(302,40,366,104))
            c=3;
         }
      if(actes[4])
         { 
         parabole  (366,40,1);//(c==4)?1:0);
         //if(teste_souris(366,40,430,104))c=4;
         }

      fleche_droite(ECRANX-64,ECRANY-64,1); 

      if(teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
         break;
      textprintf(buffer, font, 30, 110, 50,"Villes");
      textprintf(buffer, font, 210, 110, 50,"Stock");

      for (i=0;i<5;i++)
         textprintf(buffer, font, 0, 130+i*10, 50,"%s : %d",joueur[j].nville[i],joueur[j].ville[i]);
      for (i=0;i<4;i++)
         if (joueur[j].stock[i])
         textprintf(buffer, font, 190, 130+i*10, 50,"%d * %d mgt",joueur[j].stock[i],mega[i]);
      if (joueur[j].pasdetir>-1)
         textprintf(buffer, font, 50, 190, 50,"%s",m1);

      if (key[KEY_ESC])
         quitte();
      }
   return c+1;
   }




   //on peut definir des comportements :
   //- si un joueur a la une population + il va etre port sur l'attaque
   //- si un joueur n a plus assez de bombes il va construire
   //- si un joueur n'a plus assez de villes il va plutot faire de la propagande
   //- le joueur qui attaque va chercher a detruire une ville s'il le peut
   //- plus le joueur a de villes plus il va attaquer
   //
void ia(int j)
   {
   int i,pop,k,actes,encore;

   fprintf(FP,S"ia :");

   //si pas de stock et population > 50 construction
   if (megatonnage(j)<=200)
      {
      if (joueur[j].popu>150)
         {
         joueur[j].action[0] = 2 ;         // construction
         }
      else
         {
         joueur[j].action[0]=1+(rand()%2);  // 50% propagande 50% construction
         }
      }
   else
      {
      if (joueur[j].popu<=150)
         {
         joueur[j].action[0] = 1 ;         // propagande
         }
      else
         {
         if ( joueur[j].pasdetir==-1 )
            {
            joueur[j].action[0]=3;            // prepare

            // choix de la plus grosse bombe
            for (i=0;i<4;i++)
               if (joueur[j].stock[i]>0)
                  joueur[j].action[1]=i;
            }
         else
            {
            joueur[j].action[0]=4;    //  une attaque
            }
         }
      }
//   fprintf(FP,"%s",actions[joueur[j].action[0]].nom);
   //si propagande ou attaque ,
   // recherche de la ville la plus peuple du joueur le plus peupl
   // sauf joueur j ( en cours)
   if (joueur[j].action[0]==1||joueur[j].action[0]==4)
      {
      pop=0;
      for (i=0;i<nb_joueurs;i++)
         if (i!=j&&joueur[i].popu>=pop)
            {
            k=i;
            pop=joueur[i].popu;
            }
      pop=0;
      for (i=0;i<5;i++)
         if (joueur[k].ville[i]>=pop)
            {
            pop=joueur[k].ville[i];
            joueur[j].action[1]=k;
            joueur[j].action[2]=i;
            }
//      fprintf(FP," %s %s",joueur[k].nom,joueur[k].nville[i]);
      }
   }




void init() 
   {
   //init des actions
   actions[0]= cree_action ("mort"        ,pas_de_choix ,toujours_possible,mort);
   actions[1]= cree_action ("propagande"  ,choix_ville  ,toujours_possible,propagande);
   actions[2]= cree_action ("construction",pas_de_choix ,toujours_possible,construction);
   actions[3]= cree_action ("armement     ",choix_arme   ,teste_arme       ,arme);
   actions[4]= cree_action ("attaque"      ,choix_ville  ,teste_attaque    ,attaque);
   //ouverture du fichier
   temps=time(0);
   FP = fopen ( "debug.htm" , "w" ); // efface le fichier debug
   fclose (FP);
   FP = fopen ( "debug.htm" , "a" );
   //debug
   fprintf(FP,S"main");
   //initialisation de la librairie
   allegro_init();
   install_keyboard();
   install_mouse();
   install_timer();
   set_gfx_mode( GFX_AUTODETECT, ECRANX, ECRANY, 0, 0 );
   //init du son
   if (install_sound(DIGI_AUTODETECT, MIDI_AUTODETECT, "nuclear") != 0)
      {
      printf("Sound problems");
      exit(1);
      }
   charge_sons();
   config.son=1;
   joue_son(debut);
   // reglage de la palette
   console = load_bitmap("images/console.bmp", palette);
   buffer = load_bitmap("images/oussama.bmp", palette);
   set_pallete(palette);
   //intro
   destroy_bitmap(buffer);
   //initialisation du globe
   init_coords();
   // chargement du bitmap du globe
   buffer=create_bitmap(ECRANX ,ECRANY);
   clear(buffer);
   intro();
   //menu : configuration ,selection des joueurs et creation du map
   menu ();
   en_tete_fichier();
   // chargement des images des bombes
   bombes[0] = load_bitmap("images/b1.bmp", palette);
   bombes[1] = load_bitmap("images/b2.bmp", palette);
   bombes[2] = load_bitmap("images/b3.bmp", palette);
   bombes[3] = load_bitmap("images/b4.bmp", palette);
   }




void jeu()
   {
   int i,j;
   int encore=1,c=0;
   // boucle principale
   while (1)
      {

      if(!personne_ne_gagne())
         break;

      report_fichier();
      if (!config.modauto)

         affiche_info();

   //choix des actions ...

      for (j=0;j<nb_joueurs;j++)
         {
         if (joueur[j].popu>0)
            {
            if (joueur[j].humain)
               {  
               if(!config.modauto)
                  nuke(j);
               encore=1;
               while(encore)
                  {
                  joueur[j].action[0]=choix_action(j);
                  if(actions[joueur[j].action[0]].test(j))
                     encore=actions[joueur[j].action[0]].choix(j);
                  else
                     encore=1;
                  }
               }
            else
               {
               ia(j);
               if(joueur[j].action[0]>=0&&joueur[j].action[0]<=4)
                  fprintf(FP,actions[joueur[j].action[0]].nom);
               else
                  fprintf(FP,"<h1>BUG</h1>");
               }
            }
         else mort(j);
         }
   // resolution des actions ...
      for (j=0;j<nb_joueurs;j++)
         actions[joueur[j].action[0]].ecran(j);

      manche++;
 
      for (j=0;j<nb_joueurs;j++)
         i=est_mort(j);
      }
   }




void fin()
   {
   int i,j;
   int encore=1,c=0;

   clear(buffer);

   if (config.modjeu==0)  // victoire d'un joueur
      {
      for (j=0;j<nb_joueurs;j++)
         if (!est_mort(j))
            break;
      //sprintf ( message,victoire_joueur() ,manche,joueur[j].nom);
      //fprintf(FP,message);
      if(j<nb_joueurs)
         while(1)
            {
            ou_est_la_souris();
   
            versus(joueur[j].bitmap,NULL);  
   
            textprintf(buffer,font,ECRANX/2,ECRANY/2,50,"%s gagne",joueur[j].nom);
            //affiche_message ();
            fleche_droite(ECRANX-64,ECRANY-64,1);
            if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
               break;
            affiche();
            }
      }
   if (config.modjeu==1) // victoire d'un camp

         {
         //sprintf ( message ,victoire_equipe(),manche,(encore_des_humains)?"humains":"machines");
         //fprintf(FP,message);
         while(1)
            {
            ou_est_la_souris();

            versus(joueur[j].bitmap,NULL);  
            textprintf(buffer,font,ECRANX/2,ECRANY/2,50,"les %s gagnent",encore_des_humains?"humains":"machines");
   
            //affiche_message ();
            affiche();
            fleche_droite(ECRANX-64,ECRANY-64,1);
            if (teste_souris(ECRANX-64,ECRANY-64,ECRANX,ECRANY))
               break;
            }
         }
   generique();
   allegro_exit();
   fclose(FP);
   }



   // fonction principale
int main ()
   {
int i;
   init();
   for(i=0;i<10;i++)
      {
     joue_son(m_sound[i]);//joue un bruit electronique
delay(1000);
     }

   jeu();
   fin();
   }
