#ifndef TIC_TAC_TOE_H
#define TIC_TAC_TOE_H

#define COLOUR_BACKGROUND makecol(96, 185, 220)
#define COLOUR_PLAYER_ICONS makecol(0, 0, 0)
#define COLOUR_SELECTOR makecol(0, 0, 0)
#define COLOUR_PLAYER_ICON_SELECT makecol(0, 0, 0)
#define COLOUR_ICON_SELECT_CELL makecol(61, 78, 83)
#define COLOUR_GRID_CELL makecol(255, 255, 255)
#define COLOUR_ICON_SELECT_TITLE makecol(0, 0, 128)
#define COLOUR_SCORES makecol(0, 0, 0)
#define COLOUR_FEEDBACK makecol(0, 0, 128)

struct objPlayer
{	
	//The pieceCol and pieceRow says which row/col the sprite is on the sprite sheet
	//This means the row and col does not need to be calculated every time a piece needs to be drawn
	unsigned short pieceCol, pieceRow, score;
	bool pieceSet;
	
};

struct objSelect //Current location of the selector
{
	unsigned short row, col; //Logical location	
};

BITMAP* imgBuffer; //Double buffering
BITMAP* imgSprites;
BITMAP* imgSelector;

const unsigned int WIDTH = 300, HEIGHT = 200;
const unsigned short PLAYER_1 = 0, PLAYER_2 = 1, EMPTY = 2;
const unsigned short CELL_SIZE = 32, BORDER_SIZE = 1;

const unsigned int ICON_SELECT_START_X = 50, ICON_SELECT_START_Y = 50, ICON_SELECT_SPACE = 20;
const unsigned int GRID_START_X = 30, GRID_START_Y = 30, GRID_SPACE = 5;
const unsigned int ICON_SELECT_END_Y = ICON_SELECT_START_Y + (2 * (CELL_SIZE + ICON_SELECT_SPACE));
const unsigned int PLAYER_ICONS_START_X = GRID_START_X + (3 * (CELL_SIZE + GRID_SPACE)), PLAYER_ICONS_START_Y = GRID_START_Y;
const unsigned int SCORE_START_X = PLAYER_ICONS_START_X + 20, SCORE_START_Y = GRID_START_Y + (3 * (CELL_SIZE + GRID_SPACE)) + 15;
const unsigned int FEEDBACK_START_X = 30, FEEDBACK_START_Y = SCORE_START_Y;

unsigned short grid[3][3]; //2d array to represent the grid
unsigned short currentPlayer = PLAYER_1, roundStartPlayer = PLAYER_1, numMoves = 0, numDraws = 0;
bool gameActive = true, iconSelectMode = true;

objPlayer players[2];
objSelect selector;

#endif
