// Handles all functions relating to the objects in the game
// i.e initialization, update and shutdown

#include <allegro.h>
#include <stdio.h>
#include "objects.h"
#include "man.h"
#include "bar.h"
#include "collect.h"

static man my_man;
static collect my_collect;
static bar my_bar;
DATAFILE *data;

void objects_init() {
  data = load_datafile("moonman.dat");              /* load datafile */
        if (!data) {
            printf("Error: Couldn't find moonman.dat\n");
            allegro_exit();
        }
  man_init(&my_man, 87, 40, 0, 0); 
  collect_init(&my_collect, 150, 150);
  bar_init(&my_bar, 150, 10, 170, 20, 2);
  }

void objects_update() {
  man_update(&my_man, &my_collect, data);
  collect_update(&my_collect, data);
  bar_update(&my_bar);
  }

void objects_shutdown() {
  man_shutdown(&my_man);
  collect_shutdown(&my_collect);
  bar_shutdown(&my_bar);
  }

void objects_draw(BITMAP *buffer, DATAFILE *data) {
  collect_draw(&my_collect, buffer, data);
  man_draw(&my_man, buffer, data);
  bar_draw(&my_bar, buffer);
  }