// Handles all functions relating to the man

#include <allegro.h>
#include "man.h"
#include "ivars.h"
#include "global.h"
#include "collect.h"


// sets man's initial attributes e.g x, y co-ordinates
void man_init(man *my_man, int x, int y, int dir, int trav_flag) {
  my_man->cur_x = x;
  my_man->cur_y = y;
  my_man->cur_dir = dir;
  my_man->trav = trav_flag;
  }

void man_update(man *my_man, collect *my_collect, DATAFILE *data) {
  if (my_man->trav == 1)  {   // if man is moving
    switch(my_man->cur_dir) {
      case 1 : {   // if moving right
        // next line - if man is not on one of four x grid positions
        if ((my_man->cur_x != grid_pos_x[0]) && (my_man->cur_x != grid_pos_x[1])
                && (my_man->cur_x != grid_pos_x[2]) && (my_man->cur_x != grid_pos_x[3]))  {
        my_man->cur_x++;
        }
        else unset_travel = 1;
        break;
      }
      case 2 : {   // if moving left
        // next line - if man is not on one of four x grid positions
        if ((my_man->cur_x != grid_pos_x[0]) && (my_man->cur_x != grid_pos_x[1])
                && (my_man->cur_x != grid_pos_x[2]) && (my_man->cur_x != grid_pos_x[3]))  {
        my_man->cur_x--;
        }
        else unset_travel = 1;
        break;
     }
      case 3 : {   // if moving up
        // next line - if man is not on one of four y grid positions
        if ((my_man->cur_y != grid_pos_y[0]) && (my_man->cur_y != grid_pos_y[1])
                && (my_man->cur_y != grid_pos_y[2]) && (my_man->cur_y != grid_pos_y[3]))  {
        my_man->cur_y--;
        }
        else unset_travel = 1;
        break;
      }
      case 4 : {   // if moving down
        // next line - if man is not on one of four y grid positions
        if ((my_man->cur_y != grid_pos_y[0]) && (my_man->cur_y != grid_pos_y[1])
                && (my_man->cur_y != grid_pos_y[2]) && (my_man->cur_y != grid_pos_y[3]))  {
        my_man->cur_y++;
        }
        else unset_travel = 1;
        break;
      }

    }
    if (unset_travel == 1) my_man->trav = 0;  // stop man moving
    }
  else  {
      // next line - if man has moved on top of the counter
      if ((my_man->cur_x == my_collect->collect_x) && (my_man->cur_y == my_collect->collect_y))
        {
        play_sample(data[6].dat, 255, 175, 1000, 0);  // play "collected object" sound
        score++;
        collect_time = 0;  //reset counter
        my_collect->collect_x = grid_pos_x[rand()%4];
        my_collect->collect_y = grid_pos_y[rand()%4];
        }
      if (i_rightkey) move_right(my_man);
      else if (i_leftkey) move_left(my_man);
           else if (i_upkey) move_up(my_man);
                else if (i_downkey) move_down(my_man);
     }
  }



void man_shutdown(man *my_man) {
  (void)my_man;
  }


// draws man onto video memory
void man_draw( man *my_man, BITMAP *buffer, DATAFILE *data) {
  draw_sprite(buffer, (BITMAP*)data[4].dat, my_man->cur_x, my_man->cur_y);
  }


// moves man right and sets direction
void move_right(man *my_man) {
  if (my_man->cur_x == grid_pos_x[3]) {
    my_man->cur_x = grid_pos_x[0];
    rest(200);
    }
  else {
    my_man->cur_dir = 1;
    my_man->trav = 1;
    unset_travel = 0;
    my_man->cur_x++;
    }
  }


// moves man left and sets direction
void move_left(man *my_man) {
  if (my_man->cur_x == grid_pos_x[0]) {
    my_man->cur_x = grid_pos_x[3];
    rest(200);
    }
  else {
    my_man->cur_dir = 2;
    my_man->trav = 1;
    unset_travel = 0;
    my_man->cur_x--;
    }
  }


// moves man up and sets direction
void move_up(man *my_man) {
  if (my_man->cur_y == grid_pos_y[0]) {
    my_man->cur_y = grid_pos_y[3];
    rest(200);
    }
  else {
    my_man->cur_dir = 3;
    my_man->trav = 1;
    unset_travel = 0;
    my_man->cur_y--;
    }
  }


// moves man down and sets direction
void move_down(man *my_man) {
  if (my_man->cur_y == grid_pos_y[3]) {
    my_man->cur_y = grid_pos_y[0];
    rest(200);
    }
  else {
    my_man->cur_dir = 4;
    my_man->trav = 1;
    unset_travel = 0;
    my_man->cur_y++;
    }
  }
