#include <allegro.h>
#include <midasdll.h>

#include "main.h"
#include "sound.h"

MIDASsample	s_shoot1 = NULL;
MIDASsample	s_door	 = NULL;
MIDASsample	s_spawn1 = NULL;
MIDASsample	s_spawn2 = NULL;
MIDASsample	s_jdead  = NULL;
MIDASsample	s_l2hit  = NULL;
MIDASsample	s_l2dead = NULL;
MIDASsample	s_e3amb  = NULL;
MIDASsample	s_e3dead = NULL;
MIDASsample	s_e3hit  = NULL;
MIDASsample	s_flash  = NULL;
MIDASsample	s_turn   = NULL;
MIDASsample	s_dhit   = NULL;
MIDASsample	s_ddead  = NULL;

MIDASsamplePlayHandle p_e3amb;

void sound_load()
{
	s_shoot1 = NULL;
	s_shoot1 = MIDASloadWaveSample("wave/shoot1.WAV", FALSE);
	if (!s_shoot1) shutdown(MIDASERROR);

	s_door = NULL;
	s_door = MIDASloadWaveSample("wave/door.WAV", FALSE);
	if (!s_door) shutdown(MIDASERROR);

	s_spawn1 = NULL;
	s_spawn1 = MIDASloadWaveSample("wave/spawn1.WAV", FALSE);
	if (!s_spawn1) shutdown(MIDASERROR);

	s_spawn2 = NULL;
	s_spawn2 = MIDASloadWaveSample("wave/spawn2.WAV", FALSE);
	if (!s_spawn2) shutdown(MIDASERROR);

	s_jdead = NULL;
	s_jdead = MIDASloadWaveSample("wave/jdead.WAV", FALSE);
	if (!s_jdead) shutdown(MIDASERROR);

	s_l2hit = NULL;
	s_l2hit = MIDASloadWaveSample("wave/l2hit.WAV", FALSE);
	if (!s_l2hit) shutdown(MIDASERROR);

	s_l2dead = NULL;
	s_l2dead = MIDASloadWaveSample("wave/l2dead.WAV", FALSE);
	if (!s_l2dead) shutdown(MIDASERROR);

	s_e3amb = NULL;
	s_e3amb = MIDASloadWaveSample("wave/e3amb.WAV", TRUE);
	if (!s_e3amb) shutdown(MIDASERROR);

	s_e3hit = NULL;
	s_e3hit = MIDASloadWaveSample("wave/e3hit.WAV", FALSE);
	if (!s_e3hit) shutdown(MIDASERROR);

	s_e3dead = NULL;
	s_e3dead = MIDASloadWaveSample("wave/e3dead.WAV", FALSE);
	if (!s_e3dead) shutdown(MIDASERROR);

	s_flash = NULL;
	s_flash = MIDASloadWaveSample("wave/flash.WAV", FALSE);
	if (!s_flash) shutdown(MIDASERROR);

	s_turn = NULL;
	s_turn = MIDASloadWaveSample("wave/turn.WAV", FALSE);
	if (!s_turn) shutdown(MIDASERROR);

	s_dhit = NULL;
	s_dhit = MIDASloadWaveSample("wave/dhit.WAV", FALSE);
	if (!s_dhit) shutdown(MIDASERROR);

	s_ddead = NULL;
	s_ddead = MIDASloadWaveSample("wave/ddead.WAV", FALSE);
	if (!s_ddead) shutdown(MIDASERROR);

}

void sound_unload()
{
	if (s_shoot1)
		MIDASfreeSample(s_shoot1);
	s_shoot1 = NULL;

	if (s_door)
		MIDASfreeSample(s_door);
	s_door = NULL;

	if (s_spawn1)
		MIDASfreeSample(s_spawn1);
	s_spawn1 = NULL;

	if (s_spawn2)
		MIDASfreeSample(s_spawn2);
	s_spawn2 = NULL;

	if (s_jdead)
		MIDASfreeSample(s_jdead);
	s_jdead = NULL;

	if (s_l2dead)
		MIDASfreeSample(s_l2dead);
	s_l2dead = NULL;

	if (s_l2hit)
		MIDASfreeSample(s_l2hit);
	s_l2hit = NULL;

	if (s_e3dead)
		MIDASfreeSample(s_e3dead);
	s_e3dead = NULL;

	if (s_e3hit)
		MIDASfreeSample(s_e3hit);
	s_e3hit = NULL;

	if (s_e3amb)
		MIDASfreeSample(s_e3amb);
	s_e3amb = NULL;

	if (s_flash)
		MIDASfreeSample(s_flash);
	s_flash = NULL;

	if (s_turn)
		MIDASfreeSample(s_turn);
	s_turn = NULL;

	if (s_ddead)
		MIDASfreeSample(s_ddead);
	s_ddead = NULL;

	if (s_dhit)
		MIDASfreeSample(s_dhit);
	s_dhit = NULL;


}

MIDASsamplePlayHandle sound_play(MIDASsample *snd)
{
	return MIDASplaySample(*snd, MIDAS_CHANNEL_AUTO, 100, 11025, 64, MIDAS_PAN_MIDDLE);
}

void e3amb_play(void)
{
	p_e3amb = MIDASplaySample(s_e3amb, 7, 10000, 11025, 64, MIDAS_PAN_MIDDLE);
}

void e3amb_stop(void)
{
	MIDASstopSample(p_e3amb);
}