#include <allegro.h>
#include <string.h>
#include <stdio.h>

#include "main.h"
#include "level.h"
#include "sound.h"
#include "game.h"
#include "object.h"

DATAFILE	*tiles = NULL;

#define DOOR_SPEED			6
#define DOOR_CLOSE_TICKS	85

MAP::MAP(void)
{
	Clear();
}

MAP::~MAP(void)
{
}


void MAP::Clear(void)
{
	memset(map, 0, sizeof(map));
	door_x = 0;
	door_open = false;
	door_ticks = 0;
	door_closeticks = DOOR_CLOSE_TICKS;

	OBJITEM       *obj;
	OBJECT_BASE   *base;

	if (objlist)
	{
		obj = objlist->GetFirst();
		while(obj)
		{
		  base = obj->GetData();
		  base->remove = true;
		  obj = obj->next;
		}
	}
	
	if (player)
		player->remove = false;

	enemy_count	= 0;
	e3 = false;
	enemy_max	= 3;
	enemy_killed= 0;
	enemy_killedmax = 20;

	finished = false;
	dead	 = false;
	endticks = 150;
}

bool MAP::Load(int level)
{
	char	fname[200];
	FILE	*f = NULL;

	Clear();

	sprintf(fname, "levels\\l%0.3d", level);

	f = fopen(fname, "r");
	if (!f)
		return false;

	fread(map, 1, sizeof(map), f);
	fclose(f);

	return true;
}

bool MAP::Save(int level)
{
	char	fname[200];
	FILE	*f = NULL;

	sprintf(fname, "levels\\l%0.3d", level);

	f = fopen(fname, "w");
	if (!f)
		shutdown("could not open map");

	fwrite(map, 1, sizeof(map), f);
	fclose(f);

	return true;
}

void MAP::SuperLoad(int level)
{
	BITMAP*		buffer = create_bitmap(320, 240);
	int			sy = 120;

	clear(buffer);
	Draw(buffer);

	sound_play(&s_turn);

	gametick = 0;

	while (sy > 0)
	{
		while (gametick > 0)
		{
			gametick--;
			sy-=2;
		}

		blit((BITMAP*) game_dat[G_BACK].dat, backbuffer, 0, 0, 0, 0, 320, 240);
		stretch_sprite(backbuffer, buffer, 0, 120-sy, 320, sy*2);
		flip();
	}
	
	Load(level);
	clear(buffer);
	Draw(buffer);

	gametick = 0;

	while (sy < 120)
	{
		while (gametick > 0)
		{
			gametick--;
			sy+=2;
		}

		blit((BITMAP*) game_dat[G_BACK].dat, backbuffer, 0, 0, 0, 0, 320, 240);
		stretch_sprite(backbuffer, buffer, 0, 120-sy, 320, sy*2);
		flip();
	}

	destroy_bitmap(buffer);
}



void MAP::Draw(BITMAP *buffer)
{
	int	x, y;

	for (x = 0; x < MAP_WIDTH; x++)
	{
		for (y = 0; y < MAP_HEIGHT; y++)
		{
			if (!((x == 2) && (y == 14)))
			{
				draw_sprite(buffer, (BITMAP*) tiles[map[x+y*MAP_WIDTH]].dat, x * TILESIZE, y * TILESIZE);
			} else
			{
				draw_sprite(buffer, (BITMAP*) tiles[map[x+y*MAP_WIDTH]].dat, x * TILESIZE + door_x, y * TILESIZE);
			}

		}
	}
}

void MAP::Update(void)
{
	if (enemy_count < 0) enemy_count = 0;

	if (door_ticks > 0)
		door_ticks--;

	if ((door_closeticks > 0) && (door_open) && (door_x == TILESIZE-1))
	{
		door_closeticks--;
		if (door_closeticks == 0)
			CloseDoor();
	}

	if (door_open)
	{
		if (door_x < TILESIZE)
		{
			if (door_ticks == 0)
			{
				door_x++;
				if (door_x >= TILESIZE) door_x = TILESIZE - 1;
				door_ticks = DOOR_SPEED;
			}
		}
	} else
	if (!door_open)
	{
		if (door_x > 0)
		{
			if (door_ticks == 0)
			{
				door_x--;
				if (door_x < 0) door_x = 0;
				door_ticks = DOOR_SPEED;
			}
		}
	}

	if (!door_open)
	if (rand()%100 > 95)
	{
		if (enemy_count < enemy_max)
		{
			if (enemy_killed + enemy_count < 7)
				new OBJECT_ENEMY1((rand()%MAP_WIDTH)*TILESIZE, (rand()%(MAP_HEIGHT-1))*TILESIZE, 1);
			else
			if( enemy_killed + enemy_count < 14)
				new OBJECT_ENEMY1((rand()%MAP_WIDTH)*TILESIZE, (rand()%MAP_HEIGHT)*TILESIZE, (rand()%100>80) ? 1 : 2);
			else
			if ((enemy_killed == 14) && (enemy_count == 0))
				new OBJECT_ENEMY1((rand()%MAP_WIDTH)*TILESIZE, (rand()%MAP_HEIGHT)*TILESIZE, 3);

		}
	}
	if ((enemy_killed == 15) || (dead))
		endticks--;
	if (endticks <= 0) finished = true;
}

void MAP::OpenDoor(void)
{
	door_open = true; 
	sound_play(&s_door);
	door_closeticks = DOOR_CLOSE_TICKS;
}

void MAP::CloseDoor(void)
{
	door_open = false; 
	sound_play(&s_door);
}

bool MAP::IsFree(int x, int y, int dir)
{
	if (dir == DIR_LEFT)
		x--;
	else
	if (dir == DIR_RIGHT)
		x++;
	else
	if (dir == DIR_UP)
		y--;
	else
	if (dir == DIR_DOWN)
		y++;

	if ((x > -1) && (x < MAP_WIDTH) && (y > -1) && (y < MAP_HEIGHT))
		if (map[x+y*MAP_WIDTH] == 0) return true;

	return false;
}

bool MAP::CollCheck(int x, int y)
{
	if (GetTile(x, y) > 0) return true; else
	if (GetTile(x+TILESIZE-1, y) > 0) return true; else
	if (GetTile(x, y+TILESIZE-1) > 0) return true; else
	if (GetTile(x+TILESIZE-1, y+TILESIZE-1) > 0) return true;


	return false;
}

int MAP::GetTile(int x, int y)
{
	int tx, ty;
	tx = x / TILESIZE;
	ty = y / TILESIZE;

	if ((tx == 2) && (ty == 14) && (door_open))
		return 0;

	if (tx+ty*MAP_WIDTH >= MAP_WIDTH*MAP_HEIGHT) return 0;
	
	else return map[tx+ty*MAP_WIDTH];
}

void MAP::Flash()
{
	PALETTE white;

	for (int i = 0; i < 256; i++)
	{
		white[i].r = 63;
		white[i].g = 63;
		white[i].b = 63;
	}


	gametick = 0;

	sound_play(&s_flash);
	while (gametick < 40)
	{
		if (gametick % 2 == 0)
		{
			set_palette(white);
		}

		set_palette(*game_pal);
	}

	gametick = 0;
}
