#include <allegro.h>
#include <memory.h>

#include "main.h"
#include "game.h"
#include "sound.h"
#include "object.h"
#include "level.h"

OBJECT_BASE     *player = NULL;
OBJLIST         *objlist = NULL;
OBJLIST         *projectiles = NULL;
OBJLIST         *actors = NULL;
MAP				*level = NULL;


bool			exitgame = false;
bool			exitlevel = false;
int			current_level = 0;

int			blink_val = 0;
int			blink_dir = 1;
bool			blink_pal = false;

int			lives = 3;

PALETTE blink;

void game_init(void)
{
  objlist = new OBJLIST;
  projectiles = new OBJLIST;
  actors = new OBJLIST;

  player = new OBJECT_BASE;

  player->x = 2 * TILESIZE;
  player->y = 14 * TILESIZE;
  player->dir = DIR_UP;
  player->gfx[0] = (BITMAP*) game_dat[G_DENUP].dat;
  player->gfx[1] = (BITMAP*) game_dat[G_DENDOWN].dat;
  player->gfx[2] = (BITMAP*) game_dat[G_DENLEFT].dat;
  player->gfx[3] = (BITMAP*) game_dat[G_DENRIGHT].dat;
  player->move_speed = 1;
  player->spawndelay = 150;


  sound_load();

  MIDASmodule mod = NULL;
  MIDASmodulePlayHandle handle = 0;

  get_palette_range(blink, 160, 191);

//  mod = MIDASloadModule("music\\equinox2.mod");
///  if (mod) handle = MIDASplayModule(mod,TRUE);
  //if (handle) MIDASsetMusicVolume(handle, 30);
}

void game_control()
{
  if (key[KEY_ESC])
	  exitlevel = true;

  if (level->door_open) return;
  if (level->dead) return;

  if (key[KEY_LEFT])
  {
    player->dir = DIR_LEFT;
  }
  if (key[KEY_RIGHT])
  {
    player->dir = DIR_RIGHT;
  }

  if (key[KEY_UP])
  {
	player->dir = DIR_UP;
  }
  if (key[KEY_DOWN])
  {
	player->dir = DIR_DOWN;
  }

  if (key[KEY_SPACE])
  {
	player->shoot();
  }

  if (key[KEY_F12])
	  Capture_Screen();
}

void game_loop()
{
	game_init();
	level = new MAP;
	level->SuperLoad(current_level);
	while (!exitgame)
	{
	  level->OpenDoor();

	  player->x = 2 * TILESIZE;
	  player->y = 14 * TILESIZE;
	  player->dir = DIR_UP;
	  player->hp  = 3;
	  player->olddir = DIR_UP;
	  player->spawndelay = 150;

	  gametick = 0;
	  while (!exitlevel)
	  {
		while (gametick > 0)
		{
			game_control();
			game_update();
			gametick--;
		}
		game_draw();
		if (blink_pal)
			set_palette_range(blink, 160, 191, FALSE);
		flip();
	  }

	  e3amb_stop();

	  if (!level->dead) current_level++; else lives--;
	  exitlevel = false;

	  if (lives < 0) game_over();

	  if (key[KEY_ESC])
		  exitgame = true;
	  else
	  if (current_level == 10) 
		  game_finished();
	  else
		  level->SuperLoad(current_level);
	}
	game_quit();
	fade_out(1);
}

void game_quit()
{
  delete player;
  player = NULL;

  delete objlist;
  objlist = NULL;

  delete projectiles;
  projectiles = NULL;

  delete actors;
  actors = NULL;

  sound_unload();
}

void game_draw()
{
  OBJITEM       *obj;
  OBJECT_BASE   *base;
  int           i;

  blit((BITMAP*) game_dat[G_BACK].dat, backbuffer, 0, 0, 0, 0, 320, 240);
  level->Draw(backbuffer);

  obj = objlist->GetFirst();
  while(obj)
  {
    base = obj->GetData();
    base->draw();
    obj = obj->next;
  }

  int x = 10;
  for (i = 0; i < player->hp; i++)
  {
	  draw_sprite(backbuffer, (BITMAP*) game_dat[G_HEART].dat, x, 5);
	  x += 20;
  }

  x = 290;
  for (i = 0; i < lives; i++)
  {
	  if ((level->dead) && ( i == lives-1 ) && (tick % 10 > 5)) continue;
	  draw_sprite(backbuffer, (BITMAP*) game_dat[G_DENUP].dat, x, 5);
	  x -= 20;
  }

//  textprintf(backbuffer, font, 0, 0, 15, "%d %d %d", level->enemy_count, level->enemy_max, level->enemy_killed);


};

void game_update()
{
  OBJITEM       *obj, *tmp;
  OBJECT_BASE   *base;

  obj = objlist->GetFirst();
  while(obj)
  {
    tmp = obj->next;

    base = obj->GetData();
    if (base->remove)
    {
      if (base->removeticks == 0)
      {
        delete base;
      }
      else
      {
        base->removeticks--;
      }
    }
    obj = tmp;
  }

  obj = objlist->GetFirst();
  while(obj)
  {
    base = obj->GetData();
    base->update();
    obj = obj->next;
  }

  level->Update();
  if (level->finished) exitlevel = true;

  if (level->e3)
  {
	if (blink_dir == 1)
	{
		blink_val++;
		if (blink_val > 30)
			blink_dir = -1;
	} else
	{
		blink_val--;
		if (blink_val <= 0)
			blink_dir = 1;
	}

	int	  i;

	for ( i = 160; i < 191; i++)
	{
		blink[i].r += blink_dir; if (blink[i].r > 63) blink[i].r -= blink_dir; if (blink[i].r < 0) blink[i].r -= blink_dir;
		blink[i].g += blink_dir; if (blink[i].g > 63) blink[i].g -= blink_dir; if (blink[i].g < 0) blink[i].g -= blink_dir;
		blink[i].b += blink_dir; if (blink[i].b > 63) blink[i].b -= blink_dir; if (blink[i].b < 0) blink[i].b -= blink_dir; 
	}
	blink_pal = true;
  }
  else
  {
	  if (blink_pal)
	  {
		  set_palette(*game_pal);
		  blink_pal = false;
	  }
  }

}
