/********************************
/ DataList.h			AUTHOR: Joerg Rueppel
/ Double Linked List Class
/********************************/

#ifndef DATALIST_H
#define DATALIST_H

#include <allegro.h>

/* ONE SINGLE LISTITEM
*/
template <class T>
class DATAITEM
{
public:
	DATAITEM(void);

	void		SetData(T ptr);
	T		GetData(void);

	DATAITEM	*next;
	DATAITEM	*prev;

protected:
	T			data;
};

/* LIST CONTROL
*/
template <class T>
class DATALIST
{
public:
	DATALIST(void);
	~DATALIST(void);

	void		Insert(DATAITEM<T> *i, T ptr);
	void		Push_Front(T ptr);
	void		Push_Back(T ptr);
	DATAITEM<T>	*Delete(DATAITEM<T> *ptr);
	DATAITEM<T>	*Delete(T ptr);
	void		Clear(void);

	DATAITEM<T>	*GetFirst(void) { current = first; return first; }
	DATAITEM<T>	*GetLast(void)  { current = last;  return last;  }
	DATAITEM<T>	*GetCurrent(void){ return current; }

        int             Size(void) {return size;}

protected:
	DATAITEM<T>	*first;
	DATAITEM<T>	*last;
	DATAITEM<T>     *current;

        int             size;
};

// DATAITEM Constructor
template <class T> DATAITEM<T>::DATAITEM(void)
{
	data = NULL;
	prev = NULL;
	next = NULL;
}

// Set Datapointer
template <class T> void DATAITEM<T>::SetData(T ptr)
{
	data = ptr;
}

// Get Datapointer
template <class T> T DATAITEM<T>::GetData(void)
{
	return data;
}

// DATALIST Constructor
template <class T> DATALIST<T>::DATALIST(void)
{
	first = NULL;
	last  = NULL;
	current = NULL;
        size    = 0;
}

// DATALIST Destructor
template <class T> DATALIST<T>::~DATALIST(void)
{
	Clear();
	return;
}

// deletes all entries in list
template <class T> void DATALIST<T>::Clear(void)
{
	DATAITEM<T> *temp, *temp2;

	// delete remaining listitems
	temp = first;
	while (temp)
	{
		temp2 = temp->next;
		delete temp;
		temp = temp2;
	}

        size = 0;
	first = last = current = NULL;
}

// Insert datapointer at current position
template <class T> void DATALIST<T>::Insert(DATAITEM<T> *i, T ptr)
{
	// create listitem
	DATAITEM<T> *data = NULL;
	data = new DATAITEM<T>;
	if (!data) return;

	// set data
	data->SetData(ptr);
        size++;

	current = i;

	// if list is empty
	if (!first)
	{
		first = data;
		last = data;
		current = data;
		return;
	} else
	// insert in between
	{
		data->next = current->next;
		current->next = data;
		data->prev = current;
		if (data->next)
			data->next->prev = data;
		else
			last = data;
	}
}

// Insert datapointer at beginning of list
template <class T> void DATALIST<T>::Push_Front(T ptr)
{
	// create listitem
	DATAITEM<T> *data = NULL;
	data = new DATAITEM<T>;
	if (!data) return;

	// set data
	data->SetData(ptr);
        size++;

	// empty list
	if (!last)
	{
		first = data;
		last = data;
		current = data;
		return;
	}
	else
	// insert
	{
		data->next = first;
		first->prev = data;
		first = data;
	}
}

// Append datapointer at end of list
template <class T> void DATALIST<T>::Push_Back(T ptr)
{
	// create listitem
	DATAITEM<T> *data = NULL;
	data = new DATAITEM<T>;
	if (!data) return;

	// set data
	data->SetData(ptr);
        size++;

	// empty list
	if (!last)
	{
		first = data;
		last = data;
		current = data;
		return;
	}
	else
	// append
	{
		last->next = data;
		data->prev = last;
		last = data;
	}
}

// search list for data and delete this item
template <class T> DATAITEM<T> *DATALIST<T>::Delete(T ptr)
{
	DATAITEM<T>	*tmp;

	// search list
	tmp = first;
	while (tmp)
	{
		if (tmp->GetData() == ptr)
			break;
		tmp = tmp->next;
	}
	// not found
	if (!tmp) return NULL;

	// call standard delete
	return Delete(tmp);
}

// delete given item from list
template <class T> DATAITEM<T> *DATALIST<T>::Delete(DATAITEM<T> *ptr)
{
        DATAITEM<T> *old;
        if (!ptr) return NULL;
        size--;

	// only element in list
	if ((!ptr->prev) && (!ptr->next))
	{
		delete ptr;
		last = first = current = NULL;
		return NULL;
	}
	else
	// first element 
	if (!ptr->prev)
	{
	        old = ptr->next;
		ptr->next->prev = NULL;
		first = ptr->next;
		delete ptr;
		return old;
	} else
	// last element
	if (!ptr->next)
	{
	        old = ptr->next;
		ptr->prev->next = NULL;
		last = ptr->prev;
		delete ptr;
		return old;
	} else
	// somewhere in between
	{
	        old = ptr->next;
		ptr->next->prev = ptr->prev;
		ptr->prev->next = ptr->next;
		delete ptr;
		return old;
	}
}
#endif
