#ifndef _OBJECT_H_
#define _OBJECT_H_

#include <allegro.h>

#include "datalist.h"
#include "level.h"

#define  DIR_UP			0
#define  DIR_LEFT		1
#define  DIR_DOWN		2
#define  DIR_RIGHT      3

#define	 SHOOT_DELAY	10

enum OBJ_TYPES
{
	OBJ_PLAYER = 0,
	OBJ_ENEMY,
	OBJ_PROJ,
	OBJ_COUNT
};

class OBJECT_BASE
{
  public:
    OBJECT_BASE();
    ~OBJECT_BASE();

    virtual  void  move(bool recurse = false);
    virtual  void  draw();
	virtual	 void  update();

	bool			coll;

	void			shoot();

    bool           remove;
    int            removeticks;
	int			   spawndelay;

	int			   type;

    fix            x;
    fix            y;

    int            vx;
    int            vy;

	int			   hp;

	fix			   move_speed;

	int			   shoot_tick;

    int            dir, olddir;


	BITMAP		   *cur_gfx;
    BITMAP         *gfx[20];
	bool		   trans;
};

extern OBJECT_BASE     *player;

typedef DATALIST<OBJECT_BASE*>  OBJLIST;
typedef DATAITEM<OBJECT_BASE*>  OBJITEM;

extern OBJLIST  *objlist;
extern OBJLIST  *projectiles;
extern OBJLIST  *actors;


class OBJECT_PROJECTILE : public OBJECT_BASE
{
  public:
    OBJECT_PROJECTILE(OBJECT_BASE *own);
    ~OBJECT_PROJECTILE();

    virtual void move(bool recurse = false);
	virtual void update(void);

    bool	friendly;
};

class OBJECT_ANIM : public OBJECT_BASE
{
public:
	OBJECT_ANIM(int x, int y, int first, int count, int speed, bool trans = false);
	virtual void draw();
	virtual void update();

	int f, c, s, p, t;
};

class OBJECT_ENEMY1 : public OBJECT_BASE
{
  public:
    OBJECT_ENEMY1(int x, int y, int lev);
    ~OBJECT_ENEMY1(void);

    virtual void update();

	int			lev;
};

class OBJECT_EXPLODE : public OBJECT_BASE
{
public:
	OBJECT_EXPLODE(BITMAP* gfx, int x, int y, bool reverse, int dark, int light);

	virtual void	draw();
	virtual void	update();

	bool			reverse;
	fix				px[TILESIZE * TILESIZE];
	fix				py[TILESIZE * TILESIZE];
	fix				vx[TILESIZE * TILESIZE];
	fix				vy[TILESIZE * TILESIZE];
	int				col[TILESIZE * TILESIZE];
	int				dark;
	int				lifetime;
};

#endif