#include <allegro.h>
#include <winalleg.h>
#include <midasdll.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>


#include "main.h"
#include "sound.h"
#include "game.h"
#include "edit.h"

DATAFILE		*game_dat = NULL;
PALETTE		*game_pal = NULL;
COLOR_MAP	*trans_map = NULL;

BITMAP		*backbuffer = NULL;

volatile	int	tick = 0;
volatile	int	gametick = 0;

void game_speed(void)
{
  tick++;
  gametick++;
}
END_OF_FUNCTION(game_speed);

void exit_func()
{
	MIDASclose();
}

void shutdown(char *buf, ...)
{
    va_list args;
    char msg[1024];
	
	if (buf)
	{
		va_start(args, buf);
		vsprintf(msg, buf, args);
		va_end(args);
		allegro_message(msg);
	}

	sound_unload();

	destroy_bitmap(backbuffer);

	if (game_dat)
		unload_datafile(game_dat);

	if (tiles)
		unload_datafile(tiles);

	delete trans_map;

	set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
	MessageBox(win_get_window(), "Monster Mash! v1.0\n(c)2000 by Jrg Rppel/Genlog Productions\nhttp://www.sharky-x.de\n\nThis game has been developed with the awesome Allegro game library - the complete development time is 4 days. It was supposed to enter the speedgame compo, but I had no time during this weekend so I coded it a few days later. I hope you enjoyed playing this game.\n\nContact: sharky-x@gmx.net", "Monster Mash! v1.0", MB_OK | MB_RIGHT | MB_ICONINFORMATION);

	exit(0);
}


void intro()
{
	PALETTE* title_pal;
	BITMAP *title;

	title = (BITMAP*) game_dat[G_TITLE].dat;
	title_pal = (PALETTE*) game_dat[G_TITLEPAL].dat;

	set_palette(black_palette);
	stretch_sprite(screen, title, 0, 0, 320, 240);
	fade_in(*title_pal, 1);

	clear_keybuf();
	while (!keypressed());

	fade_out(1);
	clear(screen);
	stretch_sprite(screen, (BITMAP*) game_dat[G_BACK].dat, 0, 0, 320, 240);
}

void game_finished()
{
	shutdown(NULL);
}


void game_over()
{
	shutdown(NULL);
}

void info()
{
	
}


void flip()
{
	acquire_screen();
	blit(backbuffer, screen, 0, 0, 0, 0, 320, 240);
	release_screen();
	clear(backbuffer);
}

void Capture_Screen()
{
  BITMAP* bmp;
  PALETTE p;
  char s[100];
  int i;

  get_palette(p);
  bmp = create_sub_bitmap(screen, 0, 0, SCREEN_W, SCREEN_H);

  i = 0;
  do
  {
    sprintf(s, "scrn%d.pcx", i);
    i++;
  } while (exists(s));

  save_bitmap(s, bmp, p);
  destroy_bitmap(bmp);
}

void main(int argc, char *argv[])
{
	// setup system
	allegro_init();
	set_window_title("Monster Mash!");

	install_timer();
	install_keyboard();

	srand( (unsigned)time( NULL ) );

	// setup sound
	if (MIDASstartup() == FALSE) 
		shutdown(MIDASERROR);
	//MIDASloadConfig("sound.cfg");
	MIDASsetOption(MIDAS_OPTION_DSOUND_MODE, MIDAS_DSOUND_FORCE_STREAM );
	MIDASsetOption(MIDAS_OPTION_DSOUND_HWND, (DWORD) win_get_window());
	if (MIDASinit() == FALSE) 
		 shutdown(MIDASERROR);
	if (MIDASstartBackgroundPlay(0) == FALSE) 
		shutdown(MIDASERROR);
	if (MIDASopenChannels(30) == FALSE) 
		shutdown(MIDASERROR);
	if (MIDASallocAutoEffectChannels(6) == FALSE) 
		shutdown(MIDASERROR);

	atexit(exit_func);

	LOCK_FUNCTION(game_speed);
	LOCK_VARIABLE(tick);
	LOCK_VARIABLE(gametick);
	install_int_ex(game_speed, BPS_TO_TIMER(50));
	// load game datafile
	game_dat = NULL;
	game_dat = load_datafile("game.dat");
	if (!game_dat)
		shutdown("could not open game.dat");

	// load tiles
	tiles = NULL;
	tiles = load_datafile("tiles.dat");
	if (!tiles)
		shutdown("could not open tiles.dat");

	// get palette from data
	game_pal = (PALETTE*) (game_dat[G_GAMEPAL].dat);

	if (set_gfx_mode(GFX_AUTODETECT, 320, 240, 0, 0) < 0)
		shutdown("gfx: %s", allegro_error);

	trans_map = new COLOR_MAP;
	create_trans_table(trans_map, *game_pal , 128, 128, 128, NULL);
	color_map = trans_map;

	// create backbuffer
	backbuffer = create_bitmap(320, 240);
	clear(backbuffer);

	// wait a moment
	rest ( 1000 );

	clear(backbuffer);
	clear(screen);

	set_palette(*game_pal);
	text_mode(-1);

	// start game
	if ((argc > 1) && (strcmp(argv[1], "-edit") == 0))
		edit_loop();
	else
	{
		// play intro
		intro();
		fade_in(*game_pal, 1);
		game_loop();
	}

	// exit
	shutdown(NULL);
}
END_OF_MAIN();