#ifndef _LEVEL_H_
#define _LEVEL_H_

#include <allegro.h>

#define  TILESIZE		16
#define  MAP_WIDTH		320 / TILESIZE
#define  MAP_HEIGHT		240 / TILESIZE

class MAP
{
public:
	MAP(void);
	~MAP(void);

	bool	
		Load(int	level);
	void
		SuperLoad( int level );
	bool
		Save(int	level);
	void
		Draw(BITMAP *buffer);
	void
		Clear( void );
	void
		Update( void );

	void
		Flash(void);

	void 
		OpenDoor();
	void 
		CloseDoor();
	
	int	
		GetTile(int x, int y);

	bool
		IsFree(int x, int y, int dir);
	bool
		CollCheck(int x, int y);
	bool
		IsDoorOpen(void) { if ((door_open) && (door_x == TILESIZE -1)) return true; else return false; }


	int	map[MAP_WIDTH*MAP_HEIGHT];

	bool	door_open;
	int		door_x;
	int		door_ticks;
	int		door_closeticks;

	int		enemy_max;
	int		enemy_count;
	int		enemy_killed;
	int		enemy_killedmax;

	bool	finished;
	bool	e3;
	int		endticks;
	bool	dead;
};

#endif