#include <allegro.h>

#include "..\program\gfx\tiles\tiles.h"

#include "main.h"
#include "level.h"
#include "edit.h"
#include "sound.h"
#include "object.h"

MAP		*elevel = NULL;
int		edit_num = 0;
int		edit_x = 0;
int		edit_y = 0;
int		edit_tile = 1;
int		key_timer;

void edit_init()
{
	objlist = new OBJLIST;
	projectiles = new OBJLIST;
	actors = new OBJLIST;
	sound_load();
	elevel = new MAP;
	elevel->Clear();
}

void edit_loop()
{
	edit_init();

	while (!key[KEY_ESC])
	{
		edit_control();
		edit_draw();
		flip();
	}

	edit_quit();
}

void edit_quit()
{
	delete elevel;
	delete objlist;
	delete actors;
	delete projectiles;
	objlist = actors = projectiles = NULL;
}

void edit_draw()
{
	elevel->Draw(backbuffer);

	draw_sprite(backbuffer, (BITMAP*) tiles[edit_tile].dat, edit_x * TILESIZE, edit_y * TILESIZE);
	rect(backbuffer, edit_x * TILESIZE, edit_y * TILESIZE, edit_x * TILESIZE + TILESIZE, edit_y * TILESIZE + TILESIZE, makecol(200, 200, 200));

	textprintf(backbuffer, font, 0, 0, makecol(0, 200, 0), "%d %d %d", edit_x, edit_y, edit_num);
}

#define KEY_DELAY	25

void edit_control()
{
	key_timer--;
	if (key_timer > 0) return;

	if (key[KEY_DOWN])
	{
		edit_y++;
		if (edit_y >= MAP_HEIGHT) edit_y = MAP_HEIGHT-1;
		key_timer = KEY_DELAY;
	}
	if (key[KEY_UP])
	{
		edit_y--;
		if (edit_y < 0) edit_y = 0;
		key_timer = KEY_DELAY;
	}
	if (key[KEY_RIGHT])
	{
		edit_x++;
		if (edit_x >= MAP_WIDTH) edit_x = MAP_WIDTH - 1;
		key_timer = KEY_DELAY;
	}
	if (key[KEY_LEFT])
	{
		edit_x--;
		if (edit_x < 0) edit_x = 0;
		key_timer = KEY_DELAY;
	}
	if (key[KEY_SPACE])
	{
		elevel->map[edit_x + edit_y * MAP_WIDTH] = edit_tile;
	}
	if (key[KEY_PLUS_PAD])
	{
		edit_tile++;
		if (edit_tile >= T_COUNT) edit_tile = T_COUNT - 1;
		key_timer = KEY_DELAY;
	}
	if (key[KEY_MINUS_PAD])
	{
		edit_tile--;
		if (edit_tile < 0) edit_tile = 0;
		key_timer = KEY_DELAY;
	}
	if (key[KEY_1])
	{
		edit_num = 0;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_2])
	{
		edit_num = 1;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_3])
	{
		edit_num = 2;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_4])
	{
		edit_num = 3;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_5])
	{
		edit_num = 4;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_6])
	{
		edit_num = 5;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_7])
	{
		edit_num = 6;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_8])
	{
		edit_num = 7;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_9])
	{
		edit_num = 8;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_0])
	{
		edit_num = 9;
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_S])
	{
		elevel->Save(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_L])
	{
		elevel->Load(edit_num);
		key_timer = KEY_DELAY;
	}
	if (key[KEY_C])
	{
		elevel->Clear();
		key_timer = KEY_DELAY;
	}
}
