#include <allegro.h>

#include "main.h"
#include "game.h"
#include "object.h"
#include "level.h"
#include "sound.h"

OBJECT_BASE::OBJECT_BASE(void)
{
  x = y = vx = vy = 0;
  trans = false;

  type = OBJ_PLAYER;

  dir = DIR_UP;

  gfx[0] = NULL;

  remove = false;
  removeticks = 1;

  move_speed = 1;

  shoot_tick = 0;

  olddir = 0;

  objlist->Push_Back(this);
}

OBJECT_BASE::~OBJECT_BASE(void)
{
  objlist->Delete(this);
  if (type == OBJ_PROJ)
	  projectiles->Delete(this);
  if (type == OBJ_ENEMY)
	  level->enemy_count--;
  return;
}

void OBJECT_BASE::update(void)
{
	if (remove) return;
	if (spawndelay > 0) { spawndelay--; if (spawndelay == 0) sound_play(&s_spawn1); return; }
	move();
	olddir = dir;
	if (shoot_tick > 0)
		shoot_tick--;

	OBJECT_PROJECTILE	*tmp = NULL;
	OBJITEM				*tmp2 = NULL;

	tmp2 = (OBJITEM*) projectiles->GetFirst();
	if (level->dead) tmp2 = NULL;

	while (tmp2)
	{
		tmp = (OBJECT_PROJECTILE*) tmp2->GetData();
		if ((tmp->remove) || (tmp->friendly)) { tmp2 = tmp2->next; continue; }

  			if
			(((tmp->x >= (int)x) && 
			(tmp->y >= (int)y) && 
			(tmp->x <= (int)x + TILESIZE) && 
			(tmp->y <= (int)y + TILESIZE)) ||
			((x >= tmp->x) && 
			(  y >= tmp->y) && 
			(  x <= tmp->x + TILESIZE) && 
			(  y <= tmp->y + TILESIZE)))
			{
				hp--;
				tmp->remove = true;
				new OBJECT_EXPLODE(cur_gfx, tmp->x, tmp->y, false, 16, 26);

				sound_play(&s_dhit);
				if (hp == 0)
				{
					level->dead = true;
					new OBJECT_EXPLODE(cur_gfx, tmp->x, tmp->y, false, 0, 15);
					sound_play(&s_ddead);
				}
			}
		tmp2 = tmp2->next;
	}
}

void OBJECT_BASE::shoot(void)
{
	if (spawndelay > 0) return;
	if (remove) return;

	if (shoot_tick > 0) return;
	else
	{
		new OBJECT_PROJECTILE(this);
		shoot_tick = SHOOT_DELAY;
	}
}

void OBJECT_BASE::move(bool recurse)
{
	if (spawndelay > 0) return;
	if (remove) return;
	coll = false;
	if (dir == DIR_UP)
	{
		y -= move_speed;
		if (level->CollCheck(x, y))
		{
			y += move_speed;
			y -= 1;
			if (level->CollCheck(x, y))
			{
				y += 1;
				dir = olddir;
				coll = true;
				if (!recurse) move(true);
			}
		}
	} else
	if (dir == DIR_DOWN)
	{
		y += move_speed;
		if (level->CollCheck(x, y))
		{
			y -= move_speed;
			y += 1;
			if (level->CollCheck(x, y))
			{
				y -= 1;
				dir = olddir;
				coll = true;
				if (!recurse) move(true);
			}
		}
	} else
	if (dir == DIR_LEFT)
	{
		x -= move_speed;
		if (level->CollCheck(x, y))
		{
			x += move_speed;
			x -= 1;
			if (level->CollCheck(x, y))
			{
				x += 1;
				dir = olddir;
				coll = true;
				if (!recurse) move(true);
			}
		}
	} else
	if (dir == DIR_RIGHT)
	{
		x += move_speed;
		if (level->CollCheck(x, y))
		{
			x -= move_speed;
			x += 1;
			if (level->CollCheck(x, y))
			{
				x -= 1;
				dir = olddir;
				coll = true;
				if (!recurse) move(true);
			}
		}
	}
}


void OBJECT_BASE::draw(void)
{
	if (remove) return;
	if (spawndelay > 0) return;
	if ((type == OBJ_PLAYER) && (level->dead)) return;

	if (dir == DIR_UP)
	{
			if (!trans)
				draw_sprite(backbuffer, gfx[0], x, y);
			else
				draw_trans_sprite(backbuffer, gfx[0], x, y);

				cur_gfx = gfx[0];
	} else
	if (dir == DIR_DOWN)
	{
			if (!trans)
				draw_sprite(backbuffer, gfx[1], x, y);
			else
				draw_trans_sprite(backbuffer, gfx[1], x, y);

				cur_gfx = gfx[1];

	} else
	if (dir == DIR_LEFT)
	{
			if (!trans)
				draw_sprite(backbuffer, gfx[2], x, y);
			else
				draw_trans_sprite(backbuffer, gfx[2], x, y);

				cur_gfx = gfx[2];

	} else
	if (dir == DIR_RIGHT)
	{
			if (!trans)
				draw_sprite(backbuffer, gfx[3], x, y);
			else
				draw_trans_sprite(backbuffer, gfx[3], x, y);

				cur_gfx = gfx[3];
	} else
		shutdown("weird direction %d", dir);
}

OBJECT_PROJECTILE::OBJECT_PROJECTILE(OBJECT_BASE *own)
{
  x = own->x;
  y = own->y;

  type = OBJ_PROJ;

  if (own->type == OBJ_PLAYER)
	  friendly = true; else friendly = false;

  trans = true;
  spawndelay = 0;

  dir = own->olddir;

  switch (dir)
  {
  case DIR_UP:
	  y -= TILESIZE;
	  break;
  case DIR_DOWN:
	  y += TILESIZE;
	  break;
  case DIR_LEFT:
	  x -= TILESIZE;
	  break;
  case DIR_RIGHT:
	  x += TILESIZE;
	  break;
  }

  move();

  gfx[0] = (BITMAP*) game_dat[G_SPUP].dat;
  gfx[1] = (BITMAP*) game_dat[G_SPDOWN].dat;
  gfx[2] = (BITMAP*) game_dat[G_SPLEFT].dat;
  gfx[3] = (BITMAP*) game_dat[G_SPRIGHT].dat;

  cur_gfx = gfx[0];

  move_speed = own->move_speed + 4;

  sound_play(&s_shoot1);

  projectiles->Push_Back(this);
}

OBJECT_PROJECTILE::~OBJECT_PROJECTILE(void)
{
  projectiles->Delete(this);
}

void OBJECT_PROJECTILE::update(void)
{
	if (remove) return;
	if (spawndelay > 0) { spawndelay--; if (spawndelay == 0) sound_play(&s_spawn1); return; }
	move();
}

void OBJECT_PROJECTILE::move(bool recurse)
{
	if (remove) return;

	if (dir == DIR_UP)
	{
		y -= move_speed;
		if (level->CollCheck(x, y))
		{
			remove = true;
		}
	} else
	if (dir == DIR_DOWN)
	{
		y += move_speed;
		if (level->CollCheck(x, y))
		{
			remove = true;
		}
	} else
	if (dir == DIR_LEFT)
	{
		x -= move_speed;
		if (level->CollCheck(x, y))
		{
			remove = true;
		}
	} else
	if (dir == DIR_RIGHT)
	{
		x += move_speed;
		if (level->CollCheck(x, y))
		{
			remove = true;
		}
	}

	if (remove)
	{
		//new OBJECT_ANIM(x, y, G_EXPLO1_01, 7, 3, true);
		new OBJECT_EXPLODE(cur_gfx, x, y, false, 16, 26);
	}
}

OBJECT_ENEMY1::OBJECT_ENEMY1(int _x, int _y, int _lev)
{
  x = _x;
  y = _y;

  type = OBJ_ENEMY;

  level->enemy_count++;

  if (level->GetTile(x, y) > 0) { remove = true; return; }
  if ((x / TILESIZE == player->x / TILESIZE) && (y / TILESIZE == player->y / TILESIZE)) { remove = true; return; }

  dir = rand()%4;
  spawndelay = 10;

  hp = _lev;
  move_speed = 1;
  if (_lev == 2) move_speed = 2;
  if (_lev == 3) move_speed = 4;

  lev = _lev;

  if (lev == 1)
  {
	gfx[0] = (BITMAP*) game_dat[G_JUP].dat;
	gfx[1] = (BITMAP*) game_dat[G_JDOWN].dat;
	gfx[2] = (BITMAP*) game_dat[G_JLEFT].dat;
	gfx[3] = (BITMAP*) game_dat[G_JRIGHT].dat;
  } else
  if (lev == 2)
  {
	gfx[0] = (BITMAP*) game_dat[G_CUP].dat;
	gfx[1] = (BITMAP*) game_dat[G_CDOWN].dat;
	gfx[2] = (BITMAP*) game_dat[G_CLEFT].dat;
	gfx[3] = (BITMAP*) game_dat[G_CRIGHT].dat;
  } else
  if (lev == 3)
  {
	gfx[0] = (BITMAP*) game_dat[G_EUP].dat;
	gfx[1] = (BITMAP*) game_dat[G_EDOWN].dat;
	gfx[2] = (BITMAP*) game_dat[G_ELEFT].dat;
	gfx[3] = (BITMAP*) game_dat[G_ERIGHT].dat;
	e3amb_play();
	level->e3 = true;
  }
	
  actors->Push_Back(this);
}

OBJECT_ENEMY1::~OBJECT_ENEMY1(void)
{
  actors->Delete(this);
}

void OBJECT_ENEMY1::update(void)
{
	if (remove) return;
	if (spawndelay > 0) { spawndelay--; if (spawndelay == 0) sound_play(&s_spawn2); return; }

	move();
	olddir = dir;
	if (shoot_tick > 0)
		shoot_tick--;

	if (rand()%100 < lev) shoot();

	OBJECT_PROJECTILE	*tmp = NULL;
	OBJITEM				*tmp2 = NULL;

	tmp2 = (OBJITEM*) projectiles->GetFirst();

	while (tmp2)
	{
		tmp = (OBJECT_PROJECTILE*) tmp2->GetData();
		if ((tmp->remove) || (!tmp->friendly)) { tmp2 = tmp2->next; continue; }

  	if		(((tmp->x >= (int)x) && 
			(tmp->y >= (int)y) && 
			(tmp->x <= (int)x + TILESIZE) && 
			(tmp->y <= (int)y + TILESIZE)) ||
			((x >= tmp->x) && 
			(  y >= tmp->y) && 
			(  x <= tmp->x + TILESIZE) && 
			(  y <= tmp->y + TILESIZE)))
		{
			tmp->remove = true;
			new OBJECT_EXPLODE(cur_gfx, tmp->x, tmp->y, false, 16, 26);
			if (lev == 1)
				new OBJECT_EXPLODE(cur_gfx, tmp->x, tmp->y, false, 160, 172);
			if (lev == 2)
				new OBJECT_EXPLODE(cur_gfx, tmp->x, tmp->y, false, 144, 159);
			if (lev == 3)
				new OBJECT_EXPLODE(cur_gfx, tmp->x, tmp->y, false, 0, 15);

			hp--;
			if (hp > 0) if (lev == 2)
			{
				sound_play(&s_l2hit);
			}
			if (hp > 0) if (lev == 3)
			{
				sound_play(&s_e3hit);
			}
			if (hp == 0)
			{
				remove = true;
				level->enemy_killed++;
			}
		}
	tmp2 = tmp2->next;
	}

	if (coll)
	{
		switch (rand()%4)
		{
		case DIR_UP:
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_UP)) dir = DIR_UP;
			break;
		case DIR_LEFT:
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_LEFT)) dir = DIR_LEFT;
			break;
		case DIR_RIGHT:
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_RIGHT)) dir = DIR_RIGHT;
			break;
		case DIR_DOWN:
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_DOWN)) dir = DIR_DOWN;
			break;
		}
	} else
	if ((((int)x % TILESIZE) == 0) && (((int)y % TILESIZE) == 0))
	{
		switch (rand()%4)
		{
		case DIR_UP:
			if (dir != DIR_DOWN)
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_UP)) dir = DIR_UP;
			break;
		case DIR_LEFT:
			if (dir != DIR_RIGHT)
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_LEFT)) dir = DIR_LEFT;
			break;
		case DIR_RIGHT:
			if (dir != DIR_LEFT)
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_RIGHT)) dir = DIR_RIGHT;
			break;
		case DIR_DOWN:
			if (dir != DIR_UP)
			if (level->IsFree(x/TILESIZE, y/TILESIZE, DIR_DOWN)) dir = DIR_DOWN;
			break;
		}
	}

	if (remove) 
	{
		if (lev == 1)
			sound_play(&s_jdead);
		else
		if (lev == 2)
			sound_play(&s_l2dead);
		else
		if (lev == 3)
		{
			sound_play(&s_e3dead);
			e3amb_stop();
			level->e3 = false;
			level->Flash();
		}

	}
}



OBJECT_ANIM::OBJECT_ANIM(int _x, int _y, int first, int count, int speed, bool _trans)
{
	trans = _trans; 

	f = first;
	c = count;
	s = speed;

	x = _x;
	y = _y;

	gfx[0] = (BITMAP*) game_dat[first].dat;
	p = 0;
	t = speed;
}

void OBJECT_ANIM::draw()
{
	if (trans)
		draw_trans_sprite(backbuffer, gfx[0], x, y);
	else
		draw_sprite(backbuffer, gfx[0], x, y);
}

void OBJECT_ANIM::update()
{
	if (remove) return;

	t--;
	if (t == 0)
	{
		t = s;
		p++;
		if (p == c)
		{
			remove = true;
			return;
		}
	}
	gfx[0] = (BITMAP*) game_dat[f + p].dat;
}

OBJECT_EXPLODE::OBJECT_EXPLODE(BITMAP *_gfx, int _x, int _y, bool rev, int _dark, int light)
{
	reverse = rev;

	lifetime = 100;

	x = _x + TILESIZE/2;
	y = _y + TILESIZE/2;

	int cx, cy;

	for (cx = 0; cx < TILESIZE; cx++)
	{
		for (cy = 0; cy < TILESIZE; cy++)
		{
			px[cx+cy*TILESIZE] = _x + cx;
			py[cx+cy*TILESIZE] = _y + cy;
			if (_x+cx > x) vx[cx+cy*TILESIZE] = (fix) (rand()%100 / (float)100); else vx[cx+cy*TILESIZE] = (fix)(rand()%100 / (float)-100);
			if (_y+cy > y) vy[cx+cy*TILESIZE] = (fix) (rand()%100 / (float)100); else vy[cx+cy*TILESIZE] = (fix)(rand()%100 / (float)-100);
			col[cx+cy*TILESIZE] = light;
		}
	}

	dark = _dark;
}

void OBJECT_EXPLODE::draw(void)
{
	int cx, cy;
	if (remove) return;

	for (cx = 0; cx < TILESIZE; cx++)
	{
		for (cy = 0; cy < TILESIZE; cy++)
		{
			if (col[cx+cy*TILESIZE] > dark)
				putpixel(backbuffer, px[cx+cy*TILESIZE], py[cx+cy*TILESIZE], col[cx+cy*TILESIZE]);
		}
	}
}

void OBJECT_EXPLODE::update(void)
{
	if (remove) return;

	int cx, cy;
	lifetime--;

	if (lifetime <= 0) remove = true;

	for (cx = 0; cx < TILESIZE; cx++)
	{
		for (cy = 0; cy < TILESIZE; cy++)
		{
			px[cx+cy*TILESIZE] += vx[cx+cy*TILESIZE];
			py[cx+cy*TILESIZE] += vy[cx+cy*TILESIZE];
			if ((rand()%100 > 80) && (col[cx+cy*TILESIZE] > dark)) col[cx+cy*TILESIZE]--;
		}
	}
}