#include <stdio.h>
#include <time.h>
#include "allegro.h"

#define KUVIA 64
#define SIZE_X 50
#define SIZE_Y 50

#define DRAW 1
#define SELECT 2

int init();
void engine();
void display();
void increment_speed_counter();

bool quit = false;
char map[SIZE_X][SIZE_Y];
int x, y, sy;
int selected = 1, digits = 1;
volatile int speed_counter;
int temp, temp2;
int mode = DRAW;
char none;
bool wait_button = false;

BITMAP * buffer;
BITMAP * bmp[KUVIA];
BITMAP * talo1;
PALETTE pal;
PACKFILE * file;

void increment_speed_counter()
{
   speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

int main()
{
   init();//) return 1;

   char * nimet[KUVIA+50]= {
   "gfx/tv.pcx",
   "gfx/tieulko.pcx",
   "gfx/tiekulma_yv.pcx",
   "gfx/tielaitah_y.pcx",
   "gfx/tiekulma_yo.pcx",
   "gfx/tiekulmab_ao.pcx",
   "gfx/tiekulmab_av.pcx",

   "gfx/tk.pcx",
   "gfx/th.pcx",
   "tyhj",
   "gfx/tielaitav_v.pcx",
   "gfx/m.pcx",
   "gfx/tielaitav_o.pcx",
   "gfx/tiekulmab_yo.pcx",
   "gfx/tiekulmab_yv.pcx",

   "gfx/xtalo2_1.pcx",
   "gfx/xtalo2_2.pcx",
   "gfx/xtalo2_3.pcx",
   "gfx/tiekulma_av.pcx",
   "gfx/tielaitah_a.pcx",
   "gfx/tiekulma_ao.pcx",
   "tyhj",
   "tyhj",

   "gfx/xtalo2_4.pcx",
   "gfx/xtalo2_5.pcx",
   "gfx/xtalo2_6.pcx",
   "gfx/xtalo2b_1.pcx",
   "gfx/xtalo2b_2.pcx",
   "tyhj",
   "tyhj",
   "tyhj",
   
   "gfx/xtalo2_7.pcx",
   "gfx/xtalo2_8.pcx",
   "gfx/xtalo2_9.pcx",
   "gfx/xtalo2b_3.pcx",
   "gfx/xtalo2b_4.pcx",
   "tyhj",
   "tyhj",
   "tyhj",

   "gfx/talo1_1.pcx",
   "gfx/talo1_2.pcx",
   "gfx/talo1_3.pcx",
   "tyhj",
   "tyhj",
   "tyhj",
   "tyhj",
   "tyhj",

   "gfx/talo1_4.pcx",
   "gfx/talo1_5.pcx",
   "gfx/talo1_6.pcx",
   "gfx/talo1b_1.pcx",
   "gfx/talo1b_2.pcx",
   "tyhj",
   "tyhj",
   "tyhj",
   
   "gfx/talo1_7.pcx",
   "gfx/talo1_8.pcx",
   "gfx/talo1_9.pcx",
   "gfx/talo1b_3.pcx",
   "gfx/talo1b_4.pcx",
   "tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj"
   };

   for(int i = 0; i < KUVIA; i++)
         bmp[i] = load_pcx((char *)nimet[i],pal);
      
   while (!quit) {
      while (speed_counter > 0) {
         engine();
         speed_counter--;
      }

      display();
   }

   return 0;
}
END_OF_MAIN();

int init()
{
   srand(time(NULL));
   allegro_init();

   LOCK_VARIABLE(speed_counter);
   LOCK_FUNCTION(increment_speed_counter);

   text_mode(-1);

   install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));

   install_keyboard();

   if(install_mouse()==-1 || mouse_needs_poll()) {
      allegro_message("Unable to install mouse");
      return 1;
   }

   set_color_depth(16);
   if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0) {
      allegro_message("Error setting graphics mode\n%s\n", allegro_error);
      return 1;
   }

   for(int tx = 0; tx < SIZE_X; tx++)
      for(int ty = 0; ty < SIZE_Y; ty++)
         map[tx][ty] = 0;
   buffer = create_bitmap(SCREEN_W, SCREEN_H);
}

void display()
{
   acquire_screen();
   clear(buffer);
   vsync();

   if(mode == DRAW)
   {
      for(int tx = (x - x%80) /80; tx < (x - x%80) /80 + int(SCREEN_W / 80 + .5) + 1; tx++)
         for(int ty = (y - y%80) /80; ty < (y - y%80) /80 + int(SCREEN_H / 80 + .5) + 1; ty++)
            if(tx < SIZE_X && ty < SIZE_Y && map[tx][ty])
               if(bmp[map[tx][ty]-1]!=NULL)
                  blit(bmp[map[tx][ty]-1], buffer, 0, 0, tx * 80 - x, ty * 80 - y, 80, 80);

      textprintf(buffer, font, 10, 0, makecol(255,255,255), "X: %d", x+mouse_x);
      textprintf(buffer, font, 10, 10, makecol(255,255,255), "Y: %d", y+mouse_y);
      textprintf(buffer, font, 10, 20, makecol(255,255,255), "SELECTED: %d", selected);
   }
   else
   {
      for(int tx = 0; tx < SCREEN_W; tx += 80)
         for(int ty = 0; ty < int(KUVIA/8)*80+80; ty += 80)
           if(tx/80 + ty/80*SCREEN_W/80 <= KUVIA && tx/80 + ty/80*SCREEN_W/80 > 0)
              if(bmp[tx/80 + ty/80*SCREEN_W/80-1] != NULL)
                 blit(bmp[tx/80 + ty/80*SCREEN_W/80-1], buffer, 0, 0, tx, ty-sy*80, 80, 80);
   }
      show_mouse(buffer);

   blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);
   release_screen();
}

void engine()
{
   if(mode == DRAW)
   {
   if(!(mouse_b & 1))
   {
      wait_button = false;
   }
   if(mouse_b & 1 && selected <= KUVIA && wait_button == false)
      map[(x+mouse_x - (x+mouse_x)%80)/80][(y+mouse_y - (y+mouse_y)%80)/80] = selected;

   if(key[KEY_RIGHT]) x += 8;
   if(key[KEY_LEFT]) x -= 8;
   if(key[KEY_UP]) y -= 8;
   if(key[KEY_DOWN]) y += 8;
   
   if(key[KEY_RIGHT] && key_shifts & KB_SHIFT_FLAG) x += 50;
   if(key[KEY_LEFT] && key_shifts & KB_SHIFT_FLAG) x -= 50;
   if(key[KEY_UP] && key_shifts & KB_SHIFT_FLAG) y -= 50;
   if(key[KEY_DOWN] && key_shifts & KB_SHIFT_FLAG) y += 50;
   if(key[KEY_F12])
   {
      file = pack_fopen("city.map", "w");
      for(int tx = 0; tx < SIZE_X; tx++)
         for(int ty = 0; ty < SIZE_Y; ty++)
            pack_putc(int(map[tx][ty]), file);
      pack_fclose(file);
   }

   if(key[KEY_F1])
   {
      file = pack_fopen("city.map", "r");
      for(int tx = 0; tx < SIZE_X; tx++)
         for(int ty = 0; ty < SIZE_Y; ty++)
            map[tx][ty] = pack_getc(file);
      pack_fclose(file);
   }

   if(x < 0) x = 0;
   if(y < 0) y = 0;
   if(x > 80 * SIZE_X - 640) x = 80 * SIZE_X - 640;
   if(y > 80 * SIZE_Y - 480) y = 80 * SIZE_Y - 480;


   if(keypressed())
   {
      temp = readkey() & 0xff;
//      selected = temp;
      
      if(temp == 43 && selected > 0) selected--;
      if(temp == 45 && selected < 99) selected++;

      if(temp == 32) mode = SELECT;

      if(temp == 119)
         for(int ty = 0; ty < SIZE_Y-1; ty++)
            for(int tx = 0; tx < SIZE_X; tx++)
               map[tx][ty] = map[tx][ty+1];

      if(temp == 115)
         for(int ty = SIZE_Y-1; ty > 0; ty--)
            for(int tx = 0; tx < SIZE_X; tx++)
               map[tx][ty] = map[tx][ty-1];

      if(temp == 97)
         for(int tx = 0; tx < SIZE_X-1; tx++)
            for(int ty = 0; ty < SIZE_Y; ty++)
               map[tx][ty] = map[tx+1][ty];

      if(temp == 100)
         for(int tx = SIZE_X-1; tx > 0; tx--)
            for(int ty = 0; ty < SIZE_Y; ty++)
               map[tx][ty] = map[tx-1][ty];
               
      if(temp > 47 && temp < 58)
      {
         if(digits == 1)
         {
            selected *= 10;
            selected += temp - 48 - (temp==58) * 10;
            digits++;
         }
         else
         {
            selected = temp - 48 - (temp==58) * 10;
            digits--;
         }
      }
   }
   }
   else
   {
   if(keypressed())
   {
      temp2 = readkey() >> 2;//& 0xff;
      
      if(temp2 == 4808) mode = DRAW;
      if(temp2 == 5440) if(sy < 5)sy++;
      if(temp2 == 5376) if(sy > 0)sy--;
   }
   if(mouse_b & 1)
   {
      selected = (mouse_x - mouse_x % 80)/80 + (mouse_y - mouse_y % 80)/80*SCREEN_W/80+sy*8;
      mode = DRAW;
//      mouse_b &= ~1;
      wait_button = true;
   }
   }

   if(key[KEY_ESC]) quit = true;

}

