#include <math.h>
#include "vector.h"

//////////////////////////////////////////////////
//**************ANGLE CLASS*********************//
//////////////////////////////////////////////////

angle calcang(double x2, double y2, double x1, double y1)
{
   if(y1 == y2 && x1 >= x2) return 0;
   if(y1 == y2)             return 180;
   if(x1 == x2 && y1 >  y2) return 90;
   if(x1 == x2)             return 270;

   if(x1 > x2 && y1 > y2) return atan((y1-y2)/(x1-x2)) * RAD;
   if(x1 < x2 && y1 > y2) return atan((x2-x1)/(y1-y2)) * RAD + 90;
   if(x1 > x2 && y1 < y2) return atan((y1-y2)/(x1-x2)) * RAD + 360;
                          return atan((x2-x1)/(y1-y2)) * RAD + 270;
}

angle angle::operator+(double v)
{
	angle a;
	a.val = v + val;
	if(a.val>360) a.val-=360;
	if(a.val<0) a.val+=360;
	return a;
}
angle angle::operator-(double v)
{
	angle a;
	a.val = val - v;
	if(a.val>360) a.val-=360;
	if(a.val<0) a.val+=360;
	return a;
}
angle & angle::operator+=(double v)
{
	val += v;
	if(val>360) val-=360;
	return *this;
}
angle & angle::operator-=(double v)
{
	val -= v;
	if(val<0) val+=360;
	return *this;
}
angle & angle::operator=(double v)
{
	val = v;
	return *this;
}
angle angle::operator-()
{
	angle a;
	a = *this + 180;
	return a;
}
bool angle::operator<(angle a)
{
	double tr = a.val - val;
	if( tr < 0 ) tr += 360;
	double tl = -tr + 360;
	if( tr <= tl )	return true;
	else return false;
}
bool angle::operator>(angle a)
{
	double tr = a.val - val;
	if( tr < 0 ) tr += 360;
	double tl = -tr + 360;
	if( tr <= tl )	return false;
	else return true;
}
double angle::operator>>(angle a)
{
	double tr = a.val - val;
	if( tr < 0 ) tr += 360;
	double tl = -tr + 360;
	if( tr <= tl )	return tr;
	else return -tl;
}

angle operator+(double v,angle a)
{
	return a + v;
}
angle operator-(double v,angle a)
{
	angle t;
	t.val = v- a.val;
	if(t.val<0) t.val+=360;
	return a;
}

//////////////////////////////////////////////////////
//###############RECTANGULAR VECTOR#################//
//////////////////////////////////////////////////////

vector::vector()
{
        v[0] = 0;
        v[1] = 0;
	v[2] = 1;
	v[3] = 1;
}
vector::vector(double x, double y)
{
	v[0] = x;
	v[1] = y;
	v[2] = 1;
	v[3] = 1;
}
vector::vector(double x, double y, double s)
{
	v[0] = x;
	v[1] = y;
	v[2] = s;
	v[3] = 1;
}
vector::vector(double x, double y, double s, double w)
{
	v[0] = x;
	v[1] = y;
	v[2] = s;
	v[3] = w;
}
vector_pol vector::pol()
{
        return vector_pol(mag(), ang().val);
}
double vector::mag()
{
	return sqrt((v[0]*v[0])+(v[1]*v[1]));
}
angle vector::ang()
{
	if(v[1] == 0 && v[0] >=0) return 0;
	if(v[1] == 0)		  return 180;
	if(v[0] == 0 && v[1] > 0) return 90;
	if(v[0] == 0)		  return 270;

	if(v[0] > 0 && v[1] > 0) return atan( v[1] / v[0]) * RAD;
	if(v[0] < 0 && v[1] > 0) return atan(-v[0] / v[1]) * RAD + 90;
	if(v[0] > 0 && v[1] < 0) return atan( v[1] / v[0]) * RAD + 360;
				 return atan(-v[0] / v[1]) * RAD + 270;
}
double vector::x()
{
	return v[0];
}
double vector::y()
{
	return v[1];
}
vector & vector::x(double x)
{
	v[0] = x;
	return * this;
}
vector & vector::y(double y)
{
	v[1] = y;
	return * this;
}

vector vector::operator+(const vector & vect)
{
	vector t;
	t.v[0] = v[0] + vect.v[0];
	t.v[1] = v[1] + vect.v[1];
	return t;
}
vector vector::operator-(const vector & vect)
{
	vector t;
	t.v[0] = v[0] - vect.v[0];
	t.v[1] = v[1] - vect.v[1];
	return t;
}
vector vector::operator-()
{
	vector t;
	t.v[0] = -this->v[0];
	t.v[1] = -this->v[1];
	return t;
}
vector vector::operator*(double val)
{
	vector t;
	t.v[0] = v[0] * val;
	t.v[1] = v[1] * val;
	return t;
}
vector vector::operator/(double val)
{
	vector t;
	t.v[0] = v[0] / val;
	t.v[1] = v[1] / val;
	return t;
}

vector operator*(double val, vector & vect)
{
	return vect * val;
}

///////////////////////////////////////////////
//###############POLAR VECTOR################//
///////////////////////////////////////////////

vector_pol::vector_pol(double m, double a)
{
	mag = m;
	ang = a;
}
vector vector_pol::rec()
{
	vector t;
	t.v[0] = cos(ang.val / RAD) * mag;
	t.v[1] = sin(ang.val / RAD) * mag;
	t.v[2] = 1;
	t.v[3] = 1;
	return t;
}
double vector_pol::x()
{
	return cos(ang.val / RAD) * mag;
}
double vector_pol::y()
{
	return sin(ang.val / RAD) * mag;
}
vector_pol vector_pol::operator*(double val)
{
	vector_pol t;
	t.mag = mag * val;
	return t;
}
vector_pol vector_pol::operator/(double val)
{
	vector_pol t;
	t.mag = mag / val;
	return t;
}
vector_pol vector_pol::operator-()
{
	vector_pol t;
	t.ang = ang + 180;
	return t;
}
vector_pol vector_pol::project(angle a)
{
        vector_pol t;
        double gap = (ang>>a);
        if(gap> 90) gap -= 180;
        if(gap<-90) gap += 180;
        t.ang = ang + gap;
        t.mag = mag*cos(gap/RAD);
        return t;
}
vector_pol operator*(double val, vector_pol & vect)
{
	return vect * val;
}
vector_pol operator/(double val, vector_pol & vect)
{
	return vect / val;
}

