#include "allegro.h"
#include "vector.h"
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <math.h>
#include <jgmod.h>

#define KUVIA 64
#define SIZE_X 50
#define SIZE_Y 50
#define MAX_PLAYERS 9
#define MAX_AMMUKSIA 50000

#define rnd (double(rand())/RAND_MAX)
#define rad 57.29578

int init();
void display();
void engine();
int varaa_ammus();
void calc_fps();
int load_data();
void ammu(double posx, double posy, int life, int type, int owner, vector vel);
void liikuta_ammuksia();
void increment_speed_counter();


struct player_data
{
   bool alive;
   vector pos;
   vector velocity;
   double angle;
   bool left_flag, right_flag, up_flag, shoot_flag;
   int craft, energy, weapon, score, gunheat;
   BITMAP * pic;
   int team;

   // these are cpu variables
   int cpu; //Ai level, 0 if human
   int collision, trydir, nme, nme0nrgturns, oldnmenrg;
   int own0nrgturns, oldownnrg;
   double wait, waitmod;
};

struct ammus_data
{
   double x, y, vx, vy;
   bool isfree;
   int type, life, vari, owner;
};

bool game_over;
volatile int speed_counter = 0;
volatile int fps = 0, fps1 = 0, fps2 = 0, fps3 = 0;
volatile int frame_count = 0;
int t = 0;
int fps_graph[80];
int ammuksia = 0;
ammus_data ammus[MAX_AMMUKSIA];

int viewx=0, viewy=0;
int players = 2;
int omaenu = 500, vihoenu = 500;
player_data player[MAX_PLAYERS];
int cputype = 4;
int teamnrg;
int tx, ty;
int collision[2][2];
angle tang;
vector eta, tvector;

JGMOD *ex;

char map[SIZE_X][SIZE_Y];
bool collide[SIZE_X][SIZE_Y];
BITMAP * buffer;
BITMAP * craft1 ,*craft;
BITMAP * a1;
BITMAP * tausta[KUVIA];
PACKFILE * file;
PALETTE pal;

void increment_speed_counter()
{
   speed_counter++;
}
END_OF_FUNCTION(increment_speed_counter);

void calc_fps()
{
   for(int i = 79; i > 0; i--)
      fps_graph[i] = fps_graph[i-1];

   fps_graph[0] = fps = fps1 + fps2 + fps3 + frame_count;
   fps1 = fps2;
   fps2 = fps3;
   fps3 = frame_count;
   
   frame_count = 0;
}
END_OF_FUNCTION(calc_fps);

int load_data() {

   player[0].pic = load_pcx("gfx/bumpy.pcx", pal);
   for(int i = 1; i < players; i++)
      player[i].pic = player[0].pic;
   a1 = load_pcx("gfx/a1.pcx", pal);
   char * nimet[KUVIA+60]= {
   "gfx/tv.pcx",
   "gfx/tieulko.pcx",
   "gfx/tiekulma_yv.pcx",
   "gfx/tielaitah_y.pcx",
   "gfx/tiekulma_yo.pcx",
   "gfx/tiekulmab_ao.pcx",
   "gfx/tiekulmab_av.pcx",

   "gfx/tk.pcx",
   "gfx/th.pcx",
   "tyhj",
   "gfx/tielaitav_v.pcx",
   "gfx/m.pcx",
   "gfx/tielaitav_o.pcx",
   "gfx/tiekulmab_yo.pcx",
   "gfx/tiekulmab_yv.pcx",

   "gfx/xtalo2_1.pcx",
   "gfx/xtalo2_2.pcx",
   "gfx/xtalo2_3.pcx",
   "gfx/tiekulma_av.pcx",
   "gfx/tielaitah_a.pcx",
   "gfx/tiekulma_ao.pcx",
   "tyhj",
   "tyhj",

   "gfx/xtalo2_4.pcx",
   "gfx/xtalo2_5.pcx",
   "gfx/xtalo2_6.pcx",
   "gfx/xtalo2b_1.pcx",
   "gfx/xtalo2b_2.pcx",
   "tyhj",
   "tyhj",
   "tyhj",
   
   "gfx/xtalo2_7.pcx",
   "gfx/xtalo2_8.pcx",
   "gfx/xtalo2_9.pcx",
   "gfx/xtalo2b_3.pcx",
   "gfx/xtalo2b_4.pcx",
   "tyhj",
   "tyhj",
   "tyhj",

   "gfx/talo1_1.pcx",
   "gfx/talo1_2.pcx",
   "gfx/talo1_3.pcx",
   "tyhj",
   "tyhj",
   "tyhj",
   "tyhj",
   "tyhj",

   "gfx/talo1_4.pcx",
   "gfx/talo1_5.pcx",
   "gfx/talo1_6.pcx",
   "gfx/talo1b_1.pcx",
   "gfx/talo1b_2.pcx",
   "tyhj",
   "tyhj",
   "tyhj",
   
   "gfx/talo1_7.pcx",
   "gfx/talo1_8.pcx",
   "gfx/talo1_9.pcx",
   "gfx/talo1b_3.pcx",
   "gfx/talo1b_4.pcx",
   "tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj",
   "tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj","tyhj"
   };

   for(int i = 0; i < KUVIA; i++)
         tausta[i] = load_pcx((char *)nimet[i],pal);

   file = pack_fopen("city.map", "r");
   for(int tx = 0; tx < SIZE_X; tx++)
      for(int ty = 0; ty < SIZE_Y; ty++)
      {
         map[tx][ty] = pack_getc(file);
         if(map[tx][ty] > 0 && map[tx][ty] < 70)
           if(nimet[map[tx][ty]-1][4] == 'x')
            collide[tx][ty] = true;
           else
            collide[tx][ty] = false;
           else
            collide[tx][ty] = false;
      }
   pack_fclose(file);

   reserve_voices (8, -1);     // call this before install_sound if needed
   if (install_sound (DIGI_AUTODETECT, MIDI_NONE, NULL) < 0)
   {
      allegro_message("Error initializing sound card");
      return 1;
   }

   if (install_mod (8) < 0)    // call install_mod only after install_sound
   {
      allegro_message("Error setting digi voices");
      return 1;
   }

   if(rand()%2 == 1)
      ex = load_mod ("audio/danger.xm");
   else
      ex = load_mod ("audio/hassu.xm");
   if (ex == NULL)
   {
      allegro_message("Error reading music file");
      return 1;
   }
   return 0;
}

int main(int argc, char *argv[])
{
   if(argc > 1)
      players = int(argv[1][0]) - 48 + 1;
   if(argc > 2)
      omaenu = atoi(argv[2]);
   if(argc > 3)
      vihoenu = atoi(argv[3]);
   if(argc > 4)
      cputype = int(argv[4][0]) - 48;

   if(players < 1)
      players = 1;
   if(players > MAX_PLAYERS)
      players = MAX_PLAYERS;

   if(cputype < 1)
      cputype = 1;
   if(cputype > 7)
      cputype = 7;

   if(init()) return 1;
   if(load_data()) return 1;

   play_mod(ex,TRUE);

   while (!game_over) {
      while (speed_counter > 0) {
         engine();
         speed_counter--;
      }

      display();
   }
   stop_mod();
   destroy_mod(ex);

   return 0;
}
END_OF_MAIN();

int init()
{
   srand(time(NULL));
   allegro_init();
   install_timer();

   LOCK_VARIABLE(speed_counter);
   LOCK_VARIABLE(frame_count);
   LOCK_VARIABLE(fps);
   LOCK_VARIABLE(fps1);
   LOCK_VARIABLE(fps2);
   LOCK_VARIABLE(fps3);
   LOCK_VARIABLE(fps_graph);
   LOCK_FUNCTION(increment_speed_counter);
   LOCK_FUNCTION(calc_fps);

   text_mode(-1);

   install_int_ex(increment_speed_counter, BPS_TO_TIMER(60));
   install_int_ex(calc_fps, BPS_TO_TIMER(4));

   install_keyboard();

   set_color_depth(16);
   set_color_conversion(COLORCONV_TOTAL);

   if (set_gfx_mode(GFX_AUTODETECT, 640, 480, 0, 0) != 0) {
      allegro_message("Error setting graphics mode\n%s\n", allegro_error);
      return 1;
   }


   buffer = create_bitmap(SCREEN_W, SCREEN_H);

   for(int i = 0; i < MAX_AMMUKSIA; i++)
      ammus[i].isfree = true;

   player[0].pos = vector(100,100);
   player[0].angle = 0;
   player[0].energy = omaenu;
   player[0].cpu = false;
   player[0].trydir = 240;
   player[0].alive = true;
   player[0].team = 0;

   for(int i = 1; i < players; i++)
   {
      player[i].angle = 180;
      player[i].cpu = cputype;
      player[i].trydir = 240;
      player[i].energy = vihoenu;
      player[i].nme0nrgturns = 0;
      player[i].oldnmenrg = omaenu;
      player[i].alive = true;
      player[i].nme = 0;
      player[i].team = 1;
   }
   if(players > 1)
      player[1].pos = vector(2000,400);
   if(players > 2)
      player[2].pos = vector(100,2000);
   if(players > 3)
      player[3].pos = vector(2200,2000);
   if(players > 4)
      player[4].pos = vector(3800,400);
   if(players > 5)
      player[5].pos = vector(1000,3200);
   if(players > 6)
      player[6].pos = vector(3600,2000);
   if(players > 7)
      player[7].pos = vector(2000,3600);
   if(players > 8)
      player[8].pos = vector(3600,3600);
   return 0;
}

void display()
{
   frame_count++;
   acquire_screen();
//   clear(buffer);

   vsync();
   for(int tx = (viewx - viewx%80) /80; tx < (viewx - viewx%80) /80 + int(SCREEN_W / 80 + .5) + 1; tx++)
      for(int ty = (viewy - viewy%80) /80; ty < (viewy - viewy%80) /80 + int(SCREEN_H / 80 + .5) + 1; ty++)
         if(tx < SIZE_X && ty < SIZE_Y && map[tx][ty])
            if(tausta[map[tx][ty]-1]!=NULL)
               blit(tausta[map[tx][ty]-1], buffer, 0, 0, tx * 80 - viewx, ty * 80 - viewy, 80, 80);

   for(int i = 0; i <= ammuksia; i++)
      if(ammus[i].isfree == false)
         if(ammus[i].type == 1)
            draw_sprite(buffer, a1, ammus[i].x-viewx, ammus[i].y-viewy);
         else
            putpixel(buffer, ammus[i].x-viewx, ammus[i].y-viewy, ammus[i].vari);

   for(int i = 0; i < players; i++)
      if(player[i].alive)
         rotate_sprite(buffer, player[i].pic, player[i].pos.x()-viewx-21, player[i].pos.y()-viewy-16, itofix((player[i].angle)/1.40625 + .5));

   textprintf(buffer, font, 576,0, makecol(255,255,255), "FPS: %d", fps);
   textprintf(buffer, font, 0,0, makecol(255,0,0), "ENERGY: %d", player[0].energy);
   if(players == 2)
      textprintf(buffer, font, 0,8, makecol(255,255,0), "ENEMY'S ENERGY: %d", player[1].energy);
   else
   {
      for(int i = 1; i < players; i++)
         textprintf(buffer, font, 0,8*i, makecol(255,255,0), "%d. ENEMY'S ENERGY: %d",i, player[i].energy);
      textprintf(buffer, font, 0,8*players, makecol(255,255,0), "ENEMY TEAM'S ENERGY: %d", teamnrg);
   }

   textprintf(buffer, font, 200,0, makecol(255,0,0), "X: %d", int(player[0].pos.x()));
   textprintf(buffer, font, 200,8, makecol(255,0,0), "Y: %d", int(player[0].pos.y()));

   for(int i = 0; i < 79; i++)
      line(buffer, 560 + i, SCREEN_H - fps_graph[i], 561 + i, SCREEN_H - fps_graph[i+1], makecol(0,50,150));

   blit(buffer, screen, 0, 0, 0, 0, SCREEN_W, SCREEN_H);

   release_screen();
}

void ammu(double posx, double posy, int life, int type, int owner,  vector vel)
{
   int nro = varaa_ammus();
   if(nro == -1) return;
   ammus[nro].x = posx-2.5*(type==1);
   ammus[nro].y = posy-2.5*(type==1);
   ammus[nro].vx = vel.x();
   ammus[nro].vy = vel.y();
   ammus[nro].isfree = false;
   ammus[nro].life = life;
   ammus[nro].type = type;
   ammus[nro].owner = owner;
   if(type == 0)
   {
      double tummuus;
      tummuus = rnd/2+0.5;
      ammus[nro].vari = makecol(int(255*tummuus),int((rand()%155)*tummuus),0);
   }
}
int varaa_ammus()
{
   for(int i = 0; i < MAX_AMMUKSIA; i++)
      if(ammus[i].isfree)
      {
         if(i > ammuksia) ammuksia = i;
         return i;
      }
   return -1;
}
void liikuta_ammuksia()
{
   int tmpammuksia = 0, tx, ty;
   for(int i = 0; i <= ammuksia; i++)
   {
      if(ammus[i].isfree == false)
      {
         ammus[i].x += ammus[i].vx;
         ammus[i].y += ammus[i].vy;
         ammus[i].life--;
         if(ammus[i].life <= 0)
         {
            ammus[i].isfree = true;
         }
         tx = int(ammus[i].x);
         ty = int(ammus[i].y);
         if(collide[int(ammus[i].x/80)][int(ammus[i].y/80)])
         {
            if( ammus[i].type == 1)
            {
               ammus[i].isfree = true;
               for(int j = 0; j < 50; j++)
               {
                  ammu(ammus[i].x-ammus[i].vx, ammus[i].y-ammus[i].vy, 20, 0, -1, vector_pol(rnd*3, rand()%360).rec());
               }
            }
            if( ammus[i].type == 0)
            {
               ammus[i].isfree = true;
            }
         }
         for(int j = 0; j <= players; j++)
         {
            if(player[j].team != ammus[i].owner && ammus[i].owner > -1 && ammus[i].type ==1 && player[j].alive == true)
            {
               if(ammus[i].x+2<player[j].pos.x()+21&&ammus[i].x+2>player[j].pos.x()-21&&ammus[i].y+2<player[j].pos.y()+21&&ammus[i].y+2>player[j].pos.y()-21)
               {
                  player[j].energy -= 10;
                  ammus[i].isfree = true;
                  for(int j = 0; j < 50; j++)
                     ammu(ammus[i].x-ammus[i].vx, ammus[i].y-ammus[i].vy, 20, 0, -1, vector_pol(rnd*3, rand()%360).rec());
               }
            }
         }
         if(ammus[i].isfree == false)
         {
            tmpammuksia = i;
         }
      }
   }
   ammuksia = tmpammuksia;
}

void engine()
{
   t++;
   if(t > 500) t = 0;
   if(key[KEY_ESC]) game_over = true;

   teamnrg = 0;
   for(int j = 1; j < players; j++)
      teamnrg += player[j].energy;

   for(int i = 0; i < players; i++)
   {
      if(player[i].alive == false)
         continue;

      player[i].up_flag = false;
      player[i].right_flag = false;
      player[i].left_flag = false;
      player[i].shoot_flag = false;
      if(player[i].energy <= 0)
      {
         player[i].alive =false;
         for(int j = 0; j < 2000; j++)
            ammu(player[i].pos.x(), player[i].pos.y(), rand()%400, 0, -1, vector_pol(rnd*7, rand()%360).rec());
         for(int j = 0; j < 50; j++)
            ammu(player[i].pos.x(), player[i].pos.y(), rand()%400, 1, -1, vector_pol(rnd*7, rand()%360).rec());
         continue;
      }
      if(player[i].cpu)
      {
         if(player[i].oldnmenrg == player[player[i].nme].energy)
            player[i].nme0nrgturns++;
         else
            player[i].nme0nrgturns = 0;
         player[i].oldnmenrg = player[player[i].nme].energy;

         if(player[i].oldownnrg == player[i].energy)
            player[i].own0nrgturns++;
         else
            player[i].own0nrgturns = 0;
         if(player[i].nme0nrgturns >= 1200)
            player[i].nme0nrgturns = 0;

         player[i].oldownnrg = player[i].energy;

         if(player[i].cpu == 6 || player[i].cpu == 4 ||player[i].cpu == 7)
         {
            if(player[i].collision)
               player[i].waitmod += 0.1;
            if(player[i].collision && player[i].wait < player[i].waitmod*10)
               player[i].wait = player[i].waitmod*10;
            if(player[i].collision)
               player[i].wait += player[i].waitmod;
            if(player[i].waitmod > 0)
               player[i].waitmod -= 0.01;
            if(player[i].waitmod > 4)
               player[i].waitmod = 0;
         }
   /*   if(player[i].cpu == 6 || player[i].cpu == 4)
      {
//         if(player[i].collision && player[i].wait < 20)
//            player[i].wait = 20;
         if(player[i].collision)
            player[i].wait += 2;
      }*/
         else
         {
            if(player[i].collision)
               player[i].wait = 40;
         }
         if(player[i].wait)
            player[i].wait--;
         if(player[i].wait < 0)
            player[i].wait = 0;

         player[i].shoot_flag = true;

         if(player[i].cpu == 4 || player[i].cpu == 6 || player[i].cpu == 7)
         {
            tvector = player[player[i].nme].pos - player[i].pos;
            eta = (player[i].pos + tvector / tvector.mag() * 60) - (player[player[i].nme].pos + player[player[i].nme].velocity * 60);
         }
         else
            eta = player[i].pos - player[player[i].nme].pos;

         if(player[i].cpu == 1 || player[i].cpu == 2 || (player[i].cpu == 7 && player[i].energy <  vihoenu / 2))
            player[i].up_flag = true;
         if(player[i].cpu == 3 || player[i].cpu == 4)
            if(eta.mag() > 240 || player[player[i].nme].up_flag)
               player[i].up_flag = true;
         if(player[i].cpu == 5 || player[i].cpu == 6 || (player[i].cpu == 7 && player[i].energy >= vihoenu / 2))
            if(eta.mag() > 240 || player[i].nme0nrgturns > 240 || (player[i].nme0nrgturns > 120 && player[i].own0nrgturns < 180) ||  (teamnrg+20 < player[player[i].nme].energy && player[i].nme0nrgturns > 180 ))
               player[i].up_flag = true;

         if(player[i].collision && player[i].cpu > 1)
         {
            if(player[i].trydir == 1) player[i].trydir = -240;
            else if(player[i].trydir == -1) player[i].trydir = 240;
            else if(player[i].trydir > 0) player[i].trydir--;
            else if(player[i].trydir < 0) player[i].trydir++;
            else player[i].trydir = 240;
            if(player[i].trydir < 0) player[i].left_flag = true;
            if(player[i].trydir > 0) player[i].right_flag = true;
         }
         else if(player[i].wait == 0 || player[i].cpu == 1)
         {
            if(player[i].cpu == 7)
            {
               tvector = (player[player[i].nme].velocity - player[i].velocity);
               tang = calcang(player[i].pos.x(),player[i].pos.y(),player[player[i].nme].pos.x(),player[player[i].nme].pos.y()).val + asin(sin((tvector.pol().ang>>(-player[player[i].nme].pos+player[i].pos).pol().ang)/RAD)*(tvector.mag()/8))*RAD;
            }
            else
               tang  = calcang(player[i].pos.x(),player[i].pos.y(),player[player[i].nme].pos.x(),player[player[i].nme].pos.y()).val;
            if(player[0].up_flag && player[i].up_flag)
            {
               if((angle(player[i].angle)>>tang) > rand()%90-45) player[i].right_flag = true;
               if((angle(player[i].angle)>>tang) < -rand()%90+45) player[i].left_flag = true;
            }
            else
            {
               if((angle(player[i].angle)>>tang) > 5.5) player[i].right_flag = true;
               if((angle(player[i].angle)>>tang) < -5.5) player[i].left_flag = true;
            }
         }
         if(player[i].collision)
            player[i].collision--;
      }
 /*  if(player[i].cpu)
   {
      if(player[i].oldnmenrg == player[player[i].nme].energy)
         player[i].nme0nrgturns++;
      else
         player[i].nme0nrgturns = 0;
      player[i].oldnmenrg = player[player[i].nme].energy;

      if(player[i].oldownnrg == player[i].energy)
         player[i].own0nrgturns++;
      else
         player[i].own0nrgturns = 0;
      if(player[i].nme0nrgturns >= 600)
         player[i].nme0nrgturns = 0;

      player[i].oldownnrg = player[i].energy;

      if(player[i].collision)
         player[i].collision--;
      if(player[i].wait)
         player[i].wait--;
      if(player[i].collision && player[i].wait == 0)
      {
         player[i].wait = 60;
         player[i].collision = 0;
      }
      if(player[i].collision && player[i].wait)
      {
         player[i].wait = 60;
      }
      player[i].shoot_flag = true;
      eta = player[i].pos - player[player[i].nme].pos;

      if(player[i].cpu < 3)
         player[i].up_flag = true;
      if(player[i].cpu == 3)
         if(eta.mag() > 240 || player[player[i].nme].up_flag)
            player[i].up_flag = true;
      if(player[i].cpu == 4)
         if(eta.mag() > 240 || player[i].nme0nrgturns > 240 || (player[i].nme0nrgturns > 120 && player[i].own0nrgturns < 180) ||  (teamnrg+20 < player[player[i].nme].energy && player[i].nme0nrgturns > 180 ))
            player[i].up_flag = true;

      if(player[i].collision>28)// && player[i].cpu > 1)
      {
         if(player[i].trydir == 1) player[i].trydir = -240;
         else if(player[i].trydir == -1) player[i].trydir = 240;
         else if(player[i].trydir > 0) player[i].trydir--;
         else if(player[i].trydir < 0) player[i].trydir++;
         else player[i].trydir = 240;
         if(player[i].trydir < 0) player[i].left_flag = true;
         if(player[i].trydir > 0) player[i].right_flag = true;
      }
      else if(player[i].collision == 0)// || player[i].cpu == 1)
      {
         tang  = calcang(player[i].pos.x(),player[i].pos.y(),player[player[i].nme].pos.x(),player[player[i].nme].pos.y()).val;
         if(player[0].up_flag && player[i].up_flag)
         {
            if((angle(player[i].angle)>>tang) > rand()%90-45) player[i].right_flag = true;
            if((angle(player[i].angle)>>tang) < -rand()%90+45) player[i].left_flag = true;
         }
         else
         {
            if((angle(player[i].angle)>>tang) > 5.5) player[i].right_flag = true;
            if((angle(player[i].angle)>>tang) < -5.5) player[i].left_flag = true;
         }
      }
   }
*/
      else
      {
         if(key[KEY_LEFT])
            player[i].left_flag = true;
         else if(key[KEY_RIGHT])
            player[i].right_flag = true;

         if(key[KEY_LCONTROL])
            player[i].shoot_flag = true;
         if(key[KEY_UP])
            player[i].up_flag = true;
      }
         if(player[i].left_flag)
            player[i].angle-=5.5;
         else if(player[i].right_flag)
            player[i].angle+=5.5;

         if(player[i].angle < 0) player[i].angle += 360;
         if(player[i].angle >= 360) player[i].angle -= 360;

         if(player[i].shoot_flag && player[i].gunheat == 0)
         {
            ammu(player[i].pos.x(),player[i].pos.y(),120,1,player[i].team, vector_pol(8, player[i].angle).rec() + player[i].velocity);
            player[i].gunheat = 10;
         }
         if(player[i].gunheat > 0)
            player[i].gunheat--;
         if(player[i].up_flag)
         {
            player[i].velocity.v[0] += cos(player[i].angle / rad)*.10;
            player[i].velocity.v[1] += sin(player[i].angle / rad)*.10;
         }
         else player[i].velocity = player[i].velocity * 0.95;
//   if(key[KEY_DOWN])
//   {
//      velocity.v[0] -= cos(angle / rad)*1;
//      velocity.v[1] -= sin(angle / rad)*1;
//   }

      if(player[i].velocity.mag() > 10) player[i].velocity = player[i].velocity / player[i].velocity.mag() * 10;

      player[i].pos = player[i].pos + player[i].velocity;

      tx = (player[i].pos.x() + 21 - 40)/80;
      ty = (player[i].pos.y() + 21 - 40)/80;
      collision[0][0] = 0;
      collision[1][0] = 0;
      collision[0][1] = 0;
      collision[1][1] = 0;
      if(collide[tx][ty] && player[i].pos.x()-21 < tx*80+80 && player[i].pos.y()-21 < ty*80+80)
         if(fabs(player[i].pos.x() - tx*80-40) > fabs(player[i].pos.y() - ty*80-40))
            collision[0][0] = 1;
         else
            collision[0][0] = 2;
      if(collide[tx+1][ty] && player[i].pos.x()+21 > tx*80+80 && player[i].pos.y()-21 < ty*80+80)
         if(fabs(player[i].pos.x() - tx*80-120) > fabs(player[i].pos.y() - ty*80-40))
            collision[1][0] = 1;
         else
            collision[1][0] = 2;
      if(collide[tx][ty+1] && player[i].pos.x()-21 < tx*80+80 && player[i].pos.y()+21 > ty*80+80)
         if(fabs(player[i].pos.x() - tx*80-40) > fabs(player[i].pos.y() - ty*80-120))
            collision[0][1] = 1;
         else
            collision[0][1] = 2;
      if(collide[tx+1][ty+1] && player[i].pos.x()+21 > tx*80+80 && player[i].pos.y()+21 > ty*80+80)
         if(fabs(player[i].pos.x() - tx*80-120) > fabs(player[i].pos.y() - ty*80-120))
            collision[1][1] = 1;
         else
            collision[1][1] = 2;
      if(collision[0][0]||collision[1][0]||collision[0][1]||collision[1][1])
         player[i].pos = player[i].pos - player[i].velocity;

//      collision[0][0] = 0;
 //     collision[1][0] = 0;
  //    collision[0][1] = 0;
   //   collision[1][1] = 0;

      if(collision[0][0])
         if(collision[1][0])
            player[i].velocity.v[1] = fabs(player[i].velocity.v[1]);
         else if(collision[0][1])
            player[i].velocity.v[0] = fabs(player[i].velocity.v[0]);
         else if(collision[0][0] == 1)
            player[i].velocity.v[0] = fabs(player[i].velocity.v[0]);
         else
            player[i].velocity.v[1] = fabs(player[i].velocity.v[1]);
      else if(collision[1][0])
         if(collision[1][1])
            player[i].velocity.v[0] = -fabs(player[i].velocity.v[0]);
         else if(collision[1][0] == 1)
            player[i].velocity.v[0] = -fabs(player[i].velocity.v[0]);
         else
            player[i].velocity.v[1] = fabs(player[i].velocity.v[1]);
      else if(collision[0][1])
         if(collision[1][1])
            player[i].velocity.v[1] = -fabs(player[i].velocity.v[1]);
         else if(collision[0][1] == 1)
            player[i].velocity.v[0] = fabs(player[i].velocity.v[0])*1;
         else
            player[i].velocity.v[1] = -fabs(player[i].velocity.v[1])*1;
      else if(collision[1][1])
         if(collision[1][1] == 1)
            player[i].velocity.v[0] = -fabs(player[i].velocity.v[0])*1;
         else
            player[i].velocity.v[1] = -fabs(player[i].velocity.v[1])*1;

      if(collision[0][0]||collision[1][0]||collision[0][1]||collision[1][1])
      {
         player[i].velocity = player[i].velocity * .5;
         player[i].collision = 1;
      }
      for(int j = 0; j < players; j++)
         if(j!=i && player[j].alive && (player[i].pos-player[j].pos).mag() <= 42)
         {
            vector ivelocity;
            vector jvelocity;

            player[i].pos = player[j].pos - vector_pol(42, calcang(player[i].pos.v[0],player[i].pos.v[1],player[j].pos.v[0],player[j].pos.v[1]).val).rec();

            ivelocity = player[i].velocity.pol().project(calcang(
                     player[i].pos.v[0],player[i].pos.v[1],player[j].pos.v[0],player[j].pos.v[1])).rec();

            jvelocity = player[j].velocity.pol().project(calcang(
                     player[j].pos.v[0],player[j].pos.v[1],player[i].pos.v[0],player[i].pos.v[1])).rec();

            player[i].velocity = player[i].velocity +(-ivelocity + jvelocity);
            player[j].velocity = player[j].velocity +(-jvelocity + ivelocity);
         }


/*
      int tx, ty;
      for(int j = 0; j < 4; j++)
      {
         if(j == 0) {tx = int(player[i].pos.x());ty = int(player[i].pos.y())-5;}
         if(j == 1) {tx = int(player[i].pos.x())+42;ty = int(player[i].pos.y())-5;}
         if(j == 2) {tx = int(player[i].pos.x());ty = int(player[i].pos.y())+37;}
         if(j == 3) {tx = int(player[i].pos.x())+42;ty = int(player[i].pos.y())+37;}
         if(collide[tx/80][ty/80])
         {
            if(tx%80 > ty%80)
               if(tx%80 > 80 - ty%80) {player[i].pos = player[i].pos - player[i].velocity;
                  player[i].velocity.v[0] = fabs(player[i].velocity.v[0])*1;}
               else{player[i].pos = player[i].pos - player[i].velocity;
                  player[i].velocity.v[1] = -fabs(player[i].velocity.v[1])*1;}
            else
               if(tx%80 < 80 - ty%80){player[i].pos = player[i].pos - player[i].velocity;
                  player[i].velocity.v[0] = -fabs(player[i].velocity.v[0])*1;}
               else{player[i].pos = player[i].pos - player[i].velocity;
                  player[i].velocity.v[1] = fabs(player[i].velocity.v[1])*1;}
            j = 4;
            player[i].velocity = player[i].velocity * .5;
            player[i].collision = 1;
         }
      }*/
   }
   liikuta_ammuksia();

   viewx = player[0].pos.v[0] - 320;
   viewy = player[0].pos.v[1] - 240;
   if(viewx < 0) viewx = 0;
   if(viewy < 0) viewy = 0;
   if(viewx > 80 * SIZE_X - 640) viewx = 80 * SIZE_X - 640;
   if(viewy > 80 * SIZE_Y - 480) viewy = 80 * SIZE_Y - 480;
}
