#include <string.h>
#include <allegro.h>

#include "tile.h"


BITMAP ** tiles;
BITMAP * b_key;
BITMAP * b_bomb;
BITMAP * b_smallb;
BITMAP * b_banana;
BITMAP * b_explo;



void draw_grid(BITMAP * bmp, s_map * map, int x, int y)
{
	for (int xt=0;xt<=map->w;xt++)
    	vline(bmp,x+xt*32,y,y+map->h*32,makecol(0,255,0));
    for (int yt=0;yt<=map->h;yt++)
    	hline(bmp,x,y+yt*32,x+map->w*32,makecol(0,255,0));
}

void draw_map(BITMAP *bmp, s_map * map, int x, int y)
{
	for (int xt=0;xt<map->w;xt++)
    {
    	for (int yt=0;yt<map->h;yt++)
        {
        	s_tile *tile= &map->tiles[yt*map->w+xt];
            if (tile->type>0)
            {
        		int typet;
        		typet=tile->type;
        		switch (tile->type)
           	 	{
           	 	case 4: case 5:
           	 		if (isset(tile->flags,TILE_OPENED))
           	 			typet+=5;
           	 	break;
                case 8:
                	if (isset(tile->flags,TILE_OPENED))
                    	typet=10;
           	 	}

           	 	if ((tile->type==5 || tile->type==8) && isset(tile->flags,TILE_VERT))
         		{
                	//DAMN why does rotate work wrong?!?!? I'm missing one line of the sprite!
	    	        blit(tiles[0],bmp,0,0,x+xt*32,y+yt*32,32,32);
                	rotate_sprite(bmp,tiles[typet-1],x+xt*32-1,y+yt*32,itofix(64));
                }
                else
                	blit(tiles[typet-1],bmp,0,0,x+xt*32,y+yt*32,32,32);
           	  if (tile->item==1) masked_blit(b_key,bmp,0,0,x+xt*32,y+yt*32,32,32);
              if (tile->item==2) masked_blit(b_bomb,bmp,0,0,x+xt*32,y+yt*32,32,32);
              if (tile->item==3) masked_blit(b_smallb,bmp,0,0,x+xt*32,y+yt*32,32,32);
              if (tile->item==4) masked_blit(b_banana,bmp,0,0,x+xt*32,y+yt*32,32,32);

              }
        }
    }

}

int load_tiles()
{
	tiles = new BITMAP *[12];
    tiles[0]=load_bitmap("tile.bmp",NULL);
    tiles[1]=load_bitmap("water.bmp",NULL);
    tiles[2]=load_bitmap("bridge.bmp",NULL);
    tiles[3]=load_bitmap("wall.bmp",NULL);
    tiles[4]=load_bitmap("doorclose.bmp",NULL);
    tiles[5]=load_bitmap("button.bmp",NULL);
    tiles[6]=load_bitmap("computer.bmp",NULL);
    tiles[7]=load_bitmap("doorlock.bmp",NULL);
    tiles[8]=load_bitmap("wallbroke.bmp",NULL);
	tiles[9]=load_bitmap("dooropen.bmp",NULL);

    b_bomb=load_bitmap("bomb.bmp",NULL);
    b_key=load_bitmap("key.bmp",NULL);
  	b_banana=load_bitmap("banana.bmp",NULL);
    b_smallb=load_bitmap("smallb.bmp",NULL);
    b_explo=load_bitmap("explosion.bmp",NULL);


	return 0;
}

void reset_tiles(s_map * map)
{
        memset(map->tiles,0,map->w*map->h*sizeof(s_tile));
}

void create_tiles(s_map * map)
{
	map->tiles= new s_tile[map->w*map->h];
}

bool isset(int flags,int flag)
{
    return (bool)(flags&flag);
}

void save_map(s_map * map, FILE * file)
{
	fwrite(&map->w,sizeof(int),1,file);
    fwrite(&map->h,sizeof(int),1,file);
    fwrite(&map->enterx,sizeof(int),1,file);
    fwrite(&map->entery,sizeof(int),1,file);
    fwrite(map->tiles,sizeof(s_tile),map->w*map->h,file);
}

void load_map(s_map * map, FILE * file)
{
	fread(&map->w,sizeof(int),1,file);
    fread(&map->h,sizeof(int),1,file);
    fread(&map->enterx,sizeof(int),1,file);
    fread(&map->entery,sizeof(int),1,file);
    create_tiles(map);
    fread(map->tiles,sizeof(s_tile),map->w*map->h,file);
}








