#include <math.h>
#include <allegro.h>
#include <stdlib.h>
#include <time.h>
#include "util.h"
#include "tile.h"
#include "part2.h"

extern volatile int timer;

#define NUM_SHOTS 3

extern FONT *old_font;

extern BITMAP ** tiles;
BITMAP * buffer;

extern BITMAP * b_key;
extern BITMAP * b_bomb;
extern BITMAP * b_smallb;
extern BITMAP * b_explo;


SAMPLE * sound1;
SAMPLE * sound2;

BITMAP * monkeybig;
BITMAP *monkey[4];
BITMAP *b_menu;
BITMAP *advert;
BITMAP *title;

s_map map;
int x,y,dir,keys,bombs,points;
int level;
int starthack(int);
bool quit=true;
bool kdownu,kdownr,kdownd,kdownl;


void loadm(char * filename);
void loop();
void flip();
void draw_monkey();
int can_walk(int x,int y);
void check_keys();
void walk(int xt, int yt);
void trigger(s_tile * tile);
void dodoors(int doors);
void dobridges(int bridges);
void use_key();
void use_bomb();
void draw_menu();
void next_level();
void hack();

void cyber_init();
int hackstart(int leveln);
int credits();

void main()
{
    allegro_init();
    install_keyboard();
    install_timer();
    score_init();
    rain_init();
    set_color_depth(16);
    srand(time(NULL));

    if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0)) {
      set_color_depth(15);
      if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0)) {
        set_color_depth(24);
        if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0)) {
          set_color_depth(32);
          if(set_gfx_mode(GFX_AUTODETECT,640,480,0,0))
            exit(0);
        }

      }
    }

    buffer = create_bitmap(640,480);
    clear(buffer);
    cyber_init();

    detect_digi_driver(DIGI_AUTODETECT);
    detect_midi_driver(MIDI_AUTODETECT);
    reserve_voices(4,0);
    int ret = install_sound(DIGI_AUTODETECT,MIDI_AUTODETECT,NULL);
	if (ret==-1) exit(4);
    sound1 = load_wav("sound1.wav");
    sound2 = load_wav("sound2.wav");


    load_tiles();
    level=1;
    loadm("level1.mkh");
    monkey[0]=load_bitmap("monkeyback.bmp",NULL);
    monkey[1]=load_bitmap("monkeyright.bmp",NULL);
	monkey[2]=load_bitmap("monkeyfront.bmp",NULL);
	monkey[3]=load_bitmap("monkeyleft.bmp",NULL);
    monkeybig=load_bitmap("monkey.bmp",NULL);
    b_menu=load_bitmap("menu.pcx",NULL);
    title=load_bitmap("title.bmp",NULL);
    advert=load_bitmap("advert.bmp",NULL);

    x=map.enterx;
    y=map.entery;
    dir=1;
    keys=bombs=0;
    kdownu=kdownr=kdownd=kdownl=0;
    loop();
}
END_OF_MAIN();

char *type_in_name (int place)
{
  static char name[128];
  name[0]=0;
  char a;
  int i=0;
  clear_keybuf();

  timer=0;

  while(!key[KEY_ENTER]) {
    while(timer>0) {
      timer--;
      if(keypressed()) {
        a=readkey();
        name[i++]=a;
        name[i]=0;
      }
      if(key[KEY_BACKSPACE]) {
        i=0;
        name[0]=0;
      }
      add_star_drop();
      update_rain();
    }
    clear(buffer);
    draw_rain();

    textprintf_centre(buffer,old_font,SCREEN_W/2,SCREEN_H/2-32,makecol(255,255,255),"Hi Score! Enter your name:");
    
    textprintf_centre(buffer,old_font,SCREEN_W/2,SCREEN_H/2+32,makecol(255,255,255),name);
    flip();
    
  }

  return name;

}

void end_scene()
{
    if(check(points))
      add(points,type_in_name);
    points=0;
    delete[] map.tiles;
    loadm("level1.mkh");
    x=map.enterx;
    y=map.entery;
    bombs=0;
    keys=0;
    level=1;
    quit=true;

}



void loop()
{
  while(true) {
    timer=0;
    if(credits()==1)
      return;


    while (quit)         
    {
    	if (key[KEY_ESC]) quit=false;
        check_keys();
        clear(buffer);
        draw_map(buffer,&map,320-x*32,240-y*32);
        draw_monkey();
        flip();      
    }
    end_scene();
  }
}

void draw_shot(int shot)
{
  FONT *f=old_font;

  char line[128];
  char line2[128];

  clear(buffer);
  draw_rain();              
  switch(shot) {
    case 0: {
      draw_sprite(buffer,title,(SCREEN_W-title->w)/2,(SCREEN_H-title->h)/2);
         
      add_rain_drop();
      add_rain_drop();

      break;
    }
    case 1: {

      add_snow_drop();
      add_snow_drop();

      textprintf_centre(buffer,f,SCREEN_W/2,SCREEN_H/2-32,makecol(255,255,255),"--------- HI SCORES ----------");
      int jj=0;

      for(int i=0;i<MAX_WINS;i++) {
        sprintf(line,get_name(i));

        jj=strlen(line);
        for(int j=0;j<40-jj;j++) {
          sprintf(line2,"%s.",line);
          strcpy(line,line2);
        }

        sprintf(line2,"%s%08d",line,get_score(i));
        strcpy(line,line2);

        textprintf_centre(buffer,f,SCREEN_W/2,SCREEN_H/2-32+((i+2)*8),makecol(255,255,255),line);
        

      }

      break;
    }
    case 2: {
      add_star_drop();
      add_star_drop();
      draw_sprite(buffer,advert,(SCREEN_W-advert->w)/2,(SCREEN_H-advert->h)/2);
     

      break;
    }

  }
  textprintf_centre(buffer,f,SCREEN_W/2,SCREEN_H-30,makecol(255,255,255),"Press [space] to start [ESC] to quit.");

}

int credits()
{
  while(key[KEY_ESC]);
  timer=0;
  int xx=0;
  int scrn=0;

  while(true) {
    while(timer>0) {
      timer--;
      if(key[KEY_ESC]) return 1;
      if(key[KEY_SPACE]) return 0;
      if(xx++>500) {xx=0; scrn=(scrn+1)%NUM_SHOTS;}
      update_rain();
    }
    draw_shot(scrn);

    flip();
  }
}
void flip()
{
	blit(buffer,screen,0,0,0,0,640,480);
}


void loadm(char * filename)
{
    FILE *file = fopen(filename,"r");
    if (!file) exit(1);
    load_map(&map,file);
}

void draw_monkey()
{
	masked_blit(monkey[dir-1],buffer,0,0,320,240,32,32);
    masked_blit (b_menu,buffer,0,0,500,5,130,460);
    masked_blit(b_smallb,buffer,0,0,525,90,32,32);
    masked_blit(b_key,buffer,0,0,525,130,32,32);
    masked_blit(b_bomb,buffer,0,0,525,170,32,32);
    textprintf(buffer,font,560,102,makecol(255,255,255),"x %d",points);
    textprintf(buffer,font,560,142,makecol(255,255,255),"x %d",keys);
	textprintf(buffer,font,560,182,makecol(255,255,255),"x %d",bombs);
	textprintf(buffer,font,545,230,makecol(255,255,255),"Level: %d",level);

}


int can_walk(int xt,int yt)
{
    if (x<0 || x>=map.w ||y<0 || y>map.h) return 0;
    s_tile *tile= &map.tiles[yt*map.w+xt];
    switch (tile->type)
    {
    	case 1: case 3: case 6: case 7:
        return 1;
        break;
        case 2:
        return 0;
        break;
        case 4: case 5: case 8:
        if (isset(tile->flags,TILE_OPENED)) return 1;
        else return 0;
        break;
    }
	return 0;
}

  

void check_keys()
{
    if (key[KEY_UP] )
    {
        dir=1;
        if (can_walk(x,y-1)) walk(0,-1);
    }
    else if (key[KEY_RIGHT] )
    {
        dir=2;
        if (can_walk(x+1,y)) walk(1,0);
    }
    else if (key[KEY_DOWN])
    {
        dir=3;
        if (can_walk(x,y+1)) walk(0,1);
    }
    else if (key[KEY_LEFT])
    {
        dir=4;
        if (can_walk(x-1,y)) walk(-1,0);
    }
    else if (key[KEY_F1])
    	save_bitmap("mkhshot.bmp",buffer,NULL);
    else if (key[KEY_K])
    	use_key();
    else if (key[KEY_B])
    	use_bomb();
    else if (key[KEY_H])
    	hack();

}


void walk(int xt, int yt)
{
	int xb=320-x*32;
    int yb=240-y*32;
	for (int i=0;i<32;i+=2)
    {
        clear(buffer);
    	draw_map(buffer,&map,xb,yb);
        draw_monkey();
        flip();
        xb-=xt*2;
        yb-=yt*2;
    }
	x+=xt;
    y+=yt;
    trigger(&map.tiles[(y)*map.w +(x)]);
}

void trigger(s_tile * tile)
{
    switch(tile->type)
    {
      case 6:
        if (isset(tile->flags,TILE_AFDOOR)) dodoors(tile->affect);
        else dobridges(tile->affect);
        return;
    }
    if (tile->item==1) keys++;
    if (tile->item==2) bombs++;
    if (tile->item==3) { points+=100; play_sample(sound1,128,128,1000,0);          }
    if (tile->item==4) { play_sample(sound2,128,128,1000,0);rest(2);next_level();}
    tile->item=0;
}

void dodoors(int doors)
{
    bool dodoor=false;
    int count=map.w*map.h;
    bool *move = new bool[count];
    for (int temp=0;temp<count;temp++) move[temp]=false;

    for (int dot=0;dot<16;dot++)
    {
        int doo=1<<dot;
    	if (isset(doors,doo))
        {
            for (int t=0;t<count;t++)
            {
            	if (map.tiles[t].type==5 && map.tiles[t].affect==doo)
                {
                	dodoor=true;
                    move[t]=true;
                }
            }
        }
    }
    if (dodoor)
    {
    	BITMAP *tempdo= create_bitmap(32,32);
        BITMAP *tempdc= create_bitmap(32,32);

        for (int i=5;i<24;i++)
        {
            clear(buffer);
            draw_map(buffer,&map,320-x*32,240-y*32);
            blit (tiles[9],tempdo,0,0,0,0,32,32);
            blit (tiles[9],tempdc,0,0,0,0,32,32);
            blit (tiles[4],tempdo,27-i,0,4,0,i,32);
            blit (tiles[4],tempdc,i,0,5,0,26-i,32);

        	for(int xt=0;xt<map.w;xt++)
            {
                for (int yt=0;yt<map.h;yt++)
                {
                	int t=yt*map.w+xt;
                    if (move[t])
                    {
                        int tx=xt*32+(320-x*32);
                        int ty=yt*32+(240-y*32);
          				BITMAP *temp;
                    	if (isset(map.tiles[t].flags,TILE_OPENED)) temp=tempdo;
                        else temp=tempdc;
                        if (isset(map.tiles[t].flags,TILE_VERT))
                        {
                        	blit(tiles[0],buffer,0,0,tx,ty,32,32);
 	               			rotate_sprite(buffer,temp,tx-1,ty,itofix(64));
                        }
                        else
                        	blit(temp,buffer,0,0,tx,ty,32,32);

                    }
                }
            }
        	draw_monkey();
     		flip();
		}
    	for (int t=0;t<count;t++)
    	{
    		if (move[t])
    		if(isset(map.tiles[t].flags,TILE_OPENED)) map.tiles[t].flags&=~TILE_OPENED;
        	else map.tiles[t].flags|=TILE_OPENED;
    	}
        destroy_bitmap(tempdo);
        destroy_bitmap(tempdc);

    }
}

void dobridges(int bridges)
{
    bool done=true;
    int counter=0;
    int count= map.w*map.h;
    bool * move = new bool[count];
    for (int temp=0;temp<count;temp++) move[temp]=false;

    for (int brt=0;brt<16;brt++)
    {
        int br=1<<brt;
    	if (isset(bridges,br))
        {
            for (int t=0;t<count;t++)
            {
            	if (map.tiles[t].type==3 && map.tiles[t].affect==br)
                {
                    map.tiles[t].type=2;
                	move[t]=true;
                    done=false;
                }
            }
        }
    }
    while (!done)
    {
    	done=true;
     	for (int i=0;i<32;i+=4)
        {
            clear(buffer);
            draw_map(buffer,&map,320-x*32,240-y*32);
            for (int xt=0;xt<map.w;xt++)
            {
                for (int yt=0;yt<map.h;yt++)
                {
                	int t=yt*map.w+xt;
                    if (move[t])
             		{
                    	int tx=xt*32+(320-x*32);
                        int ty=yt*32+(240-y*32);
                        int txb=0;
                        if (map.tiles[t].movex!=0) txb = map.tiles[t].movex/abs(map.tiles[t].movex);
                       	int tyb=0;
						if (map.tiles[t].movey!=0) tyb = map.tiles[t].movey/abs(map.tiles[t].movey);
                        int countert=counter;
                        if (counter>abs(map.tiles[t].movex)) countert=abs(map.tiles[t].movex);
                        tx+=(txb*countert*32);
                        if (counter<abs(map.tiles[t].movex)) tx+=(txb*i);
                        countert=counter;
                        if (counter>abs(map.tiles[t].movey)) countert=abs(map.tiles[t].movey);
                        ty+=(tyb*countert*32);
                        if (counter<abs(map.tiles[t].movey))	ty+=(tyb*i);
                        blit(tiles[2],buffer,0,0,tx,ty,32,32);
                        if (i==28)
                        {
                            if (counter+1>=abs(map.tiles[t].movex) && counter+1 >=abs(map.tiles[t].movey))
                            {

                            }
                            else
                            {
                            	done=false;
                            }
                        }

                    }
                }

            }
            draw_monkey();
            flip();
        }
        counter++;
        //if (counter ==10) done=true;
    }
    s_tile * tiles2 = new s_tile[count]; //damn I hate this, but have to make a copy of the map, since dest and source of a bridge can be same tile
    if(!tiles2) {
      set_gfx_mode(GFX_TEXT,0,0,0,0);
      allegro_message("ouch bad stuff! out of memory!");
      exit(1);
    }
    memcpy(tiles2,map.tiles,sizeof(s_tile)*count);
    for (int t=0;t<count;t++)
    if (move[t])
    {
        int movex=map.tiles[t].movex;
        int movey=map.tiles[t].movey;

        tiles2[t+(movey*map.w)+movex].type=3;
        tiles2[t+(movey*map.w)+movex].affect=map.tiles[t].affect;
        tiles2[t+(movey*map.w)+movex].movex=-movex;
        tiles2[t+(movey*map.w)+movex].movey=-movey;
    }
    delete[] map.tiles;
    map.tiles=tiles2;

}


void use_key()
{
    if (keys==0) return;
    int xt=x,yt=y;
    if (dir==1) yt--;
    if (dir==2) xt++;
    if (dir==3) yt++;
    if (dir==4) xt--;
    int newtile=yt*map.w+xt;
    if (map.tiles[newtile].type==8 && !isset(map.tiles[newtile].flags,TILE_OPENED))
    {
        for (int i=5;i<24;i++)
        {
            clear(buffer);
            draw_map(buffer,&map,320-x*32,240-y*32);
            int tx=xt*32+(320-x*32);
            int ty=yt*32+(240-y*32);
            BITMAP * temp = create_bitmap(32,32);
            blit (tiles[9],temp,0,0,0,0,32,32);
            blit (tiles[7],temp,i,0,5,0,26-i,32);
            if (isset(map.tiles[newtile].flags,TILE_VERT))
            {
	           	blit(tiles[0],buffer,0,0,tx,ty,32,32);
 	   			rotate_sprite(buffer,temp,tx-1,ty,itofix(64));
            }
            else
              	blit(temp,buffer,0,0,tx,ty,32,32);
        	draw_monkey();
            flip();
        }
		map.tiles[newtile].flags|=TILE_OPENED;
        keys--;
    }
}

void use_bomb()
{
	if (bombs==0) return;
    int xt=320-x*32;
    int yt=240-y*32;

    for (int i=0;i<35;i++)
    {
    	clear(buffer);
        draw_map(buffer,&map,xt,yt);
        draw_monkey();
    	masked_blit(b_explo,buffer,0,0,320-32,240,32,32);
        masked_blit(b_explo,buffer,0,0,320+32,240,32,32);
		masked_blit(b_explo,buffer,0,0,320,240-32,32,32);
		masked_blit(b_explo,buffer,0,0,320,240+32,32,32);
		flip();
    }
    if (map.tiles[y*map.w+x+1].type==4) map.tiles[y*map.w+x+1].flags|=TILE_OPENED;
    if (map.tiles[y*map.w+x-1].type==4) map.tiles[y*map.w+x-1].flags|=TILE_OPENED;
	if (map.tiles[(y+1)*map.w+x].type==4) map.tiles[(y+1)*map.w+x].flags|=TILE_OPENED;
	if (map.tiles[(y-1)*map.w+x].type==4) map.tiles[(y-1)*map.w+x].flags|=TILE_OPENED;
    bombs--;
}

void win_game() {
  timer=0;
  while(!key[KEY_ESC]&&!key[KEY_SPACE]) {
    while(timer>0) {
      timer--;
      add_snow_drop();
      update_rain();
    }
    clear(buffer);
    draw_rain();

    textprintf_centre(buffer,old_font,SCREEN_W/2,SCREEN_H/2-32,makecol(255,255,255),"Congrats! I have completed the game!");    
    flip();
    
  }
}


void next_level()
{
    points+=500;  // well you got a big banana!
    level++;
    char * lev=new char[10];
    sprintf(lev,"level%d.mkh",level);
    if (!exists(lev)) {
      quit=false;
      win_game();
      return;
    }
    delete[] map.tiles;
    loadm(lev);
    x=map.enterx;
    y=map.entery;
    bombs=0;
    keys=0;
}


void hack()
{
	int t= y*map.w+x;
    if (map.tiles[t].type!=7) return;
    if (isset(map.tiles[t].flags,TILE_OPENED)) return;
    //destroy_bitmap(buffer);
    //set_gfx_mode(GFX_AUTODETECT,320,240,0,0);
    //buffer=create_bitmap(320,240);
    //clear(buffer);
    int ret = starthack(map.tiles[t].movex);
    //destroy_bitmap(buffer);
    //set_gfx_mode(GFX_AUTODETECT,640,480,0,0);
    //buffer=create_bitmap(640,480);
    //clear(buffer);
    if (ret)
    {
    	dodoors(map.tiles[t].affect);
    	map.tiles[t].flags|=TILE_OPENED;
    }
    clear_keybuf();
}
