// This file contains misc functions that didn't fit anywhere else.
//

#include <allegro.h>
#include <string.h>

#include "util.h"

// fill a bitmap with a gradient
void fill_grad(BITMAP *bmp,int c1,int c2)
{
      double r1=getr(c1);
      double g1=getg(c1);
      double b1=getb(c1);
      double r2=getr(c2);
      double g2=getg(c2);
      double b2=getb(c2);
      double sr=(r2-r1)/double(bmp->w-1);
      double sg=(g2-g1)/double(bmp->w-1);
      double sb=(b2-b1)/double(bmp->w-1);
   
      for(int i=0;i<bmp->w;i++) {
         vline(bmp,i,0,bmp->h-1,makecol(int(r1),int(g1),int(b1)));
      
         r1+=sr;
         g1+=sg;
         b1+=sb;
      }
   
   
}


char get_first_char(char *line)
{
  while(*line!=0&&(*line==' '||*line=='\t')) line++;
  return *line;
}
char get_last_char(char *line)
{ 
  int i=strlen(line)-1;
  while(i>=0&&(line[i]==0&&line[i]==' '||line[i]=='\t'||line[i]=='\r'||line[i]=='\n')) i--;

  if(i>=0)
    return line[i];
  return 0;
}
char *get_word(char *line,int number)
{
  static char word[100];
  int i=0;

  while(number>=0) {
    i=0;
    while(*line!=0&&(*line==' '||*line=='\t')) line++;
    while(*line!=0&&*line!=' '&&*line!='\t') {word[i++]=*line;line++;}
    number--;
  }

  word[i]=0;
  return word;
}
int get_int(char *line,int number) // get a number from a line
{
  return atoi(get_word(line,number));  
}
float get_float(char *line,int number) // get a number from a line
{
  return atof(get_word(line,number));  
}



struct score_b score_board[MAX_WINS];

// returns true if score is a hi score
bool check(int score)
{
  int i;
  for(i=MAX_WINS-1;i>=0;i--)
    if(score>score_board[i].score)
      return true;
  return false;
}
// add the score to the board
void add(int score,char *(*name_func)(int place))
{
  int i,j;
  if(name_func==NULL) return;

  for(i=MAX_WINS-1;i>=0;i--)
    if(score>score_board[i].score) {
      for(j=0;j<i;j++) {
        strcpy(score_board[j].name,score_board[j+1].name);
        score_board[j].score=score_board[j+1].score;
      }
      strcpy(score_board[i].name,name_func(MAX_WINS-(i+1)));
      score_board[i].score=score;
      return;
    }

}

char *get_name(int place)
{
  if(place<0||place>=MAX_WINS)
    return NULL;

  return score_board[MAX_WINS-(place+1)].name;
}

int get_score(int place)
{
  if(place<0||place>=MAX_WINS)
    return 0;

  return score_board[MAX_WINS-(place+1)].score;
}

void score_close()
{
  char temp[80];
  set_config_file("score.dat");
  for(int i=0;i<MAX_WINS;i++) {
    sprintf(temp,"Name%02d",i);

    set_config_string(NULL,temp,score_board[i].name);

    sprintf(temp,"amount%02d",i);

    set_config_int(NULL,temp,score_board[i].score);
  }
}

void score_init()
{
  char temp[80];
  set_config_file("score.dat");
  for(int i=0;i<MAX_WINS;i++) {
    sprintf(temp,"Name%02d",i);
    if(i%3==0)
      strcpy(score_board[i].name,get_config_string(NULL,temp,"Nathan Smith"));
    else if(i%3==1)
      strcpy(score_board[i].name,get_config_string(NULL,temp,"Thijs Vaessen"));
    else
      strcpy(score_board[i].name,get_config_string(NULL,temp,"Bram Vaessen"));

    sprintf(temp,"amount%02d",i);

    score_board[i].score=get_config_int(NULL,temp,(i+1)*MIN_SCORE);
  }
  atexit(score_close);
}
