#include <stdio.h>

#define TILE_OPENED   1 //for doors and walls (if bombed)
#define TILE_AFDOOR	  2 // for button: doesn it affect doors? yes if set, if not set affect bridges
#define TILE_VERT     4 // for doors: if set then door is drawn vertical



struct s_tile
{
	short type; //1=normal 2=water 3=bridge 4=wall 5=door 6=button 7=security
    short flags;
    long int affect;	//doors&bridges: id number | button: the bit's in this int tell what doors&bridges it affects(corresp. id)
    short movex, movey; //for bridges. when bridge at dest.. these values are multiplied by -1
	short item; 		//is there an item on this tile, what the number?
};

struct s_map
{
	int w,h; //with and height of the map
	s_tile * tiles;
    int enterx,entery; //coordinates for where you start
};


void draw_grid(BITMAP *bmp, s_map * map, int x, int y);
void draw_map(BITMAP *bmp, s_map * map, int x, int y);
int load_tiles();
void reset_tiles(s_map * map);
void create_tiles(s_map * map);
bool isset(int flags,int flag);
void save_map(s_map * map, FILE * file);
void load_map(s_map * map, FILE * file);

