#ifndef _PART_HEADER_
#define _PART_HEADER_

#define MAX_PART 100  // all I need

class particle
{
  private:
    double x,y;
    int c;
    double dx,dy;
    int alive;
  public:
    int is_alive() {return (alive>0);}
    particle() 
    {x=y=dx=dy=0;c=alive=0;}
    void draw(BITMAP *bmp) {
      if(alive>0) {
        putpixel(bmp,int(x),int(y),c);
      }
    }
    void clear() {
      alive=0;
    }
    void create() {
      x=160;
      y=120;
      dx=(double(rand()%200-100))/400;
      dy=(double(-rand()%200-200))/400;
      c=makecol(255,255,255);
      alive=100;
    }
    void update() {
      if(alive<=0) return;
      x+=dx;
      y+=dy;
      dy+=0.01;
      alive--;
      c=makecol(155+alive,155+alive,155+alive);
    }
} parts[MAX_PART];

int total_parts;

#endif
