#ifndef _OBJECT_3D_HEADER_
#define _OBJECT_3D_HEADER_

struct POLY3D        // a polygon
{
  V3D_f *v[3];       // vertexs
  V3D_f normal;      // polygon normal
};

struct OBJ3D         // a 3d objec
{ 
  char *name;        
  V3D_f *v;          // vertexs
  V3D_f *vnormal;    // vertex normals
  V3D_f *tmp;        // rotated vertexs
  POLY3D *p;         // polygons
  int num_vertex;    // size of v,vnormal, and tmp arrays
  int num_poly;      // size of p array
  int poly_type;     // polygon type
  MATRIX_f pos;      // object matrix
  BITMAP *tex;       // texture if needed
};

// helper functions:

OBJ3D *load_3dp(PACKFILE *file,int length);
OBJ3D *load_3d(char *filename);
void draw_3d(BITMAP *bmp,OBJ3D *o,MATRIX_f *camera,int x,int y,int color);
void destroy_3d(OBJ3D *o);
void make_normal(V3D_f *n,V3D_f *a,V3D_f *b, V3D_f *c);
#endif
