#ifndef _DEVICE_HEADER_
#define _DEVICE_HEADER_

class gameobj
{
//friends:
  friend class level;
  protected:
    int x,y;
    int is_device;
    gameobj *next;
  public:
    gameobj() {x=0;y=0;next=NULL;is_device=false;}
    virtual ~gameobj() {if(next!=NULL) delete next;}
    virtual void set_color(int _color)=0;
    virtual void draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera)=0;
    virtual void update()=0;
    virtual void target() {return;}
};

class level
{
  private:
    gameobj *first;
  public:
    level();
    ~level();
    void add_object(gameobj *o);
    void clear();               // empty the level
    void load(char *filename);
    void update();
    int check(int x,int y);
    void draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera);
    
};
class grid3d : public gameobj
{
  private:
    OBJ3D *o;
 
  public:
    grid3d(int grid_size_x,int grid_size_y);
    ~grid3d();
    void set_color(int _color);
    void draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera);
    void update();
};

class device : public gameobj
{
//friends:
    friend class data_line;
  private:
    int is_target;
    OBJ3D *o;
    int current_color;
    class data_line *in_lines;
    class data_line *out_lines;
  public:
    device(OBJ3D *_obj,int _x,int _y,int _color);
    ~device();
    void set_color(int _color);
    void draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera);
    void update();
    void target();
};

class data_line : public gameobj
{
//friends:
    friend class device;
  private:
    int x1,y1;
    int x2,y2;
    OBJ3D *o;
    int color;
    int progress;
    class device *from;
    class device *to;
    class data_line *onext;
    class data_line *inext;
  public:
    data_line(device *_from,device *_to,int _color);          
    ~data_line();
    void set_color(int _color);
    void update();
    void draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera);
     
};

#endif
