//
// This contains the gameobj classes + the level class
//
//  There are three type of gameobjs:
//    a. device 
//    b. data_line to link the devices together
//    c. grid3d just a big polygon with the u,v looped
//       number of grids*the length of the texture
//

#include <allegro.h>
#include <string.h>


#include "obj3d.h"
#include "util.h"
#include "device.h"
#include "part.h"

level::level()
{
  first=NULL;
}
level::~level()
{
  clear();
}
void level::clear()
{
  if(first) delete first;
  first=NULL;
}
void level::add_object(gameobj *o)
{
  o->next=first;
  first=o;
}
extern OBJ3D *obj[];
static gameobj *create_obj(char *line,device **d)
{
   int a,b;
   gameobj *tmp=NULL;
   
   char *fw=get_word(line,0);

   if(strcmp(fw,"grid")==0) {
     tmp=new grid3d(get_int(line,1),get_int(line,1));
   }
   else if(strcmp(fw,"device")==0) {
     a=get_int(line,1);
     d[a]=new device(obj[get_int(line,4)],get_int(line,2),get_int(line,3),makecol(get_int(line,5),get_int(line,6),get_int(line,7)));
     tmp=d[a];
   }
   else if(strcmp(fw,"data_line")==0) {
     a=get_int(line,1);
     b=get_int(line,2);
     tmp=new data_line(d[a],d[b],makecol(get_int(line,3),get_int(line,4),get_int(line,5)));
   }

   return tmp;
}

void level::load(char *filename)
{
  PACKFILE *f=pack_fopen(filename,F_READ);
  char line[1024];
  device *d[128];

  gameobj *tmp;

  while(!pack_feof(f)) {
    pack_fgets(line,1023,f);

    tmp= create_obj(line,d);
    
    if(tmp) add_object(tmp);
  }

  pack_fclose(f);

}
void level::update()
{
  gameobj *tmp=first;
  while(tmp) {
    tmp->update();
    tmp=tmp->next;
  }
}
int level::check(int x,int y)
{
  gameobj *tmp=first;
  while(tmp) {
    if(tmp->is_device) {
      if(((x+50)/100)==((tmp->x+50)/100)&&((y+50)/100)==((tmp->y+50)/100)) {
        tmp->target();
        return true;
      }
    } 
    tmp=tmp->next;
  }
  return false;
}
void level::draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera)
{
  gameobj *tmp=first;
  while(tmp) {
    tmp->draw(bmp,target,camera);
    tmp=tmp->next;
  }

}
    
device::device(OBJ3D *_obj,int _x,int _y,int _color) : gameobj() 
{
       o=_obj;
       x=-_x;
       y=_y;
       current_color=_color;
       in_lines=NULL;
       out_lines=NULL;
       is_device=true;
}

device::~device()
{
// for future use
}
void device::update()
{
  data_line *t;
  is_target=false;

  int red=makecol(255,0,0);
  int green=makecol(0,255,0);
  int yellow=makecol(255,255,0);
  int grey=makecol(64,64,64);
  int blue=makecol(0,0,255);

  int nc=green;

  if(current_color==blue) {
    t=out_lines;
      while(t) {
        if(t->color!=blue) t->set_color(blue);
        t=t->onext;
      }
      t=in_lines;
      while(t) {
        if(t->color!=blue) t->set_color(blue);
        t=t->inext;
      }
  }
  else if(current_color==red) {
      t=out_lines;
      while(t) {
        if(t->color!=grey&&t->color!=red&&t->color!=blue)
          t->set_color(red);
        if(t->color==blue) set_color(blue);
        t=t->onext;
      }
      
   }
   else
   if(current_color==grey) {
      t=out_lines;
      while(t) {
        if(t->color!=grey&&t->color!=blue) t->set_color(grey);
        if(t->color==blue) set_color(blue);
        t=t->onext;
      }
      t=in_lines;
      while(t) {
        if(t->color!=grey&&t->color!=blue) t->set_color(grey);
        if(t->color==blue) set_color(blue);
        t=t->inext;
      }
    }
    else if(current_color==green) {
      t=in_lines;
      while(t) {
        if(t->color==yellow) nc=yellow;
        if(t->color==blue) nc=blue;
        t=t->inext;
      }
      t=out_lines;
      while(t) {
        if(t->color==blue) nc=blue;
        t=t->onext;
      }
      if(nc==green) {
        t=in_lines;
        while(t) {
          if(t->color==red) nc=red;
          t=t->inext;
        }
      }
      if(nc!=green)
        set_color(nc);

      }
    else if(current_color== yellow) {
      t=in_lines;
      while(t) {
        if(t->color==yellow) nc=yellow;
        if(t->color==blue) nc=blue;
        t=t->inext;
      }
      t=out_lines;
      while(t) {
        if(t->color==blue) nc=blue;
        t=t->onext;
      }
      if(nc!=yellow&&nc!=blue) {
        t=out_lines;
        while(t) {
          if(t->color!=grey&&t->color!=nc) t->set_color(nc);
          t=t->onext;
        }
        set_color(nc);
      }
      if(nc==blue)
        set_color(nc);
      
    }
      
}
void complete_level(); // call back
void device::target()
{
// this device has been targeted
  is_target=true;
  static int a=0;
  static int type=0;

  if(current_color==makecol(0,0,255)) // win level!!!
    complete_level();
      
  
  if((getb(current_color)==0||getr(current_color)==0||getg(current_color)==255)&&getg(current_color)>0&&current_color!=makecol(64,64,64)&&current_color!=makecol(255,255,0)) {
    if(o!=obj[3]&&o!=obj[1]&&key[KEY_A]&&(type==0||type==1)) {  // Flood!
      type=1;
      set_color(makecol(MID(0,a,255),255,MID(0,a,255)));
      a++;
      if(a>=255) set_color(makecol(64,64,64)); // DEAD!
    }
    else if(o!=obj[3]&&o!=obj[2]&&key[KEY_S]&&(type==0||type==2)) {  // infecting!
      type=2;
      set_color(makecol(MID(0,a,255),MID(0,256-a,255),0)); 
      a++;
      if(a>=255) set_color(makecol(255,0,0)); 
    }
    else if(o==obj[4]&&key[KEY_D]&&(type==0||type==3)) { // Hacking...
      type=3;
      set_color(makecol(0,MID(0,256-a,255),MID(0,a,255))); 
      a++;
      if(a>=255) 
        set_color(makecol(0,0,255));// win level!!!
    }
  }
  if(getr(current_color)==255&&current_color!=makecol(255,255,0)) {
    if(key[KEY_F]&&(type==0||type==4)) {
      type=4;
      set_color(makecol(255,MID(0,a,255),MID(0,a,255)));
      a++;
      if(a>=255) set_color(makecol(64,64,64));
    }

  }
  if(!key[KEY_A]&&!key[KEY_S]&&!key[KEY_D]&&!key[KEY_F]) {
    if(current_color!=makecol(0,0,255)
       &&current_color!=makecol(64,64,64)
       &&current_color!=makecol(255,0,0)
       &&current_color!=makecol(255,255,0)
       &&current_color!=makecol(0,255,0)){
      if(type==1||type==2||type==3)
        set_color(makecol(0,255,0));
      if(type==4)
        set_color(makecol(255,0,0));
    }
    a=0;type=0;
    for(int i=0;i<MAX_PART;i++) {
      parts[i].clear();
    }
  }
  else {
    for(int i=0;i<MAX_PART;i++) {
      if(!parts[i].is_alive()) {
        parts[i].create();
        break;
      }
    }
    for(int i=0;i<MAX_PART;i++) {
      parts[i].update();
    }
  }
}

void device::set_color(int _color) 
{
       current_color=_color;
}

void device::draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera) 
{     
  draw_3d(bmp,o,camera,x,y,current_color);

  if(is_target) {
    char *c;  
    if(current_color== makecol(255,0,0))
        c="Infected";
    else if(current_color== makecol(0,255,0))
        c="Unprotected";
    else if(current_color== makecol(255,255,0))
        c="Protected";
    else if(current_color== makecol(64,64,64))
        c="Destroyed";
    else if(current_color== makecol(0,0,255))
        c="Hacked";
    else if(getg(current_color)==255)
        c="Flooding";
    else if(getr(current_color)>0&&getb(current_color)==0)
        c="Infecting";
    else if(getr(current_color)==255)
        c="Nuking";
    else 
        c="Hacking";
    
       
    
    textprintf(target,font,270,28,current_color,"%s",c);
    
    if(o==obj[0])
        c="Node";
    else if(o==obj[1])
        c="Firewall";
    else if(o==obj[2])
        c="Filter";
    else if(o==obj[3])
        c="Encrypter";
    else 
        c="File Server";

    textprintf(target,font,273,209,makecol(0,0,255),"%s",c);
    
    if((getb(current_color)==0||getr(current_color)==0||getg(current_color)==255)&&getg(current_color)>0&&current_color!=makecol(64,64,64)&&current_color!=makecol(255,255,0)) {
      if(o!=obj[3]&&o!=obj[1]) textprintf(target,font,5,77,makecol(220,220,220),"[A] Flood");
      else textprintf(target,font,5,77,makecol(64,64,64),"[A] N/A");
      if(o!=obj[3]&&o!=obj[2]) textprintf(target,font,5,114,makecol(220,220,220),"[S] Infect");
      else textprintf(target,font,5,114,makecol(64,64,64),"[S] N/A");
      if(o==obj[4]) textprintf(target,font,5,158,makecol(220,220,220),"[D] Hack");
      else textprintf(target,font,5,158,makecol(64,64,64),"[D] N/A");
    }
    else {
      textprintf(target,font,5,77,makecol(64,64,64),"[A] N/A");
      textprintf(target,font,5,114,makecol(64,64,64),"[S] N/A");
      textprintf(target,font,5,158,makecol(64,64,64),"[D] N/A");
    
    }
    if(getr(current_color)==255&&current_color!=makecol(255,255,0))
      textprintf(target,font,5,205,makecol(220,220,220),"[F] Nuke");
    else textprintf(target,font,5,205,makecol(64,64,64),"[F] N/A");
    
    for(int i=0;i<MAX_PART;i++) {
      parts[i].draw(target);
    }
  }
}

grid3d::grid3d(int grid_size_x,int grid_size_y) : gameobj() 
{
  int i;
  o=load_3d("line.ase");


  o->poly_type=POLYTYPE_PTEX_MASK;
  o->tex=create_bitmap(32,32);

  clear_to_color(o->tex,bitmap_mask_color(o->tex));
  hline(o->tex,0,0,32,makecol(0,255,0));
  vline(o->tex,0,0,32,makecol(0,255,0));

  o->v[0].x=-10240;
  o->v[0].y=-10240;
  o->v[0].u=0;
  o->v[0].v=0;
  o->v[1].x=-10240;
  o->v[1].y=10240;
  o->v[1].u=0;
  o->v[1].v=grid_size_x*32;
  o->v[2].x=10240;
  o->v[2].y=-10240;
  o->v[2].u=grid_size_x*32;
  o->v[2].v=0;
  o->v[3].x=10240;
  o->v[3].y=10240;
  o->v[3].u=grid_size_x*32;
  o->v[3].v=grid_size_y*32;
  
  for(i=0;i<4;i++) {
    o->v[i].z=-10;    // this should puts the grid under all the objects    
    
  }
      
}

grid3d::~grid3d()
{
      if(o->tex)
        destroy_bitmap(o->tex);
      destroy_3d(o);
}
void grid3d::update()
{
// for future use
}

void grid3d::set_color(int _color) 
{
       return ;  // do nothing
}

void grid3d::draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera) 
{
//  float x=camera->t[0];
//  float y=camera->t[1];

  for(int i=0;i<4;i++) {
    o->tmp[i].u=o->v[i].u;//+x;
    o->tmp[i].v=o->v[i].v;//+y;
  }

//  camera->t[0]=0;
//  camera->t[1]=0;

  draw_3d(bmp,o,camera,0,0,0);
}

data_line::data_line(device *_from,device *_to,int _color) : gameobj() 
{
      float dx,dy,s;//c;
      from=_from;
      to=_to;
      onext=from->out_lines;
      from->out_lines=this;
      inext=to->in_lines;
      to->in_lines=this;

      x1=from->x;
      y1=from->y; 
      x2=to->x; 
      y2=to->y;
      color=_color; // negate x values because of the camera
      int length = 10;

      dx=float(x2-x1);
      dy=float(y2-y1);

      if(dx!=0&&dy!=0) {
        s=dy/dx;
//        c=y1-x1*s;
        dx=10;
        dy=-s*dx;
      }
      else {
        if(dx==0) {
          dx=10;
          dy=0;
        } else {
          dy=10;
          dx=0;
        }
      }
      
      o=load_3d("line.ase");
      o->v[0].x=x1-dx;
      o->v[0].y=y1-dy;
      o->v[0].u=0;
      o->v[0].v=0;
      o->v[1].x=x1+dx;
      o->v[1].y=y1+dy;
      o->v[1].u=0;
      o->v[1].v=2;
      o->v[2].x=x2-dx;
      o->v[2].y=y2-dy;
      o->v[2].u=64*length;
      o->v[2].v=0;
      o->v[3].x=x2+dx;
      o->v[3].y=y2+dy;
      o->v[3].u=64*length;
      o->v[3].v=2;

      o->poly_type=POLYTYPE_PTEX;
      o->tex=create_bitmap(64,2);

      set_color(color);
      
      progress=0;

}

data_line::~data_line() 
{
      if(o->tex)
        destroy_bitmap(o->tex);
      destroy_3d(o);
}

void data_line::set_color(int _color) 
{
      color=_color;
      if(color==makecol(64,64,64))
        clear_to_color(o->tex,color);
      else fill_grad(o->tex,makecol(0,0,0),color);

}

void data_line::update() 
{
      progress++;
      if(progress>64) progress-=64;
}

void data_line::draw(BITMAP *bmp,BITMAP *target,MATRIX_f *camera) 
{
      for(int i=0;i<4;i++) {
        o->tmp[i].u=o->v[i].u-progress;
        o->tmp[i].v=o->v[i].v-progress;
      }
      draw_3d(bmp,o,camera,0,0,color);
}



